/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.evaluationmemory.gui;

import de.rcenvironment.core.component.model.endpoint.api.EndpointMetaDataDefinition;
import de.rcenvironment.core.component.workflow.model.spi.ComponentInstanceProperties;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointActionType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.utils.incubator.NumericalTextConstraintListener;
import de.rcenvironment.core.gui.workflow.editor.properties.EndpointEditDialog;
import java.util.Map;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EvaluationMemoryEndpointEditDialog
extends EndpointEditDialog {
    private Button useToleranceButton;
    private Label toleranceFieldLabel;
    private Text toleranceField;
    private DataType previousDataType = null;
    private Label percentageSignLabel;

    public EvaluationMemoryEndpointEditDialog(Shell parentShell, EndpointActionType actionType, ComponentInstanceProperties configuration, EndpointType direction, String id, boolean isStatic, EndpointMetaDataDefinition metaData, Map<String, String> metadataValues) {
        super(parentShell, actionType, configuration, direction, id, isStatic, metaData, metadataValues);
    }

    protected void createEndpointSettings(Composite parent) {
        super.createEndpointSettings(parent);
        this.comboDataType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                DataType newDataType = EvaluationMemoryEndpointEditDialog.this.getTypeSelectionFromUI();
                EvaluationMemoryEndpointEditDialog.this.updateControlsAndDataType(newDataType);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
    }

    protected Text createLabelAndTextfield(Composite container, String text, String dataType, String value) {
        this.appendUseToleranceButton(container);
        this.appendToleranceFieldAndLabel(container, text);
        if (value.isEmpty()) {
            this.enableUseToleranceButton();
            this.disableToleranceField();
        } else {
            this.enableUseToleranceButton();
            this.useToleranceButton.setSelection(true);
            this.toleranceField.setText(value);
        }
        this.previousDataType = this.getTypeSelectionFromUI();
        return this.toleranceField;
    }

    private boolean useTolerance() {
        return this.useToleranceButton.getSelection();
    }

    private String getToleranceFieldText() {
        return this.toleranceField.getText();
    }

    protected void okPressed() {
        if (this.useTolerance()) {
            this.setToleranceInMetadata(this.getToleranceFieldText());
        } else {
            this.removeToleranceFromMetadata();
        }
        super.okPressed();
    }

    private void setToleranceInMetadata(String tolerance) {
        this.metadataValues.put("tolerance", tolerance);
    }

    private void removeToleranceFromMetadata() {
        this.metadataValues.put("tolerance", "");
    }

    private void appendUseToleranceButton(Composite container) {
        this.useToleranceButton = new Button(container, 32);
        this.useToleranceButton.setText("Use relative tolerance");
        this.useToleranceButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                boolean useTolerance = EvaluationMemoryEndpointEditDialog.this.useToleranceButton.getSelection();
                if (useTolerance) {
                    EvaluationMemoryEndpointEditDialog.this.enableToleranceField();
                } else {
                    EvaluationMemoryEndpointEditDialog.this.disableToleranceField();
                }
                EvaluationMemoryEndpointEditDialog.this.validateInput();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        this.useToleranceButton.setLayoutData((Object)gridData);
    }

    private void appendToleranceFieldAndLabel(Composite container, String text) {
        this.toleranceFieldLabel = new Label(container, 0);
        this.toleranceFieldLabel.setText(text);
        this.toleranceFieldLabel.setVisible(true);
        Composite toleranceFieldContainer = new Composite(container, 0);
        toleranceFieldContainer.setLayout((Layout)new GridLayout(2, false));
        toleranceFieldContainer.setLayoutData((Object)new GridData(4, 4, true, false));
        this.toleranceField = new Text(toleranceFieldContainer, 133120);
        this.toleranceField.setLayoutData((Object)new GridData(4, 4, true, false));
        this.toleranceField.setVisible(true);
        this.percentageSignLabel = new Label(toleranceFieldContainer, 0);
        this.percentageSignLabel.setText("%");
        this.percentageSignLabel.setVisible(true);
        this.toleranceField.addVerifyListener((VerifyListener)new NumericalTextConstraintListener(this.toleranceField, 1));
    }

    private boolean dataTypeSupportsTolerance(DataType dataType) {
        boolean previousIsInt = dataType.equals((Object)DataType.Integer);
        boolean previousIsFloat = dataType.equals((Object)DataType.Float);
        return previousIsInt || previousIsFloat;
    }

    private void updateControlsAndDataType(DataType newDataType) {
        boolean previousSupportsTolerance = this.dataTypeSupportsTolerance(this.previousDataType);
        boolean currentSupportsTolerance = this.dataTypeSupportsTolerance(newDataType);
        if (previousSupportsTolerance && !currentSupportsTolerance) {
            this.disableUseToleranceButton();
            this.disableToleranceField();
        } else if (!previousSupportsTolerance && currentSupportsTolerance) {
            this.enableUseToleranceButton();
            this.disableToleranceField();
        }
        this.previousDataType = newDataType;
    }

    protected boolean validateMetaDataInputs() {
        boolean validTolerance;
        String toleranceValue = this.toleranceField.getText();
        boolean bl = validTolerance = !this.useTolerance() || !toleranceValue.isEmpty();
        return validTolerance && super.validateMetaDataInputs();
    }

    private void disableUseToleranceButton() {
        this.useToleranceButton.setSelection(false);
        this.useToleranceButton.setEnabled(false);
    }

    private void enableUseToleranceButton() {
        this.useToleranceButton.setSelection(false);
        this.useToleranceButton.setEnabled(true);
    }

    private void disableToleranceField() {
        this.toleranceFieldLabel.setEnabled(false);
        this.toleranceField.setEnabled(false);
        this.toleranceField.setEditable(false);
        this.percentageSignLabel.setEnabled(false);
    }

    private void enableToleranceField() {
        this.toleranceFieldLabel.setEnabled(true);
        this.toleranceField.setEnabled(true);
        this.toleranceField.setEditable(true);
        this.percentageSignLabel.setEnabled(true);
    }
}

