/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.script.execution.python.internal;

import de.rcenvironment.components.script.common.ScriptComponentHistoryDataItem;
import de.rcenvironment.components.script.common.pythonAgentInstanceManager.PythonAgentInstanceManager;
import de.rcenvironment.components.script.common.pythonAgentInstanceManager.internal.PythonAgent;
import de.rcenvironment.components.script.execution.DefaultScriptExecutor;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.CommonComponentHistoryDataItem;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.execution.api.ComponentLog;
import de.rcenvironment.core.component.execution.api.ConsoleRow;
import de.rcenvironment.core.component.execution.api.ConsoleRowUtils;
import de.rcenvironment.core.configuration.ConfigurationSegment;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumFactory;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.datamodel.types.api.NotAValueTD;
import de.rcenvironment.core.scripting.ScriptingService;
import de.rcenvironment.core.scripting.ScriptingUtils;
import de.rcenvironment.core.scripting.python.PythonScriptContext;
import de.rcenvironment.core.scripting.python.PythonScriptEngine;
import de.rcenvironment.core.utils.common.OSFamily;
import de.rcenvironment.core.utils.scripting.ScriptLanguage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import org.apache.commons.logging.LogFactory;

public class PythonAgentScriptExecutor
extends DefaultScriptExecutor {
    private static final String NOT_VALUE_UUID = "not_a_value_7fdc603e";
    private static final String OS = "os";
    private final PythonAgentInstanceManager pythonInstanceManagerService;
    private PythonAgent agent;
    private PythonScriptContext scriptContext;
    private ComponentContext compCtx;

    public PythonAgentScriptExecutor(PythonAgentInstanceManager pythonInstanceManager) {
        this.pythonInstanceManagerService = pythonInstanceManager;
    }

    public boolean prepareExecutor(ComponentContext newCompCtx) throws ComponentException {
        this.compCtx = newCompCtx;
        super.prepareExecutor(this.compCtx);
        this.setComponentContext(this.compCtx);
        String pythonInstallation = this.getPythonPathFromConfigurationOrThrowException();
        this.scriptContext = new PythonScriptContext();
        this.scriptContext.setAttribute("pythonExecutionPath", (Object)pythonInstallation, 0);
        this.scriptContext.setAttribute(OS, (Object)OSFamily.getLocal(), 0);
        this.scriptContext.setAttribute("compCtx", (Object)this.componentContext, 0);
        if (this.workingPath != null && !this.workingPath.isEmpty()) {
            this.scriptContext.setAttribute("pythonWorkDir", (Object)this.workingPath, 0);
        }
        try {
            this.agent = this.pythonInstanceManagerService.getAgent(pythonInstallation, this.compCtx, this.scriptContext);
        }
        catch (IOException e) {
            throw new ComponentException("Unable to create python agent", (Throwable)e);
        }
        this.stateMap = new HashMap();
        scriptingService = (ScriptingService)this.compCtx.getService(ScriptingService.class);
        this.prepareOutputForRun();
        return true;
    }

    private String getPythonPathFromConfigurationOrThrowException() throws ComponentException {
        String pythonInstallation = this.getPythonConfigurationSegment().getString("binaryPath");
        if (pythonInstallation == null || pythonInstallation.isEmpty()) {
            throw new ComponentException("No Python installation specified. Please add thirdPartyIntegration parameter to configuration file.");
        }
        return pythonInstallation;
    }

    private ConfigurationSegment getPythonConfigurationSegment() {
        ConfigurationService configurationService = (ConfigurationService)this.compCtx.getService(ConfigurationService.class);
        ConfigurationSegment pythonConfiguration = configurationService.getConfigurationSegment("thirdPartyIntegration/python");
        return pythonConfiguration;
    }

    public void prepareNewRun(ScriptLanguage scriptLanguage, String userScript, ScriptComponentHistoryDataItem dataItem) throws ComponentException {
        this.historyDataItem = dataItem;
        this.scriptEngine = scriptingService.createScriptEngine(scriptLanguage);
        this.wrappingScript = userScript;
        if (this.wrappingScript == null || this.wrappingScript.length() == 0) {
            throw new ComponentException("No Python script configured");
        }
        this.scriptEngine.setContext((ScriptContext)this.scriptContext);
        this.scriptContext.removeAttribute("stateMap", 0);
        this.scriptContext.setAttribute("stateMap", (Object)this.stateMap, 0);
        this.scriptContext.removeAttribute("runNumber", 0);
        this.scriptContext.setAttribute("runNumber", (Object)this.getCurrentRunNumber(), 0);
        ((PythonScriptEngine)this.scriptEngine).createNewExecutor((CommonComponentHistoryDataItem)this.historyDataItem);
    }

    public void runScript() throws ComponentException {
        try {
            try {
                this.agent.acquireLock();
                this.componentContext.announceExternalProgramStart();
                ((PythonScriptEngine)this.scriptEngine).agentPrepareScriptExecution(this.wrappingScript, this.agent.getDirectory());
                this.agent.executeScript(this.wrappingScript);
                ((PythonScriptEngine)this.scriptEngine).agentReadOutputFromPython(this.agent.getDirectory());
            }
            catch (IOException e) {
                this.agent.stopInstanceRun();
                throw new ComponentException("Failed to execute script", (Throwable)e);
            }
            catch (InterruptedException | ScriptException e) {
                throw new ComponentException("Failed to execute script", (Throwable)e);
            }
        }
        finally {
            this.componentContext.announceExternalProgramTermination();
            this.agent.releaseLock();
        }
    }

    public boolean postRun() throws ComponentException {
        TypedDatumFactory factory = ((TypedDatumService)this.componentContext.getService(TypedDatumService.class)).getFactory();
        for (String outputName : this.componentContext.getOutputs()) {
            DataType type = this.componentContext.getOutputDataType(outputName);
            List resultList = (List)this.scriptEngine.get(outputName);
            NotAValueTD outputValue = null;
            if (this.scriptEngine.get(outputName) == null) continue;
            for (Object o : resultList) {
                if (o != null && !String.valueOf(o).equals(NOT_VALUE_UUID)) {
                    outputValue = ScriptingUtils.getOutputByType(o, (DataType)type, (String)outputName, (String)this.agent.getDirectory().getAbsolutePath(), (ComponentContext)this.componentContext);
                    this.componentContext.writeOutput(outputName, (TypedDatum)outputValue);
                    continue;
                }
                if (!String.valueOf(o).equals(NOT_VALUE_UUID)) continue;
                outputValue = factory.createNotAValue();
                this.componentContext.writeOutput(outputName, (TypedDatum)outputValue);
            }
        }
        this.stateMap = ((PythonScriptEngine)this.scriptEngine).getStateOutput();
        for (String outputName : ((PythonScriptEngine)this.scriptEngine).getCloseOutputChannelsList()) {
            this.componentContext.closeOutput(outputName);
        }
        this.deleteTempFiles();
        return true;
    }

    public void cancelScript() {
    }

    public boolean isCancelable() {
        return true;
    }

    public void tearDown() {
        boolean agentStopped = this.agent != null ? this.pythonInstanceManagerService.stopAgent(this.agent) : false;
        if (agentStopped && this.scriptEngine != null) {
            LogFactory.getLog(((Object)((Object)this)).getClass()).debug((Object)"Disposing script engine");
            ((PythonScriptEngine)this.scriptEngine).dispose();
        }
    }

    public void prepareOutputForRun() {
        ConsoleRowUtils.logToWorkflowConsole((ComponentLog)((ComponentContext)this.scriptContext.getAttribute("compCtx")).getLog(), (InputStream)this.agent.getStdout(), (ConsoleRow.Type)ConsoleRow.Type.TOOL_OUT, null, (boolean)false);
        ConsoleRowUtils.logToWorkflowConsole((ComponentLog)((ComponentContext)this.scriptContext.getAttribute("compCtx")).getLog(), (InputStream)this.agent.getStderr(), (ConsoleRow.Type)ConsoleRow.Type.TOOL_ERROR, null, (boolean)false);
    }
}

