/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.script.common.pythonAgentInstanceManager.internal;

import de.rcenvironment.components.script.common.pythonAgentInstanceManager.PythonAgentInstanceManager;
import de.rcenvironment.components.script.common.pythonAgentInstanceManager.internal.PythonAgent;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.scripting.python.PythonScriptContext;
import de.rcenvironment.core.scripting.python.PythonScriptEngine;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.executor.LocalApacheCommandLineExecutor;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import javax.script.ScriptException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;

@Component
public class PythonAgentInstanceManagerImpl
implements PythonAgentInstanceManager {
    private static final Log LOGGER = LogFactory.getLog(PythonScriptEngine.class);
    private Map<String, Integer> usageCounterByInstallationPath = new HashMap<String, Integer>();
    private Map<String, PythonAgent> agentsByInstallationPath = new HashMap<String, PythonAgent>();
    private Map<String, ServerSocket> socketsByInstallationPath = new HashMap<String, ServerSocket>();
    private final AtomicInteger runningCount = new AtomicInteger(0);
    private CountDownLatch initializationSignal;

    @Override
    public synchronized PythonAgent getAgent(String pythonInstallationPath, ComponentContext compCtx, PythonScriptContext pythonScriptContext) throws IOException {
        if (this.agentsByInstallationPath.containsKey(pythonInstallationPath)) {
            this.usageCounterByInstallationPath.compute(pythonInstallationPath, (ignored, x) -> x + 1);
            return this.agentsByInstallationPath.get(pythonInstallationPath);
        }
        try {
            ServerSocket serverSocket = new ServerSocket(0);
            this.socketsByInstallationPath.put(pythonInstallationPath, serverSocket);
        }
        catch (IOException e) {
            throw new IOException("No socket could be opened. Therefore, the communication to python couldn't be established.", e);
        }
        try {
            this.initializationSignal = new CountDownLatch(1);
            LOGGER.debug((Object)"Starting new Python agent");
            ServerSocket socket = this.socketsByInstallationPath.get(pythonInstallationPath);
            PythonAgent agent = new PythonAgent(this, pythonInstallationPath, this.runningCount.getAndIncrement(), socket, this.initializationSignal, compCtx, pythonScriptContext);
            ConcurrencyUtils.getAsyncTaskService().execute("Run Python Agent", (Runnable)agent);
            this.initializationSignal.await();
            if (!agent.wasInitializationSuccessful()) {
                throw new IOException("Unable to create a PythonAgent for the script execution.");
            }
            this.agentsByInstallationPath.put(pythonInstallationPath, agent);
            this.usageCounterByInstallationPath.put(pythonInstallationPath, 1);
            return agent;
        }
        catch (InterruptedException | ScriptException exception) {
            throw new IOException("Unable to create a PythonAgent for the script execution.");
        }
    }

    @Override
    public synchronized boolean stopAgent(PythonAgent agent) {
        int newUsageCount = this.usageCounterByInstallationPath.compute(agent.getInstallationPath(), (ignored, x) -> x - 1);
        if (newUsageCount == 0) {
            agent.stopInstance();
            try {
                this.socketsByInstallationPath.get(agent.getInstallationPath()).close();
            }
            catch (IOException iOException) {
                LOGGER.warn((Object)("Could not close server socket used for communication with python installation " + agent.getInstallationPath() + ". Since that agent is not used anymore, this should not implact further operation."));
            }
            this.usageCounterByInstallationPath.remove(agent.getInstallationPath());
            this.agentsByInstallationPath.remove(agent.getInstallationPath());
            return true;
        }
        return false;
    }

    @Override
    public LocalApacheCommandLineExecutor createNewExecutor() {
        try {
            return new LocalApacheCommandLineExecutor(null);
        }
        catch (IOException iOException) {
            LOGGER.error((Object)"Failed to create executor for python.");
            return null;
        }
    }
}

