/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.optimizer.generic.execution.internal;

import de.rcenvironment.components.optimizer.common.MethodDescription;
import de.rcenvironment.components.optimizer.common.OptimizerComponentHistoryDataItem;
import de.rcenvironment.components.optimizer.common.execution.CommonPythonAlgorithmExecutor;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.configuration.ConfigurationSegment;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.utils.common.FileCompressionFormat;
import de.rcenvironment.core.utils.common.FileCompressionService;
import de.rcenvironment.core.utils.common.LogUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;

public class GenericAlgorithmExecutor
extends CommonPythonAlgorithmExecutor {
    private File configurationFile;
    private FileReferenceTD configurationFileReference;

    public GenericAlgorithmExecutor(Map<String, MethodDescription> methodConfiguration, Map<String, TypedDatum> outputValues, Collection<String> input, ComponentContext ci, Map<String, Double> upperMap, Map<String, Double> lowerMap, Map<String, Double> stepValues) throws ComponentException {
        super(methodConfiguration, outputValues, input, ci, upperMap, lowerMap, stepValues, "input.in");
    }

    protected void prepareProblem() throws ComponentException {
        try {
            File destinationDirectory;
            InputStream inputStream;
            File sourceFolder = this.getSourceFolder();
            if (sourceFolder.exists() && sourceFolder.exists()) {
                FileUtils.copyDirectoryToDirectory((File)sourceFolder, (File)this.workingDir);
            }
            if (!FileCompressionService.expandCompressedDirectoryFromInputStream((InputStream)(inputStream = GenericAlgorithmExecutor.class.getResourceAsStream("/resources/RCE_Optimizer_API.zip")), (File)(destinationDirectory = new File(this.workingDir, "source/")), (FileCompressionFormat)FileCompressionFormat.ZIP).booleanValue()) {
                LOGGER.error((Object)"Was not able to prepare the generic algorithm due to an archive issue.");
                throw new ComponentException("Was not able to prepare the generic algorithm due to an archive issue.");
            }
        }
        catch (IOException e) {
            throw new ComponentException("Failed to prepare generic algorithm", (Throwable)e);
        }
        this.configurationFile = new File(new File(this.workingDir, "source"), "configuration.json");
        this.writeConfigurationFile(this.configurationFile);
    }

    private File getSourceFolder() {
        File configFolder = new File(((ConfigurationService)this.compContext.getService(ConfigurationService.class)).getConfigurablePath(ConfigurationService.ConfigurablePathId.DEFAULT_WRITEABLE_INTEGRATION_ROOT), "optimizer");
        File sourceFolder = new File(new File(configFolder, ((MethodDescription)this.methodConfiguration.get(this.algorithm)).getConfigValue("genericFolder")), "source");
        return sourceFolder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getOptimalRunNumber() throws ComponentException {
        File result = new File(this.workingDir, "generic.result");
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                int n;
                BufferedReader fr = new BufferedReader(new FileReader(result));
                try {
                    String firstLine = fr.readLine();
                    if (firstLine == null) throw new ComponentException("Failed to parse result file for information about optimal variables; cause: result file is empty");
                    n = Integer.parseInt(firstLine);
                    return n;
                }
                finally {
                    if (fr == null) return n;
                    fr.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ComponentException("Failed to parse result file for information about optimal variables", (Throwable)e);
        }
    }

    @TaskDescription(value="Optimizer Algorithm Executor Generic")
    public void run() {
        try {
            String pythonInstallation;
            if (this.getPythonConfigurationSegment().isPresentInCurrentConfiguration()) {
                pythonInstallation = this.getPythonConfigurationSegment().getString("binaryPath");
                if (pythonInstallation == null || pythonInstallation.isEmpty()) {
                    throw new ComponentException("No Python installation specified.");
                }
            } else {
                throw new ComponentException("No Python installation specified.");
            }
            this.startProgram("source" + File.separator + "generic_optimizer.py", pythonInstallation);
        }
        catch (ComponentException e) {
            this.startFailed.set(true);
            this.startFailedException = e;
            LOGGER.error((Object)"Could not start external algorithm: ", (Throwable)e);
        }
    }

    public void writeHistoryDataItem(OptimizerComponentHistoryDataItem historyItem) {
        if (this.configurationFileReference == null) {
            try {
                this.configurationFileReference = ((ComponentDataManagementService)this.compContext.getService(ComponentDataManagementService.class)).createFileReferenceTDFromLocalFile(this.compContext, this.configurationFile, "configuration.json");
            }
            catch (IOException e) {
                String errorMessage = "Failed to store configuration file into the data management; it is not available in the workflow data browser";
                String errorId = LogUtils.logExceptionWithStacktraceAndAssignUniqueMarker((Log)LOGGER, (String)errorMessage, (Throwable)e);
                this.compContext.getLog().componentError(errorMessage, (Throwable)e, errorId);
            }
        }
        if (this.configurationFileReference != null) {
            historyItem.setInputFileReference(this.configurationFileReference.getFileReference());
        }
    }

    private ConfigurationSegment getPythonConfigurationSegment() {
        ServiceRegistryAccess serviceRegistry = ServiceRegistry.createAccessFor((Object)((Object)this));
        ConfigurationService configurationService = (ConfigurationService)serviceRegistry.getService(ConfigurationService.class);
        ConfigurationSegment pythonConfiguration = configurationService.getConfigurationSegment("thirdPartyIntegration/python");
        return pythonConfiguration;
    }
}

