/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner.definitions.impl;

import cucumber.api.java.en.Then;
import cucumber.api.java.en.When;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.executor.testutils.IntegrationTestExecutorUtils;
import de.rcenvironment.extras.testscriptrunner.common.CommonUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;

public class CommonStateAndSteps {
    private static CommonStateAndSteps current;
    private IntegrationTestExecutorUtils.ExecutionResult currentExecutionResult;
    private Map<String, String> substitutionMap;
    private final Log log = LogFactory.getLog(this.getClass());

    public CommonStateAndSteps() {
        current = this;
    }

    public static CommonStateAndSteps getCurrent() {
        return current;
    }

    public void setParameterSubstitutionMap(Map<String, String> newSubstitutionMap) {
        this.substitutionMap = newSubstitutionMap;
    }

    public void setCurrentExecutionResult(IntegrationTestExecutorUtils.ExecutionResult lastExecutionResult) {
        this.currentExecutionResult = lastExecutionResult;
    }

    @When(value="^[Ww]aiting for (\\d+) seconds")
    public void wait(int seconds) throws InterruptedException {
        if (seconds < 0) {
            throw new IllegalArgumentException("Invalid wait time: " + seconds);
        }
        this.log.info((Object)("Waiting for " + seconds + " seconds"));
        Thread.sleep(TimeUnit.SECONDS.toMillis(seconds));
    }

    @Then(value="^the exit code should be (\\d+)$")
    public void assertExitCodeIs(int expected) throws Throwable {
        int actual = this.currentExecutionResult.exitCode;
        Assert.assertEquals((String)"Wrong exit code", (long)expected, (long)actual);
    }

    @Then(value="^the (standard |error |)output should be (\\d+) lines? long$")
    public void assertLineCountOfSelectedOutputIs(String outputType, int expectedLines) throws Throwable {
        List<String> output = this.getSelectedFilteredOutput(outputType);
        Assert.assertEquals((String)("Wrong line count on " + outputType + " output"), (long)expectedLines, (long)output.size());
    }

    @Then(value="^the (standard |error |)output (should |should not |)contain \"(.*?)\"$")
    public void assertSelectedOutputContains(String outputType, String sign, String content) throws Throwable {
        if (this.substitutionMap != null) {
            content = CommonUtils.substitute(content, this.substitutionMap);
        }
        List<String> output = this.getSelectedFilteredOutput(outputType.trim());
        boolean contains = false;
        for (String line : output) {
            if (!line.contains(content)) continue;
            contains = true;
            break;
        }
        boolean error = false;
        String errorMessageTemplate = "";
        boolean should = this.parseSignSelector(sign);
        if (should && !contains) {
            error = true;
            errorMessageTemplate = "The %soutput did not contain the expected string \"%s\"; the full output is:\n%s";
        } else if (!should && contains) {
            error = true;
            errorMessageTemplate = "The %soutput did contain the unexpected string \"%s\"; the full output is:\n%s";
        }
        if (error) {
            Assert.fail((String)StringUtils.format((String)errorMessageTemplate, (Object[])new Object[]{outputType, content, this.getSelectedRawOutput(outputType)}));
        }
    }

    @Then(value="^the (standard |error |)output (should |should not |)contain$")
    public void assertSelectedOutputContainsLongText(String outputType, String sign, String expectedContent) throws Throwable {
        this.assertSelectedOutputContains(outputType, sign, expectedContent);
    }

    @Then(value="^the (standard |error |)output should be empty$")
    public void assertSelectedOutputIsEmpty(String outputType) throws Throwable {
        this.assertLineCountOfSelectedOutputIs(outputType, 0);
    }

    private String getSelectedRawOutput(String outputType) {
        switch (this.parseOutputSelector(outputType)) {
            case STANDARD: {
                return this.currentExecutionResult.stdout;
            }
            case ERROR: {
                return this.currentExecutionResult.stderr;
            }
        }
        throw new IllegalArgumentException(outputType);
    }

    private List<String> getSelectedFilteredOutput(String outputType) {
        switch (this.parseOutputSelector(outputType)) {
            case STANDARD: {
                return this.currentExecutionResult.filteredStdoutLines;
            }
            case ERROR: {
                return this.currentExecutionResult.filteredStderrLines;
            }
        }
        throw new IllegalArgumentException(outputType);
    }

    private boolean parseSignSelector(String sign) {
        switch (sign = sign.trim()) {
            case "should": {
                return true;
            }
            case "should not": {
                return false;
            }
        }
        throw new IllegalArgumentException(sign);
    }

    private OutputType parseOutputSelector(String outputType) {
        if (outputType == null || outputType.isEmpty()) {
            return OutputType.STANDARD;
        }
        switch (outputType = outputType.trim()) {
            case "standard": {
                return OutputType.STANDARD;
            }
            case "error": {
                return OutputType.ERROR;
            }
        }
        throw new IllegalArgumentException(outputType);
    }

    private static enum OutputType {
        STANDARD,
        ERROR;

    }
}

