/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;

public class CompositeReconcilerStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private List<IReconcilingStrategy> fReconcilingStrategies;

    public CompositeReconcilerStrategy(List<IReconcilingStrategy> strategies) {
        this.fReconcilingStrategies = strategies;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        for (IReconcilingStrategy iReconcilingStrategy : this.fReconcilingStrategies) {
            if (!(iReconcilingStrategy instanceof IReconcilingStrategyExtension)) continue;
            ((IReconcilingStrategyExtension)iReconcilingStrategy).setProgressMonitor(monitor);
        }
    }

    public void initialReconcile() {
        for (IReconcilingStrategy iReconcilingStrategy : this.fReconcilingStrategies) {
            if (!(iReconcilingStrategy instanceof IReconcilingStrategyExtension)) continue;
            ((IReconcilingStrategyExtension)iReconcilingStrategy).initialReconcile();
        }
    }

    public void setDocument(IDocument document) {
        for (IReconcilingStrategy iReconcilingStrategy : this.fReconcilingStrategies) {
            iReconcilingStrategy.setDocument(document);
        }
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        for (IReconcilingStrategy iReconcilingStrategy : this.fReconcilingStrategies) {
            iReconcilingStrategy.reconcile(dirtyRegion, subRegion);
        }
    }

    public void reconcile(IRegion partition) {
        for (IReconcilingStrategy iReconcilingStrategy : this.fReconcilingStrategies) {
            iReconcilingStrategy.reconcile(partition);
        }
    }
}

