/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandDescription;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.NetworkDestination;
import de.rcenvironment.core.communication.configuration.NodeConfigurationService;
import de.rcenvironment.core.datamanagement.MetaDataService;
import de.rcenvironment.core.datamanagement.commons.WorkflowRun;
import de.rcenvironment.core.datamanagement.commons.WorkflowRunDescription;
import de.rcenvironment.core.datamanagement.export.objects.PlainWorkflowRun;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.osgi.service.component.annotations.Component;

@Component
public class TestCommandPlugin
implements CommandPlugin {
    private static final String ROOT_COMMAND = "tc";
    private static final String OPEN_VIEW_COMMAND = "open_view";
    private static final String CLOSE_VIEW_COMMAND = "close_view";
    private static final String CLOSE_WELCOME_SCREEN = "close_welcome";
    private static final String EXPORT_WORKFLOW_RUN = "export_wf_run";
    private Map<String, String> viewIds = new HashMap<String, String>();

    public TestCommandPlugin() {
        this.fillViewIdMap();
    }

    private void fillViewIdMap() {
        this.viewIds.put("Component_Publishing", "de.rcenvironment.core.gui.authorization.ComponentPublishingView");
        this.viewIds.put("Cluster_Job_Monitor", "de.rcenvironment.core.gui.cluster.view.ClusterJobMonitorView");
        this.viewIds.put("Command_Console", "de.rcenvironment.core.gui.command.CommandConsoleViewer");
        this.viewIds.put("CPACS_Writer", "de.rcenvironment.components.cpacs.writer.gui.runtime.CpacsGeomView");
        this.viewIds.put("Data_Management_Browser", "de.rcenvironment.rce.gui.datamanagement.browser.DataManagementBrowser");
        this.viewIds.put("Excel", "de.rcenvironment.components.excel.gui.view.ExcelView");
        this.viewIds.put("Log", "de.rcenvironment.core.gui.log.LogView");
        this.viewIds.put("Network", "de.rcenvironment.core.gui.communication.views.NetworkView");
        this.viewIds.put("Optimizer", "de.rcenvironment.components.optimizer.gui.view.OptimizerView");
        this.viewIds.put("Parametric_Study", "de.rcenvironment.components.parametricstudy.gui.view.ParametricStudyView");
        this.viewIds.put("Properties", "org.eclipse.ui.views.PropertySheet");
        this.viewIds.put("TIGL_Viewer", "de.rcenvironment.core.gui.tiglviewer.views.TIGLViewer");
        this.viewIds.put("Timeline", "de.rcenvironment.gui.Timeline");
        this.viewIds.put("Workflow_List", "de.rcenvironment.gui.workflowList");
        this.viewIds.put("Workflow_Console", "de.rcenvironment.gui.WorkflowComponentConsole");
    }

    public void execute(CommandContext context) throws CommandException {
        String subCommand;
        context.consumeExpectedToken(ROOT_COMMAND);
        switch (subCommand = context.consumeNextToken()) {
            case "open_view": {
                this.handleOpenViewCommand(context);
                break;
            }
            case "close_view": {
                this.handleCloseViewCommand(context);
                break;
            }
            case "close_welcome": {
                this.closeWelcomeScreen(context);
                break;
            }
            case "export_wf_run": {
                this.exportWorkflow(context);
                break;
            }
            default: {
                throw CommandException.unknownCommand((CommandContext)context);
            }
        }
    }

    public Collection<CommandDescription> getCommandDescriptions() {
        ArrayList<CommandDescription> contributions = new ArrayList<CommandDescription>();
        contributions.add(new CommandDescription(StringUtils.format((String)"%s %s", (Object[])new Object[]{ROOT_COMMAND, OPEN_VIEW_COMMAND}), "<view>", true, "opens a GUI view and sets focus to it.", new String[]{"<view> : one of the following view keys is a valid input:", this.viewIds.keySet().toString()}));
        contributions.add(new CommandDescription(StringUtils.format((String)"%s %s", (Object[])new Object[]{ROOT_COMMAND, CLOSE_VIEW_COMMAND}), "(<view>|all)", true, "closes a GUI view.", new String[]{"<view> : one of the following view keys is a valid input:", "\t" + this.viewIds.keySet().toString()}));
        contributions.add(new CommandDescription(StringUtils.format((String)"%s %s", (Object[])new Object[]{ROOT_COMMAND, CLOSE_WELCOME_SCREEN}), "", true, "closes the welcome screen if present.", new String[0]));
        contributions.add(new CommandDescription(StringUtils.format((String)"%s %s", (Object[])new Object[]{ROOT_COMMAND, EXPORT_WORKFLOW_RUN}), "<absolute path to directory> <workflowtitle>", true, "exports the run corresponding to the workflowtitle to the given directory.", new String[0]));
        return contributions;
    }

    private void closeWelcomeScreen(CommandContext context) {
        new UIJob("Closing welcome screen"){

            public IStatus runInUIThread(IProgressMonitor progressMonitor) {
                IViewReference[] viewReferences;
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IViewReference[] iViewReferenceArray = viewReferences = page.getViewReferences();
                int n = viewReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    IViewReference viewRef = iViewReferenceArray[n2];
                    if (viewRef.getId().equals("org.eclipse.ui.internal.introview")) {
                        TestCommandPlugin.this.closeView("org.eclipse.ui.internal.introview");
                    }
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void exportWorkflow(CommandContext context) {
        File targetDirectory = new File(context.consumeNextToken());
        String workflowTitle = context.consumeNextToken();
        if (targetDirectory == null || workflowTitle == null) {
            context.println((Object)"Failed to execute: Not enough parameters.");
        }
        if (context.hasRemainingTokens()) {
            context.println((Object)"Failed to execute: Too many parameters.");
            return;
        }
        File targetFile = new File(targetDirectory, String.valueOf(workflowTitle.replaceAll(":", "_")) + ".json");
        try {
            ServiceRegistryAccess serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)this);
            MetaDataService metaDataService = (MetaDataService)serviceRegistryAccess.getService(MetaDataService.class);
            NodeConfigurationService nodeConfigurationService = (NodeConfigurationService)serviceRegistryAccess.getService(NodeConfigurationService.class);
            InstanceNodeSessionId nodeSessionId = nodeConfigurationService.getInstanceNodeSessionId();
            boolean foundCorrespondingWfRunId = false;
            for (WorkflowRunDescription wfRunDesc : metaDataService.getWorkflowRunDescriptions()) {
                if (!workflowTitle.equals(wfRunDesc.getWorkflowTitle())) continue;
                foundCorrespondingWfRunId = true;
                WorkflowRun workflowRun = metaDataService.getWorkflowRun(wfRunDesc.getWorkflowRunID(), (NetworkDestination)nodeSessionId);
                TypedDatumSerializer serializer = ((TypedDatumService)serviceRegistryAccess.getService(TypedDatumService.class)).getSerializer();
                PlainWorkflowRun plainWorkflowRun = new PlainWorkflowRun(workflowRun, serializer);
                ObjectMapper mapper = new ObjectMapper();
                mapper.enable(SerializationFeature.INDENT_OUTPUT);
                mapper.writeValue(targetFile, (Object)plainWorkflowRun);
                context.println((Object)"Successfully exported workflowrun.");
                break;
            }
            if (!foundCorrespondingWfRunId) {
                context.println((Object)StringUtils.format((String)"Failed to find workflow corresponding to wf title \"%s\"", (Object[])new Object[]{workflowTitle}));
            }
        }
        catch (CommunicationException | IOException e) {
            context.println((Object)StringUtils.format((String)"Failed to export workflow run: %s", (Object[])new Object[]{e}));
        }
    }

    private void handleOpenViewCommand(CommandContext context) throws CommandException {
        String viewId = context.consumeNextToken();
        if (context.hasRemainingTokens()) {
            throw CommandException.syntaxError((String)"Too many arguments. Only one is expected.", (CommandContext)context);
        }
        if (!this.viewIds.containsKey(viewId)) {
            throw CommandException.syntaxError((String)"No view associated to passed argument.", (CommandContext)context);
        }
        this.openView(viewId);
    }

    private void handleCloseViewCommand(CommandContext context) throws CommandException {
        String viewId = context.consumeNextToken();
        if (context.hasRemainingTokens()) {
            throw CommandException.syntaxError((String)"Too many arguments. Only one is expected.", (CommandContext)context);
        }
        if (!this.viewIds.containsKey(viewId)) {
            throw CommandException.syntaxError((String)"No view associated with passed argument.", (CommandContext)context);
        }
        this.closeView(this.viewIds.get(viewId));
    }

    private void openView(final String viewKey) {
        new UIJob(StringUtils.format((String)"Opening view %s", (Object[])new Object[]{viewKey})){

            public IStatus runInUIThread(IProgressMonitor progressMonitor) {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView((String)TestCommandPlugin.this.viewIds.get(viewKey));
                }
                catch (PartInitException partInitException) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void closeView(final String viewId) {
        new UIJob(StringUtils.format((String)"Closing view %s", (Object[])new Object[]{viewId})){

            public IStatus runInUIThread(IProgressMonitor progressMonitor) {
                IViewReference[] viewReferences;
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IViewReference[] iViewReferenceArray = viewReferences = page.getViewReferences();
                int n = viewReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    IViewReference viewRef = iViewReferenceArray[n2];
                    if (viewRef.getId().equals(viewId)) {
                        page.hideView(viewRef.getView(true));
                        return Status.OK_STATUS;
                    }
                    ++n2;
                }
                return Status.CANCEL_STATUS;
            }
        }.schedule();
    }

    private void closeAllViews() {
        new UIJob("Closing all views"){

            public IStatus runInUIThread(IProgressMonitor progressMonitor) {
                IViewReference[] viewReferences;
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IViewReference[] iViewReferenceArray = viewReferences = page.getViewReferences();
                int n = viewReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    IViewReference viewRef = iViewReferenceArray[n2];
                    if (TestCommandPlugin.this.viewIds.containsValue(viewRef.getId())) {
                        TestCommandPlugin.this.closeView(viewRef.getId());
                    }
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }
}

