/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner.definitions.impl;

import com.jcraft.jsch.JSchException;
import cucumber.api.java.en.Then;
import cucumber.api.java.en.When;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.common.textstream.receivers.CapturingTextOutReceiver;
import de.rcenvironment.core.utils.ssh.jsch.SshParameterException;
import de.rcenvironment.extras.testscriptrunner.definitions.common.InstanceManagementStepDefinitionBase;
import de.rcenvironment.extras.testscriptrunner.definitions.common.ManagedInstance;
import de.rcenvironment.extras.testscriptrunner.definitions.common.TestScenarioExecutionContext;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.junit.Assert;

public class WorkflowStepDefinitions
extends InstanceManagementStepDefinitionBase {
    private String lastWorkflowName;
    private Path lastWorkflowLogDir;
    private ManagedInstance lastWorkflowInitiatingInstance;
    private Map<String, String> runningWorkflows = new HashMap<String, String>();

    public WorkflowStepDefinitions(TestScenarioExecutionContext executionContext) {
        super(executionContext);
    }

    @When(value="^executing (?:the )?workflow \"([^\"]*)\" on (?:instance )?\"([^\"]*)\"$(?: in (\\d+) seconds)?")
    public void whenExecutingWorkflowOnInstance(String workflowNameInput, String instanceId, String timeoutString) throws Throwable {
        this.whenStartingWorkflowOnInstance(workflowNameInput, instanceId);
        this.whenWaitingUntilWorkflowReachedState(workflowNameInput, instanceId, "finished", timeoutString);
    }

    @When(value="^starting (?:the )?workflow \"([^\"]*)\" on (?:instance )?\"([^\"]*)\"$")
    public void whenStartingWorkflowOnInstance(String workflowNameInput, final String instanceId) throws Throwable {
        String workflowName;
        final ManagedInstance instance = this.resolveInstance(instanceId);
        String[] workflowInfo = this.startWorkflowOnInstance(instance, workflowName = this.addWorkflowFileExtension(workflowNameInput));
        if (!workflowInfo[0].equals(workflowName)) {
            Assert.fail((String)"obtained workflowInfo for wrong workflow execution.");
        }
        String workflowLogDir = workflowInfo[1];
        final String workflowId = workflowInfo[2];
        final String workflowKey = this.getWorkflowKey(workflowName, instanceId);
        if (this.runningWorkflows.containsKey(workflowKey)) {
            this.log.warn((Object)"Another workflow of the same file is still running. Cannot store the new workflow id.");
        } else {
            this.runningWorkflows.put(workflowKey, workflowId);
            new Job(StringUtils.format((String)"check for termination workflow %s", (Object[])new Object[]{workflowId})){

                protected IStatus run(IProgressMonitor monitor) {
                    block6: {
                        Pattern workflowFinishedPattern = Pattern.compile("FINISHED \\[" + workflowId + "\\]");
                        try {
                            while (INSTANCE_MANAGEMENT_SERVICE.isInstanceRunning(instanceId)) {
                                String commandOutput = WorkflowStepDefinitions.this.executeCommandOnInstance(instance, "wf list", false);
                                Matcher m = workflowFinishedPattern.matcher(commandOutput);
                                if (m.find()) {
                                    WorkflowStepDefinitions.this.runningWorkflows.remove(workflowKey);
                                    break block6;
                                }
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (InterruptedException e) {
                                    WorkflowStepDefinitions.this.log.error((Object)"Exception while trying to sleep tread", (Throwable)e);
                                    return Status.CANCEL_STATUS;
                                }
                            }
                            WorkflowStepDefinitions.this.printToCommandConsole(StringUtils.format((String)"instance %s not running anymore. Stopping to check for state of workflow %s.", (Object[])new Object[]{instanceId, workflowName}));
                        }
                        catch (IOException e) {
                            WorkflowStepDefinitions.this.log.error((Object)"Exception while checking running state of instance", (Throwable)e);
                            return Status.CANCEL_STATUS;
                        }
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
        Path logFilesDirectory = Paths.get(workflowLogDir, new String[0]);
        if (!Files.isDirectory(logFilesDirectory, new LinkOption[0])) {
            Assert.fail((String)("Found log output directory location '" + logFilesDirectory + "' in command output, but it does not point to an actual directory"));
        }
        this.lastWorkflowLogDir = logFilesDirectory;
        this.lastWorkflowName = workflowName;
        this.lastWorkflowInitiatingInstance = instance;
    }

    @When(value="^(cancelling|deleting|opening|pausing|resuming) workflow \"([^\"]*)\" on (?:instance )?\"([^\"]*)\"$")
    public void operationOnRunningWorkflow(String operation, String workflowNameInput, String instanceId) {
        block20: {
            String command;
            String workflowKey;
            ManagedInstance instance;
            block19: {
                instance = this.resolveInstance(instanceId);
                String workflowName = this.addWorkflowFileExtension(workflowNameInput);
                workflowKey = this.getWorkflowKey(workflowName, instanceId);
                if (this.runningWorkflows.containsKey(workflowKey)) break block19;
                Assert.fail((String)"Could not execute operation on workflow, since workflow id could not be obtained.");
                break block20;
            }
            String workflowId = this.runningWorkflows.get(workflowKey);
            switch (operation) {
                case "cancelling": {
                    command = StringUtils.format((String)"wf cancel %s", (Object[])new Object[]{workflowId});
                    break;
                }
                case "deleting": {
                    command = StringUtils.format((String)"wf delete %s", (Object[])new Object[]{workflowId});
                    break;
                }
                case "opening": {
                    command = StringUtils.format((String)"wf open %s", (Object[])new Object[]{workflowId});
                    break;
                }
                case "pausing": {
                    command = StringUtils.format((String)"wf pause %s", (Object[])new Object[]{workflowId});
                    break;
                }
                case "resuming": {
                    command = StringUtils.format((String)"wf resume %s", (Object[])new Object[]{workflowId});
                    break;
                }
                default: {
                    Assert.fail((String)StringUtils.format((String)"%s a unsupported operation.", (Object[])new Object[]{operation}));
                    return;
                }
            }
            String output = this.executeCommandOnInstance(instance, command, false);
            this.printToCommandConsole(output);
        }
    }

    @When(value="^waiting until workflow \"([^\"]*)\" on (?:instance )?\"([^\"]*)\" (?:has|is) (finished|cancelled|canceling|failed)(?: or (\\d+) seconds have passed)?")
    public void whenWaitingUntilWorkflowReachedState(String workflowNameInput, String instanceId, String state, String timeoutString) {
        ManagedInstance instance = this.resolveInstance(instanceId);
        String workflowName = this.addWorkflowFileExtension(workflowNameInput);
        int timeoutInSecs = this.parseTimeout(timeoutString);
        this.printToCommandConsole(StringUtils.format((String)"Waiting for workflow %s to be %s. Aborting after %s seconds if not happend by then.", (Object[])new Object[]{workflowName, state, timeoutInSecs}));
        String workflowKey = this.getWorkflowKey(workflowName, instanceId);
        if (!this.runningWorkflows.containsKey(workflowKey)) {
            this.printToCommandConsole(StringUtils.format((String)"Workflow %s is not running on instance %s", (Object[])new Object[]{workflowName, instanceId}));
            return;
        }
        String workflowId = this.runningWorkflows.get(workflowKey);
        Pattern workflowFinishedPattern = Pattern.compile(String.valueOf(state.toUpperCase()) + " \\[" + workflowId + "\\]");
        for (long countMillis = TimeUnit.SECONDS.toMillis(timeoutInSecs); countMillis > 0L; countMillis -= 500L) {
            String commandOutput = this.executeCommandOnInstance(instance, "wf list", false);
            Matcher m = workflowFinishedPattern.matcher(commandOutput);
            try {
                if (m.find()) {
                    this.printToCommandConsole(StringUtils.format((String)"Workflow %s has reached state %s on %s.", (Object[])new Object[]{workflowName, state, instanceId}));
                    return;
                }
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                Assert.fail((String)StringUtils.format((String)"InterruptedException caused when waiting for workflow to reach state. Exception: \n%s", (Object[])new Object[]{e}));
                return;
            }
        }
        this.printToCommandConsole(StringUtils.format((String)"%s second(s) have passed and workflow %s has not reached state %s. Timeout was reached.", (Object[])new Object[]{timeoutInSecs, workflowName, state}));
    }

    @When(value="^waiting until all workflows on \"([^\"]*)\" are not running anymore(?: or (\\d+) seconds have passed)?")
    public void whenWaitingUntilAllWorkflowsFinished(String instanceId, String timeoutString) throws Throwable {
        int timeoutInSecs = this.parseTimeout(timeoutString);
        long countMillis = TimeUnit.SECONDS.toMillis(timeoutInSecs);
        while (countMillis > 0L) {
            ManagedInstance instance = this.resolveInstance(instanceId);
            String commandOutput = this.executeCommandOnInstance(instance, "wf", false);
            Pattern logDirPattern = Pattern.compile("-- TOTAL COUNT: \\d+ workflow\\(s\\): (\\d+) running");
            Matcher matcher = logDirPattern.matcher(commandOutput);
            if (!matcher.find()) {
                Assert.fail((String)StringUtils.format((String)"Could not identify the number of running workflows by trying to match \"%s\"; full output:\n %s", (Object[])new Object[]{logDirPattern, commandOutput}));
            } else if (Integer.parseInt(matcher.group(1)) == 0) {
                return;
            }
            Thread.sleep(500L);
            countMillis -= 500L;
        }
        this.printToCommandConsole(StringUtils.format((String)"%s second(s) have passed and not all workflows are finished. Timeout was reached.", (Object[])new Object[]{timeoutInSecs}));
    }

    @Then(value="^the workflow log should (not )?contain (the pattern )?\"(.*)\"$")
    public void thenWorkflowLogContains(String negationFlag, String useRegexpMarker, String substring) throws Throwable {
        if (this.lastWorkflowLogDir == null) {
            Assert.fail((String)"Test error: No workflow log present yet");
            return;
        }
        String wfLogFileContent = null;
        Path wfLogFile = this.lastWorkflowLogDir.resolve("workflow.log");
        if (Files.exists(this.lastWorkflowLogDir.resolve("workflow.log.tmp"), new LinkOption[0]) || Files.isRegularFile(wfLogFile, new LinkOption[0])) {
            int tries = 3;
            while (tries > 0) {
                if (Files.isRegularFile(wfLogFile, new LinkOption[0])) {
                    wfLogFileContent = FileUtils.readFileToString((File)wfLogFile.toFile());
                    break;
                }
                Thread.sleep(500L);
                if (tries != 0) continue;
                Assert.fail((String)("Found log output directory location '" + this.lastWorkflowLogDir + "', but workflow.log.tmp did not convert to workflow.log"));
            }
        } else {
            Assert.fail((String)("Found log output directory location '" + this.lastWorkflowLogDir + "', but there is neither workflow.log not workflow.log.tmp file inside"));
        }
        if (wfLogFileContent.isEmpty()) {
            Assert.fail((String)"Test error: Workflow log was stored, but is empty");
        }
        this.assertPropertyOfTextOutput(this.lastWorkflowInitiatingInstance, negationFlag, useRegexpMarker, substring, wfLogFileContent, "workflow log");
    }

    @Then(value="^the workflow should have reached the (\\w+) state$")
    public void thenWorkflowReachedState(String state) throws Throwable {
        this.thenWorkflowLogContainsCaller(false, false, "NEW_STATE:" + state);
    }

    @Then(value="^the workflow controller should have been \"([^\"]+)\"(?: using node id \"(\\w+)\")?$")
    public void thenWorkflowController(String nodeName, String nodeId) throws Throwable {
        this.thenWorkflowLogContainsCaller(false, false, "Location of workflow controller: \"" + nodeName + "\"");
    }

    @Then(value="^workflow component \"([^\"]+)\" should have been run on \"([^\"]+)\"( via uplink)?(?: using node id \"(\\w+)\")?$")
    public void thenComponentRanOn(String compName, String nodeName, String uplinkFlag, String nodeId) throws Throwable {
        if (uplinkFlag != null) {
            nodeName = String.valueOf(nodeName) + " \\(via [^)]+\\)";
        }
        String regexp = "Location of workflow component \"" + compName + "\" [^:]+: \"" + nodeName + "\"";
        if (nodeId != null) {
            regexp = String.valueOf(regexp) + " \\[" + nodeId + ":0\\]";
        }
        this.thenWorkflowLogContainsCaller(false, true, regexp);
    }

    @Then(value="^workflow component \"([^\"]+)\" should have been cancelled$")
    public void thenComponentCancelledOn(String compName) throws Throwable {
        this.whenWaitingUntilWorkflowReachedState(this.lastWorkflowName, this.lastWorkflowInitiatingInstance.getId(), "cancelled", null);
        this.thenComponentTerminated(compName);
    }

    @Then(value="^workflow component \"([^\"]+)\" should be terminated$")
    public void thenComponentTerminated(String compName) throws Throwable {
        String regexp = "\\[LIFE_CYCLE_EVENT\\] \\[" + compName + "\\] COMPONENT_TERMINATED";
        this.thenWorkflowLogContainsCaller(false, true, regexp);
    }

    private String[] startWorkflowOnInstance(ManagedInstance instance, String workflowName) throws IOException {
        Path originalWfFileLocation = this.executionContext.getTestScriptLocation().toPath().resolve("workflows").resolve(workflowName);
        if (!Files.isRegularFile(originalWfFileLocation, new LinkOption[0])) {
            throw new AssertionError((Object)("No workflow file found at expected location " + originalWfFileLocation));
        }
        File tempDir = TempFileServiceAccess.getInstance().createManagedTempDir("bdd-wf");
        Path wfFileLocation = tempDir.toPath().resolve(originalWfFileLocation.getFileName());
        Files.copy(originalWfFileLocation, wfFileLocation, new CopyOption[0]);
        String instanceId = instance.getId();
        String startInfoText = StringUtils.format((String)"Starting workflow %s on instance %s", (Object[])new Object[]{workflowName, instanceId});
        this.printToCommandConsole(startInfoText);
        this.log.debug((Object)startInfoText);
        CapturingTextOutReceiver commandOutputReceiver = new CapturingTextOutReceiver();
        try {
            String[] workflowInfo = INSTANCE_MANAGEMENT_SERVICE.startWorkflowOnInstance(instanceId, wfFileLocation, commandOutputReceiver);
            if (workflowInfo.length != 3) {
                Assert.fail((String)"Info about started workflow did not contain the expected amount of information.");
            }
            instance.setLastCommandOutput(commandOutputReceiver.getBufferedOutput());
            this.executionContext.setLastInstanceWithSingleCommandExecution(instance);
            this.log.debug((Object)StringUtils.format((String)"Started workflow %s on instance %s", (Object[])new Object[]{workflowName, instanceId}));
            return workflowInfo;
        }
        catch (JSchException | SshParameterException | IOException | InterruptedException e) {
            Assert.fail((String)StringUtils.format((String)"Failed to start workflow %s on instance %s: %s", (Object[])new Object[]{workflowName, instanceId, e.toString()}));
            return null;
        }
    }

    private void thenWorkflowLogContainsCaller(boolean negate, boolean useRegex, String contents) throws Throwable {
        String negationFlag = null;
        String regexFlag = null;
        if (negate) {
            negationFlag = "not ";
        }
        if (useRegex) {
            regexFlag = "the pattern ";
        }
        this.thenWorkflowLogContains(negationFlag, regexFlag, contents);
    }

    private int parseTimeout(String timeoutString) {
        int timeoutInSecs = timeoutString == null ? 60 : Integer.parseInt(timeoutString);
        return timeoutInSecs;
    }

    private String addWorkflowFileExtension(String workflowName) {
        if (!workflowName.endsWith(".wf")) {
            workflowName = String.valueOf(workflowName) + ".wf";
        }
        return workflowName;
    }

    private String getWorkflowKey(String workflowName, String instanceId) {
        return StringUtils.format((String)"%s_%s", (Object[])new Object[]{workflowName, instanceId});
    }
}

