/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.outputwriter.execution;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rcenvironment.core.component.update.api.PersistentComponentDescription;
import de.rcenvironment.core.component.update.spi.PersistentComponentDescriptionUpdater;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.IOException;

public class OutputWriterPersistentComponentDescriptionUpdater
implements PersistentComponentDescriptionUpdater {
    private static final String V1_1 = "1.1";
    private static final String V2_0 = "2.0";
    private static final String CURRENT_VERSION = "2.0";

    public String[] getComponentIdentifiersAffectedByUpdate() {
        return new String[]{"de.rcenvironment.outputwriter"};
    }

    public int getFormatVersionsAffectedByUpdate(String persistentComponentDescriptionVersion, boolean silent) {
        int update = 0;
        if (!silent && persistentComponentDescriptionVersion != null && persistentComponentDescriptionVersion.compareTo("2.0") < 0) {
            update |= 4;
        }
        return update;
    }

    public PersistentComponentDescription performComponentDescriptionUpdate(int formatVersion, PersistentComponentDescription description, boolean silent) throws IOException {
        if (!silent) {
            switch (formatVersion) {
                case 4: {
                    if (description.getComponentVersion().compareTo(V1_1) < 0) {
                        description = this.updateFromV10ToV11(description);
                    }
                    if (description.getComponentVersion().compareTo("2.0") >= 0) break;
                    description = this.updateFromV11ToV20(description);
                    break;
                }
            }
        }
        return description;
    }

    private PersistentComponentDescription updateFromV10ToV11(PersistentComponentDescription description) throws JsonParseException, IOException {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        ObjectNode configurationsNode = (ObjectNode)node.get("configuration");
        if (configurationsNode != null && configurationsNode.has("OWWritePath")) {
            configurationsNode.remove("OWWritePath");
            configurationsNode.put("OWWritePath", "${targetRootFolder}");
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        description = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        description.setComponentVersion(V1_1);
        return description;
    }

    private PersistentComponentDescription updateFromV11ToV20(PersistentComponentDescription description) throws JsonParseException, IOException {
        description.setComponentVersion("2.0");
        return description;
    }
}

