/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.core.text;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;

public class TextSearchEngineRegistry {
    private static final String EXTENSION_POINT_ID = "org.eclipse.search.textSearchEngine";
    private static final String ENGINE_NODE_NAME = "textSearchEngine";
    private static final String ATTRIB_ID = "id";
    private static final String ATTRIB_LABEL = "label";
    private static final String ATTRIB_CLASS = "class";
    private TextSearchEngine fPreferredEngine = null;
    private String fPreferredEngineId = null;

    public TextSearchEngine getPreferred() {
        String preferredId = this.getPreferredEngineID();
        if (!preferredId.equals(this.fPreferredEngineId)) {
            this.updateEngine(preferredId);
        }
        return this.fPreferredEngine;
    }

    private void updateEngine(String preferredId) {
        if (preferredId.length() != 0) {
            TextSearchEngine engine = this.createFromExtension(preferredId);
            if (engine != null) {
                this.fPreferredEngineId = preferredId;
                this.fPreferredEngine = engine;
                return;
            }
            this.setPreferredEngineID("");
        }
        this.fPreferredEngineId = "";
        this.fPreferredEngine = TextSearchEngine.createDefault();
    }

    private String getPreferredEngineID() {
        IPreferenceStore prefs = SearchPlugin.getDefault().getPreferenceStore();
        String preferedEngine = prefs.getString(EXTENSION_POINT_ID);
        return preferedEngine;
    }

    private void setPreferredEngineID(String id) {
        IPreferenceStore prefs = SearchPlugin.getDefault().getPreferenceStore();
        prefs.setValue(EXTENSION_POINT_ID, id);
    }

    private TextSearchEngine createFromExtension(final String id) {
        final TextSearchEngine[] res = new TextSearchEngine[1];
        SafeRunnable safe = new SafeRunnable(){

            public void run() throws Exception {
                IConfigurationElement[] extensions;
                IConfigurationElement[] iConfigurationElementArray = extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(TextSearchEngineRegistry.EXTENSION_POINT_ID);
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement curr = iConfigurationElementArray[n2];
                    if (TextSearchEngineRegistry.ENGINE_NODE_NAME.equals(curr.getName()) && id.equals(curr.getAttribute(TextSearchEngineRegistry.ATTRIB_ID))) {
                        res[0] = (TextSearchEngine)curr.createExecutableExtension(TextSearchEngineRegistry.ATTRIB_CLASS);
                        return;
                    }
                    ++n2;
                }
            }

            public void handleException(Throwable e) {
                SearchPlugin.log(e);
            }
        };
        SafeRunnable.run((ISafeRunnable)safe);
        return res[0];
    }

    public String[][] getAvailableEngines() {
        IConfigurationElement[] extensions;
        ArrayList<String[]> res = new ArrayList<String[]>();
        res.add(new String[]{SearchMessages.TextSearchEngineRegistry_defaulttextsearch_label, ""});
        IConfigurationElement[] iConfigurationElementArray = extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement engine = iConfigurationElementArray[n2];
            if (ENGINE_NODE_NAME.equals(engine.getName())) {
                res.add(new String[]{engine.getAttribute(ATTRIB_LABEL), engine.getAttribute(ATTRIB_ID)});
            }
            ++n2;
        }
        return (String[][])res.toArray((T[])new String[res.size()][]);
    }
}

