/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.help.ICriteria;
import org.eclipse.help.internal.criteria.CriterionResource;

public class CriteriaUtilities {
    public static List<String> getCriteriaValues(String rawValues) {
        ArrayList<String> result = new ArrayList<String>();
        if (rawValues != null) {
            String[] values = rawValues.split(",");
            int j = 0;
            while (j < values.length) {
                String value = values[j].trim();
                if (value.length() > 0) {
                    result.add(value);
                }
                ++j;
            }
        }
        return result;
    }

    public static void addCriteriaToMap(Map<String, Set<String>> map, ICriteria[] criteria) {
        int i = 0;
        while (i < criteria.length) {
            ICriteria criterion = criteria[i];
            String name = criterion.getName();
            List<String> values = CriteriaUtilities.getCriteriaValues(criterion.getValue());
            if (name != null && name.length() > 0 && values.size() > 0) {
                Set<String> existingValueSet = map.get(name = name.toLowerCase());
                if (existingValueSet == null) {
                    existingValueSet = new HashSet<String>();
                }
                existingValueSet.addAll(values);
                map.put(name, existingValueSet);
            }
            ++i;
        }
    }

    public static void addCriteriaToMap(Map<String, Set<String>> map, CriterionResource[] criteria) {
        int i = 0;
        while (i < criteria.length) {
            CriterionResource criterion = criteria[i];
            String criterionName = criterion.getCriterionName();
            List criterionValues = criterion.getCriterionValues();
            Set<String> existedValueSet = map.get(criterionName);
            if (existedValueSet == null) {
                existedValueSet = new HashSet<String>();
            }
            existedValueSet.addAll(criterionValues);
            map.put(criterionName, existedValueSet);
            ++i;
        }
    }
}

