/*
 * Decompiled with CFR 0.152.
 */
package de.vonloesch.pdf4eclipse.model.jpedal;

import de.vonloesch.pdf4eclipse.model.IPDFDestination;
import de.vonloesch.pdf4eclipse.model.IPDFFile;
import de.vonloesch.pdf4eclipse.model.IPDFPage;
import de.vonloesch.pdf4eclipse.model.jpedal.JPedalPDFFile;
import de.vonloesch.pdf4eclipse.model.jpedal.JPedalPDFPage;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import org.jpedal.PdfDecoder;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;

public class JPedalPDFDestination
implements IPDFDestination {
    PdfObject dest;
    String url;
    int type;

    public JPedalPDFDestination(PdfObject o) {
        this.dest = o;
        this.type = 2;
    }

    public JPedalPDFDestination(String url) {
        this.url = url;
        this.type = 1;
    }

    @Override
    public IPDFPage getPage(IPDFFile pdfFile) {
        if (this.type == 1) {
            return null;
        }
        PdfDecoder decoder = ((JPedalPDFFile)pdfFile).decoder;
        PdfArrayIterator destIt = this.dest.getMixedArray(339034948);
        String ref = this.dest.getObjectRefAsString();
        int pageNr = -1;
        if (destIt != null && destIt.getTokenCount() > 0) {
            String newRef;
            int possiblePage = destIt.getNextValueAsInteger(false) + 1;
            ref = destIt.getNextValueAsString(true);
            if (ref.endsWith(" R")) {
                pageNr = decoder.getPageFromObjectRef(ref);
            } else if (possiblePage > 0) {
                pageNr = possiblePage;
            }
            if (pageNr == -1 && (newRef = decoder.getIO().convertNameToRef(ref)) != null && newRef.endsWith(" R")) {
                pageNr = decoder.getPageFromObjectRef(newRef);
            }
        }
        if (pageNr == -1) {
            return null;
        }
        return new JPedalPDFPage(decoder, pageNr);
    }

    @Override
    public Rectangle2D getPosition() {
        if (this.type == 1) {
            return null;
        }
        PdfArrayIterator destIt = this.dest.getMixedArray(339034948);
        if (destIt != null && destIt.getTokenCount() > 1) {
            destIt.getNextValueAsString(true);
            int type = destIt.getNextValueAsConstant(true);
            if (type == 2631978) {
                float x = destIt.getNextValueAsFloat();
                float y = destIt.getNextValueAsFloat();
                return new Rectangle((int)x, (int)y, 10, 10);
            }
        }
        return null;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public String getURL() {
        return this.url;
    }
}

