/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner.definitions.helper;

import de.rcenvironment.extras.testscriptrunner.definitions.helper.CommonConnectionOptions;
import java.util.Optional;

public class RegularConnectionOptions {
    private int autoRetryInitialDelay;
    private int autoRetryMaxDelay;
    private float autoRetryDelayMultiplier;
    private boolean isRelay;
    private CommonConnectionOptions commonOptions = new CommonConnectionOptions();

    RegularConnectionOptions() {
        this.setAutoRetryInitialDelay(5);
        this.setAutoRetryMaxDelay(30);
        this.setAutoRetryDelayMultiplier(1.5f);
        this.setRelay(false);
    }

    private void setAutoRetryDelayMultiplier(float autoRetryDelayMultiplier) {
        this.autoRetryDelayMultiplier = autoRetryDelayMultiplier;
    }

    private void setAutoRetryInitialDelay(int autoRetryInitialDelay) {
        this.autoRetryInitialDelay = autoRetryInitialDelay;
    }

    private void setAutoRetryMaxDelay(int autoRetryMaxDelay) {
        this.autoRetryMaxDelay = autoRetryMaxDelay;
    }

    private void setAutoStart(boolean autoStartFlag) {
        this.commonOptions.setAutoStart(autoStartFlag);
    }

    private void setConnectionName(String connectionName) {
        this.commonOptions.setConnectionName(connectionName);
    }

    private void setHost(String host) {
        this.commonOptions.setHost(host);
    }

    private void setPort(int port) {
        this.commonOptions.setPort(port);
    }

    private void setServerNumber(int serverNumber) {
        this.commonOptions.setServerNumber(serverNumber);
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getAutoRetryInitialDelay() {
        return this.autoRetryInitialDelay;
    }

    public int getAutoRetryMaxDelay() {
        return this.autoRetryMaxDelay;
    }

    public float getAutoRetryDelayMultiplier() {
        return this.autoRetryDelayMultiplier;
    }

    public Optional<String> getConnectionName() {
        return this.commonOptions.getConnectionName();
    }

    public String getHost() {
        return this.commonOptions.getHost();
    }

    public Optional<Integer> getPort() {
        return this.commonOptions.getPort();
    }

    public int getServerNumber() {
        return this.commonOptions.getServerNumber();
    }

    public boolean getAutoStartFlag() {
        return this.commonOptions.getAutoStart();
    }

    public boolean isRelay() {
        return this.isRelay;
    }

    public void setRelay(boolean isRelayFlag) {
        this.isRelay = isRelayFlag;
    }

    public static class Builder {
        private RegularConnectionOptions options = new RegularConnectionOptions();

        Builder() {
        }

        public Builder autoStart(boolean autoStartValue) {
            this.options.setAutoStart(autoStartValue);
            return this;
        }

        public Builder autoRetryDelayMultiplier(float autoRetryDelayMultiplierValue) {
            this.options.setAutoRetryDelayMultiplier(autoRetryDelayMultiplierValue);
            return this;
        }

        public Builder autoRetryInitialDelay(int autoRetryInitialDelayValue) {
            this.options.setAutoRetryInitialDelay(autoRetryInitialDelayValue);
            return this;
        }

        public Builder autoRetryMaxDelay(int autoRetryMaxDelayValue) {
            this.options.setAutoRetryMaxDelay(autoRetryMaxDelayValue);
            return this;
        }

        public Builder connectionName(String connenctionNameValue) {
            this.options.setConnectionName(connenctionNameValue);
            return this;
        }

        public Builder host(String hostValue) {
            this.options.setHost(hostValue);
            return this;
        }

        public Builder port(int portValue) {
            this.options.setPort(portValue);
            return this;
        }

        public Builder relay(Boolean isRelayFlag) {
            this.options.setRelay(isRelayFlag);
            return this;
        }

        public Builder serverNumber(int serverNumberValue) {
            this.options.setServerNumber(serverNumberValue);
            return this;
        }

        public RegularConnectionOptions build() {
            return this.options;
        }
    }
}

