/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.switchcmp.gui;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.components.switchcmp.common.SwitchComponentConstants;
import de.rcenvironment.components.switchcmp.common.SwitchCondition;
import de.rcenvironment.components.switchcmp.execution.validator.SwitchComponentValidationMessage;
import de.rcenvironment.components.switchcmp.gui.Messages;
import de.rcenvironment.core.component.model.endpoint.api.EndpointChange;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.component.validation.api.ComponentValidationMessage;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNodeUtil;
import de.rcenvironment.core.component.workflow.model.spi.ComponentInstanceProperties;
import de.rcenvironment.core.gui.workflow.editor.properties.ValidatingWorkflowNodePropertySection;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodePropertySection;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class SwitchConditionSection
extends ValidatingWorkflowNodePropertySection {
    private static final int TABLE_BUTTON_SIZE = 26;
    private static final int COLUMN_WEIGHT_NUMBER = 5;
    private static final int COLUMN_WEIGHT_CONDITION = 60;
    private static final int NUMBER_COLUMN = 0;
    private static final int CONDITION_COLUMN = 1;
    private static final String[] CONDITION_TABLE_TITLES = new String[]{"Number #", "Condition Script"};
    private static final String EXCEPTION_MESSAGE_WRITING = "Unexpected Exception occured, while writing JSON content String.";
    protected final Log log = LogFactory.getLog(SwitchConditionSection.class);
    private Button insertChannelButton;
    private Button insertOperatorButton;
    private Button insertConditionButton;
    private Combo channelCombo;
    private Combo operatorCombo;
    private Combo conditionCombo;
    private Button removeButton;
    private Button conditionUpButton;
    private Button conditionDownButton;
    private Table conditionTable;
    private TableViewer viewer;
    private ArrayList<SwitchCondition> contentList;
    private Point selectedPoint;
    private PropertyChangeListener registeredListener;
    private TextEditingSupport textEditingSupport;

    public void createCompositeContent(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createCompositeContent(parent, aTabbedPropertySheetPage);
        parent.setLayout((Layout)new GridLayout(1, false));
        parent.setLayoutData((Object)new GridData(1808));
        Section titleSection = aTabbedPropertySheetPage.getWidgetFactory().createSection(parent, 256);
        titleSection.setLayout((Layout)new GridLayout());
        titleSection.setLayoutData((Object)new GridData(768));
        titleSection.setText(Messages.conditionFieldString);
        Composite conditionSectionComposite = aTabbedPropertySheetPage.getWidgetFactory().createComposite(parent);
        conditionSectionComposite.setLayout((Layout)new GridLayout(3, false));
        conditionSectionComposite.setLayoutData((Object)new GridData(1808));
        Composite handlingComposite = aTabbedPropertySheetPage.getWidgetFactory().createComposite(conditionSectionComposite);
        handlingComposite.setLayout((Layout)new GridLayout(1, false));
        handlingComposite.setLayoutData((Object)new GridData(1044));
        GridData gridDataButtons = new GridData();
        gridDataButtons.widthHint = 26;
        gridDataButtons.heightHint = 26;
        Button addButton = aTabbedPropertySheetPage.getWidgetFactory().createButton(handlingComposite, "+", 8);
        addButton.setLayoutData((Object)gridDataButtons);
        this.removeButton = aTabbedPropertySheetPage.getWidgetFactory().createButton(handlingComposite, "-", 8);
        this.removeButton.setLayoutData((Object)gridDataButtons);
        this.conditionUpButton = aTabbedPropertySheetPage.getWidgetFactory().createButton(handlingComposite, "\u2191", 8);
        this.conditionUpButton.setLayoutData((Object)gridDataButtons);
        this.conditionDownButton = aTabbedPropertySheetPage.getWidgetFactory().createButton(handlingComposite, "\u2193", 8);
        this.conditionDownButton.setLayoutData((Object)gridDataButtons);
        addButton.addSelectionListener(this.modifyTableSelectionListener(TableRowBehavior.ADD_ROW));
        this.removeButton.addSelectionListener(this.modifyTableSelectionListener(TableRowBehavior.REMOVE_ROW));
        this.conditionUpButton.addSelectionListener(this.modifyTableSelectionListener(TableRowBehavior.MOVE_UP));
        this.conditionDownButton.addSelectionListener(this.modifyTableSelectionListener(TableRowBehavior.MOVE_DOWN));
        Composite conditionTableComposite = aTabbedPropertySheetPage.getWidgetFactory().createComposite(conditionSectionComposite);
        conditionTableComposite.setLayout((Layout)new GridLayout(1, false));
        conditionTableComposite.setLayoutData((Object)new GridData(1808));
        TableColumnLayout layout = new TableColumnLayout();
        conditionTableComposite.setLayout((Layout)layout);
        this.viewer = new TableViewer(conditionTableComposite, 68096);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.conditionTable = this.viewer.getTable();
        this.conditionTable.setHeaderVisible(true);
        this.conditionTable.setLinesVisible(true);
        this.conditionTable.addFocusListener(this.getConditionTableFocusListener());
        this.conditionTable.addSelectionListener(this.getConditionTableSelectionListener());
        this.conditionTable.setData("property.control", (Object)"conditionKey");
        this.textEditingSupport = new TextEditingSupport(this.viewer, this.conditionTable);
        this.createColumns(this.textEditingSupport);
        layout.setColumnData((Widget)this.viewer.getTable().getColumn(0), (ColumnLayoutData)new ColumnWeightData(5));
        layout.setColumnData((Widget)this.viewer.getTable().getColumn(1), (ColumnLayoutData)new ColumnWeightData(60));
        this.viewer.setInput(this.contentList);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        this.viewer.getControl().setLayoutData((Object)gridData);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        Composite propertiesComposite = aTabbedPropertySheetPage.getWidgetFactory().createComposite(conditionSectionComposite);
        propertiesComposite.setLayout((Layout)new GridLayout(3, false));
        propertiesComposite.setLayoutData((Object)new GridData(525328));
        Label operatorLabel = new Label(propertiesComposite, 0);
        operatorLabel.setText(Messages.operatorsLabelString);
        operatorLabel.setBackground(propertiesComposite.getDisplay().getSystemColor(1));
        operatorLabel.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        this.operatorCombo = new Combo(propertiesComposite, 524296);
        this.operatorCombo.setLayout((Layout)new GridLayout());
        this.operatorCombo.setLayoutData((Object)new GridData(772));
        this.setComboOperators();
        this.operatorCombo.pack();
        this.insertOperatorButton = aTabbedPropertySheetPage.getWidgetFactory().createButton(propertiesComposite, Messages.insertButtonString, 524296);
        this.insertOperatorButton.addListener(13, (Listener)new InsertButtonListener(this.operatorCombo));
        Label channelLabel = new Label(propertiesComposite, 0);
        channelLabel.setText(Messages.channelLabelString);
        channelLabel.setBackground(propertiesComposite.getDisplay().getSystemColor(1));
        channelLabel.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        this.channelCombo = new Combo(propertiesComposite, 524296);
        this.channelCombo.setLayout((Layout)new GridLayout());
        this.channelCombo.setLayoutData((Object)new GridData(772));
        this.channelCombo.pack();
        this.insertChannelButton = aTabbedPropertySheetPage.getWidgetFactory().createButton(propertiesComposite, Messages.insertButtonString, 524296);
        this.insertChannelButton.addListener(13, (Listener)new InsertButtonListener(this.channelCombo));
        Label conditionLabel = new Label(propertiesComposite, 0);
        conditionLabel.setText(Messages.conditionLabelString);
        conditionLabel.setBackground(propertiesComposite.getDisplay().getSystemColor(1));
        conditionLabel.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        this.conditionCombo = new Combo(propertiesComposite, 524296);
        this.conditionCombo.setLayout((Layout)new GridLayout());
        this.conditionCombo.setLayoutData((Object)new GridData(772));
        this.conditionCombo.pack();
        this.insertConditionButton = aTabbedPropertySheetPage.getWidgetFactory().createButton(propertiesComposite, Messages.insertButtonString, 524296);
        this.insertConditionButton.addListener(13, (Listener)new InsertButtonListener(this.conditionCombo));
        this.registerComboListeners(this.operatorCombo, this.channelCombo, this.conditionCombo);
        Composite parameterComposite = aTabbedPropertySheetPage.getWidgetFactory().createComposite(parent);
        parameterComposite.setLayout((Layout)new GridLayout(2, false));
        parameterComposite.setLayoutData((Object)new GridData(4));
        Button firstConditionCheckbox = new Button(parameterComposite, 32);
        firstConditionCheckbox.setData("property.control", (Object)"writeOutputKey");
        firstConditionCheckbox.setSelection(false);
        Label firstConditionLabel = new Label(parameterComposite, 0);
        firstConditionLabel.setText(Messages.writeOutputLabel);
        firstConditionLabel.setBackground(parameterComposite.getDisplay().getSystemColor(1));
        this.setPropertyControlsEnabled(false);
        this.setTableHandlingButtonsEnabled(false);
    }

    private void registerComboListeners(Combo ... combo) {
        Combo[] comboArray = combo;
        int n = combo.length;
        int n2 = 0;
        while (n2 < n) {
            Combo c = comboArray[n2];
            c.addSelectionListener((SelectionListener)new ComboSelectionListener());
            c.addFocusListener((FocusListener)new ComboFocusListener());
            ++n2;
        }
    }

    private SelectionListener getConditionTableSelectionListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                boolean emptySelection = SwitchConditionSection.this.conditionTable.getSelectionCount() == 0;
                SwitchConditionSection.this.conditionUpButton.setEnabled(!emptySelection && SwitchConditionSection.this.conditionTable.getSelectionIndex() != 0);
                SwitchConditionSection.this.conditionDownButton.setEnabled(!emptySelection && SwitchConditionSection.this.conditionTable.getSelectionIndex() != SwitchConditionSection.this.conditionTable.getItemCount() - 1);
                SwitchConditionSection.this.removeButton.setEnabled(!emptySelection && SwitchConditionSection.this.conditionTable.getItemCount() > 1);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        };
    }

    private FocusListener getConditionTableFocusListener() {
        return new FocusListener(){

            public void focusLost(FocusEvent arg0) {
                if (!SwitchConditionSection.this.isMousePositionOnControl(new Control[]{SwitchConditionSection.this.removeButton, SwitchConditionSection.this.conditionDownButton, SwitchConditionSection.this.conditionUpButton})) {
                    SwitchConditionSection.this.setTableHandlingButtonsEnabled(false);
                    SwitchConditionSection.this.conditionTable.deselectAll();
                }
            }

            public void focusGained(FocusEvent arg0) {
            }
        };
    }

    private void setPropertyControlsEnabled(boolean enable) {
        this.insertOperatorButton.setEnabled(enable);
        this.operatorCombo.setEnabled(enable);
        this.insertChannelButton.setEnabled(enable && this.channelCombo.getItemCount() > 0);
        this.channelCombo.setEnabled(enable && this.channelCombo.getItemCount() > 0);
        this.insertConditionButton.setEnabled(enable && this.conditionCombo.getItemCount() > 0);
        this.conditionCombo.setEnabled(enable && this.conditionCombo.getItemCount() > 0);
    }

    private boolean isMousePositionOnControl(Control ... controls) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c != null && c.isEnabled() && new Rectangle(0, 0, c.getSize().x, c.getSize().y).contains(c.toControl(Display.getCurrent().getCursorLocation()))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (this.registeredListener == null) {
            ComponentInstanceProperties config = this.getConfiguration();
            this.registeredListener = evt -> {
                if (evt.getNewValue() instanceof EndpointChange) {
                    EndpointChange ec = (EndpointChange)evt.getNewValue();
                    this.updateCombos(ec);
                    if (this.textEditingSupport.getCellEditor().isActivated()) {
                        this.setPropertyControlsEnabled(true);
                    }
                }
            };
            config.addPropertyChangeListener(this.registeredListener);
        }
    }

    private void updateCombos(EndpointChange ec) {
        if (ec.getType().equals((Object)EndpointChange.Type.Removed)) {
            if (ec.getOldEndpointDescription().getDynamicEndpointIdentifier().equals("dataToInput") && !this.channelCombo.isDisposed()) {
                this.setInputChannels();
            }
            if (ec.getOldEndpointDescription().getDynamicEndpointIdentifier().equals("conditionToInput") && !this.conditionCombo.isDisposed()) {
                this.setConditionInput();
            }
        } else {
            if (ec.getEndpointDescription().getDynamicEndpointIdentifier().equals("dataToInput") && !this.channelCombo.isDisposed()) {
                this.setInputChannels();
            }
            if (ec.getEndpointDescription().getDynamicEndpointIdentifier().equals("conditionToInput") && !this.conditionCombo.isDisposed()) {
                this.setConditionInput();
            }
        }
    }

    private void createColumns(TextEditingSupport textEditSup) {
        TableViewerColumn col0 = this.createTableViewerColumn(CONDITION_TABLE_TITLES[0]);
        TableViewerColumn col1 = this.createTableViewerColumn(CONDITION_TABLE_TITLES[1]);
        col0.setLabelProvider((CellLabelProvider)new ConditionColumnLabelProvider(0));
        col1.setLabelProvider((CellLabelProvider)new ConditionColumnLabelProvider(1));
        col1.setEditingSupport((EditingSupport)textEditSup);
    }

    private TableViewerColumn createTableViewerColumn(String title) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 16384);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setResizable(false);
        return viewerColumn;
    }

    private SelectionListener modifyTableSelectionListener(final TableRowBehavior trb) {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                SwitchConditionSection.this.updateTable(trb);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        };
    }

    private void updateTable(TableRowBehavior trb) {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        String configStr = this.getProperty("conditionKey");
        this.contentList = (ArrayList)SwitchCondition.getSwitchConditionList((String)configStr);
        int newIndex = this.switchTableRowBehaviour(trb);
        String selected = this.getProperty("selectedCondition");
        try {
            if (!configStr.equals(mapper.writeValueAsString(this.contentList)) && selected != null && Integer.parseInt(selected) < this.contentList.size()) {
                this.setProperty("conditionKey", mapper.writeValueAsString(this.contentList));
            } else {
                this.setProperties("conditionKey", mapper.writeValueAsString(this.contentList), "selectedCondition", null);
            }
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(EXCEPTION_MESSAGE_WRITING, e);
        }
        if (newIndex != 0) {
            this.conditionTable.setSelection(newIndex - 1);
            this.conditionTable.notifyListeners(13, new Event());
        }
        this.conditionTable.forceFocus();
        this.updateErrorStates();
    }

    private int switchTableRowBehaviour(TableRowBehavior trb) {
        int index = this.viewer.getTable().getSelectionIndex();
        int newIndex = 0;
        int size = this.contentList.size();
        switch (trb) {
            case ADD_ROW: {
                this.contentList.add(new SwitchCondition(size + 1, ""));
                SwitchConditionSection.updateOutputDescriptions(this.getConfiguration(), trb, size);
                newIndex = size + 1;
                break;
            }
            case REMOVE_ROW: {
                if (this.viewer.getTable().getSelectionCount() == 0) break;
                this.contentList.remove(index);
                int i = index;
                while (i < size - 1) {
                    this.contentList.get(i).setConditionNumber(i + 1);
                    ++i;
                }
                SwitchConditionSection.updateOutputDescriptions(this.getConfiguration(), trb, size);
                this.updateValidationMessage(index + 1, 0);
                newIndex = index;
                if (newIndex != 0) break;
                newIndex = 1;
                break;
            }
            case MOVE_UP: {
                if (this.viewer.getTable().getSelectionCount() == 0 || index == 0) break;
                Collections.swap(this.contentList, index, index - 1);
                this.contentList.get(index).setConditionNumber(index + 1);
                this.contentList.get(index - 1).setConditionNumber(index);
                this.updateValidationMessage(index, index + 1);
                newIndex = index;
                break;
            }
            case MOVE_DOWN: {
                if (this.viewer.getTable().getSelectionCount() == 0 || index == this.contentList.size() - 1) break;
                Collections.swap(this.contentList, index + 1, index);
                this.contentList.get(index).setConditionNumber(index + 1);
                this.contentList.get(index + 1).setConditionNumber(index + 2);
                this.updateValidationMessage(index + 1, index + 2);
                newIndex = index + 2;
                break;
            }
        }
        return newIndex;
    }

    private void updateValidationMessage(int index1, int index2) {
        List messages = this.getMessageStore().getMessagesByComponentId(((WorkflowNode)this.getConfiguration()).getIdentifierAsObject().toString());
        for (ComponentValidationMessage m : messages) {
            if (!(m instanceof SwitchComponentValidationMessage)) continue;
            SwitchComponentValidationMessage scvm = (SwitchComponentValidationMessage)m;
            if (scvm.getConditionTableRowNumber() == index2) {
                scvm.setConditionTableRowNumber(index1);
                continue;
            }
            if (scvm.getConditionTableRowNumber() != index1) continue;
            scvm.setConditionTableRowNumber(index2);
        }
    }

    protected static int getTableContentLength(String configStr) {
        return SwitchCondition.getSwitchConditionList((String)configStr).size();
    }

    protected static void updateOutputDescriptions(ComponentInstanceProperties config, TableRowBehavior trb, Integer numOfCon) {
        EndpointDescriptionsManager outputDescManager = config.getOutputDescriptionsManager();
        Set dynEndDescs = config.getInputDescriptionsManager().getDynamicEndpointDescriptions();
        for (EndpointDescription endpointDesc : dynEndDescs) {
            if (!endpointDesc.getDynamicEndpointIdentifier().equals("dataToInput")) continue;
            switch (trb) {
                case ADD_ROW: {
                    HashMap metaData = new HashMap();
                    if (numOfCon == 0) {
                        outputDescManager.addDynamicEndpointDescription("dataToOutput", String.valueOf(endpointDesc.getName()) + "_no match", endpointDesc.getDataType(), metaData);
                        outputDescManager.addDynamicEndpointDescription("dataToOutput", String.valueOf(endpointDesc.getName()) + "_condition" + " " + 1, endpointDesc.getDataType(), metaData);
                        break;
                    }
                    outputDescManager.addDynamicEndpointDescription("dataToOutput", String.valueOf(endpointDesc.getName()) + "_condition" + " " + Integer.toString(numOfCon + 1), endpointDesc.getDataType(), metaData);
                    break;
                }
                case REMOVE_ROW: {
                    if (numOfCon != 1) {
                        outputDescManager.removeDynamicEndpointDescription(String.valueOf(endpointDesc.getName()) + "_condition" + " " + Integer.toString(numOfCon));
                        break;
                    }
                    outputDescManager.removeDynamicEndpointDescription(String.valueOf(endpointDesc.getName()) + "_condition" + " " + 1);
                    outputDescManager.removeDynamicEndpointDescription(String.valueOf(endpointDesc.getName()) + "_no match");
                    break;
                }
            }
        }
    }

    protected void beforeTearingDownModelBinding() {
        ComponentInstanceProperties config = this.getConfiguration();
        config.removePropertyChangeListener(this.registeredListener);
        this.registeredListener = null;
        this.selectedPoint = null;
        this.contentList = null;
        super.beforeTearingDownModelBinding();
    }

    private void setTableHandlingButtonsEnabled(Boolean enable) {
        this.removeButton.setEnabled(enable.booleanValue());
        this.conditionUpButton.setEnabled(enable.booleanValue());
        this.conditionDownButton.setEnabled(enable.booleanValue());
    }

    private void setInputChannels() {
        this.channelCombo.removeAll();
        ArrayList<String> channels = new ArrayList<String>();
        for (EndpointDescription channelName : this.getConfiguration().getInputDescriptionsManager().getDynamicEndpointDescriptions()) {
            if (!channelName.getDynamicEndpointIdentifier().equals("dataToInput") || !channelName.isRequired() || !Arrays.asList(SwitchComponentConstants.CONDITION_SCRIPT_DATA_TYPES).contains(channelName.getDataType())) continue;
            channels.add(channelName.getName());
        }
        Collections.sort(channels);
        this.channelCombo.setItems(channels.toArray(new String[channels.size()]));
        this.channelCombo.select(0);
    }

    private void setConditionInput() {
        this.conditionCombo.removeAll();
        ArrayList<String> channels = new ArrayList<String>();
        for (EndpointDescription conditionName : this.getConfiguration().getInputDescriptionsManager().getDynamicEndpointDescriptions()) {
            if (!conditionName.getDynamicEndpointIdentifier().equals("conditionToInput") || !conditionName.isRequired()) continue;
            channels.add(conditionName.getName());
        }
        Collections.sort(channels);
        this.conditionCombo.setItems(channels.toArray(new String[channels.size()]));
        this.conditionCombo.select(0);
    }

    private void setComboOperators() {
        this.operatorCombo.removeAll();
        this.operatorCombo.setItems(SwitchComponentConstants.OPERATORS);
        this.operatorCombo.select(0);
    }

    private ViewerRow getViewerRow() {
        ConditionTableTextCellEditor cellEditor = this.textEditingSupport.getCellEditor();
        ViewerCell cell = this.textEditingSupport.getViewer().getCell(cellEditor.getControl().getLocation());
        if (cell != null) {
            return cell.getViewerRow();
        }
        return null;
    }

    protected SwitchConditionSectionUpdater createUpdater() {
        return new SwitchConditionSectionUpdater();
    }

    protected void updateErrorStates(List<ComponentValidationMessage> messages, Composite parent) {
        if (parent != null && !parent.isDisposed() && this.viewer.getInput() != null) {
            Control[] controlArray = parent.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (!control.isDisposed()) {
                    String key;
                    if (control instanceof Composite) {
                        this.updateErrorStates(messages, (Composite)control);
                    }
                    if ((key = (String)control.getData("property.control")) != null && key.equals("conditionKey")) {
                        ArrayList input = (ArrayList)this.viewer.getInput();
                        for (SwitchCondition sc : input) {
                            sc.setValidationMessages(null);
                        }
                        for (ComponentValidationMessage message : messages) {
                            if (!(message instanceof SwitchComponentValidationMessage)) continue;
                            int currentRow = ((SwitchComponentValidationMessage)message).getConditionTableRowNumber();
                            String errorMessage = ((SwitchComponentValidationMessage)message).getToolTipMessage();
                            int len = this.viewer.getTable().getItems().length;
                            if (currentRow == 0 || currentRow > len) continue;
                            ((SwitchCondition)input.get(currentRow - 1)).setValidationMessages(errorMessage);
                        }
                    }
                }
                ++n2;
            }
            this.viewer.refresh();
        }
    }

    public void refreshSection() {
        super.refreshSection();
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        String configStr = this.getProperty("conditionKey");
        if (configStr == null) {
            SwitchCondition emptyCondition = new SwitchCondition(1, "");
            ArrayList<SwitchCondition> content = new ArrayList<SwitchCondition>();
            content.add(emptyCondition);
            try {
                this.setProperty("conditionKey", mapper.writeValueAsString(content));
                configStr = this.getProperty("conditionKey");
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(EXCEPTION_MESSAGE_WRITING, e);
            }
            this.log.warn((Object)"The condition key in the workflow configuration file is damaged or missing. A valid key with an empty condition was generated automatically.");
            this.log.warn((Object)" Please note that Data Outputs may have been lost and check the workflow configuration file.");
        }
        this.contentList = (ArrayList)SwitchCondition.getSwitchConditionList((String)configStr);
        this.setInputChannels();
        this.setConditionInput();
        this.updateErrorStates();
    }

    private class ComboFocusListener
    implements FocusListener {
        private ComboFocusListener() {
        }

        public void focusLost(FocusEvent arg0) {
            if (!SwitchConditionSection.this.isMousePositionOnControl(new Control[]{SwitchConditionSection.this.insertOperatorButton, SwitchConditionSection.this.insertConditionButton, SwitchConditionSection.this.insertChannelButton, SwitchConditionSection.this.operatorCombo, SwitchConditionSection.this.conditionCombo, SwitchConditionSection.this.channelCombo})) {
                SwitchConditionSection.this.setPropertyControlsEnabled(false);
            }
        }

        public void focusGained(FocusEvent arg0) {
        }
    }

    private class ComboSelectionListener
    implements SelectionListener {
        private ComboSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public void widgetSelected(SelectionEvent arg0) {
            if (SwitchConditionSection.this.getViewerRow() != null) {
                SwitchConditionSection.this.textEditingSupport.getCellEditor().activateCell(SwitchConditionSection.this.getViewerRow().getCell(1));
            }
        }
    }

    private class ConditionColumnLabelProvider
    extends ColumnLabelProvider {
        private int columnIndex;

        ConditionColumnLabelProvider(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public String getText(Object element) {
            if (element instanceof SwitchCondition) {
                SwitchCondition condition = (SwitchCondition)element;
                if (this.columnIndex == 1) {
                    return condition.getConditionScript();
                }
                if (this.columnIndex == 0) {
                    return String.valueOf(condition.getConditionNumber());
                }
            }
            return "";
        }

        public Color getBackground(Object element) {
            SwitchCondition condition;
            if (element instanceof SwitchCondition && (condition = (SwitchCondition)element).getValidationMessages() != null && this.columnIndex == 1) {
                return Display.getCurrent().getSystemColor(3);
            }
            return null;
        }

        public String getToolTipText(Object element) {
            if (element instanceof SwitchCondition) {
                SwitchCondition condition = (SwitchCondition)element;
                return condition.getValidationMessages();
            }
            return null;
        }
    }

    private class ConditionTableTextCellEditor
    extends TextCellEditor {
        ConditionTableTextCellEditor(Composite parent) {
            super(parent);
        }

        public void activateCell(ViewerCell viewerCell) {
            if (viewerCell != null) {
                SwitchConditionSection.this.conditionTable.forceFocus();
                SwitchConditionSection.this.textEditingSupport.getViewer().editElement(viewerCell.getElement(), 1);
                if (this.text != null) {
                    this.text.setSelection(((SwitchConditionSection)SwitchConditionSection.this).selectedPoint.x, ((SwitchConditionSection)SwitchConditionSection.this).selectedPoint.y);
                }
            }
        }

        public void activate() {
            SwitchConditionSection.this.setPropertyControlsEnabled(true);
            super.activate();
        }

        protected void deactivate(ColumnViewerEditorDeactivationEvent event) {
            if (!SwitchConditionSection.this.isMousePositionOnControl(new Control[]{SwitchConditionSection.this.insertOperatorButton, SwitchConditionSection.this.insertConditionButton, SwitchConditionSection.this.insertChannelButton, SwitchConditionSection.this.operatorCombo, SwitchConditionSection.this.conditionCombo, SwitchConditionSection.this.channelCombo})) {
                SwitchConditionSection.this.setPropertyControlsEnabled(false);
                String oldContent = this.getContentListAsJSON();
                for (SwitchCondition con : SwitchConditionSection.this.contentList) {
                    String script = con.getConditionScript();
                    String replacedScript = script.trim().replaceAll("\\s+", " ");
                    con.setConditionScript(replacedScript);
                }
                String content = this.getContentListAsJSON();
                SwitchConditionSection.this.setPropertyNotUndoable("conditionKey", oldContent, content);
            }
            super.deactivate(event);
        }

        private String getContentListAsJSON() {
            try {
                return new ObjectMapper().writeValueAsString((Object)SwitchConditionSection.this.contentList);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(SwitchConditionSection.EXCEPTION_MESSAGE_WRITING, e);
            }
        }

        protected boolean dependsOnExternalFocusListener() {
            return false;
        }

        protected void doSetFocus() {
            super.doSetFocus();
            if (this.text != null) {
                this.text.setSelection(this.text.getText().length());
            }
        }

        public boolean isRedoEnabled() {
            return false;
        }

        public boolean isUndoEnabled() {
            return false;
        }

        protected Point getSelection() {
            return this.text.getSelection();
        }
    }

    private class InsertButtonListener
    implements Listener {
        private Combo combo;

        InsertButtonListener(Combo combo) {
            this.combo = combo;
        }

        public void handleEvent(Event arg0) {
            String s = this.combo.getText();
            ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
            ArrayList input = (ArrayList)SwitchConditionSection.this.viewer.getInput();
            ViewerRow row = SwitchConditionSection.this.getViewerRow();
            if (row == null) {
                return;
            }
            int selectedRowNumber = Integer.parseInt(row.getText(0)) - 1;
            int start = ((SwitchConditionSection)SwitchConditionSection.this).selectedPoint.x;
            int end = ((SwitchConditionSection)SwitchConditionSection.this).selectedPoint.y;
            String currentString = row.getText(1);
            String firstSubstr = currentString.substring(0, start);
            String lastSubstr = currentString.substring(end);
            String newString = StringUtils.format((String)"%s%s%s", (Object[])new Object[]{firstSubstr, s, lastSubstr});
            ((SwitchCondition)input.get(selectedRowNumber)).setConditionScript(newString);
            ((SwitchConditionSection)SwitchConditionSection.this).selectedPoint.x += s.length();
            ((SwitchConditionSection)SwitchConditionSection.this).selectedPoint.y = ((SwitchConditionSection)SwitchConditionSection.this).selectedPoint.x;
            try {
                SwitchConditionSection.this.setProperty("conditionKey", mapper.writeValueAsString((Object)input));
            }
            catch (IOException e) {
                throw new RuntimeException(SwitchConditionSection.EXCEPTION_MESSAGE_WRITING, e);
            }
            SwitchConditionSection.this.textEditingSupport.getCellEditor().activateCell(row.getCell(1));
        }
    }

    private class SwitchConditionSectionUpdater
    extends WorkflowNodePropertySection.DefaultUpdater {
        private SwitchConditionSectionUpdater() {
            super((WorkflowNodePropertySection)SwitchConditionSection.this);
        }

        public void updateControl(Control control, String propertyName, String newValue, String oldValue) {
            super.updateControl(control, propertyName, newValue, oldValue);
            if (control instanceof Table && newValue != null && !newValue.equals(oldValue)) {
                ArrayList tableValues = null;
                try {
                    tableValues = (ArrayList)SwitchCondition.getSwitchConditionList((String)newValue);
                }
                finally {
                    SwitchConditionSection.this.viewer.setInput((Object)tableValues);
                }
                SwitchConditionSection.this.viewer.refresh();
            }
        }
    }

    protected static enum TableRowBehavior {
        ADD_ROW,
        REMOVE_ROW,
        MOVE_UP,
        MOVE_DOWN;

    }

    private class TextEditingSupport
    extends EditingSupport {
        private final ConditionTableTextCellEditor editor;

        TextEditingSupport(TableViewer viewer, Table table) {
            super((ColumnViewer)viewer);
            this.editor = new ConditionTableTextCellEditor((Composite)table);
        }

        ConditionTableTextCellEditor getCellEditor() {
            return this.editor;
        }

        protected boolean canEdit(Object arg0) {
            return true;
        }

        protected CellEditor getCellEditor(Object arg0) {
            return this.editor;
        }

        protected Object getValue(Object arg0) {
            return ((SwitchCondition)arg0).getConditionScript();
        }

        protected void setValue(Object arg0, Object arg1) {
            ArrayList inputs = (ArrayList)SwitchConditionSection.this.viewer.getInput();
            if (inputs.contains((SwitchCondition)arg0)) {
                String configStr = SwitchConditionSection.this.getProperty("conditionKey");
                ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
                int index = ((SwitchCondition)arg0).getConditionNumber() - 1;
                SwitchConditionSection.this.contentList = (ArrayList)SwitchCondition.getSwitchConditionList((String)configStr);
                if (!arg1.equals("")) {
                    ((SwitchCondition)SwitchConditionSection.this.contentList.get(index)).setConditionScript(arg1.toString());
                } else {
                    ((SwitchCondition)SwitchConditionSection.this.contentList.get(index)).setConditionScript("");
                }
                try {
                    if (!configStr.equals(mapper.writeValueAsString((Object)SwitchConditionSection.this.contentList))) {
                        String oldValue = WorkflowNodeUtil.getConfigurationValue((ComponentInstanceProperties)SwitchConditionSection.this.node, (String)"conditionKey");
                        this.setSwitchConditionProperty("conditionKey", oldValue, mapper.writeValueAsString((Object)SwitchConditionSection.this.contentList));
                    }
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(SwitchConditionSection.EXCEPTION_MESSAGE_WRITING, e);
                }
                SwitchConditionSection.this.viewer.setInput((Object)SwitchConditionSection.this.contentList);
            }
            SwitchConditionSection.this.selectedPoint = SwitchConditionSection.this.textEditingSupport.getCellEditor().getSelection();
            SwitchConditionSection.this.updateErrorStates();
        }

        private void setSwitchConditionProperty(String key, String oldValue, String newValue) {
            if (oldValue != null && !oldValue.equals(newValue) || oldValue == null && newValue != null) {
                WorkflowNodePropertySection.SetConfigurationValueCommand command = new WorkflowNodePropertySection.SetConfigurationValueCommand(key, oldValue, newValue);
                SwitchConditionSection.this.execute((WorkflowNodeCommand)command);
            }
        }
    }
}

