/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.optimizer.gui.properties.commands;

import de.rcenvironment.components.optimizer.gui.properties.commands.OptimizerDynamicEndpointCommandHelper;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.RemoveDynamicEndpointCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import java.util.List;
import java.util.Map;

public class OptimizerRemoveDynamicEndpointCommand
extends RemoveDynamicEndpointCommand {
    public OptimizerRemoveDynamicEndpointCommand(EndpointType direction, List<String> names, String id, Refreshable ... refreshable) {
        super(direction, id, names, refreshable);
    }

    public void execute() {
        super.execute();
        WorkflowNode workflowNode = this.getWorkflowNode();
        EndpointDescriptionsManager inputManager = workflowNode.getInputDescriptionsManager();
        EndpointDescriptionsManager outputManager = workflowNode.getOutputDescriptionsManager();
        for (String name : this.names) {
            EndpointDescription oldDescription = (EndpointDescription)this.oldDescriptions.get(name);
            String oldName = oldDescription.getName();
            switch (this.direction) {
                case INPUT: {
                    OptimizerDynamicEndpointCommandHelper.removeGradientsByInput(oldName, oldDescription.getMetaData(), inputManager, workflowNode.getOutputDescriptionsManager());
                    OptimizerDynamicEndpointCommandHelper.removeOptimalOutput(name, oldDescription.getDynamicEndpointIdentifier(), outputManager);
                    break;
                }
                case OUTPUT: {
                    OptimizerDynamicEndpointCommandHelper.removeOptimalOutput(name, oldDescription.getDynamicEndpointIdentifier(), outputManager);
                    OptimizerDynamicEndpointCommandHelper.removeGradientsByOutput(oldName, workflowNode.getInputDescriptionsManager());
                    OptimizerDynamicEndpointCommandHelper.removeStartInputs(oldName, oldDescription.getMetaData(), inputManager);
                    OptimizerDynamicEndpointCommandHelper.removeStepInputs(oldName, oldDescription.getMetaData(), inputManager);
                    break;
                }
                default: {
                    return;
                }
            }
            OptimizerDynamicEndpointCommandHelper.removeUpperLowerBoundsEndpoints(oldName, oldDescription.getMetaData(), workflowNode);
        }
        if (this.refreshable != null) {
            Refreshable[] refreshableArray = this.refreshable;
            int n = this.refreshable.length;
            int n2 = 0;
            while (n2 < n) {
                Refreshable r = refreshableArray[n2];
                r.refresh();
                ++n2;
            }
        }
    }

    public void undo() {
        super.undo();
        WorkflowNode workflowNode = this.getWorkflowNode();
        EndpointDescriptionsManager inputManager = workflowNode.getInputDescriptionsManager();
        EndpointDescriptionsManager outputManager = workflowNode.getOutputDescriptionsManager();
        for (String name : this.names) {
            EndpointDescription oldDescription = (EndpointDescription)this.oldDescriptions.get(name);
            String oldName = oldDescription.getName();
            DataType oldType = oldDescription.getDataType();
            Map oldMetaData = oldDescription.getMetaData();
            switch (this.direction) {
                case INPUT: {
                    OptimizerDynamicEndpointCommandHelper.addGradientToInput(name, oldMetaData, inputManager, outputManager);
                    OptimizerDynamicEndpointCommandHelper.addOptimalOutput(name, workflowNode.getInputDescriptionsManager().getEndpointDescription(name).getDynamicEndpointIdentifier(), oldType, workflowNode.getOutputDescriptionsManager());
                    break;
                }
                case OUTPUT: {
                    OptimizerDynamicEndpointCommandHelper.addOptimalOutput(oldName, outputManager.getEndpointDescription(name).getDynamicEndpointIdentifier(), oldType, outputManager);
                    OptimizerDynamicEndpointCommandHelper.checkAndAddStartValueInput(oldName, oldType, oldMetaData, inputManager);
                    OptimizerDynamicEndpointCommandHelper.checkAndAddStepValueInput(oldName, oldType, oldMetaData, inputManager);
                    OptimizerDynamicEndpointCommandHelper.addGradientforOutput(oldName, oldType, oldMetaData, inputManager);
                    break;
                }
                default: {
                    return;
                }
            }
            OptimizerDynamicEndpointCommandHelper.addLowerAndUpperBoundsEndpoints(oldName, oldType, oldMetaData, workflowNode);
        }
        if (this.refreshable != null) {
            Refreshable[] refreshableArray = this.refreshable;
            int n = this.refreshable.length;
            int n2 = 0;
            while (n2 < n) {
                Refreshable r = refreshableArray[n2];
                r.refresh();
                ++n2;
            }
        }
    }
}

