/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.optimizer.gui.properties.commands;

import de.rcenvironment.components.optimizer.gui.properties.commands.OptimizerDynamicEndpointCommandHelper;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.EditDynamicEndpointCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import java.util.Map;

public class OptimizerEditDynamicEndpointCommand
extends EditDynamicEndpointCommand {
    public OptimizerEditDynamicEndpointCommand(EndpointType direction, EndpointDescription oldDescription, EndpointDescription newDescription, Refreshable ... refreshable) {
        super(direction, oldDescription, newDescription, refreshable);
    }

    public void execute() {
        WorkflowNode workflowNode = this.getWorkflowNode();
        super.execute();
        switch (this.direction) {
            case INPUT: {
                this.checkOptimalOutput(this.oldDesc, this.newDesc);
                this.checkGradientsForInput(workflowNode);
                break;
            }
            case OUTPUT: {
                this.checkGradientsForOutput(workflowNode);
                this.checkOptimalOutput(this.oldDesc, this.newDesc);
                OptimizerEditDynamicEndpointCommand.handleExtraValueInputs(workflowNode, "hasStartValue", null, " - start value", true, this.oldDesc, this.newDesc);
                OptimizerEditDynamicEndpointCommand.handleExtraValueInputs(workflowNode, "useStep", "useUnifiedStep", " - step value", false, this.oldDesc, this.newDesc);
                break;
            }
            default: {
                return;
            }
        }
        this.editBounds(workflowNode);
        if (this.refreshable != null) {
            Refreshable[] refreshableArray = this.refreshable;
            int n = this.refreshable.length;
            int n2 = 0;
            while (n2 < n) {
                Refreshable r = refreshableArray[n2];
                r.refresh();
                ++n2;
            }
        }
    }

    public void undo() {
        WorkflowNode workflowNode = this.getWorkflowNode();
        super.undo();
        switch (this.direction) {
            case INPUT: {
                this.checkOptimalOutput(this.newDesc, this.oldDesc);
                this.undoGradientsForInput(workflowNode);
                break;
            }
            case OUTPUT: {
                this.undoGradientsForOutput(workflowNode);
                this.checkOptimalOutput(this.newDesc, this.oldDesc);
                OptimizerEditDynamicEndpointCommand.handleExtraValueInputs(workflowNode, "hasStartValue", null, " - start value", true, this.newDesc, this.oldDesc);
                OptimizerEditDynamicEndpointCommand.handleExtraValueInputs(workflowNode, "useStep", "useUnifiedStep", " - step value", false, this.newDesc, this.oldDesc);
                break;
            }
            default: {
                return;
            }
        }
        this.undoBounds(workflowNode);
        if (this.refreshable != null) {
            Refreshable[] refreshableArray = this.refreshable;
            int n = this.refreshable.length;
            int n2 = 0;
            while (n2 < n) {
                Refreshable r = refreshableArray[n2];
                r.refresh();
                ++n2;
            }
        }
    }

    private void checkOptimalOutput(EndpointDescription desc1, EndpointDescription desc2) {
        if (!desc1.getName().equals(desc2.getName()) || !desc1.getDataType().equals((Object)desc2.getDataType())) {
            OptimizerDynamicEndpointCommandHelper.editOptimalOutput(desc1, desc2, this.getWorkflowNode().getOutputDescriptionsManager());
        }
    }

    private void editBounds(WorkflowNode workflowNode) {
        String oldHasBounds = this.oldDesc.getMetaDataValue("hasSingleBounds");
        String newHasBounds = this.newDesc.getMetaDataValue("hasSingleBounds");
        if (oldHasBounds != null && Boolean.parseBoolean(oldHasBounds) && !Boolean.parseBoolean(newHasBounds)) {
            OptimizerDynamicEndpointCommandHelper.addLowerAndUpperBoundsEndpoints(this.newDesc.getName(), this.newDesc.getDataType(), this.newDesc.getMetaData(), workflowNode);
        }
        if (oldHasBounds != null && !Boolean.parseBoolean(oldHasBounds)) {
            if (Boolean.parseBoolean(newHasBounds)) {
                OptimizerDynamicEndpointCommandHelper.removeUpperLowerBoundsEndpoints(this.oldDesc.getName(), this.oldDesc.getMetaData(), workflowNode);
            } else if (!this.oldDesc.getName().equals(this.newDesc.getName())) {
                OptimizerDynamicEndpointCommandHelper.removeUpperLowerBoundsEndpoints(this.oldDesc.getName(), this.oldDesc.getMetaData(), workflowNode);
                OptimizerDynamicEndpointCommandHelper.addLowerAndUpperBoundsEndpoints(this.newDesc.getName(), this.newDesc.getDataType(), this.newDesc.getMetaData(), workflowNode);
            }
        }
    }

    private void checkGradientsForOutput(WorkflowNode workflowNode) {
        if (!this.newDesc.getName().equals(this.oldDesc.getName()) || !this.newDesc.getDataType().equals((Object)this.oldDesc.getDataType())) {
            for (EndpointDescription function : workflowNode.getInputDescriptionsManager().getDynamicEndpointDescriptions()) {
                if (workflowNode.getInputDescriptionsManager().isValidEndpointName(OptimizerDynamicEndpointCommandHelper.createGradientChannelName(function.getName(), this.oldDesc.getName()))) continue;
                String oldName = OptimizerDynamicEndpointCommandHelper.createGradientChannelName(function.getName(), this.oldDesc.getName());
                String newName = OptimizerDynamicEndpointCommandHelper.createGradientChannelName(function.getName(), this.newDesc.getName());
                EndpointDescription desc = workflowNode.getInputDescriptionsManager().getEndpointDescription(OptimizerDynamicEndpointCommandHelper.createGradientChannelName(function.getName(), this.oldDesc.getName()));
                desc.setName(newName);
                Map<String, String> metaData = OptimizerDynamicEndpointCommandHelper.createGradientMetaData(this.newDesc.getName(), function.getName(), this.newDesc.getMetaData());
                workflowNode.getInputDescriptionsManager().editDynamicEndpointDescription(oldName, newName, this.newDesc.getDataType(), metaData);
            }
        }
    }

    private void checkGradientsForInput(WorkflowNode workflowNode) {
        if (OptimizerEditDynamicEndpointCommand.hasGradient(this.oldDesc)) {
            if (OptimizerEditDynamicEndpointCommand.hasGradient(this.newDesc)) {
                this.executeBothHaveGradients(workflowNode);
            } else {
                OptimizerDynamicEndpointCommandHelper.removeGradientsByInput(this.oldDesc.getName(), this.oldDesc.getMetaData(), workflowNode.getInputDescriptionsManager(), workflowNode.getOutputDescriptionsManager());
            }
        } else if (OptimizerEditDynamicEndpointCommand.hasGradient(this.newDesc)) {
            for (EndpointDescription variable : workflowNode.getOutputDescriptionsManager().getDynamicEndpointDescriptions()) {
                this.checkVariableAndAddGradient(workflowNode, variable);
            }
        }
    }

    private void checkVariableAndAddGradient(WorkflowNode workflowNode, EndpointDescription variable) {
        if (variable.getDynamicEndpointIdentifier().equals("Design")) {
            String newGradientName = OptimizerDynamicEndpointCommandHelper.createGradientChannelName(this.newDesc.getName(), variable.getName());
            Map<String, String> metaData = OptimizerDynamicEndpointCommandHelper.createGradientMetaData(variable.getName(), this.newDesc.getName(), this.newDesc.getMetaData());
            workflowNode.getInputDescriptionsManager().addDynamicEndpointDescription("gradients", newGradientName, variable.getDataType(), metaData);
        }
    }

    private static void handleExtraValueInputs(WorkflowNode workflowNode, String conditionName, String condition2Name, String signature, boolean negateCondition, EndpointDescription fromDescription, EndpointDescription toDescription) {
        boolean checkForRemove;
        boolean nameOrDatatypeChanged;
        boolean dataTypeChanged;
        String newConditionValueString = toDescription.getMetaDataValue(conditionName);
        boolean newConditionValue = newConditionValueString != null && Boolean.parseBoolean(newConditionValueString);
        String oldConditionValueString = fromDescription.getMetaDataValue(conditionName);
        boolean oldConditionValue = oldConditionValueString != null && Boolean.parseBoolean(oldConditionValueString);
        boolean condition2Active = false;
        boolean newCondition2Value = false;
        boolean oldCondition2Value = false;
        if (condition2Name != null) {
            condition2Active = true;
            String newCondition2ValueString = toDescription.getMetaDataValue(condition2Name);
            newCondition2Value = newCondition2ValueString != null && !Boolean.parseBoolean(newCondition2ValueString);
            String oldCondition2ValueString = fromDescription.getMetaDataValue(condition2Name);
            oldCondition2Value = oldCondition2ValueString != null && !Boolean.parseBoolean(oldCondition2ValueString);
        }
        boolean nameChanged = !fromDescription.getName().equals(toDescription.getName());
        boolean bl = dataTypeChanged = !fromDescription.getDataType().equals((Object)toDescription.getDataType());
        if (negateCondition) {
            newConditionValue = !newConditionValue;
            oldConditionValue = !oldConditionValue;
        }
        boolean bl2 = nameOrDatatypeChanged = nameChanged || dataTypeChanged;
        if (nameOrDatatypeChanged && oldConditionValue && (!condition2Active || oldCondition2Value)) {
            Map metaData = workflowNode.getInputDescriptionsManager().getEndpointDescription(String.valueOf(fromDescription.getName()) + signature).getMetaData();
            metaData.put("correspondingDesVar", toDescription.getName());
            workflowNode.getInputDescriptionsManager().editDynamicEndpointDescription(String.valueOf(fromDescription.getName()) + signature, String.valueOf(toDescription.getName()) + signature, toDescription.getDataType(), metaData);
        }
        if (oldConditionValue && newConditionValue && condition2Active) {
            if (oldCondition2Value && !newCondition2Value && workflowNode.getInputDescriptionsManager().getEndpointDescription(String.valueOf(toDescription.getName()) + signature) != null) {
                workflowNode.getInputDescriptionsManager().removeDynamicEndpointDescription(String.valueOf(toDescription.getName()) + signature);
            }
            if (!oldCondition2Value && newCondition2Value) {
                OptimizerDynamicEndpointCommandHelper.addInputToStartValueIdentifier(toDescription.getName(), signature, toDescription.getDataType(), workflowNode.getInputDescriptionsManager());
            }
        }
        boolean bl3 = checkForRemove = oldConditionValue && !newConditionValue && (!condition2Active || oldCondition2Value && !newCondition2Value);
        if (checkForRemove && workflowNode.getInputDescriptionsManager().getEndpointDescription(String.valueOf(toDescription.getName()) + signature) != null) {
            workflowNode.getInputDescriptionsManager().removeDynamicEndpointDescription(String.valueOf(toDescription.getName()) + signature);
        }
        if (!oldConditionValue && newConditionValue && (!condition2Active || !oldCondition2Value && newCondition2Value)) {
            OptimizerDynamicEndpointCommandHelper.addInputToStartValueIdentifier(toDescription.getName(), signature, toDescription.getDataType(), workflowNode.getInputDescriptionsManager());
        }
    }

    private void executeBothHaveGradients(WorkflowNode workflowNode) {
        if (!this.oldDesc.getName().equals(this.newDesc.getName()) || this.oldDesc.getDataType() != this.newDesc.getDataType()) {
            for (EndpointDescription variable : workflowNode.getOutputDescriptionsManager().getDynamicEndpointDescriptions()) {
                if (variable.getName().contains("_optimal")) continue;
                String oldGradientName = OptimizerDynamicEndpointCommandHelper.createGradientChannelName(this.oldDesc.getName(), variable.getName());
                String newGradientName = OptimizerDynamicEndpointCommandHelper.createGradientChannelName(this.newDesc.getName(), variable.getName());
                EndpointDescription newDesc = workflowNode.getInputDescriptionsManager().getEndpointDescription(oldGradientName);
                newDesc.setName(newGradientName);
                newDesc.setDataType(this.newDesc.getDataType());
                Map<String, String> gradientMetadata = OptimizerDynamicEndpointCommandHelper.createGradientMetaData(variable.getName(), this.newDesc.getName(), newDesc.getMetaData());
                newDesc.setMetaData(gradientMetadata);
                workflowNode.getInputDescriptionsManager().editDynamicEndpointDescription(oldGradientName, newGradientName, newDesc.getDataType(), gradientMetadata);
            }
        }
    }

    private static boolean hasGradient(EndpointDescription description) {
        return description.getMetaDataValue("hasGradient") != null && Boolean.parseBoolean(description.getMetaDataValue("hasGradient"));
    }

    private void undoBounds(WorkflowNode workflowNode) {
        String oldHasBounds = this.oldDesc.getMetaDataValue("hasSingleBounds");
        String newHasBounds = this.newDesc.getMetaDataValue("hasSingleBounds");
        if (Boolean.parseBoolean(newHasBounds)) {
            if (oldHasBounds != null && !Boolean.parseBoolean(oldHasBounds)) {
                OptimizerDynamicEndpointCommandHelper.addLowerAndUpperBoundsEndpoints(this.oldDesc.getName(), this.oldDesc.getDataType(), this.oldDesc.getMetaData(), workflowNode);
            }
        } else if (oldHasBounds != null && !Boolean.parseBoolean(oldHasBounds)) {
            if (!this.oldDesc.getName().equals(this.newDesc.getName())) {
                OptimizerDynamicEndpointCommandHelper.removeUpperLowerBoundsEndpoints(this.newDesc.getName(), this.newDesc.getMetaData(), workflowNode);
                OptimizerDynamicEndpointCommandHelper.addLowerAndUpperBoundsEndpoints(this.oldDesc.getName(), this.oldDesc.getDataType(), this.oldDesc.getMetaData(), workflowNode);
            }
        } else {
            OptimizerDynamicEndpointCommandHelper.removeUpperLowerBoundsEndpoints(this.newDesc.getName(), this.newDesc.getMetaData(), workflowNode);
        }
    }

    private void undoGradientsForOutput(WorkflowNode workflowNode) {
        if (!this.newDesc.getName().equals(this.oldDesc.getName()) || this.newDesc.getDataType() != this.oldDesc.getDataType()) {
            for (EndpointDescription function : workflowNode.getInputDescriptionsManager().getDynamicEndpointDescriptions()) {
                if (workflowNode.getInputDescriptionsManager().isValidEndpointName(OptimizerDynamicEndpointCommandHelper.createGradientChannelName(function.getName(), this.newDesc.getName()))) continue;
                String oldName = OptimizerDynamicEndpointCommandHelper.createGradientChannelName(function.getName(), this.oldDesc.getName());
                String newName = OptimizerDynamicEndpointCommandHelper.createGradientChannelName(function.getName(), this.newDesc.getName());
                Map<String, String> metaData = OptimizerDynamicEndpointCommandHelper.createGradientMetaData(this.oldDesc.getName(), function.getName(), this.oldDesc.getMetaData());
                workflowNode.getInputDescriptionsManager().editDynamicEndpointDescription(newName, oldName, this.oldDesc.getDataType(), metaData);
            }
        }
    }

    private void undoGradientsForInput(WorkflowNode workflowNode) {
        block5: {
            block4: {
                if (!OptimizerEditDynamicEndpointCommand.hasGradient(this.newDesc)) break block4;
                if (OptimizerEditDynamicEndpointCommand.hasGradient(this.oldDesc)) {
                    this.editBothHaveGradients(workflowNode);
                } else {
                    for (EndpointDescription variable : workflowNode.getOutputDescriptionsManager().getDynamicEndpointDescriptions()) {
                        if (!variable.getDynamicEndpointIdentifier().equals("Design")) continue;
                        String newGradientName = OptimizerDynamicEndpointCommandHelper.createGradientChannelName(this.newDesc.getName(), variable.getName());
                        workflowNode.getInputDescriptionsManager().removeDynamicEndpointDescription(newGradientName);
                    }
                }
                break block5;
            }
            if (!OptimizerEditDynamicEndpointCommand.hasGradient(this.oldDesc)) break block5;
            for (EndpointDescription variable : workflowNode.getOutputDescriptionsManager().getDynamicEndpointDescriptions()) {
                if (!variable.getDynamicEndpointIdentifier().equals("Design")) continue;
                String oldGradientName = OptimizerDynamicEndpointCommandHelper.createGradientChannelName(this.oldDesc.getName(), variable.getName());
                Map<String, String> metaData = OptimizerDynamicEndpointCommandHelper.createGradientMetaData(variable.getName(), this.oldDesc.getName(), this.oldDesc.getMetaData());
                workflowNode.getInputDescriptionsManager().addDynamicEndpointDescription("gradients", oldGradientName, this.oldDesc.getDataType(), metaData);
            }
        }
    }

    private void editBothHaveGradients(WorkflowNode workflowNode) {
        if (!this.oldDesc.getName().equals(this.newDesc.getName()) || this.oldDesc.getDataType() != this.newDesc.getDataType()) {
            for (EndpointDescription variable : workflowNode.getOutputDescriptionsManager().getDynamicEndpointDescriptions()) {
                if (!variable.getDynamicEndpointIdentifier().equals("Design")) continue;
                String oldGradientName = OptimizerDynamicEndpointCommandHelper.createGradientChannelName(this.oldDesc.getName(), variable.getName());
                String newGradientName = OptimizerDynamicEndpointCommandHelper.createGradientChannelName(this.newDesc.getName(), variable.getName());
                EndpointDescription desc = workflowNode.getInputDescriptionsManager().getEndpointDescription(newGradientName);
                desc.setName(oldGradientName);
                Map<String, String> gradientMetadata = OptimizerDynamicEndpointCommandHelper.createGradientMetaData(variable.getName(), this.oldDesc.getName(), this.oldDesc.getMetaData());
                desc.setMetaData(gradientMetadata);
                workflowNode.getInputDescriptionsManager().editDynamicEndpointDescription(newGradientName, oldGradientName, this.oldDesc.getDataType(), gradientMetadata);
            }
        }
    }
}

