/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.optimizer.gui.properties.commands;

import de.rcenvironment.components.optimizer.common.StartValueType;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.datamodel.api.DataType;
import java.util.HashMap;
import java.util.Map;

public final class OptimizerDynamicEndpointCommandHelper {
    private OptimizerDynamicEndpointCommandHelper() {
    }

    public static String createGradientChannelName(String function, String variable) {
        return "\u2202" + function + "." + "\u2202" + variable;
    }

    public static void addLowerAndUpperBoundsEndpoints(String name, DataType type, Map<String, String> metaData, WorkflowNode workflowNode) {
        if (metaData.get("hasSingleBounds") != null && !Boolean.parseBoolean(metaData.get("hasSingleBounds"))) {
            HashMap<String, String> lowerBoundsMetaData = new HashMap<String, String>();
            lowerBoundsMetaData.put("correspondingDesVar", name);
            lowerBoundsMetaData.put("startValueType", StartValueType.LOWER_BOUND.toString());
            workflowNode.getInputDescriptionsManager().addDynamicEndpointDescription("startvalues", String.valueOf(name) + " - lower bounds" + " - start value", type, lowerBoundsMetaData);
            HashMap<String, String> upperBoundsMetaData = new HashMap<String, String>();
            upperBoundsMetaData.put("startValueType", StartValueType.UPPER_BOUND.toString());
            upperBoundsMetaData.put("correspondingDesVar", name);
            workflowNode.getInputDescriptionsManager().addDynamicEndpointDescription("startvalues", String.valueOf(name) + " - upper bounds" + " - start value", type, upperBoundsMetaData);
        }
    }

    public static void removeUpperLowerBoundsEndpoints(String name, Map<String, String> metaData, WorkflowNode workflowNode) {
        if (metaData.get("hasSingleBounds") != null && !Boolean.parseBoolean(metaData.get("hasSingleBounds"))) {
            workflowNode.getInputDescriptionsManager().removeDynamicEndpointDescription(String.valueOf(name) + " - lower bounds" + " - start value");
            workflowNode.getInputDescriptionsManager().removeDynamicEndpointDescription(String.valueOf(name) + " - upper bounds" + " - start value");
        }
    }

    public static void addGradientforOutput(String desVarName, DataType type, Map<String, String> originalMetadata, EndpointDescriptionsManager inputDescriptionManager) {
        for (EndpointDescription function : inputDescriptionManager.getDynamicEndpointDescriptions()) {
            if (!function.getDynamicEndpointIdentifier().equals("Constraint") && !function.getDynamicEndpointIdentifier().equals("Objective") || function.getMetaDataValue("hasGradient") == null || !Boolean.parseBoolean(function.getMetaDataValue("hasGradient"))) continue;
            inputDescriptionManager.addDynamicEndpointDescription("gradients", OptimizerDynamicEndpointCommandHelper.createGradientChannelName(function.getName(), desVarName), type, OptimizerDynamicEndpointCommandHelper.createGradientMetaData(desVarName, function.getName(), originalMetadata));
        }
    }

    public static void checkAndAddStartValueInput(String name, DataType type, Map<String, String> originalMetaData, EndpointDescriptionsManager inputManager) {
        if (originalMetaData.get("hasStartValue") == null && originalMetaData.get("startValue").isEmpty() || originalMetaData.get("hasStartValue") != null && !Boolean.parseBoolean(originalMetaData.get("hasStartValue"))) {
            OptimizerDynamicEndpointCommandHelper.addInputToStartValueIdentifier(name, " - start value", type, inputManager);
        }
    }

    public static void checkAndAddStepValueInput(String name, DataType type, Map<String, String> originalMetaData, EndpointDescriptionsManager inputManager) {
        if (originalMetaData.get("useStep") != null && !originalMetaData.get("useStep").isEmpty() && originalMetaData.get("useUnifiedStep") != null && !Boolean.parseBoolean(originalMetaData.get("useUnifiedStep"))) {
            OptimizerDynamicEndpointCommandHelper.addInputToStartValueIdentifier(name, " - step value", type, inputManager);
        }
    }

    public static void addInputToStartValueIdentifier(String desVarName, String suffix, DataType type, EndpointDescriptionsManager inputManager) {
        HashMap<String, String> startValueMetaData = new HashMap<String, String>();
        startValueMetaData.put("inputExecutionConstraint_4aae3eea", EndpointDefinition.InputExecutionContraint.Required.name());
        startValueMetaData.put("correspondingDesVar", desVarName);
        startValueMetaData.put("startValueType", StartValueType.INITIAL_POINT.toString());
        inputManager.addDynamicEndpointDescription("startvalues", String.valueOf(desVarName) + suffix, type, startValueMetaData);
    }

    public static void addGradientToInput(String name, Map<String, String> originalMetaData, EndpointDescriptionsManager inputManager, EndpointDescriptionsManager outputManager) {
        if (originalMetaData.get("hasGradient") != null && Boolean.parseBoolean(originalMetaData.get("hasGradient"))) {
            for (EndpointDescription e : outputManager.getDynamicEndpointDescriptions()) {
                if (!e.getDynamicEndpointIdentifier().equals("Design")) continue;
                inputManager.addDynamicEndpointDescription("gradients", OptimizerDynamicEndpointCommandHelper.createGradientChannelName(name, e.getName()), e.getDataType(), OptimizerDynamicEndpointCommandHelper.createGradientMetaData(e.getName(), name, originalMetaData));
            }
        }
    }

    public static void removeGradientsByInput(String name, Map<String, String> originalMetaData, EndpointDescriptionsManager inputManager, EndpointDescriptionsManager outputManager) {
        if (originalMetaData.get("hasGradient") != null && Boolean.parseBoolean(originalMetaData.get("hasGradient"))) {
            for (EndpointDescription e : outputManager.getDynamicEndpointDescriptions()) {
                if (!e.getDynamicEndpointIdentifier().equals("Design")) continue;
                inputManager.removeDynamicEndpointDescription(OptimizerDynamicEndpointCommandHelper.createGradientChannelName(name, e.getName()));
            }
        }
    }

    public static void removeGradientsByOutput(String name, EndpointDescriptionsManager inputManager) {
        for (EndpointDescription function : inputManager.getDynamicEndpointDescriptions()) {
            if (inputManager.isValidEndpointName(OptimizerDynamicEndpointCommandHelper.createGradientChannelName(function.getName(), name))) continue;
            inputManager.removeDynamicEndpointDescription(OptimizerDynamicEndpointCommandHelper.createGradientChannelName(function.getName(), name));
        }
    }

    public static void removeStartInputs(String name, Map<String, String> originalMetaData, EndpointDescriptionsManager inputManager) {
        if (originalMetaData.get("hasStartValue") == null && originalMetaData.get("startValue").isEmpty() || originalMetaData.get("hasStartValue") != null && !Boolean.parseBoolean(originalMetaData.get("hasStartValue"))) {
            inputManager.removeDynamicEndpointDescription(String.valueOf(name) + " - start value");
        }
    }

    public static void removeStepInputs(String name, Map<String, String> originalMetaData, EndpointDescriptionsManager inputManager) {
        if (originalMetaData.get("useStep") != null && !originalMetaData.get("useStep").isEmpty() && originalMetaData.get("useUnifiedStep") != null && !Boolean.parseBoolean(originalMetaData.get("useUnifiedStep"))) {
            inputManager.removeDynamicEndpointDescription(String.valueOf(name) + " - step value");
        }
    }

    public static Map<String, String> createGradientMetaData(String nameDesVar, String nameObj, Map<String, String> originalMetadata) {
        HashMap<String, String> gradientData = new HashMap<String, String>();
        gradientData.put("inputHandling_73b1056e", originalMetadata.get("inputHandling_73b1056e"));
        gradientData.put("vectorSize", originalMetadata.get("vectorSize"));
        gradientData.put("gradientCorrespondingObjOrConstr", nameObj);
        gradientData.put("gradientCorrespondingDesVar", nameDesVar);
        return gradientData;
    }

    public static void addOptimalOutput(String name, String suffix, DataType type, EndpointDescriptionsManager outputManager) {
        HashMap<String, String> optimalMetaData = new HashMap<String, String>();
        optimalMetaData.put("correspondingVar", name);
        outputManager.addDynamicEndpointDescription("optima", OptimizerDynamicEndpointCommandHelper.getOptimumEndpointName(name, suffix), type, optimalMetaData);
    }

    public static void removeOptimalOutput(String name, String suffix, EndpointDescriptionsManager outputDescriptionsManager) {
        outputDescriptionsManager.removeDynamicEndpointDescription(OptimizerDynamicEndpointCommandHelper.getOptimumEndpointName(name, suffix));
    }

    public static void editOptimalOutput(EndpointDescription oldDesc, EndpointDescription newDesc, EndpointDescriptionsManager outputDescriptionsManager) {
        String oldOptimumEndpointName = OptimizerDynamicEndpointCommandHelper.getOptimumEndpointName(oldDesc.getName(), oldDesc.getDynamicEndpointIdentifier());
        String newOptimumEndpointName = OptimizerDynamicEndpointCommandHelper.getOptimumEndpointName(newDesc.getName(), newDesc.getDynamicEndpointIdentifier());
        if (outputDescriptionsManager.getEndpointDescription(oldOptimumEndpointName) != null) {
            HashMap<String, String> newMetaData = new HashMap<String, String>();
            newMetaData.put("correspondingVar", newDesc.getName());
            outputDescriptionsManager.editDynamicEndpointDescription(oldOptimumEndpointName, newOptimumEndpointName, newDesc.getDataType(), newMetaData);
        }
    }

    private static String getOptimumEndpointName(String varName, String identifier) {
        return String.valueOf(varName) + "_optimal" + " - " + identifier.toLowerCase();
    }
}

