/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.optimizer.gui.properties.commands;

import de.rcenvironment.components.optimizer.gui.properties.commands.OptimizerDynamicEndpointCommandHelper;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.AddDynamicEndpointCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import java.util.Map;

public class OptimizerAddDynamicEndpointCommand
extends AddDynamicEndpointCommand {
    private final EndpointType direction;

    public OptimizerAddDynamicEndpointCommand(EndpointType direction, String name, String id, DataType type, Map<String, String> metaData, Refreshable ... refreshable) {
        super(direction, id, name, type, metaData, refreshable);
        this.direction = direction;
    }

    public void execute() {
        super.execute();
        WorkflowNode workflowNode = this.getWorkflowNode();
        EndpointDescriptionsManager inputDescriptionsManager = workflowNode.getInputDescriptionsManager();
        EndpointDescriptionsManager outputDescriptionsManager = workflowNode.getOutputDescriptionsManager();
        switch (this.direction) {
            case INPUT: {
                OptimizerDynamicEndpointCommandHelper.addGradientToInput(this.name, this.metaData, inputDescriptionsManager, outputDescriptionsManager);
                OptimizerDynamicEndpointCommandHelper.addOptimalOutput(this.name, inputDescriptionsManager.getEndpointDescription(this.name).getDynamicEndpointIdentifier(), this.type, outputDescriptionsManager);
                break;
            }
            case OUTPUT: {
                OptimizerDynamicEndpointCommandHelper.addOptimalOutput(this.name, outputDescriptionsManager.getEndpointDescription(this.name).getDynamicEndpointIdentifier(), this.type, outputDescriptionsManager);
                OptimizerDynamicEndpointCommandHelper.checkAndAddStartValueInput(this.name, this.type, this.metaData, inputDescriptionsManager);
                OptimizerDynamicEndpointCommandHelper.checkAndAddStepValueInput(this.name, this.type, this.metaData, inputDescriptionsManager);
                OptimizerDynamicEndpointCommandHelper.addGradientforOutput(this.name, this.type, this.metaData, inputDescriptionsManager);
                break;
            }
            default: {
                return;
            }
        }
        OptimizerDynamicEndpointCommandHelper.addLowerAndUpperBoundsEndpoints(this.name, this.type, this.metaData, workflowNode);
        if (this.refreshable != null) {
            Refreshable[] refreshableArray = this.refreshable;
            int n = this.refreshable.length;
            int n2 = 0;
            while (n2 < n) {
                Refreshable r = refreshableArray[n2];
                r.refresh();
                ++n2;
            }
        }
    }

    public void undo() {
        super.undo();
        WorkflowNode workflowNode = this.getWorkflowNode();
        EndpointDescriptionsManager inputDescriptionsManager = workflowNode.getInputDescriptionsManager();
        EndpointDescriptionsManager outputDescriptionsManager = workflowNode.getOutputDescriptionsManager();
        switch (this.direction) {
            case INPUT: {
                OptimizerDynamicEndpointCommandHelper.removeGradientsByInput(this.name, this.metaData, inputDescriptionsManager, outputDescriptionsManager);
                OptimizerDynamicEndpointCommandHelper.removeOptimalOutput(this.name, this.id, outputDescriptionsManager);
                break;
            }
            case OUTPUT: {
                OptimizerDynamicEndpointCommandHelper.removeOptimalOutput(this.name, this.id, outputDescriptionsManager);
                OptimizerDynamicEndpointCommandHelper.removeGradientsByOutput(this.name, inputDescriptionsManager);
                OptimizerDynamicEndpointCommandHelper.removeStartInputs(this.name, this.metaData, inputDescriptionsManager);
                OptimizerDynamicEndpointCommandHelper.removeStepInputs(this.name, this.metaData, inputDescriptionsManager);
                break;
            }
            default: {
                return;
            }
        }
        OptimizerDynamicEndpointCommandHelper.removeUpperLowerBoundsEndpoints(this.name, this.metaData, workflowNode);
        if (this.refreshable != null) {
            Refreshable[] refreshableArray = this.refreshable;
            int n = this.refreshable.length;
            int n2 = 0;
            while (n2 < n) {
                Refreshable r = refreshableArray[n2];
                r.refresh();
                ++n2;
            }
        }
    }
}

