from RCE_Optimizer_API import configuration as config
from RCE_Optimizer_API import evaluation as eval
from RCE_Optimizer_API import result
import copy

## Define a print function to write nice output when the optimizer is finished
def print_finish(which,xmin,fmin,cmin,X,F,C,e):
    print "#################### Finished optimization ##########################"
    if which == 'maxiter':
        print "############### Max number of iterations reached ####################"
    elif which == 'maxfunc':
        print "############# Max nbr of function evaluation reached ################"
    elif which == 'deltasmall':
        print "##################### Delta is too small ############################"
    print "xmin: " + str(xmin) + ", fmin: " + str(fmin) + ", cmin: " +  str(cmin)
    print "X: " + str(X)
    print "F: " + str(F)
    print "C: " + str(C)
    print "Failed inputs: " + str(e.get_failed())
	
## print out all configuration options

print "Example: Trust-region pattern search method (direct search / derivative-free)"

print "Algorithm: " + str(config.get_algorithm())
print "Base values: " + str(config.get_base_values())
nvar = config.get_design_variable_count()
print "Design variable count: " + str(nvar)
var_names = config.get_design_variable_names()
print "Design variable names: " + str(var_names)
print "Design variable max. values: " + str(config.get_design_variable_max_values())
print "Design variable min. values: " + str(config.get_design_variable_min_values())
cons_names = config.get_constraint_names()
print "Constraint names: " + str(cons_names) + ", "+ str(cons_names[0])
print "Constraint max. values: " + str(config.get_constraint_max_values())
print "Constraint min. values: " + str(config.get_constraint_min_values())
obj_names = config.get_objective_names()
print "Objective names: " + str(obj_names) + ", " + str(obj_names[0])
print "Objective weights: " + str(config.get_objective_weights())
print "Property keys: " + str(config.get_property_keys())
print "Properties: " + str(config.get_properties())
init_delta = config.get_property("initial_delta")
print "Property initial_delta: " + str(init_delta)
threshold_delta = config.get_property("threshold_delta")
print "Property threshold_delta: " + str(threshold_delta)
max_niter = config.get_property("max_iter")
print "Property max_iter: " + str(max_niter)
max_nfunc = config.get_property("max_func")
print "Property max_func: " + str(max_nfunc)
x0_list = config.get_start_values()
print "Start values: " + str(x0_list)
x0 = []
for i in range(0,nvar):
    x0.append(config.get_start_value(var_names[i]))
    print "Start value for variable " + str(var_names[i]) + ": " + str(x0[i])
#print "Step values: " + str(config.get_step_values())
#print "x is discrete: " + str(config.is_discrete_variable("x"))

## Compute and print values at starting point
print "############## Iteration 0 ##############"
print "x0: " + str(x0)
e = eval.evaluate(0, x0)
fvalue = e.get_objective_value(obj_names[0])
print "Objective value: " + str( fvalue )
fhasgradient = e.has_gradient(obj_names[0])
print "Has f a gradient: " + str(fhasgradient)
if fhasgradient:
    fgvalue = e.get_objective_gradient(obj_names[0])
    print "Gradient value:  " + str(fgvalue)
cvalue = e.get_constraint_value(cons_names[0])
print "Constraint value: " + str(cvalue)
chasgradient = e.has_gradient(cons_names[0])
print "Has c a gradient: " + str(chasgradient)
if chasgradient:
    cgvalue = e.get_constraint_gradient(cons_names[0])
    print "Constraint gradient: " + str(cgvalue)


x = copy.copy(x0)
xmin = copy.copy(x0)
fmin = copy.copy(fvalue)
cmin = copy.copy(cvalue)
X = [xmin]
F = [fmin]
C = [cmin]
delta = copy.copy(init_delta)
nfunc = 0
niter = 0

# Do as long as optimization is not finished
while 1:
    found_new_min = 0
    
    # Exit execution if trust-region is too small
    if delta < threshold_delta:
        print_finish('deltasmall',xmin,fmin,cmin,X,F,C,e)
        break
    
    # Exit execution if max nbr of iiterations is reached
    if niter >= max_niter:
        print_finish('maxiter',xmin,fmin,cmin,X,F,C,e)
        break
    
    # Exit execution if max nbr of function evaluations is reached
    if nfunc >= max_nfunc:
        print_finish('maxfunc',xmin,fmin,cmin,X,F,C,e)
        break

    niter = niter + 1
    print
    print "##################### Iteration " + str (niter) + " #####################"
    xnew1 = []; xnew2 = []
    obj1 = []; obj2 = []
    con1 = []; con2 = []

    # compute new x values in trust region
    for j in range(0,nvar):
        print "Dimension: " + str(j+1)
        print "Delta: " + str(delta)
        # step in positive direction
        print "Delta step in positive direction:"
        xnew1 = copy.copy(x)
        xnew1[j] = x[j] + delta
        print "xnew1: " + str(xnew1)
        e = eval.evaluate(i, xnew1)
        nfunc = nfunc + 1
        obj1 = e.get_objective_value(obj_names[0])
        print "obj1: " + str(obj1)
        con1 = e.get_constraint_value(cons_names[0])
        print "con1: " + str(con1)
        # step in negative direction
        print "Delta step in negative direction:"
        xnew2 = copy.copy(x)
        xnew2[j] = x[j] - delta
        print "xnew2: " + str(xnew2)
        e = eval.evaluate(i, xnew2)
        nfunc = nfunc + 1
        obj2 = e.get_objective_value(obj_names[0])
        print "obj2: " + str(obj2)
        con2 = e.get_constraint_value(cons_names[0])
        print "con2: " + str(con2)

        # save current values to archive variables X, F, C
        X.append(xnew1)
        X.append(xnew2)
        F.append(obj1)
        F.append(obj2)
        C.append(con1)
        C.append(con2)

        # check for smaller function value
        if obj1 < fmin:
            fmin = copy.copy(obj1)
            xmin = copy.copy(xnew1)
            cmin = copy.copy(con1)
            found_new_min = 1
            print "found new min in pos. stepsize: " + str(xmin) + ", fmin: " + str(fmin)
        if obj2 < fmin:
            fmin = copy.copy(obj2)
            xmin = copy.copy(xnew2)
            cmin = copy.copy(con2)
            found_new_min = 2
            print "found new min in neg. stepsize: " + str(xmin) + ", fmin: " + str(fmin)

    # iteration update of trust region and/or x
    if found_new_min == 0:
        delta = delta / 2
        print "Unsuccessful iteration:"
        print "Trust region radius is reduced: " + str(delta)
    else:
        x = copy.copy(xmin)
        delta = delta * 2
        print "Successful iteration:"
        print "New iterate at x:" + str(x)
        print "Trust region radius is enlarged: " + str(delta)

 
# Optimizer done, print out best evaluation
eval.finalize(1)



