/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.optimizer.generic.execution.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.components.optimizer.common.OptimizerComponentHistoryDataItem;
import de.rcenvironment.components.optimizer.common.StartValueType;
import de.rcenvironment.components.optimizer.common.execution.DesignSet;
import de.rcenvironment.components.optimizer.common.execution.OptimizerAlgorithmExecutor;
import de.rcenvironment.components.optimizer.common.execution.OptimizerConfiguration;
import de.rcenvironment.components.optimizer.common.execution.ResultSet;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.utils.common.FileCompressionFormat;
import de.rcenvironment.core.utils.common.FileCompressionService;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.LogUtils;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;

public class GenericAlgorithmExecutor
extends OptimizerAlgorithmExecutor {
    private static final String VALUE = "value";
    private OptimizerConfiguration config;
    private File configurationFile;
    private FileReferenceTD configurationFileReference;

    public GenericAlgorithmExecutor(ComponentContext context, OptimizerConfiguration config) {
        super(context, context.getInstanceName(), "input.in");
        this.config = config;
    }

    /*
     * Exception decompiling
     */
    protected void writeConfigurationFile(File configFile) throws ComponentException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[7] lbl66 : CaseStatement: default:\u000a, @NONE, blocks:[7] lbl66 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addInputsToConfig(Map<String, Object> configuration) {
        configuration.put("objectives", this.config.getExtendedObjectivesNames());
        configuration.put("constraints", this.config.getExtendedConstraintNames());
        configuration.put("gradients", this.config.getAllExtendedGradientNames());
        configuration.put("objectivesWeights", this.config.getAllExtendedObjectiveWeights());
        configuration.put("minValuesConstraints", this.config.getAllConstraintBounds(StartValueType.LOWER_BOUND));
        configuration.put("maxValuesConstraints", this.config.getAllConstraintBounds(StartValueType.UPPER_BOUND));
    }

    private void addOutputsToConfig(Map<String, Object> configuration) {
        configuration.put("designVariableCount", this.config.getDesignVariableCount());
        configuration.put("designVariables", this.config.getExtendedDesignVariableNames());
        configuration.put("initValues", this.config.getAllExtendedStartValues());
        configuration.put("minValuesVariables", this.config.getAllExtentedDesignVariableBounds(StartValueType.LOWER_BOUND));
        configuration.put("maxValuesVariables", this.config.getAllExtentedDesignVariableBounds(StartValueType.UPPER_BOUND));
        configuration.put("baseValues", this.config.getAllExtendedBaseValues());
        configuration.put("stepValues", this.config.getAllExtendedStepValues());
        configuration.put("discreteValues", this.config.getAllExtendedDiscreteValues());
    }

    public DesignSet readOutputFileFromExternalProgram() throws IOException {
        File[] cwdFiles;
        DesignSet newSet = null;
        if (this.messageFromClient == null) {
            return newSet;
        }
        String currentWorkingDir = this.messageFromClient.getCurrentWorkingDir();
        if (currentWorkingDir != null && (cwdFiles = new File(currentWorkingDir).listFiles()) != null) {
            File outputFile = cwdFiles[0];
            ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
            Map result = (Map)mapper.readValue(outputFile, HashMap.class);
            List outputs = (List)result.get("designVar");
            newSet = new DesignSet(((Boolean)result.get("gradRequest")).booleanValue(), this.config);
            int i = 0;
            for (String designVariable : this.config.getExtendedDesignVariableNames()) {
                newSet.addDesignValue(designVariable, ((Double)outputs.get(i++)).doubleValue());
            }
        }
        return newSet;
    }

    protected void writeInputFileforExternalProgram(ResultSet result, String outputFileName) throws IOException {
        HashMap<String, Map> all = new HashMap<String, Map>();
        all.put("objective", result.getNegatedObjectives());
        all.put("const", result.getConstraintValues());
        HashMap gradients = new HashMap();
        List objectiveAndConstriantNames = this.config.getCompactObjectiveNames();
        objectiveAndConstriantNames.addAll(this.config.getCompactConstraintNames());
        for (String objOrConstName : objectiveAndConstriantNames) {
            if (!this.config.hasGradient(objOrConstName)) continue;
            ArrayList<Double> values = new ArrayList<Double>();
            gradients.put(objOrConstName, values);
            for (String variable : this.config.getExtendedDesignVariableNames()) {
                values.add(result.getGradientVariableValue(objOrConstName, variable));
            }
        }
        all.put("grad", gradients);
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        File rceInputFile = new File(this.messageFromClient.getCurrentWorkingDir(), outputFileName);
        mapper.writerWithDefaultPrettyPrinter().writeValue(rceInputFile, all);
    }

    protected void prepareProblem() throws ComponentException {
        try {
            File destinationDirectory;
            InputStream inputStream;
            File sourceFolder = this.getSourceFolder();
            if (sourceFolder.exists()) {
                FileUtils.copyDirectoryToDirectory((File)sourceFolder, (File)this.workingDir);
            }
            if (!FileCompressionService.expandCompressedDirectoryFromInputStream((InputStream)(inputStream = GenericAlgorithmExecutor.class.getResourceAsStream("/resources/RCE_Optimizer_API.zip")), (File)(destinationDirectory = new File(this.workingDir, "source/")), (FileCompressionFormat)FileCompressionFormat.ZIP).booleanValue()) {
                LOGGER.error((Object)"Was not able to prepare the generic algorithm due to an archive issue.");
                throw new ComponentException("Was not able to prepare the generic algorithm due to an archive issue.");
            }
        }
        catch (IOException e) {
            throw new ComponentException("Failed to prepare generic algorithm", (Throwable)e);
        }
        this.configurationFile = new File(new File(this.workingDir, "source"), "configuration.json");
        this.writeConfigurationFile(this.configurationFile);
    }

    private File getSourceFolder() throws ComponentException {
        File configFolder = new File(((ConfigurationService)this.compContext.getService(ConfigurationService.class)).getConfigurablePath(ConfigurationService.ConfigurablePathId.DEFAULT_WRITEABLE_INTEGRATION_ROOT), "optimizer");
        return new File(new File(configFolder, this.config.getMethodDescription(this.config.getAlgorithms()[0]).getConfigValue("genericFolder")), "source");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getOptimalRunNumber() throws ComponentException {
        File result = new File(this.workingDir, "generic.result");
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                int n;
                BufferedReader fr = new BufferedReader(new FileReader(result));
                try {
                    String firstLine = fr.readLine();
                    if (firstLine == null) throw new ComponentException("Failed to parse result file for information about optimal variables; cause: result file is empty");
                    n = Integer.parseInt(firstLine);
                    return n;
                }
                finally {
                    if (fr == null) return n;
                    fr.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ComponentException("Failed to parse result file for information about optimal variables", (Throwable)e);
        }
    }

    @TaskDescription(value="Optimizer Algorithm Executor Generic")
    public void run() {
        try {
            File pythonPathFile = new File(this.getSourceFolder(), "python_path");
            if (!pythonPathFile.exists()) {
                throw new ComponentException("Could not read python path from file, it does not exist: " + pythonPathFile.getAbsolutePath());
            }
            this.readPythonPathFile(pythonPathFile);
        }
        catch (ComponentException | IOException e) {
            this.startFailed.set(true);
            this.startFailedException = e;
            LOGGER.error((Object)"Could not start external algorithm: ", e);
        }
    }

    private void readPythonPathFile(File pythonPathFile) throws IOException, ComponentException {
        String pythonPath;
        List lines = FileUtils.readLines((File)pythonPathFile);
        if (!lines.isEmpty() && lines.get(0) != null && !((String)lines.get(0)).isEmpty()) {
            pythonPath = (String)lines.get(0);
            if (pythonPath == null || pythonPath.isEmpty() || pythonPath.contains("$")) {
                LOGGER.warn((Object)"Failed to find path to Python; trying 'python'");
                pythonPath = "python";
            }
        } else {
            throw new ComponentException("Could not read python path from file: " + pythonPathFile.getAbsolutePath());
        }
        this.startProgram("source" + File.separator + "generic_optimizer.py", pythonPath);
    }

    public void writeHistoryDataItem(OptimizerComponentHistoryDataItem historyItem) {
        if (this.configurationFileReference == null) {
            try {
                this.configurationFileReference = ((ComponentDataManagementService)this.compContext.getService(ComponentDataManagementService.class)).createFileReferenceTDFromLocalFile(this.compContext, this.configurationFile, "configuration.json");
            }
            catch (IOException e) {
                String errorMessage = "Failed to store configuration file into the data management; it is not available in the workflow data browser";
                String errorId = LogUtils.logExceptionWithStacktraceAndAssignUniqueMarker((Log)LOGGER, (String)errorMessage, (Throwable)e);
                this.compContext.getLog().componentError(errorMessage, (Throwable)e, errorId);
            }
        }
        if (this.configurationFileReference != null) {
            historyItem.setInputFileReference(this.configurationFileReference.getFileReference());
        }
    }

    protected void initializeImplementation() throws ComponentException {
    }
}

