/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.optimizer.execution.algorithms.registry.internal;

import de.rcenvironment.components.optimizer.common.execution.OptimizerAlgorithmExecutor;
import de.rcenvironment.components.optimizer.common.execution.OptimizerConfiguration;
import de.rcenvironment.components.optimizer.execution.algorithms.registry.OptimizerAlgorithmExecutorFactory;
import de.rcenvironment.components.optimizer.execution.algorithms.registry.OptimizerAlgorithmExecutorFactoryRegistry;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class OptimizerAlgorithmExecutorFactoryRegistryImpl
implements OptimizerAlgorithmExecutorFactoryRegistry {
    private final List<OptimizerAlgorithmExecutorFactory> factories = Collections.synchronizedList(new LinkedList());

    @Override
    public void addOptimizerAlgorithmExecutorFactory(OptimizerAlgorithmExecutorFactory incProvider) {
        if (incProvider != null && !this.factories.contains(incProvider)) {
            this.factories.add(incProvider);
        }
    }

    @Override
    public void removeOptimizerAlgorithmExecutorFactory(OptimizerAlgorithmExecutorFactory algFactory) {
        if (algFactory != null && this.factories.contains(algFactory)) {
            this.factories.remove(algFactory);
        }
    }

    @Override
    public OptimizerAlgorithmExecutor createAlgorithmProviderInstance(ComponentContext context, OptimizerConfiguration config) throws ComponentException {
        OptimizerAlgorithmExecutor result = null;
        for (OptimizerAlgorithmExecutorFactory currentProvider : this.factories) {
            if (!currentProvider.getOptimizerAlgorithmPackageIdentifier().equalsIgnoreCase(config.getOptimizationPackage())) continue;
            result = currentProvider.createOptimizerAlgorithmExecutorInstance(context, config);
        }
        return result;
    }
}

