/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.optimizer.execution;

import de.rcenvironment.components.optimizer.common.OptimizerComponentHistoryDataItem;
import de.rcenvironment.components.optimizer.common.execution.DesignSet;
import de.rcenvironment.components.optimizer.common.execution.OptimizerAlgorithmExecutor;
import de.rcenvironment.components.optimizer.common.execution.OptimizerConfiguration;
import de.rcenvironment.components.optimizer.common.execution.ResultSet;
import de.rcenvironment.components.optimizer.execution.algorithms.registry.OptimizerAlgorithmExecutorFactoryRegistry;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.component.datamanagement.api.ComponentHistoryDataItem;
import de.rcenvironment.core.component.execution.api.Component;
import de.rcenvironment.core.component.model.spi.AbstractNestedLoopComponent;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.utils.common.LogUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OptimizerComponent
extends AbstractNestedLoopComponent {
    public static final String NO_ALGORITHM_WAS_SELECTED_EXCEPTION_MSG = "No algorithm was selected.";
    public static final String NO_OBJECTIVES_CONFIGURED_EXCEPTION_MSG = "No objectives configured.";
    public static final String NO_DESIGN_VARIABLES_CONFIGURED_EXCEPTION_MSG = "No design variables configured.";
    public static final Log LOGGER = LogFactory.getLog(OptimizerComponent.class);
    private static final String RESULT_DM_NAME = "Result.csv";
    private static final String OPTIMIZER_RESULT_FILE_CSV_NAME = "OptimizerResultFile*.csv";
    private OptimizerConfiguration config;
    private OptimizerAlgorithmExecutor optimizer;
    private DesignSet currentDesignSet = null;
    private ResultSet currentResultSet = null;
    private Map<Integer, DesignSet> iterationDesigns;
    private Map<Integer, ResultSet> iterationResults;
    private OptimizerComponentHistoryDataItem historyDataItem;
    private Map<Integer, Map<String, TypedDatum>> dataForwarded = new LinkedHashMap<Integer, Map<String, TypedDatum>>();
    private List<File> resultFiles = new LinkedList<File>();
    private Integer iteration = 0;

    protected void startNestedComponentSpecific() throws ComponentException {
        this.iterationDesigns = new TreeMap<Integer, DesignSet>();
        this.iterationResults = new TreeMap<Integer, ResultSet>();
        this.dataForwarded = new HashMap<Integer, Map<String, TypedDatum>>();
        if (!this.hasDesignVariables()) {
            throw new ComponentException(NO_DESIGN_VARIABLES_CONFIGURED_EXCEPTION_MSG);
        }
        if (!this.hasObjectives()) {
            throw new ComponentException(NO_OBJECTIVES_CONFIGURED_EXCEPTION_MSG);
        }
        this.config = new OptimizerConfiguration(this.componentContext);
        this.checkMethodConfiguration();
        this.optimizer = ((OptimizerAlgorithmExecutorFactoryRegistry)this.componentContext.getService(OptimizerAlgorithmExecutorFactoryRegistry.class)).createAlgorithmProviderInstance(this.componentContext, this.config);
        if (this.treatStartAsComponentRun()) {
            super.processInputs();
        }
    }

    private void checkMethodConfiguration() throws ComponentException {
        String[] splittedAlgorithms;
        String algorithm = this.componentContext.getConfigurationValue("algorithm");
        if (algorithm != null) {
            splittedAlgorithms = algorithm.split(",");
            if (splittedAlgorithms.length == 0) {
                throw new ComponentException(NO_ALGORITHM_WAS_SELECTED_EXCEPTION_MSG);
            }
        } else {
            throw new ComponentException(NO_ALGORITHM_WAS_SELECTED_EXCEPTION_MSG);
        }
        String[] stringArray = splittedAlgorithms;
        int n = splittedAlgorithms.length;
        int n2 = 0;
        while (n2 < n) {
            String alg = stringArray[n2];
            if (!this.config.getMethodDescriptions().containsKey(alg)) {
                throw new ComponentException("Failed to load algorithm '" + alg + "': not found");
            }
            ++n2;
        }
    }

    protected void processInputsNestedComponentSpecific() throws ComponentException {
        this.initializeNewHistoryDataItem();
        if (!this.optimizer.isInitialized()) {
            this.initializeOptimizer();
        } else {
            this.currentResultSet = this.config.readResultSet();
            this.iterationResults.put(this.getIteration(), this.currentResultSet);
            this.createNewResultfile();
            if (!this.optimizer.isFailed()) {
                this.currentDesignSet = this.optimizer.runStep(this.currentResultSet);
            }
            this.currentResultSet = null;
        }
        if (Boolean.valueOf(Boolean.parseBoolean(this.componentContext.getConfigurationValue("storeComponentHistoryData"))).booleanValue()) {
            this.optimizer.writeHistoryDataItem(this.historyDataItem);
            this.writeFinalHistoryDataItem();
        }
        this.iteration = this.iteration + 1;
        this.storeDataForwarded();
    }

    private void initializeOptimizer() throws ComponentException {
        if (this.hasStartValues()) {
            this.config.readStartValuesFromInputs();
        }
        if (!this.optimizer.initialize(this.config)) {
            throw new ComponentException("Failed to initialize optimizer");
        }
        this.currentDesignSet = this.optimizer.runStep(null);
    }

    protected void sendValuesNestedComponentSpecific() {
        if (this.currentDesignSet != null) {
            for (String e : this.config.getCompactDesignVariablesNames()) {
                this.writeOutput(e, this.currentDesignSet.getVariableTypedDatumValue(e));
            }
            this.writeOutput("Iteration", (TypedDatum)this.typedDatumFactory.createInteger((long)this.getIteration()));
            this.writeOutput("Gradient request", (TypedDatum)this.typedDatumFactory.createBoolean(this.currentDesignSet.getDerivativedNeeded()));
            this.iterationDesigns.put(this.getIteration(), this.currentDesignSet);
        }
    }

    private void createNewResultfile() {
        if (!this.componentContext.getInputsWithDatum().isEmpty() && this.historyDataItem != null) {
            try {
                File resultFile = TempFileServiceAccess.getInstance().createTempFileFromPattern(OPTIMIZER_RESULT_FILE_CSV_NAME);
                this.writeResultToCSVFile(resultFile.getAbsolutePath());
                FileReferenceTD resultFileReference = ((ComponentDataManagementService)this.componentContext.getService(ComponentDataManagementService.class)).createFileReferenceTDFromLocalFile(this.componentContext, resultFile, RESULT_DM_NAME);
                this.historyDataItem.setResultFileReference(resultFileReference.getFileReference());
                this.resultFiles.add(resultFile);
            }
            catch (IOException e) {
                String errorMessage = "Failed to store result file into the data management; it is not available in the workflow data browser";
                String errorId = LogUtils.logExceptionWithStacktraceAndAssignUniqueMarker((Log)LOGGER, (String)errorMessage, (Throwable)e);
                this.componentLog.componentError(errorMessage, (Throwable)e, errorId);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeResultToCSVFile(String path) throws IOException {
        if (path == null || this.iterationDesigns.isEmpty()) return;
        LinkedList<String> orderedOutputs = new LinkedList<String>(this.config.getExtendedDesignVariableNames());
        LinkedList<String> orderedInputs = new LinkedList<String>(this.config.getExtendedObjectivesNames());
        orderedInputs.addAll(this.config.getExtendedConstraintNames());
        orderedInputs.addAll(this.config.getAllExtendedGradientNames());
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            FileWriter fw = new FileWriter(new File(path));
            try {
                try (CSVPrinter printer = CSVFormat.newFormat((char)';').withIgnoreSurroundingSpaces().withAllowMissingColumnNames().withRecordSeparator("\n").print((Appendable)fw);){
                    for (String outputName : orderedOutputs) {
                        printer.print((Object)outputName);
                    }
                    for (String inputName : orderedInputs) {
                        printer.print((Object)inputName);
                    }
                    printer.println();
                    this.writeToCSVFile(orderedOutputs, orderedInputs, printer);
                }
                if (fw == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fw == null) throw throwable;
                fw.close();
                throw throwable;
            }
            fw.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void writeToCSVFile(List<String> orderedOutputs, List<String> orderedInputs, CSVPrinter printer) throws IOException {
        int i = 1;
        while (i <= this.iterationDesigns.size()) {
            Integer currIteration = i;
            DesignSet design = this.iterationDesigns.get(currIteration);
            ResultSet result = this.iterationResults.get(currIteration);
            printer.print((Object)currIteration);
            for (String designVariable : orderedOutputs) {
                printer.print((Object)design.getVariableValue(designVariable));
            }
            for (String resultVariable : orderedInputs) {
                try {
                    printer.print((Object)result.getInputVariableValue(resultVariable));
                }
                catch (ComponentException e) {
                    LOGGER.error((Object)"Could not write value to resultfile:", (Throwable)e);
                }
            }
            printer.println();
            printer.flush();
            ++i;
        }
    }

    protected void sendFinalValues() throws ComponentException {
        this.optimizer.setIterationData(this.iterationDesigns);
        Integer optimalRunNumber = this.optimizer.getOptimalRunNumber();
        DesignSet optimumDesign = this.iterationDesigns.get(optimalRunNumber);
        ResultSet optimumResult = this.iterationResults.get(optimalRunNumber);
        if (optimalRunNumber != Integer.MIN_VALUE && optimumDesign != null) {
            for (String e : this.config.getOptimaOutputs()) {
                this.sendOptimalValue(optimumDesign, optimumResult, e);
            }
        } else {
            throw new ComponentException("Failed to read optimal design variables");
        }
        this.sendFinalValuesForwarded(optimalRunNumber);
    }

    private void sendOptimalValue(DesignSet optimumDesign, ResultSet optimumResult, String e) {
        String correspondingVariable = this.componentContext.getOutputMetaDataValue(e, "correspondingVar");
        if (optimumDesign.getVariableTypedDatumValue(correspondingVariable) != null) {
            this.writeOutput(e, optimumDesign.getVariableTypedDatumValue(correspondingVariable));
        } else {
            this.writeOutput(e, optimumResult.getVariableTypedDatumValue(correspondingVariable));
        }
    }

    private void sendFinalValuesForwarded(Integer optimalRunNumber) {
        if (optimalRunNumber == null || optimalRunNumber == Integer.MIN_VALUE) {
            this.componentContext.getLog().componentError("Internal error: iteration of optimal design variable cannot be determined");
            return;
        }
        if (!this.dataForwarded.isEmpty()) {
            if (this.dataForwarded.get(optimalRunNumber) == null) {
                this.componentContext.getLog().componentError("No forwarding values could be found for optimal run number " + optimalRunNumber);
                return;
            }
            for (Map.Entry<String, TypedDatum> inputName : this.dataForwarded.get(optimalRunNumber).entrySet()) {
                this.writeOutput(String.valueOf(inputName.getKey()) + "_optimal", inputName.getValue());
            }
        }
    }

    private void storeDataForwarded() {
        Integer componentIteration = this.getIteration();
        for (String inputName : this.componentContext.getInputsWithDatum()) {
            if (this.componentContext.isDynamicInput(inputName) && this.componentContext.getDynamicInputIdentifier(inputName).equals("toForward")) {
                if (!this.dataForwarded.containsKey(componentIteration)) {
                    this.dataForwarded.put(componentIteration, new HashMap());
                }
                this.dataForwarded.get(componentIteration).put(inputName, this.componentContext.readInput(inputName));
            }
            if (!componentIteration.equals(1) || !this.componentContext.isDynamicInput(inputName) || !this.componentContext.getDynamicInputIdentifier(inputName).equals("startToForward")) continue;
            if (!this.dataForwarded.containsKey(componentIteration)) {
                this.dataForwarded.put(componentIteration, new HashMap());
            }
            this.dataForwarded.get(componentIteration).put(inputName.replaceFirst("_start", ""), this.componentContext.readInput(inputName));
        }
    }

    protected void resetNestedComponentSpecific() {
        this.optimizer.reset();
        this.optimizer = null;
        this.config = null;
        this.currentDesignSet = null;
        this.currentResultSet = null;
        this.historyDataItem = null;
        this.iterationDesigns = null;
        this.iterationResults = null;
        this.dataForwarded = null;
        this.iteration = 0;
    }

    protected void finishLoopNestedComponentSpecific() {
        this.writeFinalHistoryDataItem();
    }

    protected boolean isDoneNestedComponentSpecific() {
        return this.optimizer.isFinished() || this.optimizer.isFailed();
    }

    private void initializeNewHistoryDataItem() {
        if (Boolean.valueOf(this.componentContext.getConfigurationValue("storeComponentHistoryData")).booleanValue()) {
            this.historyDataItem = new OptimizerComponentHistoryDataItem();
        }
    }

    private void writeFinalHistoryDataItem() {
        if (Boolean.valueOf(this.componentContext.getConfigurationValue("storeComponentHistoryData")).booleanValue()) {
            this.componentContext.writeFinalHistoryDataItem((ComponentHistoryDataItem)this.historyDataItem);
        }
    }

    private int getIteration() {
        return this.iteration;
    }

    private boolean hasObjectives() {
        return !this.componentContext.getDynamicInputsWithIdentifier("Objective").isEmpty();
    }

    private boolean hasDesignVariables() {
        return !this.componentContext.getDynamicOutputsWithIdentifier("Design").isEmpty();
    }

    private boolean hasStartValues() {
        return !this.componentContext.getDynamicInputsWithIdentifier("startvalues").isEmpty() || !this.componentContext.getDynamicInputsWithIdentifier("stepvalues").isEmpty();
    }

    public boolean treatStartAsComponentRun() {
        return !this.hasStartValues();
    }

    public void tearDown(Component.FinalComponentState state) {
        super.tearDown(state);
        if (this.optimizer != null) {
            this.optimizer.tearDown();
        }
        for (File f : this.resultFiles) {
            if (!f.exists()) continue;
            try {
                TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(f);
            }
            catch (IOException e) {
                LOGGER.debug((Object)"Could not delete old result file. ", (Throwable)e);
            }
        }
    }
}

