/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.optimizer.dakota.execution.internal;

import de.rcenvironment.components.optimizer.common.CommonBundleClasspathStub;
import de.rcenvironment.components.optimizer.common.MethodDescription;
import de.rcenvironment.components.optimizer.common.OptimizerComponentHistoryDataItem;
import de.rcenvironment.components.optimizer.common.OptimizerVariableType;
import de.rcenvironment.components.optimizer.common.StartValueType;
import de.rcenvironment.components.optimizer.common.execution.DesignSet;
import de.rcenvironment.components.optimizer.common.execution.OptimizerAlgorithmExecutor;
import de.rcenvironment.components.optimizer.common.execution.OptimizerConfiguration;
import de.rcenvironment.components.optimizer.common.execution.ResultSet;
import de.rcenvironment.components.optimizer.dakota.execution.internal.DakotaConstants;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.configuration.ConfigurationSegment;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.utils.common.LogUtils;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.exec.OS;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;

public class DakotaAlgorithm
extends OptimizerAlgorithmExecutor {
    private static final String NAN = "NaN";
    private static final String APOSTROPHE = "'";
    private static final String INPUT_ARGUMENT = " -input ";
    private static final String RESTART_FILE_ARGUMENT = " -read_restart ";
    private static final Object LOCK_OBJECT = new Object();
    private static final double RESULT_EPS = 1.0E-9;
    private File dakotaExecutablePath = null;
    private int currentActiveSetVectorNumber = 0;
    private File dakotaInputFile;
    private FileReferenceTD dakotaInputFileReference;
    private OptimizerConfiguration config;

    public DakotaAlgorithm(OptimizerConfiguration config, ComponentContext context) {
        super(context, "dakotaInput.in", "results.out");
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeImplementation() throws ComponentException {
        ConfigurationService confService = (ConfigurationService)this.compContext.getService(ConfigurationService.class);
        Object object = LOCK_OBJECT;
        synchronized (object) {
            if (Boolean.parseBoolean(this.compContext.getConfigurationValue("CustomDakotaPath"))) {
                this.dakotaExecutablePath = new File(this.compContext.getConfigurationValue("dakotaExecPath"));
                if (!(this.dakotaExecutablePath.exists() && this.dakotaExecutablePath.isFile() && this.dakotaExecutablePath.canExecute())) {
                    this.dakotaExecutablePath = null;
                    this.compContext.getLog().componentInfo("Dakota binary not found at user specified location. Switching to default location");
                }
            }
            if (this.dakotaExecutablePath == null) {
                ConfigurationSegment confSegment = confService.getConfigurationSegment("thirdPartyIntegration/dakota");
                if (confSegment == null || confSegment.getString("binaryPath") == null) {
                    this.compContext.getLog().componentInfo("The Dakota integration is not configured correctly. Please see the \"thirdPartyConfiguration\" segment in the configuration reference for details.");
                    throw new ComponentException("The Dakota integration is not configured correctly. The 'binaryPath' key of the 'thirdPartyIntegration/dakota' configuration segment returned null.");
                }
                this.dakotaExecutablePath = new File(confSegment.getString("binaryPath"));
                if (!(this.dakotaExecutablePath.exists() && this.dakotaExecutablePath.isFile() && this.dakotaExecutablePath.canExecute())) {
                    this.compContext.getLog().componentInfo("Dakota binary not found at user specified location or cannot be executed.");
                    throw new ComponentException("Dakota binary was not found at user specified location or cannot be executed: " + this.dakotaExecutablePath.getAbsolutePath());
                }
            }
        }
        boolean setOK = this.workingDir.setExecutable(true);
        if (setOK && this.dakotaExecutablePath != null && !this.dakotaExecutablePath.exists()) {
            this.copyDakotaExecutable();
        }
    }

    private void copyDakotaExecutable() throws ComponentException {
        block17: {
            String path = null;
            if (OS.isFamilyWindows()) {
                path = "/resources/binaries/dakota.exe";
            } else if (OS.isFamilyUnix()) {
                path = "/resources/binaries/dakota";
            }
            if (path != null) {
                try {
                    Throwable throwable = null;
                    Object var3_6 = null;
                    try (InputStream dakotaInput = CommonBundleClasspathStub.class.getResourceAsStream(path);){
                        if (dakotaInput != null) {
                            FileUtils.copyInputStreamToFile((InputStream)dakotaInput, (File)this.dakotaExecutablePath);
                            this.copyDLL();
                            break block17;
                        }
                        this.initFailed.set(true);
                        throw new ComponentException("Failed to copy Dakota binaries: Dakota files might not be installed.");
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    this.initFailed.set(true);
                    throw new ComponentException("Failed to copy Dakota binaries", (Throwable)e);
                }
            }
            this.initFailed.set(true);
            this.startFailedException = new ComponentException("Dakota binaries not found; most likely because Dakota is not available for your operating system");
        }
        boolean setOK = this.dakotaExecutablePath.setExecutable(true);
        if (!setOK) {
            throw new ComponentException("Could not set executable as executable.");
        }
    }

    private void copyDLL() throws IOException {
        if (OS.isFamilyWindows()) {
            String[] dllFiles;
            String[] stringArray = dllFiles = new String[]{"libifcoremd.dll", "libmmd.dll", "msvcp100.dll", "msvcr100.dll"};
            int n = dllFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String dll = stringArray[n2];
                FileUtils.copyInputStreamToFile((InputStream)CommonBundleClasspathStub.class.getResourceAsStream("/resources/binaries/" + dll), (File)new File(this.dakotaExecutablePath.getParentFile(), dll));
                ++n2;
            }
        }
    }

    protected void prepareProblem() throws ComponentException {
        this.createScript();
        this.createDakotaInputFile();
    }

    public int getOptimalRunNumber() throws ComponentException {
        File output = new File(this.workingDir.getAbsolutePath(), "consoleStdOutput.txt");
        HashMap<String, Double> results = new HashMap<String, Double>();
        try {
            List outputLines = FileUtils.readLines((File)output);
            boolean readParameters = false;
            for (String s : outputLines) {
                String[] resultLine;
                if (s.startsWith("<<<<< Best data captured at function evaluation ")) {
                    return Integer.parseInt(s.substring("<<<<< Best data captured at function evaluation ".length()));
                }
                if (s.startsWith("<<<<< Best objective function")) {
                    readParameters = false;
                }
                if (readParameters && (resultLine = s.split("\\s+")) != null && resultLine.length == 3) {
                    results.put(resultLine[2], Double.parseDouble(resultLine[1]));
                }
                if (!s.startsWith("<<<<< Best parameters")) continue;
                readParameters = true;
            }
            if (this.iterationData != null) {
                for (Integer iteration : this.iterationData.keySet()) {
                    DesignSet iterationValues = (DesignSet)this.iterationData.get(iteration);
                    boolean containsAll = true;
                    for (String variable : results.keySet()) {
                        if (!(Math.abs((iterationValues.getVariableValue(variable) - (Double)results.get(variable)) / iterationValues.getVariableValue(variable)) > 1.0E-9) && !Double.isNaN(iterationValues.getVariableValue(variable))) continue;
                        containsAll = false;
                    }
                    if (!containsAll) continue;
                    return iteration;
                }
            }
        }
        catch (IOException e) {
            LOGGER.debug((Object)"Reading optimal run number failed: ", (Throwable)e);
            return Integer.MIN_VALUE;
        }
        return Integer.MIN_VALUE;
    }

    @TaskDescription(value="Optimizer Algorithm Executor Dakota")
    public void run() {
        String command = this.dakotaExecutablePath.getAbsolutePath();
        if (this.compContext.getConfigurationValue("usePrecalculation") != null && Boolean.parseBoolean(this.compContext.getConfigurationValue("usePrecalculation"))) {
            command = String.valueOf(command) + " -read_restart \"" + new File(this.compContext.getConfigurationValue("preCalcFilePath")).getAbsolutePath() + "\" ";
        }
        command = String.valueOf(command) + INPUT_ARGUMENT;
        try {
            if (!this.initFailed.get()) {
                this.startProgram(command);
            }
        }
        catch (ComponentException e) {
            this.startFailed.set(true);
            this.startFailedException = e;
        }
        this.stop();
    }

    private void createDakotaInputFile() throws ComponentException {
        try {
            this.createScript();
            boolean isSurrogate = this.config.getAlgorithms().length > 1 && this.config.getAlgorithms()[0].equalsIgnoreCase("Dakota Surrogate-Based Local");
            HashMap<String, String> valuesForSampleFile = new HashMap<String, String>();
            MethodDescription description = this.config.getMethodDescription(this.config.getAlgorithms()[0]);
            valuesForSampleFile.put("%%METHOD_CODE%%", description.getMethodCode());
            valuesForSampleFile.put("%%METHOD_PROPERTIES%%", String.valueOf(DakotaAlgorithm.createMethodsProperties(description.getCommonSettings())) + DakotaConstants.NEWLINE + DakotaAlgorithm.createMethodsProperties(description.getSpecificSettings()));
            if (isSurrogate) {
                MethodDescription description2 = this.config.getMethodDescription(this.config.getAlgorithms()[1]);
                valuesForSampleFile.put("%%METHOD_2_CODE%%", description2.getMethodCode());
                valuesForSampleFile.put("%%METHOD_2_PROPERTIES%%", String.valueOf(DakotaAlgorithm.createMethodsProperties(description2.getCommonSettings())) + DakotaConstants.NEWLINE + DakotaAlgorithm.createMethodsProperties(description2.getSpecificSettings()));
                MethodDescription description3 = this.config.getMethodDescription(this.config.getAlgorithms()[2]);
                valuesForSampleFile.put("%%METHOD_3_CODE%%", description3.getMethodCode());
                valuesForSampleFile.put("%%METHOD_3_PROPERTIES%%", String.valueOf(DakotaAlgorithm.createMethodsProperties(description3.getCommonSettings())) + DakotaConstants.NEWLINE + DakotaAlgorithm.createMethodsProperties(description3.getSpecificSettings()));
            }
            this.writeContinousDesignVariables(valuesForSampleFile);
            this.writeDiscreteDesignVariables(valuesForSampleFile);
            if (OS.isFamilyWindows()) {
                valuesForSampleFile.put("%%DRIVER_FOR_OS%%", "'dakotaBlackBox.bat'");
            } else if (OS.isFamilyUnix()) {
                valuesForSampleFile.put("%%DRIVER_FOR_OS%%", "'dakotaBlackBox.sh'");
            }
            valuesForSampleFile.put("%%WORKDIR%%", String.valueOf(this.inputFileName) + "workdir'");
            valuesForSampleFile.put("%%OBJECTIVE_FUNCTIONS_COUNT%%", this.config.getObjectivesCount());
            valuesForSampleFile.put("%%OBJECTIVES_WEIGHT%%", this.getWeightString());
            valuesForSampleFile.put("%%CONSTRAINT_COUNT%%", this.config.getConstraintsCount());
            valuesForSampleFile.put("%%CONSTRAINT_LOWER%%", this.getConstraintBoundString(StartValueType.LOWER_BOUND));
            valuesForSampleFile.put("%%CONSTRAINT_UPPER%%", this.getConstraintBoundString(StartValueType.UPPER_BOUND));
            valuesForSampleFile.put("%%GRADIENT_SECTION%%", DakotaAlgorithm.getGradientString(description));
            if (isSurrogate) {
                valuesForSampleFile.put("%%GRADIENT_2_SECTION%%", DakotaAlgorithm.getGradientString(this.config.getMethodDescription(this.config.getAlgorithms()[2])));
            }
            String filePath = "/resources/dakota_standard.sample";
            if (isSurrogate) {
                filePath = "/resources/dakota_surrogate.sample";
            }
            String content = DakotaAlgorithm.replacePlaceholderInSamplefile(filePath, valuesForSampleFile);
            this.dakotaInputFile = new File(String.valueOf(this.workingDir.getAbsolutePath()) + File.separator + this.inputFileName);
            if (!this.dakotaInputFile.createNewFile()) {
                throw new IOException("Can't create new dakota input file.");
            }
            FileUtils.writeStringToFile((File)this.dakotaInputFile, (String)content);
        }
        catch (IOException e) {
            throw new ComponentException("Failed to create input file for Dakota", (Throwable)e);
        }
    }

    private void writeContinousDesignVariables(Map<String, String> valuesForSampleFile) {
        int cdvCount = this.config.getContinousDesignVariableCount();
        if (cdvCount > 0) {
            valuesForSampleFile.put("%%CONTINUOUS_DESIGN_COUNT%%", Integer.toString(cdvCount));
        } else {
            valuesForSampleFile.put("%%CONTINUOUS_DESIGN_COUNT%%", "");
        }
        String startValuesString = this.createDesignVariableNameOrValueString(true, false);
        valuesForSampleFile.put("%%CDV_INITIAL_POINT%%", startValuesString);
        valuesForSampleFile.put("%%CDV_LOWER_BOUNDS%%", this.getDVBounds(StartValueType.LOWER_BOUND, false));
        valuesForSampleFile.put("%%CDV_UPPER_BOUNDS%%", this.getDVBounds(StartValueType.UPPER_BOUND, false));
        String dvNames = this.createDesignVariableNameOrValueString(false, false);
        valuesForSampleFile.put("%%CDV_NAMES%%", dvNames);
    }

    private void writeDiscreteDesignVariables(Map<String, String> valuesForSampleFile) {
        int ddvCount = this.config.getDiscreteDesignVariableCount();
        if (ddvCount > 0) {
            valuesForSampleFile.put("%%DISCRETE_DESIGN_COUNT%%", Integer.toString(ddvCount));
        } else {
            valuesForSampleFile.put("%%DISCRETE_DESIGN_COUNT%%", "");
        }
        String startValuesString = this.createDesignVariableNameOrValueString(true, true);
        valuesForSampleFile.put("%%DDV_INITIAL_POINT%%", startValuesString);
        valuesForSampleFile.put("%%DDV_LOWER_BOUNDS%%", this.getDVBounds(StartValueType.LOWER_BOUND, true));
        valuesForSampleFile.put("%%DDV_UPPER_BOUNDS%%", this.getDVBounds(StartValueType.UPPER_BOUND, true));
        String dvNames = this.createDesignVariableNameOrValueString(false, true);
        valuesForSampleFile.put("%%DDV_NAMES%%", dvNames);
    }

    private String createDesignVariableNameOrValueString(boolean addValue, boolean isDiscrete) {
        StringBuilder resultString = new StringBuilder();
        for (String designVariableName : this.config.getExtendedDesignVariableNames()) {
            boolean discrete = this.config.isDiscrete(designVariableName);
            if (isDiscrete != discrete) continue;
            if (addValue) {
                resultString.append("\t" + this.config.getStartValue(designVariableName, StartValueType.INITIAL_POINT, OptimizerVariableType.DESIGN));
                continue;
            }
            resultString.append("\t'" + designVariableName + APOSTROPHE);
        }
        return resultString.toString();
    }

    private static String replacePlaceholderInSamplefile(String filePath, Map<String, String> valuesForSampleFile) throws IOException {
        String content = IOUtils.toString((InputStream)DakotaAlgorithm.class.getResourceAsStream(filePath));
        String[] splitted = content.split(DakotaConstants.NEWLINE);
        for (String key : valuesForSampleFile.keySet()) {
            if (valuesForSampleFile.get(key) == null || valuesForSampleFile.get(key).isEmpty()) {
                String[] stringArray = splitted;
                int n = splitted.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (s.contains(key)) {
                        content = content.replace(s, "");
                    }
                    ++n2;
                }
                continue;
            }
            content = content.replaceAll(key, valuesForSampleFile.get(key));
        }
        return content;
    }

    private String getDVBounds(StartValueType boundType, boolean isDiscrete) {
        StringBuilder result = new StringBuilder();
        for (String designVariableName : this.config.getExtendedDesignVariableNames()) {
            boolean discrete = this.config.isDiscrete(designVariableName);
            if (discrete != isDiscrete) continue;
            result.append("\t" + this.config.getStartValue(designVariableName, boundType, OptimizerVariableType.DESIGN));
        }
        return result.toString();
    }

    private String getWeightString() {
        StringBuilder weights = new StringBuilder();
        for (String e : this.config.getExtendedObjectivesNames()) {
            weights.append(this.config.getObjectiveWeigth(e) + " ");
        }
        return weights.toString();
    }

    private String getConstraintBoundString(StartValueType type) {
        StringBuilder result = new StringBuilder();
        for (String element : this.config.getExtendedConstraintNames()) {
            result.append(this.config.getStartValue(element, type, OptimizerVariableType.CONSTRAINT) + " ");
        }
        return result.toString();
    }

    private static String getGradientString(MethodDescription description) throws IOException {
        HashMap<String, String> gradientStrings = new HashMap<String, String>();
        StringBuilder gradients = new StringBuilder();
        if (description.getResponsesSettings() != null && description.getResponsesSettings().get("gradients") != null) {
            Map respSettings = description.getResponsesSettings();
            String gradientValue = (String)((Map)respSettings.get("gradients")).get("Value");
            if (gradientValue == null || gradientValue.isEmpty()) {
                gradientValue = (String)((Map)respSettings.get("gradients")).get("DefaultValue");
            }
            if (gradientValue.equalsIgnoreCase("numerical_gradients")) {
                String intervalValue = (String)((Map)respSettings.get("interval_type")).get("Value");
                if (intervalValue == null || intervalValue.isEmpty()) {
                    intervalValue = (String)((Map)respSettings.get("interval_type")).get("DefaultValue");
                }
                gradientStrings.put("%%INTERVAL_TYPE%%", intervalValue);
                String stepSizeValue = (String)((Map)respSettings.get("fd_gradient_step_size")).get("Value");
                if (stepSizeValue == null || stepSizeValue.isEmpty()) {
                    stepSizeValue = (String)((Map)respSettings.get("fd_gradient_step_size")).get("DefaultValue");
                }
                gradientStrings.put("%%GRADIENT_STEP_SIZE%%", stepSizeValue);
                String hessiansValue = (String)((Map)respSettings.get("hessians")).get("Value");
                if (hessiansValue == null || hessiansValue.isEmpty()) {
                    hessiansValue = (String)((Map)respSettings.get("hessians")).get("DefaultValue");
                }
                gradientStrings.put("%%HESSIANS_VALUE%%", hessiansValue);
                if (!hessiansValue.equals("no_hessians")) {
                    String hessianIntervalValue = (String)((Map)respSettings.get("interval_type_hessian")).get("Value");
                    if (hessianIntervalValue == null || hessianIntervalValue.isEmpty()) {
                        hessianIntervalValue = (String)((Map)respSettings.get("interval_type_hessian")).get("DefaultValue");
                    }
                    gradientStrings.put("%%HESSIAN_INTERVALL%%", hessianIntervalValue);
                    String hessianStepValue = (String)((Map)respSettings.get("fd_hessian_step_size")).get("Value");
                    if (hessianStepValue == null || hessianStepValue.isEmpty()) {
                        hessianStepValue = (String)((Map)respSettings.get("fd_hessian_step_size")).get("DefaultValue");
                    }
                    gradientStrings.put("%%HESSIAN_STEP_SIZE%%", hessianStepValue);
                }
                gradientStrings.put("%%GRADIENTS%%", DakotaAlgorithm.replacePlaceholderInSamplefile("/resources/dakota_gradients.sample", gradientStrings));
                if (!((String)gradientStrings.get("%%HESSIANS_VALUE%%")).equals("no_hessians")) {
                    gradientStrings.put("%%HESSIANS%%", DakotaAlgorithm.replacePlaceholderInSamplefile("/resources/dakota_hessians.sample", gradientStrings));
                } else {
                    gradientStrings.put("%%HESSIANS%%", "no_hessians");
                }
            } else {
                gradientStrings.put("%%GRADIENTS%%", "analytic_gradients");
                gradientStrings.put("%%HESSIANS%%", "no_hessians");
            }
        } else {
            gradientStrings.put("%%GRADIENTS%%", "no_gradients");
            gradientStrings.put("%%HESSIANS%%", "no_hessians");
        }
        gradients.append(DakotaAlgorithm.replacePlaceholderInSamplefile("/resources/dakota_gradients_base.sample", gradientStrings));
        return gradients.toString();
    }

    private static String createMethodsProperties(Map<String, Map<String, String>> settingsType) {
        StringBuilder methodProperties = new StringBuilder();
        Iterator<String> iterator = settingsType.keySet().iterator();
        while (iterator.hasNext()) {
            Map<String, Map<String, String>> settings = settingsType;
            String attributeKey = iterator.next();
            if (settings.get(attributeKey).get("doNotWrite") != null && settings.get(attributeKey).get("doNotWrite").equalsIgnoreCase("true")) continue;
            String value = settings.get(attributeKey).get("Value");
            if (value == null || value.isEmpty()) {
                value = settings.get(attributeKey).get("DefaultValue");
            }
            if (settings.get(attributeKey).get("dataType").equalsIgnoreCase("BOOL")) {
                if (value.equalsIgnoreCase("true")) {
                    methodProperties.append("\t" + attributeKey);
                }
            } else if (!value.isEmpty()) {
                if (!(settings.get(attributeKey).get("NoKeyword") != null && settings.get(attributeKey).get("NoKeyword").equalsIgnoreCase("true") || attributeKey.equalsIgnoreCase("output") && value.equalsIgnoreCase("normal"))) {
                    methodProperties.append("\t" + attributeKey + " = ");
                } else {
                    methodProperties.append(" ");
                }
                if (!attributeKey.equalsIgnoreCase("output") || !value.equalsIgnoreCase("normal")) {
                    if (settings.get(attributeKey).get("dataType").equalsIgnoreCase("String")) {
                        methodProperties.append("\"" + value + "\"");
                    } else {
                        methodProperties.append(value);
                    }
                }
            }
            if (settings.get(attributeKey).get("NoLinebreak") != null && settings.get(attributeKey).get("NoLinebreak").equalsIgnoreCase("true")) continue;
            methodProperties.append(DakotaConstants.NEWLINE);
        }
        return methodProperties.toString();
    }

    private void createScript() {
        block21: {
            try {
                if (OS.isFamilyWindows()) {
                    File bat = new File(String.valueOf(this.workingDir.getAbsolutePath()) + File.separator + "dakotaBlackBox.bat");
                    Throwable throwable = null;
                    Object var3_8 = null;
                    try (FileWriter fw = new FileWriter(bat);){
                        fw.append("\"" + System.getProperty("java.home") + File.separator + "bin" + File.separator + "javaw.exe\" -jar " + this.workingDir.getAbsolutePath() + File.separator + "de.rcenvironment.components.optimizer.simulator.jar \"%CD%\" \"%1\"");
                        fw.flush();
                        break block21;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                if (!OS.isFamilyUnix()) break block21;
                File sh = new File(this.workingDir + File.separator + "dakotaBlackBox.sh");
                Throwable throwable = null;
                Object var3_10 = null;
                try (FileWriter fw = new FileWriter(sh);){
                    fw.append("#!/bin/bash \n" + System.getProperty("java.home") + File.separator + "bin" + File.separator + "java" + " -jar " + this.workingDir.getAbsolutePath() + File.separator + "de.rcenvironment.components.optimizer.simulator.jar" + " `pwd` $1 \n");
                    fw.append("echo $? \n");
                    fw.flush();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
                sh.setExecutable(true);
            }
            catch (IOException e) {
                LOGGER.error((Object)"Could not create script for starting dakota.", (Throwable)e);
            }
        }
    }

    public void writeHistoryDataItem(OptimizerComponentHistoryDataItem historyItem) {
        if (historyItem != null) {
            if (this.dakotaInputFileReference == null) {
                try {
                    this.dakotaInputFileReference = ((ComponentDataManagementService)this.compContext.getService(ComponentDataManagementService.class)).createFileReferenceTDFromLocalFile(this.compContext, this.dakotaInputFile, "dakotaInput.in");
                }
                catch (IOException e) {
                    String errorMessage = "Failed to store Dakota input file into the data management; it is not available in the workflow data browser";
                    String errorId = LogUtils.logExceptionWithStacktraceAndAssignUniqueMarker((Log)LOGGER, (String)errorMessage, (Throwable)e);
                    this.compContext.getLog().componentError(errorMessage, (Throwable)e, errorId);
                }
            }
            if (this.dakotaInputFileReference != null) {
                historyItem.setInputFileReference(this.dakotaInputFileReference.getFileReference());
            }
        }
    }

    public DesignSet readOutputFileFromExternalProgram() throws IOException {
        DesignSet newDesignSet;
        block25: {
            File paramsFile = null;
            newDesignSet = null;
            if (this.messageFromClient != null && this.messageFromClient.getCurrentWorkingDir() != null) {
                File cwd = new File(this.messageFromClient.getCurrentWorkingDir());
                File[] files = cwd.listFiles();
                if (files != null) {
                    File[] fileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File f = fileArray[n2];
                        if (f != null && f.getAbsolutePath().endsWith("params.in")) {
                            paramsFile = f;
                        }
                        ++n2;
                    }
                }
                Throwable throwable = null;
                Object var6_9 = null;
                try (BufferedReader fr = new BufferedReader(new FileReader(paramsFile));){
                    String firstLineString = fr.readLine();
                    if (firstLineString == null) break block25;
                    String[] firstLine = firstLineString.split("\\s+");
                    int varCount = 0;
                    if (firstLine != null) {
                        try {
                            varCount = Integer.parseInt(firstLine[1]);
                        }
                        catch (NumberFormatException e) {
                            throw new IOException("Failed to parse parameters file", e);
                        }
                    }
                    HashMap<String, Double> newOutput = new HashMap<String, Double>();
                    int i = 0;
                    while (i < varCount) {
                        String x = fr.readLine();
                        if (x != null) {
                            String[] xStrg = x.split(" ");
                            int j = 0;
                            while (xStrg != null && xStrg[j].isEmpty()) {
                                ++j;
                            }
                            if (xStrg != null) {
                                if (!xStrg[j].contains("nan")) {
                                    newOutput.put(xStrg[j + 1], Double.parseDouble(xStrg[j]));
                                } else {
                                    newOutput.put(xStrg[j + 1], Double.NaN);
                                }
                            }
                        }
                        ++i;
                    }
                    fr.readLine();
                    String asvLineString = fr.readLine();
                    if (asvLineString != null) {
                        String[] asvLine = asvLineString.split(" ");
                        int j = 0;
                        while (asvLine != null && asvLine[j].isEmpty()) {
                            ++j;
                        }
                        this.currentActiveSetVectorNumber = asvLine != null ? Integer.parseInt(asvLine[j]) : 0;
                        newDesignSet = new DesignSet((this.currentActiveSetVectorNumber & 2) != 0, this.config);
                        for (Map.Entry designValue : newOutput.entrySet()) {
                            newDesignSet.addDesignValue((String)designValue.getKey(), ((Double)designValue.getValue()).doubleValue());
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        return newDesignSet;
    }

    protected void writeInputFileforExternalProgram(ResultSet result, String outputFileName) throws IOException {
        File fo = new File(String.valueOf(this.messageFromClient.getCurrentWorkingDir()) + File.separatorChar + outputFileName);
        boolean created = fo.createNewFile();
        if (created) {
            Throwable throwable = null;
            Object var6_7 = null;
            try (FileWriter fw2 = new FileWriter(fo);){
                LinkedList<String> keyQueue = new LinkedList<String>();
                for (String key : this.config.getExtendedObjectivesNames()) {
                    if ((this.currentActiveSetVectorNumber & 1) != 0) {
                        fw2.append("       ");
                        if (this.config.getDesignGoalForObjective(key).equals("Maximize")) {
                            fw2.append("-");
                        }
                        if (Double.isNaN(result.getObjectiveVariableValue(key))) {
                            fw2.append(NAN);
                        } else {
                            fw2.append(String.valueOf(result.getObjectiveVariableValue(key)) + " ");
                        }
                        fw2.append(IOUtils.LINE_SEPARATOR);
                    }
                    keyQueue.offer(key);
                }
                for (String element : this.config.getExtendedConstraintNames()) {
                    if ((this.currentActiveSetVectorNumber & 1) != 0) {
                        if (Double.isNaN(result.getConstraintVariableValue(element))) {
                            fw2.append("       NaN");
                        } else {
                            fw2.append("       " + result.getConstraintVariableValue(element) + " ");
                        }
                        fw2.append(IOUtils.LINE_SEPARATOR);
                    }
                    keyQueue.offer(element);
                }
                ArrayList objectivesAndConstraints = new ArrayList();
                objectivesAndConstraints.addAll(this.config.getCompactObjectiveNames());
                objectivesAndConstraints.addAll(this.config.getCompactConstraintNames());
                if ((this.currentActiveSetVectorNumber & 2) != 0) {
                    for (String objOrConstName : objectivesAndConstraints) {
                        if (!this.config.hasGradient(objOrConstName)) continue;
                        fw2.append("[");
                        for (String gradientName : this.config.getGradientNameList(objOrConstName)) {
                            if (Double.isNaN(result.getGradientVariableValue(gradientName))) {
                                fw2.append("       NaN");
                                continue;
                            }
                            fw2.append("       " + result.getGradientVariableValue(gradientName));
                        }
                        fw2.append(" ]" + IOUtils.LINE_SEPARATOR);
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

