/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.optimizer.gui.properties;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.components.optimizer.common.MethodDescription;
import de.rcenvironment.components.optimizer.common.OptimizerFileLoader;
import de.rcenvironment.components.optimizer.gui.properties.Messages;
import de.rcenvironment.components.optimizer.gui.properties.MethodPropertiesDialogGenerator;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.utils.common.components.PropertyTabGuiHelper;
import de.rcenvironment.core.gui.workflow.editor.properties.ValidatingWorkflowNodePropertySection;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodePropertySection;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public abstract class AlgorithmSection
extends ValidatingWorkflowNodePropertySection {
    private static final String COMMA = ",";
    private static final String COULD_NOT_PARSE_METHOD_FILE = "Could not parse method file";
    private Combo comboMainAlgorithmSelection;
    private final ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
    private Map<String, MethodDescription> methodDescriptions;
    private Combo comboSecondAlgorithmSelection;
    private Combo comboThirdAlgorithmSelection;
    private Composite firstAlgo;
    private Composite secondAlgo;
    private Composite thirdAlgo;
    private String[] methods;
    private Label pythonLabel;
    private Button dakotaPathButton;

    public AlgorithmSection() {
        try {
            this.methodDescriptions = OptimizerFileLoader.getAllMethodDescriptions((String)this.getAlgorithmFolder());
        }
        catch (JsonParseException e) {
            this.logger.error((Object)"Could not parse method file ", (Throwable)e);
        }
        catch (JsonMappingException e) {
            this.logger.error((Object)"Could not map method file ", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error((Object)"Could not load method file ", (Throwable)e);
        }
    }

    protected abstract String getAlgorithmFolder();

    public void createCompositeContent(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createCompositeContent(parent, tabbedPropertySheetPage);
        Section sectionAlgorithm = PropertyTabGuiHelper.createSingleColumnSectionComposite((Composite)parent, (TabbedPropertySheetWidgetFactory)this.getWidgetFactory(), (String)Messages.algorithm);
        Composite algorithmConfigurationParent = this.getWidgetFactory().createComposite((Composite)sectionAlgorithm);
        sectionAlgorithm.setClient((Control)algorithmConfigurationParent);
        algorithmConfigurationParent.setLayout((Layout)new GridLayout(1, false));
        this.methods = new String[this.methodDescriptions.keySet().size()];
        this.methodDescriptions.keySet().toArray(this.methods);
        Arrays.sort(this.methods);
        this.firstAlgo = new Composite(algorithmConfigurationParent, 0);
        this.firstAlgo.setLayout((Layout)new GridLayout(2, false));
        new Label(this.firstAlgo, 0).setText("Main algorithm");
        new Label(this.firstAlgo, 0);
        this.comboMainAlgorithmSelection = new Combo(this.firstAlgo, 2056);
        this.comboMainAlgorithmSelection.setItems(this.methods);
        this.comboMainAlgorithmSelection.addListener(13, (Listener)new SelectAlgorithmListener());
        this.comboMainAlgorithmSelection.setData("property.control", (Object)"algorithm");
        Button buttonProperties = new Button(this.firstAlgo, 8);
        buttonProperties.setText(Messages.algorithmProperties);
        MethodSelectionAdapter buttonListener = new MethodSelectionAdapter(parent, this.comboMainAlgorithmSelection);
        buttonProperties.addSelectionListener((SelectionListener)buttonListener);
        this.secondAlgo = new Composite(algorithmConfigurationParent, 0);
        this.secondAlgo.setLayout((Layout)new GridLayout(2, false));
        this.secondAlgo.setLayoutData((Object)new GridData(4, 4, true, false));
        new Label(this.secondAlgo, 0).setText("Second algorithm");
        new Label(this.secondAlgo, 0);
        this.comboSecondAlgorithmSelection = new Combo(this.secondAlgo, 2056);
        this.comboSecondAlgorithmSelection.setItems(this.methods);
        this.comboSecondAlgorithmSelection.addListener(13, (Listener)new SelectAlgorithmListener());
        this.comboSecondAlgorithmSelection.setData("property.control", (Object)"algorithm");
        Button buttonSecondProperties = new Button(this.secondAlgo, 8);
        buttonSecondProperties.setText(Messages.algorithmProperties);
        MethodSelectionAdapter buttonListenerSecond = new MethodSelectionAdapter(parent, this.comboSecondAlgorithmSelection);
        buttonSecondProperties.addSelectionListener((SelectionListener)buttonListenerSecond);
        this.secondAlgo.setVisible(false);
        this.thirdAlgo = new Composite(algorithmConfigurationParent, 0);
        this.thirdAlgo.setLayout((Layout)new GridLayout(2, false));
        new Label(this.thirdAlgo, 0).setText("Third algorithm");
        new Label(this.thirdAlgo, 0);
        this.comboThirdAlgorithmSelection = new Combo(this.thirdAlgo, 2056);
        this.comboThirdAlgorithmSelection.setItems(this.methods);
        this.comboThirdAlgorithmSelection.addListener(13, (Listener)new SelectAlgorithmListener());
        this.comboThirdAlgorithmSelection.setData("property.control", (Object)"algorithm");
        Button buttonThirdProperties = new Button(this.thirdAlgo, 8);
        buttonThirdProperties.setText(Messages.algorithmProperties);
        MethodSelectionAdapter buttonListenerThird = new MethodSelectionAdapter(parent, this.comboThirdAlgorithmSelection);
        buttonThirdProperties.addSelectionListener((SelectionListener)buttonListenerThird);
        this.thirdAlgo.setVisible(false);
        this.pythonLabel = new Label(this.firstAlgo, 0);
        this.pythonLabel.setText(Messages.pythonForMethodInstalled);
        GridData labelData = new GridData();
        labelData.horizontalSpan = 2;
        this.pythonLabel.setLayoutData((Object)labelData);
        this.dakotaPathButton = new Button(this.firstAlgo, 32);
        this.dakotaPathButton.setText("Use custom dakota binary (selected at workflow start)");
        this.dakotaPathButton.setData("property.control", (Object)"CustomDakotaPath");
        GridData pathData = new GridData();
        pathData.horizontalSpan = 2;
        this.dakotaPathButton.setLayoutData((Object)pathData);
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        String configString = this.getConfiguration().getConfigurationDescription().getConfigurationValue("methodConfigurations");
        Map allConfiguredDescriptions = null;
        if (configString == null || configString.isEmpty()) {
            try {
                allConfiguredDescriptions = OptimizerFileLoader.getAllMethodDescriptions((String)this.getAlgorithmFolder());
                if (allConfiguredDescriptions != null) {
                    this.setPropertyNotUndoable("methodConfigurations", this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)allConfiguredDescriptions));
                }
            }
            catch (JsonParseException e) {
                this.logger.error((Object)e);
            }
            catch (JsonMappingException e) {
                this.logger.error((Object)e);
            }
            catch (IOException e) {
                this.logger.error((Object)e);
            }
        }
    }

    public void refreshAlgorithmSection() {
        String algorithm = this.getConfiguration().getConfigurationDescription().getConfigurationValue("algorithm");
        if (this.comboMainAlgorithmSelection.isDisposed()) {
            return;
        }
        if (this.comboMainAlgorithmSelection != null && Arrays.asList(this.comboMainAlgorithmSelection.getItems()).contains("Dakota Latin Hypercube Sampling") && !this.getAlgorithmFolder().equals("/doe")) {
            this.comboMainAlgorithmSelection.remove("Dakota Latin Hypercube Sampling");
        }
        if (algorithm != null) {
            String configString;
            String str;
            int n;
            int n2;
            String[] stringArray;
            boolean ok;
            String[] selectedAlgorithm = this.getConfiguration().getConfigurationDescription().getConfigurationValue("algorithm").split(COMMA);
            if (selectedAlgorithm != null && selectedAlgorithm.length > 0 && selectedAlgorithm[0] != null) {
                ok = false;
                stringArray = this.comboMainAlgorithmSelection.getItems();
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    str = stringArray[n];
                    if (str.equals(selectedAlgorithm[0])) {
                        this.comboMainAlgorithmSelection.select(this.comboMainAlgorithmSelection.indexOf(selectedAlgorithm[0]));
                        ok = true;
                    }
                    ++n;
                }
                if (!ok) {
                    this.comboMainAlgorithmSelection.deselectAll();
                    this.secondAlgo.setVisible(false);
                    this.thirdAlgo.setVisible(false);
                    this.setProperty("algorithm", "");
                }
            }
            this.refreshShownAlgorithms();
            if (this.secondAlgo.isVisible() && selectedAlgorithm != null && selectedAlgorithm.length > 1 && selectedAlgorithm[1] != null) {
                ok = false;
                stringArray = this.comboSecondAlgorithmSelection.getItems();
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    str = stringArray[n];
                    if (str.equals(selectedAlgorithm[1])) {
                        this.comboSecondAlgorithmSelection.select(this.comboSecondAlgorithmSelection.indexOf(selectedAlgorithm[1]));
                        ok = true;
                    }
                    ++n;
                }
                if (!ok) {
                    this.comboSecondAlgorithmSelection.select(0);
                }
            }
            if (this.thirdAlgo.isVisible() && selectedAlgorithm != null && selectedAlgorithm.length > 2 && selectedAlgorithm[2] != null) {
                ok = false;
                stringArray = this.comboThirdAlgorithmSelection.getItems();
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    str = stringArray[n];
                    if (str.equals(selectedAlgorithm[2])) {
                        this.comboThirdAlgorithmSelection.select(this.comboThirdAlgorithmSelection.indexOf(selectedAlgorithm[2]));
                        ok = true;
                    }
                    ++n;
                }
                if (!ok) {
                    this.comboThirdAlgorithmSelection.select(0);
                }
            }
            if ((configString = this.getConfiguration().getConfigurationDescription().getConfigurationValue("methodConfigurations")) == null || configString.equals("")) {
                try {
                    this.setProperty("methodConfigurations", this.mapper.writer().writeValueAsString(this.methodDescriptions));
                }
                catch (JsonParseException e) {
                    this.logger.error((Object)COULD_NOT_PARSE_METHOD_FILE, (Throwable)e);
                }
                catch (JsonMappingException e) {
                    this.logger.error((Object)COULD_NOT_PARSE_METHOD_FILE, (Throwable)e);
                }
                catch (IOException e) {
                    this.logger.error((Object)COULD_NOT_PARSE_METHOD_FILE, (Throwable)e);
                }
            }
        } else {
            this.secondAlgo.setVisible(false);
            this.thirdAlgo.setVisible(false);
            this.comboMainAlgorithmSelection.setText("");
        }
    }

    private void refreshShownAlgorithms() {
        try {
            String configString = this.getConfiguration().getConfigurationDescription().getConfigurationValue("methodConfigurations");
            this.comboMainAlgorithmSelection.setText("");
            Map allConfiguredDescriptions = (Map)this.mapper.readValue(configString, new HashMap().getClass());
            MethodDescription mainAlgorithm = (MethodDescription)this.mapper.convertValue(allConfiguredDescriptions.get(this.comboMainAlgorithmSelection.getText()), MethodDescription.class);
            if (mainAlgorithm != null && mainAlgorithm.getOptimizerPackage() != null) {
                this.pythonLabel.setVisible(true);
                if (mainAlgorithm.getOptimizerPackage().equalsIgnoreCase("dakota")) {
                    this.pythonLabel.setText(Messages.dakotaOSHint);
                    this.dakotaPathButton.setVisible(true);
                } else {
                    this.dakotaPathButton.setVisible(false);
                    this.pythonLabel.setText(Messages.pythonForMethodInstalled);
                }
                this.pythonLabel.getParent().pack();
                if (mainAlgorithm.getOptimizerPackage().equals("dakota") && mainAlgorithm.getMethodName().contains("Dakota Surrogate-Based Local")) {
                    this.comboSecondAlgorithmSelection.removeAll();
                    this.comboThirdAlgorithmSelection.removeAll();
                    this.comboSecondAlgorithmSelection.add("Dakota Latin Hypercube Sampling");
                    this.comboThirdAlgorithmSelection.setItems(((String)((Map)mainAlgorithm.getSpecificSettings().get("approx_method_list")).get("DefaultValue")).split(COMMA));
                    this.secondAlgo.setVisible(true);
                    this.thirdAlgo.setVisible(true);
                    this.comboSecondAlgorithmSelection.select(this.comboSecondAlgorithmSelection.indexOf("Dakota Latin Hypercube Sampling"));
                    this.comboThirdAlgorithmSelection.select(0);
                } else if (mainAlgorithm.getFollowingMethods() != null && mainAlgorithm.getFollowingMethods().equals("1")) {
                    this.comboSecondAlgorithmSelection.removeAll();
                    this.filterMethodsList(mainAlgorithm, this.comboSecondAlgorithmSelection);
                    this.secondAlgo.setVisible(true);
                    this.thirdAlgo.setVisible(false);
                    this.comboSecondAlgorithmSelection.select(0);
                } else if (mainAlgorithm.getFollowingMethods() != null && mainAlgorithm.getFollowingMethods().equals("2")) {
                    this.comboSecondAlgorithmSelection.removeAll();
                    this.comboThirdAlgorithmSelection.removeAll();
                    this.filterMethodsList(mainAlgorithm, this.comboSecondAlgorithmSelection);
                    this.filterMethodsList(mainAlgorithm, this.comboThirdAlgorithmSelection);
                    this.secondAlgo.setVisible(true);
                    this.thirdAlgo.setVisible(true);
                    this.comboSecondAlgorithmSelection.select(0);
                    this.comboThirdAlgorithmSelection.select(0);
                } else {
                    this.secondAlgo.setVisible(false);
                    this.thirdAlgo.setVisible(false);
                }
            } else {
                this.comboMainAlgorithmSelection.setText("");
                this.pythonLabel.setVisible(false);
            }
        }
        catch (JsonParseException e1) {
            this.logger.error((Object)COULD_NOT_PARSE_METHOD_FILE, (Throwable)e1);
        }
        catch (JsonMappingException e1) {
            this.logger.error((Object)COULD_NOT_PARSE_METHOD_FILE, (Throwable)e1);
        }
        catch (IOException e1) {
            this.logger.error((Object)COULD_NOT_PARSE_METHOD_FILE, (Throwable)e1);
        }
    }

    private void filterMethodsList(MethodDescription mainAlgorithm, Combo combo) {
        LinkedList<String> result = new LinkedList<String>();
        result.add("");
        for (String currentAlgorithm : this.methodDescriptions.keySet()) {
            if (!this.methodDescriptions.get(currentAlgorithm).getOptimizerPackage().equalsIgnoreCase(mainAlgorithm.getOptimizerPackage()) || currentAlgorithm.equalsIgnoreCase(mainAlgorithm.getMethodName())) continue;
            result.add(currentAlgorithm);
        }
        Object[] methodList = new String[result.size()];
        result.toArray(methodList);
        Arrays.sort(methodList);
        combo.setItems((String[])methodList);
    }

    protected void setWorkflowNode(WorkflowNode workflowNode) {
        super.setWorkflowNode(workflowNode);
    }

    protected AlgorithmSectionUpdater createUpdater() {
        return new AlgorithmSectionUpdater();
    }

    protected class AlgorithmSectionUpdater
    extends WorkflowNodePropertySection.DefaultUpdater {
        protected AlgorithmSectionUpdater() {
            super((WorkflowNodePropertySection)AlgorithmSection.this);
        }

        public void updateControl(Control control, String propertyName, String newValue, String oldValue) {
            super.updateControl(control, propertyName, newValue, oldValue);
            if (propertyName.equals("algorithm") && control instanceof Combo && !newValue.equals(oldValue)) {
                AlgorithmSection.this.refreshAlgorithmSection();
            }
        }
    }

    private class MethodSelectionAdapter
    extends SelectionAdapter {
        private final Composite parent;
        private final Combo attachedCombo;

        MethodSelectionAdapter(Composite parent, Combo attachedCombo) {
            this.parent = parent;
            this.attachedCombo = attachedCombo;
        }

        public void widgetSelected(SelectionEvent e) {
            String configString = AlgorithmSection.this.getConfiguration().getConfigurationDescription().getConfigurationValue("methodConfigurations");
            try {
                Map allConfiguredDescriptions = null;
                allConfiguredDescriptions = configString == null || configString.isEmpty() ? OptimizerFileLoader.getAllMethodDescriptions((String)AlgorithmSection.this.getAlgorithmFolder()) : (Map)AlgorithmSection.this.mapper.readValue(configString, new HashMap().getClass());
                if (allConfiguredDescriptions != null) {
                    allConfiguredDescriptions.put(this.attachedCombo.getText(), (MethodDescription)AlgorithmSection.this.mapper.convertValue(allConfiguredDescriptions.get(this.attachedCombo.getText()), MethodDescription.class));
                    if (this.attachedCombo.getText().equals("")) {
                        MessageBox dialog = new MessageBox(this.parent.getShell(), 40);
                        dialog.setText("No Algorithm");
                        dialog.setMessage("No algorithm selected!");
                        dialog.open();
                    } else {
                        MethodPropertiesDialogGenerator dialog = new MethodPropertiesDialogGenerator(this.parent.getShell(), (MethodDescription)allConfiguredDescriptions.get(this.attachedCombo.getText()));
                        if (dialog.open() == 0) {
                            AlgorithmSection.this.setProperty("methodConfigurations", AlgorithmSection.this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)allConfiguredDescriptions));
                        }
                    }
                }
            }
            catch (JsonParseException e1) {
                AlgorithmSection.this.logger.error((Object)AlgorithmSection.COULD_NOT_PARSE_METHOD_FILE, (Throwable)e1);
            }
            catch (JsonMappingException e1) {
                AlgorithmSection.this.logger.error((Object)"Could not map method file", (Throwable)e1);
            }
            catch (IOException e1) {
                AlgorithmSection.this.logger.error((Object)"Could not load method file", (Throwable)e1);
            }
        }
    }

    private class SelectAlgorithmListener
    implements Listener {
        private SelectAlgorithmListener() {
        }

        public void handleEvent(Event event) {
            String key = AlgorithmSection.this.comboMainAlgorithmSelection.getItem(AlgorithmSection.this.comboMainAlgorithmSelection.getSelectionIndex());
            if (event.widget.equals(AlgorithmSection.this.comboMainAlgorithmSelection)) {
                AlgorithmSection.this.refreshShownAlgorithms();
                String configString = AlgorithmSection.this.getConfiguration().getConfigurationDescription().getConfigurationValue("methodConfigurations");
                try {
                    MethodDescription desc;
                    Map allConfiguredDescriptions = null;
                    allConfiguredDescriptions = configString == null || configString.isEmpty() ? OptimizerFileLoader.getAllMethodDescriptions((String)AlgorithmSection.this.getAlgorithmFolder()) : (Map)AlgorithmSection.this.mapper.readValue(configString, new HashMap().getClass());
                    if (!allConfiguredDescriptions.containsKey(key) && (desc = OptimizerFileLoader.loadMethod((String)key)) != null) {
                        allConfiguredDescriptions.put(key, desc);
                        AlgorithmSection.this.setProperty("methodConfigurations", AlgorithmSection.this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)allConfiguredDescriptions));
                    }
                }
                catch (JsonParseException e1) {
                    AlgorithmSection.this.logger.error((Object)AlgorithmSection.COULD_NOT_PARSE_METHOD_FILE, (Throwable)e1);
                }
                catch (JsonMappingException e1) {
                    AlgorithmSection.this.logger.error((Object)"Could not map method file", (Throwable)e1);
                }
                catch (IOException e1) {
                    AlgorithmSection.this.logger.error((Object)"Could not load method file", (Throwable)e1);
                }
            }
            if (AlgorithmSection.this.secondAlgo.isVisible() && AlgorithmSection.this.comboSecondAlgorithmSelection.getSelectionIndex() >= 0 && !AlgorithmSection.this.comboSecondAlgorithmSelection.getItem(AlgorithmSection.this.comboSecondAlgorithmSelection.getSelectionIndex()).equals("")) {
                key = String.valueOf(key) + AlgorithmSection.COMMA + AlgorithmSection.this.comboSecondAlgorithmSelection.getItem(AlgorithmSection.this.comboSecondAlgorithmSelection.getSelectionIndex());
            }
            if (AlgorithmSection.this.thirdAlgo.isVisible() && AlgorithmSection.this.comboThirdAlgorithmSelection.getSelectionIndex() >= 0) {
                key = String.valueOf(key) + AlgorithmSection.COMMA + AlgorithmSection.this.comboThirdAlgorithmSelection.getItem(AlgorithmSection.this.comboThirdAlgorithmSelection.getSelectionIndex());
            }
            AlgorithmSection.this.setProperties("algorithm", key, new String[]{"optimizerPackageCode", ((MethodDescription)AlgorithmSection.this.methodDescriptions.get(AlgorithmSection.this.comboMainAlgorithmSelection.getText())).getOptimizerPackage()});
        }
    }
}

