/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner.definitions.common;

import cucumber.api.Scenario;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.executor.testutils.IntegrationTestExecutorUtils;
import de.rcenvironment.extras.testscriptrunner.definitions.common.ManagedInstance;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;

public final class TestScenarioExecutionContext {
    private static final ThreadLocal<TextOutputReceiver> THREAD_LOCAL_PARAMETER_OUTPUT_RECEIVER = new ThreadLocal();
    private static final ThreadLocal<String> THREAD_LOCAL_PARAMETER_BUILD_ID = new ThreadLocal();
    private static final ThreadLocal<File> THREAD_LOCAL_PARAMETER_SCRIPT_LOCATION = new ThreadLocal();
    private final TextOutputReceiver outputReceiver;
    private final String buildUnderTestId;
    private final Map<String, ManagedInstance> instancesById = new HashMap<String, ManagedInstance>();
    private IntegrationTestExecutorUtils.ExecutionResult currentExecutionResult;
    private Scenario scenario;
    private final Log log = LogFactory.getLog(this.getClass());
    private File testScriptLocation;

    public TestScenarioExecutionContext() {
        this.outputReceiver = Objects.requireNonNull(THREAD_LOCAL_PARAMETER_OUTPUT_RECEIVER.get());
        this.buildUnderTestId = Objects.requireNonNull(THREAD_LOCAL_PARAMETER_BUILD_ID.get());
        this.testScriptLocation = Objects.requireNonNull(THREAD_LOCAL_PARAMETER_SCRIPT_LOCATION.get());
    }

    public static void setThreadLocalParameters(TextOutputReceiver outputReceiverParam, String buildUnderTestIdParam, File testScriptDirectoryParam) {
        if (THREAD_LOCAL_PARAMETER_OUTPUT_RECEIVER.get() != null) {
            throw new IllegalStateException();
        }
        THREAD_LOCAL_PARAMETER_OUTPUT_RECEIVER.set(outputReceiverParam);
        THREAD_LOCAL_PARAMETER_BUILD_ID.set(buildUnderTestIdParam);
        THREAD_LOCAL_PARAMETER_SCRIPT_LOCATION.set(testScriptDirectoryParam);
    }

    public static void discardThreadLocalParameters() {
        if (THREAD_LOCAL_PARAMETER_OUTPUT_RECEIVER.get() == null) {
            throw new IllegalStateException();
        }
        THREAD_LOCAL_PARAMETER_OUTPUT_RECEIVER.set(null);
        THREAD_LOCAL_PARAMETER_BUILD_ID.set(null);
    }

    public void beforeEach(Scenario newScenario) {
        this.scenario = newScenario;
        this.outputReceiver.addOutput("> Starting test scenario \"" + newScenario.getName() + "\"");
    }

    public void afterEach(Scenario finishedScenario) {
        Assert.assertEquals((Object)finishedScenario, (Object)this.scenario);
        if (this.scenario.isFailed()) {
            this.outputReceiver.addOutput("*** Error in test scenario \"" + this.scenario.getName() + "\"; dumping any captured StdOut/StdErr output");
            this.scenario.write("*** Error in test scenario \"" + this.scenario.getName() + "\"; dumping any captured StdOut/StdErr output");
            if (this.currentExecutionResult != null) {
                String logLine;
                for (String line : this.currentExecutionResult.stdoutLines) {
                    logLine = "[StdOut] " + line;
                    this.scenario.write(logLine);
                    this.log.error((Object)logLine);
                }
                for (String line : this.currentExecutionResult.stderrLines) {
                    logLine = "[StdErr] " + line;
                    this.scenario.write(logLine);
                    this.log.error((Object)logLine);
                }
            }
        } else {
            this.outputReceiver.addOutput("< Completed test scenario \"" + this.scenario.getName() + "\"");
        }
    }

    public TextOutputReceiver getOutputReceiver() {
        return this.outputReceiver;
    }

    public String getBuildUnderTestId() {
        return this.buildUnderTestId;
    }

    public String getScenarioName() {
        return this.scenario.getName();
    }

    public File getTestScriptLocation() {
        return this.testScriptLocation;
    }

    public Map<String, ManagedInstance> getSharedInstancesByIdMap() {
        return this.instancesById;
    }
}

