/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.xml.loader.execution;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.rcenvironment.components.xml.loader.common.XmlLoaderComponentConstants;
import de.rcenvironment.core.component.update.api.PersistentComponentDescription;
import de.rcenvironment.core.component.update.api.PersistentComponentDescriptionUpdaterUtils;
import de.rcenvironment.core.component.update.spi.PersistentComponentDescriptionUpdater;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.IOException;

public class XmlLoaderPersistentComponentDescriptionUpdater
implements PersistentComponentDescriptionUpdater {
    private static final String CPACS = "CPACS";
    private static final String V3_0 = "3.0";
    private static final String V3_1 = "3.1";
    private static final String V3_2 = "3.2";
    private final String currentVersion = "3.2";
    private JsonFactory jsonFactory = new JsonFactory();

    public String[] getComponentIdentifiersAffectedByUpdate() {
        return XmlLoaderComponentConstants.COMPONENT_IDS;
    }

    public int getFormatVersionsAffectedByUpdate(String persistentComponentDescriptionVersion, boolean silent) {
        int versionsToUpdate = 0;
        if (!silent && persistentComponentDescriptionVersion != null) {
            if (persistentComponentDescriptionVersion.compareTo(V3_0) < 0) {
                versionsToUpdate |= 2;
            }
            if (persistentComponentDescriptionVersion.compareTo(V3_2) < 0) {
                versionsToUpdate |= 4;
            }
        }
        return versionsToUpdate;
    }

    public PersistentComponentDescription performComponentDescriptionUpdate(int formatVersion, PersistentComponentDescription description, boolean silent) throws IOException {
        if (!silent) {
            if (formatVersion == 2) {
                description = this.updateToV30(description);
            } else if (formatVersion == 4) {
                if (description.getComponentVersion().compareTo(V3_1) < 0) {
                    description = this.updateFrom3To31(description);
                }
                if (description.getComponentVersion().compareTo(V3_2) < 0) {
                    description = this.updateFrom31To32(description);
                }
            }
        }
        return description;
    }

    private PersistentComponentDescription updateToV30(PersistentComponentDescription description) throws JsonParseException, IOException {
        description = PersistentComponentDescriptionUpdaterUtils.updateAllDynamicEndpointsToIdentifier((String)"dynamicOutputs", (String)"default", (PersistentComponentDescription)description);
        description = PersistentComponentDescriptionUpdaterUtils.updateAllDynamicEndpointsToIdentifier((String)"dynamicInputs", (String)"default", (PersistentComponentDescription)description);
        description = PersistentComponentDescriptionUpdaterUtils.addStaticOutput((PersistentComponentDescription)description, (String)CPACS);
        description = PersistentComponentDescriptionUpdaterUtils.updateDynamicInputsOptional((PersistentComponentDescription)description);
        description.setComponentVersion(V3_2);
        return description;
    }

    private PersistentComponentDescription updateFrom3To31(PersistentComponentDescription description) throws JsonParseException, IOException {
        JsonParser jsonParser = this.jsonFactory.createParser(description.getComponentDescriptionAsString());
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        JsonNode rootNode = (JsonNode)mapper.readTree(jsonParser);
        TextNode nameNode = (TextNode)rootNode.get("name");
        String nodeName = nameNode.textValue();
        if (nodeName.contains("CPACS Loading")) {
            nodeName = nodeName.replaceAll("CPACS Loading", "XML Loader");
            ((ObjectNode)rootNode).set("name", (JsonNode)TextNode.valueOf((String)nodeName));
        }
        JsonNode staticOutputs = rootNode.get("staticOutputs");
        for (JsonNode staticOutput : staticOutputs) {
            ((ObjectNode)staticOutput).set("name", (JsonNode)TextNode.valueOf((String)staticOutput.get("name").textValue().replace(CPACS, "XML")));
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        description = new PersistentComponentDescription(writer.writeValueAsString((Object)rootNode));
        description.setComponentVersion(V3_1);
        return description;
    }

    private PersistentComponentDescription updateFrom31To32(PersistentComponentDescription description) throws JsonParseException, IOException {
        description = PersistentComponentDescriptionUpdaterUtils.updateSchedulingInformation((PersistentComponentDescription)description);
        description.setComponentVersion(V3_2);
        return description;
    }
}

