/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.switchcmp.gui;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.components.switchcmp.common.SwitchComponentConstants;
import de.rcenvironment.components.switchcmp.common.SwitchCondition;
import de.rcenvironment.components.switchcmp.execution.validator.SwitchComponentValidationMessage;
import de.rcenvironment.components.switchcmp.gui.Messages;
import de.rcenvironment.core.component.model.endpoint.api.EndpointChange;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.component.validation.api.ComponentValidationMessage;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNodeUtil;
import de.rcenvironment.core.component.workflow.model.spi.ComponentInstanceProperties;
import de.rcenvironment.core.gui.workflow.editor.properties.ValidatingWorkflowNodePropertySection;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodePropertySection;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class SwitchConditionSection
extends ValidatingWorkflowNodePropertySection {
    protected static final Log LOGGER = LogFactory.getLog(SwitchConditionSection.class);
    private static final int EDITABLE_COLUMN = 1;
    private static final String[] CONDITION_TABLE_TITLES = new String[]{"Number #", "Condition Script"};
    private static final String EXCEPTION_MESSAGE_WRITING = "Unexpected Exception occured, while writing JSON content String.";
    private Button insertChannelButton;
    private Button insertOpButton;
    private Button insertConditionButton;
    private Button firstConditionCheckbox;
    private Combo channelCombo;
    private Combo opCombo;
    private Combo conditionCombo;
    private Button addButton;
    private Button removeButton;
    private Button conditionUpButton;
    private Button conditionDownButton;
    private Table conditionTable;
    private TableViewer viewer;
    private ArrayList<SwitchCondition> contentList;
    private int latestCaret;
    private PropertyChangeListener registeredListener;
    private TextEditingSupport textEditingSupport;

    public void createCompositeContent(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        parent.setLayout((Layout)new GridLayout(1, false));
        parent.setLayoutData((Object)new GridData(1808));
        Section parentSection = aTabbedPropertySheetPage.getWidgetFactory().createSection(parent, 256);
        parentSection.setLayout((Layout)new GridLayout());
        parentSection.setLayoutData((Object)new GridData(772));
        parentSection.setText(Messages.conditionFieldString);
        super.createCompositeContent(parent, aTabbedPropertySheetPage);
        Composite mainComposite = aTabbedPropertySheetPage.getWidgetFactory().createComposite(parent);
        mainComposite.setLayout((Layout)new GridLayout(1, false));
        mainComposite.setLayoutData((Object)new GridData(1808));
        Composite parameterSectionComposite = aTabbedPropertySheetPage.getWidgetFactory().createComposite(mainComposite);
        parameterSectionComposite.setLayout((Layout)new GridLayout());
        Composite parameterComposite = aTabbedPropertySheetPage.getWidgetFactory().createComposite(parameterSectionComposite);
        parameterComposite.setLayout((Layout)new GridLayout(2, false));
        parameterComposite.setLayoutData((Object)new GridData(1044));
        this.firstConditionCheckbox = new Button(parameterComposite, 32);
        this.firstConditionCheckbox.setData("property.control", (Object)"writeOutputKey");
        this.firstConditionCheckbox.setSelection(false);
        Label firstConditionLabel = new Label(parameterComposite, 0);
        firstConditionLabel.setText(Messages.writeOutputLabel);
        firstConditionLabel.setBackground(parameterComposite.getDisplay().getSystemColor(1));
        Composite conditionSectionComposite = aTabbedPropertySheetPage.getWidgetFactory().createComposite(mainComposite);
        conditionSectionComposite.setLayout((Layout)new GridLayout(3, false));
        conditionSectionComposite.setLayoutData((Object)new GridData(1808));
        Composite handlingComposite = aTabbedPropertySheetPage.getWidgetFactory().createComposite(conditionSectionComposite);
        handlingComposite.setLayout((Layout)new GridLayout(1, false));
        handlingComposite.setLayoutData((Object)new GridData(1044));
        GridData gridDataButtons = new GridData();
        gridDataButtons.widthHint = 26;
        gridDataButtons.heightHint = 26;
        this.addButton = aTabbedPropertySheetPage.getWidgetFactory().createButton(handlingComposite, "+", 8);
        this.addButton.setLayoutData((Object)new GridData(772));
        this.addButton.setLayoutData((Object)gridDataButtons);
        this.removeButton = aTabbedPropertySheetPage.getWidgetFactory().createButton(handlingComposite, "-", 8);
        this.removeButton.setLayoutData((Object)new GridData(772));
        this.removeButton.setLayoutData((Object)gridDataButtons);
        this.conditionUpButton = aTabbedPropertySheetPage.getWidgetFactory().createButton(handlingComposite, "\u2191", 8);
        this.conditionUpButton.setLayoutData((Object)new GridData(772));
        this.conditionUpButton.setLayoutData((Object)gridDataButtons);
        this.conditionDownButton = aTabbedPropertySheetPage.getWidgetFactory().createButton(handlingComposite, "\u2193", 8);
        this.conditionDownButton.setLayoutData((Object)new GridData(772));
        this.conditionDownButton.setLayoutData((Object)gridDataButtons);
        this.addButton.addSelectionListener(this.modifyTableSelectionListener(TableRowBehavior.ADD_ROW));
        this.removeButton.addSelectionListener(this.modifyTableSelectionListener(TableRowBehavior.REMOVE_ROW));
        this.conditionUpButton.addSelectionListener(this.modifyTableSelectionListener(TableRowBehavior.MOVE_UP));
        this.conditionDownButton.addSelectionListener(this.modifyTableSelectionListener(TableRowBehavior.MOVE_DOWN));
        Composite conditionTableComposite = aTabbedPropertySheetPage.getWidgetFactory().createComposite(conditionSectionComposite);
        conditionTableComposite.setLayout((Layout)new GridLayout(1, false));
        conditionTableComposite.setLayoutData((Object)new GridData(1808));
        TableColumnLayout layout = new TableColumnLayout();
        conditionTableComposite.setLayout((Layout)layout);
        this.viewer = new TableViewer(conditionTableComposite, 68098);
        this.viewer.setContentProvider((IContentProvider)new SwitchConditionContentProvider());
        this.conditionTable = this.viewer.getTable();
        this.conditionTable.setHeaderVisible(true);
        this.conditionTable.setLinesVisible(true);
        this.conditionTable.setData("property.control", (Object)"conditionKey");
        this.textEditingSupport = new TextEditingSupport(this.viewer, this.conditionTable, 1);
        this.createColumns(this.textEditingSupport);
        layout.setColumnData((Widget)this.viewer.getTable().getColumn(0), (ColumnLayoutData)new ColumnWeightData(5));
        layout.setColumnData((Widget)this.viewer.getTable().getColumn(1), (ColumnLayoutData)new ColumnWeightData(60));
        this.viewer.setInput(this.contentList);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        this.viewer.getControl().setLayoutData((Object)gridData);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        Composite propertiesComposite = aTabbedPropertySheetPage.getWidgetFactory().createComposite(conditionSectionComposite);
        propertiesComposite.setLayout((Layout)new GridLayout(3, false));
        propertiesComposite.setLayoutData((Object)new GridData(525328));
        Label opLabel = new Label(propertiesComposite, 0);
        opLabel.setText(Messages.operatorsLabelString);
        opLabel.setBackground(propertiesComposite.getDisplay().getSystemColor(1));
        this.opCombo = new Combo(propertiesComposite, 524296);
        this.opCombo.setLayout((Layout)new GridLayout());
        this.opCombo.setLayoutData((Object)new GridData(772));
        this.setComboOperators();
        this.opCombo.pack();
        this.insertOpButton = aTabbedPropertySheetPage.getWidgetFactory().createButton(propertiesComposite, Messages.insertButtonString, 524296);
        this.insertOpButton.addListener(13, this.getButtonListener());
        Label channelLabel = new Label(propertiesComposite, 0);
        channelLabel.setText(Messages.channelLabelString);
        channelLabel.setBackground(propertiesComposite.getDisplay().getSystemColor(1));
        this.channelCombo = new Combo(propertiesComposite, 524296);
        this.channelCombo.setLayout((Layout)new GridLayout());
        this.channelCombo.setLayoutData((Object)new GridData(772));
        this.channelCombo.pack();
        this.insertChannelButton = aTabbedPropertySheetPage.getWidgetFactory().createButton(propertiesComposite, Messages.insertButtonString, 524296);
        this.insertChannelButton.addListener(13, this.getButtonListener());
        Label conditionLabel = new Label(propertiesComposite, 0);
        conditionLabel.setText(Messages.conditionInputString);
        conditionLabel.setBackground(propertiesComposite.getDisplay().getSystemColor(1));
        this.conditionCombo = new Combo(propertiesComposite, 524296);
        this.conditionCombo.setLayout((Layout)new GridLayout());
        this.conditionCombo.setLayoutData((Object)new GridData(772));
        this.conditionCombo.pack();
        this.insertConditionButton = aTabbedPropertySheetPage.getWidgetFactory().createButton(propertiesComposite, Messages.insertButtonString, 524296);
        this.insertConditionButton.addListener(13, this.getButtonListener());
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (this.registeredListener == null) {
            ComponentInstanceProperties config = this.getConfiguration();
            this.registeredListener = evt -> {
                if (evt.getNewValue() instanceof EndpointChange) {
                    EndpointChange ec = (EndpointChange)evt.getNewValue();
                    this.updateCombos(ec);
                }
            };
            config.addPropertyChangeListener(this.registeredListener);
        }
    }

    private void updateCombos(EndpointChange ec) {
        if (ec.getType().equals((Object)EndpointChange.Type.Removed)) {
            if (ec.getOldEndpointDescription().getDynamicEndpointIdentifier().equals("dataToInput") && !this.channelCombo.isDisposed()) {
                this.setInputChannels();
            }
            if (ec.getOldEndpointDescription().getDynamicEndpointIdentifier().equals("conditionToInput") && !this.conditionCombo.isDisposed()) {
                this.setConditionInput();
            }
        } else {
            if (ec.getEndpointDescription().getDynamicEndpointIdentifier().equals("dataToInput") && !this.channelCombo.isDisposed()) {
                this.setInputChannels();
            }
            if (ec.getEndpointDescription().getDynamicEndpointIdentifier().equals("conditionToInput") && !this.conditionCombo.isDisposed()) {
                this.setConditionInput();
            }
        }
    }

    private void createColumns(TextEditingSupport textEditSup) {
        TableViewerColumn col0 = this.createTableViewerColumn(CONDITION_TABLE_TITLES[0]);
        TableViewerColumn col1 = this.createTableViewerColumn(CONDITION_TABLE_TITLES[1]);
        col0.setLabelProvider((CellLabelProvider)this.getColumnLabelProvider(0));
        col1.setLabelProvider((CellLabelProvider)this.getColumnLabelProvider(1));
        col1.setEditingSupport((EditingSupport)textEditSup);
    }

    public ColumnLabelProvider getColumnLabelProvider(final int columnNumber) {
        return new ColumnLabelProvider(){

            public String getText(Object element) {
                if (((String[])element)[columnNumber] != null) {
                    return ((String[])element)[columnNumber];
                }
                return "";
            }

            public String getToolTipText(Object element) {
                ArrayList input = (ArrayList)SwitchConditionSection.this.viewer.getInput();
                String validationMessage = ((SwitchCondition)input.get(Integer.parseInt(((String[])element)[0]) - 1)).getValidationMessages();
                if (validationMessage != null) {
                    return validationMessage;
                }
                return null;
            }
        };
    }

    private TableViewerColumn createTableViewerColumn(String title) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 16384);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setResizable(false);
        return viewerColumn;
    }

    private SelectionListener modifyTableSelectionListener(final TableRowBehavior trb) {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                SwitchConditionSection.this.updateTable(trb);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        };
    }

    public void updateTable(TableRowBehavior trb) {
        String configStr = this.getProperty("conditionKey");
        this.contentList = (ArrayList)SwitchCondition.getSwitchConditionList((String)configStr);
        int index = this.getIndexOfSelectedRow();
        int newIndex = 0;
        int size = this.contentList.size();
        switch (trb) {
            case ADD_ROW: {
                this.contentList.add(new SwitchCondition(size + 1, ""));
                SwitchConditionSection.updateOutputDescriptions(this.getConfiguration(), trb, size);
                newIndex = size + 1;
                break;
            }
            case REMOVE_ROW: {
                if (index == 0) break;
                this.contentList.remove(index - 1);
                int i = index - 1;
                while (i < size - 1) {
                    this.contentList.get(i).setConditionNumber(i + 1);
                    ++i;
                }
                SwitchConditionSection.updateOutputDescriptions(this.getConfiguration(), trb, size);
                newIndex = index - 1;
                if (newIndex != 0) break;
                newIndex = 1;
                break;
            }
            case MOVE_UP: {
                if (index == 0 || index == 1) break;
                Collections.swap(this.contentList, index - 1, index - 2);
                this.contentList.get(index - 1).setConditionNumber(index);
                this.contentList.get(index - 2).setConditionNumber(index - 1);
                newIndex = index - 1;
                break;
            }
            case MOVE_DOWN: {
                if (index == 0 || index == this.contentList.size()) break;
                Collections.swap(this.contentList, index, index - 1);
                this.contentList.get(index - 1).setConditionNumber(index);
                this.contentList.get(index).setConditionNumber(index + 1);
                newIndex = index + 1;
                break;
            }
        }
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        try {
            if (!configStr.equals(mapper.writeValueAsString(this.contentList))) {
                this.setProperty("conditionKey", mapper.writeValueAsString(this.contentList));
            }
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(EXCEPTION_MESSAGE_WRITING, e);
        }
        this.viewer.setInput(this.contentList);
        if (newIndex != 0) {
            this.viewer.getTable().setSelection(newIndex - 1);
        }
        this.updateTooltipBackgroundColor();
    }

    public static int getTableContentLength(String configStr) {
        ArrayList arrayList = (ArrayList)SwitchCondition.getSwitchConditionList((String)configStr);
        return arrayList.size();
    }

    private int getIndexOfSelectedRow() {
        if (!this.viewer.getSelection().isEmpty()) {
            Object arr = this.viewer.getStructuredSelection().toArray()[0];
            String[] str = (String[])arr;
            return Integer.parseInt(str[0]);
        }
        return 0;
    }

    public static void updateOutputDescriptions(ComponentInstanceProperties config, TableRowBehavior trb, Integer numOfCon) {
        EndpointDescriptionsManager outputDescManager = config.getOutputDescriptionsManager();
        Set dynEndDescs = config.getInputDescriptionsManager().getDynamicEndpointDescriptions();
        for (EndpointDescription endpointDesc : dynEndDescs) {
            if (!endpointDesc.getDynamicEndpointIdentifier().equals("dataToInput")) continue;
            switch (trb) {
                case ADD_ROW: {
                    HashMap metaData = new HashMap();
                    if (numOfCon == 0) {
                        outputDescManager.addDynamicEndpointDescription("dataToOutput", String.valueOf(endpointDesc.getName()) + "_no match", endpointDesc.getDataType(), metaData);
                        outputDescManager.addDynamicEndpointDescription("dataToOutput", String.valueOf(endpointDesc.getName()) + "_condition" + " " + 1, endpointDesc.getDataType(), metaData);
                        break;
                    }
                    outputDescManager.addDynamicEndpointDescription("dataToOutput", String.valueOf(endpointDesc.getName()) + "_condition" + " " + Integer.toString(numOfCon + 1), endpointDesc.getDataType(), metaData);
                    break;
                }
                case REMOVE_ROW: {
                    if (numOfCon != 1) {
                        outputDescManager.removeDynamicEndpointDescription(String.valueOf(endpointDesc.getName()) + "_condition" + " " + Integer.toString(numOfCon));
                        break;
                    }
                    outputDescManager.removeDynamicEndpointDescription(String.valueOf(endpointDesc.getName()) + "_condition" + " " + 1);
                    outputDescManager.removeDynamicEndpointDescription(String.valueOf(endpointDesc.getName()) + "_no match");
                    break;
                }
            }
        }
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.setInputChannels();
        this.setConditionInput();
        this.updateTooltipBackgroundColor();
    }

    protected void beforeTearingDownModelBinding() {
        ComponentInstanceProperties config = this.getConfiguration();
        config.removePropertyChangeListener(this.registeredListener);
        this.registeredListener = null;
        this.latestCaret = 0;
        super.beforeTearingDownModelBinding();
    }

    private void setButtonActivation(Boolean b) {
        this.insertOpButton.setEnabled(b.booleanValue());
        this.insertChannelButton.setEnabled(b.booleanValue());
        this.insertConditionButton.setEnabled(b.booleanValue());
        this.opCombo.setEnabled(b.booleanValue());
        this.channelCombo.setEnabled(b.booleanValue());
        this.conditionCombo.setEnabled(b.booleanValue());
    }

    private void setTableHandlingButtonActivation(Boolean b) {
        this.addButton.setEnabled(b.booleanValue());
        this.removeButton.setEnabled(b.booleanValue());
        this.conditionUpButton.setEnabled(b.booleanValue());
        this.conditionDownButton.setEnabled(b.booleanValue());
    }

    public void setInputChannels() {
        this.channelCombo.removeAll();
        for (EndpointDescription channelName : this.getConfiguration().getInputDescriptionsManager().getDynamicEndpointDescriptions()) {
            if (!channelName.getDynamicEndpointIdentifier().equals("dataToInput") || !channelName.isRequired() || !Arrays.asList(SwitchComponentConstants.CONDITION_SCRIPT_DATA_TYPES).contains(channelName.getDataType())) continue;
            this.channelCombo.add(channelName.getName());
        }
        this.channelCombo.select(0);
    }

    public void setConditionInput() {
        this.conditionCombo.removeAll();
        for (EndpointDescription conditionName : this.getConfiguration().getInputDescriptionsManager().getDynamicEndpointDescriptions()) {
            if (!conditionName.getDynamicEndpointIdentifier().equals("conditionToInput") || !conditionName.isRequired()) continue;
            this.conditionCombo.add(conditionName.getName());
        }
        this.conditionCombo.select(0);
    }

    private void setComboOperators() {
        this.opCombo.removeAll();
        this.opCombo.setItems(SwitchComponentConstants.OPERATORS);
        this.opCombo.select(0);
    }

    private Listener getButtonListener() {
        return evt -> {
            if (evt.widget.equals(this.insertOpButton)) {
                String s = this.opCombo.getText();
                this.apply(s);
            } else if (evt.widget.equals(this.insertChannelButton)) {
                String s = this.channelCombo.getText();
                this.apply(s);
            } else if (evt.widget.equals(this.insertConditionButton)) {
                String s = this.conditionCombo.getText();
                this.apply(s);
            }
        };
    }

    private void apply(String s) {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        ArrayList input = (ArrayList)this.viewer.getInput();
        ViewerRow row = this.getViewerRow();
        if (row == null) {
            return;
        }
        int selectedRowNumber = Integer.parseInt(row.getText(0)) - 1;
        if (this.getIndexOfSelectedRow() == 0) {
            String currentString = row.getText(1);
            String firstSubstr = currentString.substring(0, this.latestCaret);
            String lastSubstr = currentString.substring(this.latestCaret);
            String newString = String.valueOf(firstSubstr) + " " + s + " " + lastSubstr;
            String trimmedStr = newString.trim();
            ((SwitchCondition)input.get(selectedRowNumber)).setConditionScript(trimmedStr);
            this.latestCaret = this.latestCaret + s.length() + 2 - (newString.length() - trimmedStr.length());
            try {
                this.setProperty("conditionKey", mapper.writeValueAsString((Object)input));
            }
            catch (IOException e) {
                throw new RuntimeException(EXCEPTION_MESSAGE_WRITING, e);
            }
            this.updateTooltipBackgroundColor();
        }
    }

    private ViewerRow getViewerRow() {
        CellEditor cellEditor = this.textEditingSupport.getCellEditor(0);
        ViewerCell cell = this.textEditingSupport.getViewer().getCell(cellEditor.getControl().getLocation());
        if (cell != null) {
            return cell.getViewerRow();
        }
        return null;
    }

    protected SwitchConditionSectionUpdater createUpdater() {
        return new SwitchConditionSectionUpdater();
    }

    protected void updateErrorStates(List<ComponentValidationMessage> messages, Composite parent) {
        if (parent != null && !parent.isDisposed()) {
            Control[] controlArray = parent.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (!control.isDisposed() && this.viewer.getInput() != null) {
                    String key;
                    if (control instanceof Composite) {
                        this.updateErrorStates(messages, (Composite)control);
                    }
                    if ((key = (String)control.getData("property.control")) != null && key.equals("conditionKey")) {
                        this.updateTooltipMessages(messages, control);
                    }
                }
                ++n2;
            }
        }
    }

    private void updateTooltipMessages(List<ComponentValidationMessage> messages, Control control) {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        ArrayList input = (ArrayList)this.viewer.getInput();
        for (SwitchCondition condition : input) {
            condition.setValidationMessages(null);
        }
        for (ComponentValidationMessage message : messages) {
            if (!(message instanceof SwitchComponentValidationMessage)) continue;
            control.setData("property.control.colorized", (Object)true);
            if (control.getData("property.control.color") == null) {
                control.setData("property.control.color", (Object)control.getBackground());
            }
            int currentRow = ((SwitchComponentValidationMessage)message).getConditionTableRowNumber();
            String errorMessage = ((SwitchComponentValidationMessage)message).getToolTipMessage();
            int len = this.viewer.getTable().getItems().length;
            if (currentRow == 0 || currentRow > len) continue;
            ((SwitchCondition)input.get(currentRow - 1)).setValidationMessages(errorMessage);
        }
        try {
            this.setPropertyNotUndoable("conditionKey", mapper.writeValueAsString((Object)input));
        }
        catch (IOException e) {
            throw new RuntimeException(EXCEPTION_MESSAGE_WRITING, e);
        }
        this.updateTooltipBackgroundColor();
    }

    private void updateTooltipBackgroundColor() {
        ArrayList input = (ArrayList)this.viewer.getInput();
        if (input != null) {
            for (SwitchCondition condition : input) {
                if (condition.getValidationMessages() == null) continue;
                this.viewer.getTable().getItem(condition.getConditionNumber() - 1).setBackground(Display.getDefault().getSystemColor(3));
            }
        }
    }

    public void refreshSection() {
        if (this.getComposite() != null) {
            this.refreshComposite(this.getComposite());
        }
        this.updateTooltipBackgroundColor();
    }

    protected void setSwitchConditionProperty(String key, String value) {
        String oldValue = WorkflowNodeUtil.getConfigurationValue((ComponentInstanceProperties)this.node, (String)key);
        this.setSwitchConditionProperty(key, oldValue, value);
    }

    protected void setSwitchConditionProperty(String key, String oldValue, String newValue) {
        if (oldValue != null && !oldValue.equals(newValue) || oldValue == null && newValue != null) {
            SetSwitchConfigurationValueCommand command = new SetSwitchConfigurationValueCommand(key, oldValue, newValue);
            this.execute((WorkflowNodeCommand)command);
        }
    }

    private class ConditionTableTextCellEditor
    extends TextCellEditor {
        ConditionTableTextCellEditor(Composite parent) {
            super(parent);
        }

        protected void doSetFocus() {
            super.doSetFocus();
            if (this.text != null) {
                this.text.setSelection(this.text.getText().length());
            }
        }

        protected int getDoubleClickTimeout() {
            return 0;
        }

        public boolean isRedoEnabled() {
            return false;
        }

        public boolean isUndoEnabled() {
            return false;
        }

        protected int getCaret() {
            return this.text.getCaretPosition();
        }
    }

    protected class SetSwitchConfigurationValueCommand
    extends WorkflowNodePropertySection.SetConfigurationValueCommand {
        public SetSwitchConfigurationValueCommand(String key, String oldValue, String newValue) {
            super(key, oldValue, newValue);
        }

        public void undo2() {
            if (!SwitchConditionSection.this.textEditingSupport.getCellEditor(0).getControl().isDisposed() && SwitchConditionSection.this.textEditingSupport.getCellEditor(0).isActivated()) {
                SwitchConditionSection.this.setPropertyNotUndoable(this.key, this.oldValue, this.newValue);
                SwitchConditionSection.this.textEditingSupport.getCellEditor(0).deactivate();
                this.commandStack.undo();
            } else {
                super.undo2();
            }
        }
    }

    private class SwitchConditionContentProvider
    implements IStructuredContentProvider {
        private SwitchConditionContentProvider() {
        }

        public Object[] getElements(Object element) {
            if (element instanceof ArrayList) {
                ArrayList array = (ArrayList)element;
                int len = array.size();
                String[][] tableValues = new String[len][2];
                int i = 0;
                for (SwitchCondition entry : array) {
                    tableValues[i][0] = String.valueOf(entry.getConditionNumber());
                    tableValues[i][1] = entry.getConditionScript();
                    ++i;
                }
                return tableValues;
            }
            throw new RuntimeException("Invalid input type for ListContentProvider: " + element.getClass());
        }
    }

    private class SwitchConditionSectionUpdater
    extends WorkflowNodePropertySection.DefaultUpdater {
        private SwitchConditionSectionUpdater() {
            super((WorkflowNodePropertySection)SwitchConditionSection.this);
        }

        public void updateControl(Control control, String propertyName, String newValue, String oldValue) {
            super.updateControl(control, propertyName, newValue, oldValue);
            if (control instanceof Table && !newValue.equals(oldValue)) {
                ArrayList tableValues = null;
                try {
                    if (!newValue.equals("")) {
                        tableValues = (ArrayList)SwitchCondition.getSwitchConditionList((String)newValue);
                    }
                }
                catch (Throwable throwable) {
                    SwitchConditionSection.this.viewer.setInput(tableValues);
                    throw throwable;
                }
                SwitchConditionSection.this.viewer.setInput((Object)tableValues);
                SwitchConditionSection.this.updateTooltipBackgroundColor();
            }
        }
    }

    public static enum TableRowBehavior {
        ADD_ROW,
        REMOVE_ROW,
        MOVE_UP,
        MOVE_DOWN;

    }

    private class TextEditingSupport
    extends EditingSupport {
        private final ConditionTableTextCellEditor editor;
        private final TableViewer viewer;
        private final int columnNumber;

        TextEditingSupport(TableViewer viewer, Table table, int columnNumber) {
            super((ColumnViewer)viewer);
            this.columnNumber = columnNumber;
            this.viewer = viewer;
            this.editor = new ConditionTableTextCellEditor((Composite)table);
        }

        protected boolean canEdit(Object arg0) {
            return true;
        }

        protected CellEditor getCellEditor(Object arg0) {
            return this.editor;
        }

        protected Object getValue(Object arg0) {
            return ((String[])arg0)[this.columnNumber];
        }

        protected void setValue(Object arg0, Object arg1) {
            String configStr = SwitchConditionSection.this.getProperty("conditionKey");
            SwitchConditionSection.this.contentList = (ArrayList)SwitchCondition.getSwitchConditionList((String)configStr);
            ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
            int index = Integer.parseInt(((String[])arg0)[0]) - 1;
            if (!arg1.equals("")) {
                ((SwitchCondition)SwitchConditionSection.this.contentList.get(index)).setConditionScript(arg1.toString());
            } else {
                ((SwitchCondition)SwitchConditionSection.this.contentList.get(index)).setConditionScript("");
            }
            try {
                if (!configStr.equals(mapper.writeValueAsString((Object)SwitchConditionSection.this.contentList))) {
                    SwitchConditionSection.this.setSwitchConditionProperty("conditionKey", mapper.writeValueAsString((Object)SwitchConditionSection.this.contentList));
                }
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(SwitchConditionSection.EXCEPTION_MESSAGE_WRITING, e);
            }
            this.viewer.setInput((Object)SwitchConditionSection.this.contentList);
            SwitchConditionSection.this.latestCaret = this.editor.getCaret();
            SwitchConditionSection.this.updateTooltipBackgroundColor();
        }
    }
}

