/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.switchcmp.execution.validator;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import de.rcenvironment.components.switchcmp.common.ScriptValidation;
import de.rcenvironment.components.switchcmp.common.SwitchCondition;
import de.rcenvironment.components.switchcmp.execution.validator.Messages;
import de.rcenvironment.components.switchcmp.execution.validator.SwitchComponentValidationMessage;
import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.validation.api.ComponentValidationMessage;
import de.rcenvironment.core.component.validation.spi.AbstractComponentValidator;
import de.rcenvironment.core.datamodel.api.DataType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SwitchComponentValidator
extends AbstractComponentValidator {
    private static final String EXCEPTION_MESSAGE_READING = "Unexpected Exception occured, while reading JSON content String.";

    public String getIdentifier() {
        return "de.rcenvironment.switchcmp";
    }

    protected List<ComponentValidationMessage> validateComponentSpecific(ComponentDescription componentDescription) {
        ArrayList<ComponentValidationMessage> messages = new ArrayList<ComponentValidationMessage>();
        String configStr = this.getProperty(componentDescription, "conditionKey");
        ObjectMapper mapper = new ObjectMapper();
        CollectionType mapCollectionType = mapper.getTypeFactory().constructCollectionType(ArrayList.class, SwitchCondition.class);
        ArrayList contentList = new ArrayList();
        try {
            if (!configStr.equals("")) {
                contentList = (ArrayList)mapper.readValue(configStr, (JavaType)mapCollectionType);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(EXCEPTION_MESSAGE_READING, e);
        }
        if (contentList != null && !contentList.isEmpty()) {
            int i = 0;
            while (i < contentList.size()) {
                if (((SwitchCondition)contentList.get(i)).getConditionScript().trim().isEmpty()) {
                    SwitchComponentValidationMessage emptyCondition = SwitchComponentValidationMessage.create(ComponentValidationMessage.Type.ERROR, "conditionKey", Messages.noConditionString, i + 1);
                    messages.add(emptyCondition);
                } else {
                    String errorMessage = ScriptValidation.validateScript((String)((SwitchCondition)contentList.get(i)).getConditionScript(), this.getInputAndConnectionStatus(componentDescription), this.getInputsAndDataTypes(componentDescription), (Object)((Object)this));
                    if (!errorMessage.isEmpty()) {
                        SwitchComponentValidationMessage scriptError = SwitchComponentValidationMessage.create(ComponentValidationMessage.Type.ERROR, "conditionKey", errorMessage, i + 1);
                        messages.add(scriptError);
                    }
                }
                ++i;
            }
        } else {
            ComponentValidationMessage emptyCondition = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "conditionKey", Messages.noConditionString, Messages.noConditionString);
            messages.add(emptyCondition);
        }
        return messages;
    }

    protected List<ComponentValidationMessage> validateOnWorkflowStartComponentSpecific(ComponentDescription componentDescription) {
        return null;
    }

    private Map<String, DataType> getInputsAndDataTypes(ComponentDescription componentDescription) {
        HashMap<String, DataType> inputs = new HashMap<String, DataType>();
        for (EndpointDescription description : this.getInputs(componentDescription)) {
            inputs.put(description.getName(), description.getDataType());
        }
        return inputs;
    }

    private Map<String, Boolean> getInputAndConnectionStatus(ComponentDescription componentDescription) {
        HashMap<String, Boolean> inputs = new HashMap<String, Boolean>();
        for (EndpointDescription description : this.getInputs(componentDescription)) {
            inputs.put(description.getName(), description.isConnected());
        }
        return inputs;
    }
}

