/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.switchcmp.execution;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.components.switchcmp.common.ScriptValidation;
import de.rcenvironment.components.switchcmp.common.SwitchComponentHistoryDataItem;
import de.rcenvironment.components.switchcmp.common.SwitchCondition;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.ComponentHistoryDataItem;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.model.spi.DefaultComponent;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.scripting.ScriptingService;
import de.rcenvironment.core.scripting.ScriptingUtils;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.scripting.ScriptLanguage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.commons.lang3.text.WordUtils;

public class SwitchComponent
extends DefaultComponent {
    private static final String QUOTE = "\\\\Q";
    private static final String ENDQUOTE = "\\\\E";
    private static final String EXCEPTION_MESSAGE_WRITING = "Unexpected Exception occured, while writing JSON content String.";
    protected ScriptingService scriptingService;
    private ScriptLanguage scriptLanguage;
    private ScriptEngine engine;
    private String condition;
    private CloseOutputBehavior closeOutputBehavior;
    private ComponentContext componentContext;
    private SwitchComponentHistoryDataItem historyDataItem;
    private String closeOnCondition;

    public void setComponentContext(ComponentContext componentContext) {
        this.componentContext = componentContext;
    }

    public void start() throws ComponentException {
        this.condition = this.componentContext.getConfigurationValue("conditionKey");
        this.closeOutputBehavior = this.getCloseOutputBehavior();
        if (this.closeOutputBehavior.equals((Object)CloseOutputBehavior.CLOSE_OUTPUTS_ON_CONDITION_NUMBER)) {
            this.closeOnCondition = this.componentContext.getConfigurationValue("selectedCondition");
        }
        this.scriptLanguage = ScriptLanguage.getByName((String)"Jython");
        this.scriptingService = (ScriptingService)this.componentContext.getService(ScriptingService.class);
        this.engine = this.scriptingService.createScriptEngine(this.scriptLanguage);
        List conditionArray = SwitchCondition.getSwitchConditionList((String)this.condition);
        for (SwitchCondition con : conditionArray) {
            String errorMessage = ScriptValidation.validateScript((String)con.getConditionScript(), (ScriptEngine)this.engine, this.getInputAndConnectionStatus(), this.getInputsAndDataTypes());
            if (errorMessage.isEmpty()) continue;
            throw new ComponentException(errorMessage);
        }
    }

    private CloseOutputBehavior getCloseOutputBehavior() {
        if (Boolean.TRUE.equals(Boolean.valueOf(this.componentContext.getConfigurationValue("closeOutputsOnConditionNumber")))) {
            return CloseOutputBehavior.CLOSE_OUTPUTS_ON_CONDITION_NUMBER;
        }
        if (Boolean.TRUE.equals(Boolean.valueOf(this.componentContext.getConfigurationValue("closeOutputsOnNoMatch")))) {
            return CloseOutputBehavior.CLOSE_OUTPUTS_ON_NO_MATCH;
        }
        return CloseOutputBehavior.NEVER_CLOSE_OUTPUTS;
    }

    public void processInputs() throws ComponentException {
        this.initializeNewHistoryDataItem();
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        ArrayList conditionArrayWithPlaceholder = (ArrayList)SwitchCondition.getSwitchConditionList((String)this.condition);
        HashMap<String, String> actualConditionArray = new HashMap<String, String>();
        String writeToFirstCondition = this.componentContext.getConfigurationValue("writeOutputKey");
        Boolean outputWritten = false;
        Boolean closeOutputs = false;
        List<Boolean> list = this.checkConditionsAndWriteOutput(conditionArrayWithPlaceholder, actualConditionArray, closeOutputs, outputWritten, writeToFirstCondition);
        outputWritten = list.get(0);
        closeOutputs = list.get(1);
        if (Boolean.TRUE.equals(closeOutputs)) {
            this.componentContext.closeAllOutputs();
        }
        if (Boolean.FALSE.equals(outputWritten)) {
            this.writeOutputsNoMatch();
            if (this.closeOutputBehavior == CloseOutputBehavior.CLOSE_OUTPUTS_ON_NO_MATCH) {
                this.componentContext.closeAllOutputs();
            }
        }
        if (this.historyDataItem != null) {
            try {
                this.historyDataItem.setActualCondition(mapper.writeValueAsString(actualConditionArray));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(EXCEPTION_MESSAGE_WRITING, e);
            }
            this.historyDataItem.setConditionPattern(this.condition);
            this.historyDataItem.setWriteToFirstCondition(writeToFirstCondition);
            this.historyDataItem.setIdentifier(this.componentContext.getComponentIdentifier());
        }
        this.writeFinalHistoryDataItem();
    }

    public void completeStartOrProcessInputsAfterFailure() throws ComponentException {
        this.writeFinalHistoryDataItem();
    }

    private void initializeNewHistoryDataItem() {
        if (Boolean.TRUE.equals(Boolean.valueOf(this.componentContext.getConfigurationValue("storeComponentHistoryData")))) {
            this.historyDataItem = new SwitchComponentHistoryDataItem();
        }
    }

    private void writeFinalHistoryDataItem() {
        if (this.historyDataItem != null && Boolean.TRUE.equals(Boolean.valueOf(this.componentContext.getConfigurationValue("storeComponentHistoryData")))) {
            this.componentContext.writeFinalHistoryDataItem((ComponentHistoryDataItem)this.historyDataItem);
        }
    }

    private List<Boolean> checkConditionsAndWriteOutput(ArrayList<SwitchCondition> conditionArrayWithPlaceholder, Map<String, String> actualConditionMap, Boolean closeOutputs, Boolean outputWritten, String writeToFirstCondition) throws ComponentException {
        Object returnValue = false;
        int i = 0;
        while (i < conditionArrayWithPlaceholder.size()) {
            String conditionNumber = String.valueOf(i + 1);
            String conditionWithPlaceholder = conditionArrayWithPlaceholder.get(i).getConditionScript();
            if (!conditionWithPlaceholder.isEmpty()) {
                Boolean writeOutput;
                String conditionWithActualValues = this.replacePlaceholder(conditionWithPlaceholder);
                String evalScript = "if " + conditionWithActualValues + ":\n    returnValue=True\nelse:\n    returnValue=False";
                returnValue = this.evaluateScript(evalScript, conditionWithActualValues, i + 1);
                this.componentContext.getLog().componentInfo(StringUtils.format((String)"Evaluated '%s' -> %b", (Object[])new Object[]{conditionWithActualValues, returnValue}));
                actualConditionMap.put(conditionNumber, StringUtils.format((String)"%s -> %b", (Object[])new Object[]{conditionWithActualValues, returnValue}));
                if (Boolean.TRUE.equals((Boolean)returnValue)) {
                    outputWritten = this.writeOutputs(conditionNumber);
                    if (this.closeOutputBehavior == CloseOutputBehavior.CLOSE_OUTPUTS_ON_CONDITION_NUMBER && this.closeOnCondition != null && this.closeOnCondition.equals(conditionNumber)) {
                        closeOutputs = true;
                    }
                }
                if ((writeOutput = Boolean.valueOf(Boolean.parseBoolean(writeToFirstCondition))).booleanValue() && outputWritten.booleanValue()) break;
            }
            ++i;
        }
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        list.add(outputWritten);
        list.add(closeOutputs);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object evaluateScript(String evalScript, String conditionWithActualValues, int conditionNumber) throws ComponentException {
        Object returnValue;
        try {
            Object object = ScriptingUtils.SCRIPT_EVAL_LOCK_OBJECT;
            synchronized (object) {
                this.engine.eval(evalScript);
                returnValue = this.engine.get("returnValue");
            }
        }
        catch (ScriptException e) {
            throw new ComponentException(StringUtils.format((String)"Failed to interpret condition %s '%s': %s", (Object[])new Object[]{String.valueOf(conditionNumber), conditionWithActualValues, e.getMessage()}), (Throwable)e);
        }
        return returnValue;
    }

    private String replacePlaceholder(String conditionString) {
        for (String inputName : this.componentContext.getInputsWithDatum()) {
            TypedDatum datum = this.componentContext.readInput(inputName);
            if (datum.getDataType().equals((Object)DataType.Float) || datum.getDataType().equals((Object)DataType.Integer)) {
                conditionString = conditionString.replace(inputName, Pattern.quote(datum.toString()).replaceAll(QUOTE, "")).replaceAll(ENDQUOTE, "");
            }
            if (!datum.getDataType().equals((Object)DataType.Boolean)) continue;
            conditionString = conditionString.replace(inputName, WordUtils.capitalize((String)Pattern.quote(datum.toString()).replaceAll(QUOTE, ""))).replaceAll(ENDQUOTE, "");
        }
        return conditionString;
    }

    private Boolean writeOutputs(String conditionNumber) {
        boolean val = false;
        for (String input : this.componentContext.getInputsWithDatum()) {
            if (this.componentContext.getDynamicInputIdentifier(input).equals("conditionToInput")) continue;
            TypedDatum datum = this.componentContext.readInput(input);
            this.componentContext.writeOutput(String.valueOf(input) + "_condition" + " " + conditionNumber, datum);
            String outputName = String.valueOf(input) + "_condition" + " " + conditionNumber;
            this.componentContext.getLog().componentInfo(StringUtils.format((String)"Wrote to '%s': %s", (Object[])new Object[]{outputName, datum}));
            val = true;
        }
        return val;
    }

    private void writeOutputsNoMatch() {
        for (String input : this.componentContext.getInputsWithDatum()) {
            if (this.componentContext.getDynamicInputIdentifier(input).equals("conditionToInput")) continue;
            TypedDatum datum = this.componentContext.readInput(input);
            this.componentContext.writeOutput(String.valueOf(input) + "_no match", datum);
            String outputName = String.valueOf(input) + "_no match";
            this.componentContext.getLog().componentInfo(StringUtils.format((String)"Wrote to '%s': %s", (Object[])new Object[]{outputName, datum}));
        }
    }

    private Map<String, Boolean> getInputAndConnectionStatus() {
        HashMap<String, Boolean> inputs = new HashMap<String, Boolean>();
        for (String name : this.componentContext.getInputs()) {
            inputs.put(name, true);
        }
        for (String name : this.componentContext.getInputsNotConnected()) {
            inputs.put(name, false);
        }
        return inputs;
    }

    private Map<String, DataType> getInputsAndDataTypes() {
        HashMap<String, DataType> inputs = new HashMap<String, DataType>();
        for (String name : this.componentContext.getInputs()) {
            inputs.put(name, this.componentContext.getInputDataType(name));
        }
        for (String name : this.componentContext.getInputsNotConnected()) {
            inputs.put(name, this.componentContext.getInputDataType(name));
        }
        return inputs;
    }

    private static enum CloseOutputBehavior {
        NEVER_CLOSE_OUTPUTS,
        CLOSE_OUTPUTS_ON_CONDITION_NUMBER,
        CLOSE_OUTPUTS_ON_NO_MATCH;

    }
}

