/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.switchcmp.common;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SwitchCondition {
    private static final String EXCEPTION_MESSAGE_READING = "Unexpected Exception occured, while reading JSON content String.";
    private int conditionNumber;
    private String conditionScript;
    private String validationMessages;

    public SwitchCondition() {
    }

    public SwitchCondition(int conditionNumber, String conditionScript, String validationMessages) {
        this.conditionNumber = conditionNumber;
        this.conditionScript = conditionScript;
        this.validationMessages = validationMessages;
    }

    public SwitchCondition(int conditionNumber, String conditionScript) {
        this(conditionNumber, conditionScript, null);
    }

    public int getConditionNumber() {
        return this.conditionNumber;
    }

    public void setConditionNumber(int conditionNumber) {
        this.conditionNumber = conditionNumber;
    }

    public String getConditionScript() {
        return this.conditionScript;
    }

    public void setConditionScript(String conditionScript) {
        this.conditionScript = conditionScript;
    }

    public String getValidationMessages() {
        return this.validationMessages;
    }

    public void setValidationMessages(String validationMessages) {
        this.validationMessages = validationMessages;
    }

    public static List<SwitchCondition> getSwitchConditionList(String configStr) {
        ObjectMapper mapper = new ObjectMapper();
        CollectionType mapCollectionType = mapper.getTypeFactory().constructCollectionType(ArrayList.class, SwitchCondition.class);
        ArrayList switchConditionArray = new ArrayList();
        try {
            if (!configStr.equals("")) {
                switchConditionArray = (ArrayList)mapper.readValue(configStr, (JavaType)mapCollectionType);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(EXCEPTION_MESSAGE_READING, e);
        }
        return switchConditionArray;
    }
}

