/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.switchcmp.common;

import de.rcenvironment.components.switchcmp.common.SwitchComponentConstants;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.scripting.ScriptingService;
import de.rcenvironment.core.scripting.ScriptingUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import de.rcenvironment.core.utils.scripting.ScriptLanguage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ScriptValidation {
    private static ScriptEngine engine = null;
    private static final Log LOGGER = LogFactory.getLog(ScriptValidation.class);
    private static final int COLUMNNOTFOUND = -1;
    private static /* synthetic */ int[] $SWITCH_TABLE$de$rcenvironment$core$datamodel$api$DataType;

    private ScriptValidation() {
    }

    public static String validateScript(String script, Map<String, Boolean> inputsAndConnectionStatus, Map<String, DataType> inputsAndDataTypes, Object callerInstance) {
        if (engine == null) {
            ServiceRegistryAccess serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)callerInstance);
            ScriptingService service = (ScriptingService)serviceRegistryAccess.getService(ScriptingService.class);
            engine = service.createScriptEngine(ScriptLanguage.getByName((String)"Jython"));
        }
        return ScriptValidation.validateScript(script, engine, inputsAndConnectionStatus, inputsAndDataTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static String validateScript(String script, ScriptEngine scriptEngine, Map<String, Boolean> inputsAndConnectionStatus, Map<String, DataType> inputsAndDataTypes) {
        block18: {
            errorMessageNotSupported = new HashSet<String>();
            errorMessageNotDefined = new HashSet<String>();
            errorMessageNotConnected = new HashSet<String>();
            errorMessagePython = new HashSet<String>();
            operatorList = new ArrayList<String>(Arrays.asList(SwitchComponentConstants.OPERATORS));
            operatorList.addAll(Arrays.asList(SwitchComponentConstants.OPERATORS_FOR_VALIDATION));
            operatorPattern = Pattern.compile(ScriptValidation.createValidationRegex(operatorList));
            operatorMatcher = operatorPattern.matcher(script);
            if (inputsAndConnectionStatus.keySet().isEmpty()) ** GOTO lbl29
            for (String inputName : inputsAndConnectionStatus.keySet()) {
                inputToForwardDataType = inputsAndDataTypes.get(inputName);
                while (operatorMatcher.find()) {
                    if (operatorMatcher.group(0).equals(inputName) && inputToForwardDataType != null && !inputToForwardDataType.equals((Object)DataType.Float) && !inputToForwardDataType.equals((Object)DataType.Integer) && !inputToForwardDataType.equals((Object)DataType.Boolean)) {
                        errorMessageNotSupported.add(StringUtils.format((String)"Data type '%s' of input '%s' not supported in script", (Object[])new Object[]{inputToForwardDataType, inputName}));
                    }
                    if (!(inputsAndConnectionStatus.containsKey(operatorMatcher.group(0)) || operatorList.contains(operatorMatcher.group(0)) || operatorMatcher.group(0).trim().isEmpty() || org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)operatorMatcher.group()))) {
                        errorMessageNotDefined.add(StringUtils.format((String)"'%s' is not defined", (Object[])new Object[]{operatorMatcher.group(0)}));
                    }
                    if (!inputsAndConnectionStatus.containsKey(operatorMatcher.group(0)) || inputsAndConnectionStatus.get(operatorMatcher.group(0)).booleanValue()) continue;
                    errorMessageNotConnected.add(StringUtils.format((String)"'%s' is not connected", (Object[])new Object[]{operatorMatcher.group(0)}));
                }
            }
            break block18;
lbl-1000:
            // 1 sources

            {
                if (operatorList.contains(operatorMatcher.group(0)) || operatorMatcher.group(0).trim().isEmpty() || org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)operatorMatcher.group())) continue;
                errorMessageNotDefined.add(StringUtils.format((String)"'%s' is not defined", (Object[])new Object[]{operatorMatcher.group(0)}));
lbl29:
                // 3 sources

                ** while (operatorMatcher.find())
            }
        }
        varDefScript = new StringBuilder();
        for (Map.Entry<String, DataType> entry : inputsAndDataTypes.entrySet()) {
            switch (ScriptValidation.$SWITCH_TABLE$de$rcenvironment$core$datamodel$api$DataType()[entry.getValue().ordinal()]) {
                case 3: {
                    str = String.valueOf(entry.getKey()) + " = 11\n";
                    varDefScript.append(str);
                    break;
                }
                case 4: {
                    str = String.valueOf(entry.getKey()) + " = 11.1\n";
                    varDefScript.append(str);
                    break;
                }
                case 2: {
                    str = String.valueOf(entry.getKey()) + " = True\n";
                    varDefScript.append(str);
                    break;
                }
            }
        }
        try {
            entry = ScriptingUtils.SCRIPT_EVAL_LOCK_OBJECT;
            synchronized (entry) {
                evalScript = String.valueOf(varDefScript.toString()) + "if " + script + ":\n    returnValue=True\nelse:\n    returnValue=False";
                scriptEngine.eval(evalScript);
            }
        }
        catch (ScriptException e) {
            if (e.getColumnNumber() != -1) {
                errorMessagePython.add("Syntax error: mismatched input at position " + (e.getColumnNumber() - 3));
            }
            errorMessagePython.add("Syntax error: unknown position");
        }
        errorMessage = new ArrayList<String>();
        errorMessage.addAll(errorMessageNotSupported);
        errorMessage.addAll(errorMessageNotDefined);
        errorMessage.addAll(errorMessageNotConnected);
        errorMessage.addAll(errorMessagePython);
        return ScriptValidation.createErrorMessage(errorMessage);
    }

    private static String createErrorMessage(ArrayList<String> errorMessage) {
        if (!errorMessage.isEmpty()) {
            if (errorMessage.size() == 1) {
                return errorMessage.get(0);
            }
            String lastErrorMessage = errorMessage.remove(errorMessage.size() - 1);
            String string = org.apache.commons.lang3.StringUtils.join(errorMessage, (String)"; \n");
            return String.valueOf(string) + "; \n" + lastErrorMessage;
        }
        return "";
    }

    private static String createValidationRegex(List<String> operatorList) {
        StringBuilder op = new StringBuilder();
        op.append("(");
        for (String operator : operatorList) {
            if (operator.equals("<") || operator.equals(">")) {
                op.append(String.valueOf(operator) + "(?!=)");
            } else {
                op.append(operator);
            }
            op.append("|");
        }
        op.append("\\b\\w+\\b");
        op.append(")");
        try {
            Pattern.compile(op.toString());
        }
        catch (PatternSyntaxException e) {
            LOGGER.error((Object)"Invalid Regex!", (Throwable)e);
        }
        return op.toString();
    }

    static /* synthetic */ int[] $SWITCH_TABLE$de$rcenvironment$core$datamodel$api$DataType() {
        if ($SWITCH_TABLE$de$rcenvironment$core$datamodel$api$DataType != null) {
            return $SWITCH_TABLE$de$rcenvironment$core$datamodel$api$DataType;
        }
        int[] nArray = new int[DataType.values().length];
        try {
            nArray[DataType.BigTable.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DataType.Boolean.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DataType.DateTime.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DataType.DirectoryReference.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DataType.Empty.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DataType.FileReference.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DataType.Float.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DataType.Integer.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DataType.Internal.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DataType.Matrix.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DataType.NotAValue.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DataType.ShortText.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DataType.SmallTable.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DataType.StructuredData.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DataType.Vector.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$de$rcenvironment$core$datamodel$api$DataType = nArray;
        return nArray;
    }
}

