/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.felix.gogo.runtime.ArgList;
import org.apache.felix.gogo.runtime.BaseTokenizer;
import org.apache.felix.gogo.runtime.EOFError;
import org.apache.felix.gogo.runtime.Evaluate;
import org.apache.felix.gogo.runtime.GlobPathMatcher;
import org.apache.felix.gogo.runtime.Parser;
import org.apache.felix.gogo.runtime.SyntaxError;
import org.apache.felix.gogo.runtime.Token;

public class Expander
extends BaseTokenizer {
    private final Evaluate evaluate;
    private boolean inQuote;
    private boolean generateFileNames;
    private boolean semanticJoin;
    private boolean unquote;
    private boolean asPattern;
    private boolean rawVariable;
    private static final char EOL = '\u0000';

    public static Object expand(CharSequence word, Evaluate eval) throws Exception {
        return Expander.expand(word, eval, false, true, false, true, false);
    }

    private static Object expand(CharSequence word, Evaluate eval, boolean inQuote) throws Exception {
        return new Expander(word, eval, inQuote, true, false, false, false).expand();
    }

    private static Object expand(CharSequence word, Evaluate eval, boolean inQuote, boolean generateFileNames, boolean semanticJoin, boolean unquote, boolean asPattern) throws Exception {
        return new Expander(word, eval, inQuote, generateFileNames, semanticJoin, unquote, asPattern).expand();
    }

    public Expander(CharSequence text, Evaluate evaluate, boolean inQuote, boolean generateFileNames, boolean semanticJoin, boolean unquote, boolean asPattern) {
        super(text);
        this.evaluate = evaluate;
        this.inQuote = inQuote;
        this.generateFileNames = generateFileNames;
        this.semanticJoin = semanticJoin;
        this.unquote = unquote;
        this.asPattern = asPattern;
    }

    public Object expand(CharSequence word) throws Exception {
        return Expander.expand(word, this.evaluate, this.inQuote, true, false, false, false);
    }

    public Object expand(CharSequence word, boolean generateFileNames, boolean semanticJoin, boolean unquote) throws Exception {
        return Expander.expand(word, this.evaluate, this.inQuote, generateFileNames, semanticJoin, unquote, false);
    }

    public Object expandPattern(CharSequence word) throws Exception {
        return Expander.expand(word, this.evaluate, this.inQuote, false, false, false, true);
    }

    /*
     * WARNING - void declaration
     */
    private Object expand() throws Exception {
        Object expanded = this.doExpand();
        if (this.rawVariable) {
            return expanded;
        }
        ArrayList<void> args = new ArrayList<void>();
        for (Object o1 : this.toCollection(expanded)) {
            for (Object e : o1 instanceof CharSequence ? this.expandBraces((CharSequence)o1) : Collections.singleton(o1)) {
                for (Object e2 : this.generateFileNames && e instanceof CharSequence ? this.generateFileNames((CharSequence)e) : Collections.singleton(e)) {
                    void var8_8;
                    if (this.unquote && e2 instanceof CharSequence) {
                        CharSequence charSequence = this.unquote((CharSequence)e2);
                    }
                    args.add(var8_8);
                }
            }
        }
        if (args.size() == 1) {
            return args.get(0);
        }
        if (expanded instanceof ArgList) {
            return new ArgList(args);
        }
        return args;
    }

    private CharSequence unquote(CharSequence arg) {
        if (this.inQuote) {
            return arg;
        }
        boolean hasEscape = false;
        for (int i = 0; i < arg.length(); ++i) {
            char c = arg.charAt(i);
            if (c != '\\' && c != '\"' && c != '\'') continue;
            hasEscape = true;
            break;
        }
        if (!hasEscape) {
            return arg;
        }
        boolean singleQuoted = false;
        boolean doubleQuoted = false;
        boolean escaped = false;
        StringBuilder buf = new StringBuilder(arg.length());
        for (int i = 0; i < arg.length(); ++i) {
            char c = arg.charAt(i);
            if (doubleQuoted && escaped) {
                if (c != '\"' && c != '\\' && c != '$' && c != '%') {
                    buf.append('\\');
                }
                buf.append(c);
                escaped = false;
                continue;
            }
            if (escaped) {
                buf.append(c);
                escaped = false;
                continue;
            }
            if (singleQuoted) {
                if (c == '\'') {
                    singleQuoted = false;
                    continue;
                }
                buf.append(c);
                continue;
            }
            if (doubleQuoted) {
                if (c == '\\') {
                    escaped = true;
                    continue;
                }
                if (c == '\"') {
                    doubleQuoted = false;
                    continue;
                }
                buf.append(c);
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == '\'') {
                singleQuoted = true;
                continue;
            }
            if (c == '\"') {
                doubleQuoted = true;
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    /*
     * Could not resolve type clashes
     */
    protected List<? extends CharSequence> expandBraces(CharSequence arg) throws Exception {
        int braces = 0;
        boolean escaped = false;
        boolean doubleQuoted = false;
        boolean singleQuoted = false;
        ArrayList<CharSequence> parts = new ArrayList<CharSequence>();
        int start = 0;
        for (int i = 0; i < arg.length(); ++i) {
            char c = arg.charAt(i);
            if (doubleQuoted && escaped) {
                escaped = false;
                continue;
            }
            if (escaped) {
                escaped = false;
                continue;
            }
            if (singleQuoted) {
                if (c != '\'') continue;
                singleQuoted = false;
                continue;
            }
            if (doubleQuoted) {
                if (c == '\\') {
                    escaped = true;
                    continue;
                }
                if (c != '\"') continue;
                doubleQuoted = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == '\'') {
                singleQuoted = true;
                continue;
            }
            if (c == '\"') {
                doubleQuoted = true;
                continue;
            }
            if (c == '{') {
                if (braces++ != 0) continue;
                if (i > start) {
                    parts.add(arg.subSequence(start, i));
                }
                start = i;
                continue;
            }
            if (c != '}' || --braces != 0) continue;
            parts.add(arg.subSequence(start, i + 1));
            start = i + 1;
        }
        if (start < arg.length()) {
            parts.add(arg.subSequence(start, arg.length()));
        }
        if (start == 0) {
            return Collections.singletonList(arg);
        }
        ArrayList generated = new ArrayList();
        Pattern pattern = Pattern.compile("\\{(((?<intstart>\\-?[0-9]+)\\.\\.(?<intend>\\-?[0-9]+)(\\.\\.(?<intinc>\\-?0*[1-9][0-9]*))?)|((?<charstart>\\S)\\.\\.(?<charend>\\S)))\\}");
        for (CharSequence part : parts) {
            List<Object> generators = new ArrayList<CharSequence>();
            Matcher matcher = pattern.matcher(part);
            if (matcher.matches()) {
                if (matcher.group("intstart") != null) {
                    int k;
                    int intinc;
                    int intstart = Integer.parseInt(matcher.group("intstart"));
                    int intend = Integer.parseInt(matcher.group("intend"));
                    int n = intinc = matcher.group("intinc") != null ? Integer.parseInt(matcher.group("intinc")) : 1;
                    if (intstart > intend) {
                        if (intinc < 0) {
                            k = intstart;
                            intstart = intend;
                            intend = k;
                        }
                        intinc = -intinc;
                    } else if (intinc < 0) {
                        k = intstart;
                        intstart = intend;
                        intend = k;
                    }
                    if (intinc > 0) {
                        for (k = intstart; k <= intend; k += intinc) {
                            generators.add(Integer.toString(k));
                        }
                    } else {
                        for (k = intstart; k >= intend; k += intinc) {
                            generators.add(Integer.toString(k));
                        }
                    }
                } else {
                    char c;
                    char charend;
                    char charstart = matcher.group("charstart").charAt(0);
                    if (charstart < (charend = matcher.group("charend").charAt(0))) {
                        for (c = charstart; c <= charend; c = (char)(c + '\u0001')) {
                            generators.add(Character.toString(c));
                        }
                    } else {
                        for (c = charstart; c >= charend; c = (char)(c - '\u0001')) {
                            generators.add(Character.toString(c));
                        }
                    }
                }
            } else if (part.charAt(0) == '{' && part.charAt(part.length() - 1) == '}') {
                braces = 0;
                escaped = false;
                doubleQuoted = false;
                singleQuoted = false;
                start = 1;
                for (int i = 1; i < part.length() - 1; ++i) {
                    char c = part.charAt(i);
                    if (doubleQuoted && escaped) {
                        escaped = false;
                        continue;
                    }
                    if (escaped) {
                        escaped = false;
                        continue;
                    }
                    if (singleQuoted) {
                        if (c != '\'') continue;
                        singleQuoted = false;
                        continue;
                    }
                    if (doubleQuoted) {
                        if (c == '\\') {
                            escaped = true;
                            continue;
                        }
                        if (c != '\"') continue;
                        doubleQuoted = false;
                        continue;
                    }
                    if (c == '\\') {
                        escaped = true;
                        continue;
                    }
                    if (c == '\'') {
                        singleQuoted = true;
                        continue;
                    }
                    if (c == '\"') {
                        doubleQuoted = true;
                        continue;
                    }
                    if (c == '}') {
                        --braces;
                        continue;
                    }
                    if (c == '{') {
                        ++braces;
                        continue;
                    }
                    if (c != ',' || braces != 0) continue;
                    generators.add(part.subSequence(start, i));
                    start = i + 1;
                }
                if (start < part.length() - 1) {
                    generators.add(part.subSequence(start, part.length() - 1));
                }
                ArrayList<String> l = new ArrayList<String>();
                for (CharSequence cs : generators) {
                    Object o1 = this.expand(cs, false, false, false);
                    for (Object o2 : this.toCollection(o1)) {
                        l.add(String.valueOf(o2));
                    }
                }
                generators = l;
                if (generators.size() < 2) {
                    generators = Collections.singletonList(part.toString());
                }
            } else {
                generators.add(part.toString());
            }
            if (generated.isEmpty()) {
                generated.addAll(generators);
                continue;
            }
            ArrayList prevGenerated = generated;
            generated = new ArrayList();
            for (CharSequence s : generators) {
                for (Object cs : prevGenerated) {
                    generated.add(String.valueOf(cs) + s);
                }
            }
        }
        return generated;
    }

    protected List<? extends CharSequence> generateFileNames(CharSequence arg) throws IOException {
        String prefix;
        Path dir;
        Path currentDir = this.evaluate.currentDir();
        if (currentDir == null || this.inQuote) {
            return Collections.singletonList(arg);
        }
        boolean hasUnescapedReserved = false;
        boolean escaped = false;
        boolean doubleQuoted = false;
        boolean singleQuoted = false;
        StringBuilder buf = new StringBuilder(arg.length());
        String pfx = "";
        for (int i = 0; i < arg.length(); ++i) {
            char c = arg.charAt(i);
            if (doubleQuoted && escaped) {
                if (c != '\"' && c != '\\' && c != '$' && c != '%') {
                    buf.append('\\');
                }
                buf.append(c);
                escaped = false;
                continue;
            }
            if (escaped) {
                buf.append(c);
                escaped = false;
                continue;
            }
            if (singleQuoted) {
                if (c == '\'') {
                    singleQuoted = false;
                    continue;
                }
                buf.append(c);
                continue;
            }
            if (doubleQuoted) {
                if (c == '\\') {
                    escaped = true;
                    continue;
                }
                if (c == '\"') {
                    doubleQuoted = false;
                    continue;
                }
                buf.append(c);
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == '\'') {
                singleQuoted = true;
                continue;
            }
            if (c == '\"') {
                doubleQuoted = true;
                continue;
            }
            if (c == '~') {
                Object home = this.evaluate.get("HOME");
                if (home == null) continue;
                buf.append(home.toString());
                continue;
            }
            if ("*(|<[?".indexOf(c) >= 0 && !hasUnescapedReserved) {
                hasUnescapedReserved = true;
                pfx = buf.toString();
            }
            buf.append(c);
        }
        if (!hasUnescapedReserved) {
            return Collections.singletonList(arg);
        }
        String org = buf.toString();
        final ArrayList expanded = new ArrayList();
        if (pfx.indexOf(47) >= 0) {
            pfx = pfx.substring(0, pfx.lastIndexOf(47));
            arg = org.substring(pfx.length() + 1);
            dir = currentDir.resolve(pfx).normalize();
            prefix = pfx + "/";
        } else {
            dir = currentDir;
            prefix = "";
        }
        final GlobPathMatcher matcher = new GlobPathMatcher(arg.toString());
        Files.walkFileTree(dir, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.equals(dir)) {
                    return FileVisitResult.CONTINUE;
                }
                if (Files.isHidden(file)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                Path r = dir.relativize(file);
                if (matcher.matches(r.toString(), true)) {
                    expanded.add(prefix + r.toString());
                }
                if (matcher.matches(r.toString(), false)) {
                    return FileVisitResult.CONTINUE;
                }
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path r;
                if (!Files.isHidden(file) && matcher.matches((r = dir.relativize(file)).toString(), true)) {
                    expanded.add(prefix + r.toString());
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir2, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
        Collections.sort(expanded);
        if (expanded.isEmpty()) {
            throw new IOException("no matches found: " + org);
        }
        return expanded;
    }

    private Object doExpand() throws Exception {
        String special = "%$\\\"'";
        int i = this.text.length();
        while (--i >= 0 && "%$\\\"'".indexOf(this.text.charAt(i)) == -1) {
        }
        if (i < 0) {
            return this.text;
        }
        StringBuilder buf = new StringBuilder();
        block8: while (this.ch != '\uffff') {
            int start = this.index;
            switch (this.ch) {
                case '%': {
                    Object exp = this.expandExp();
                    if ('\uffff' == this.ch && buf.length() == 0) {
                        return exp;
                    }
                    if (null == exp) continue block8;
                    buf.append(exp);
                    break;
                }
                case '$': {
                    Token value;
                    if (this.peek() == '\'') {
                        this.getch();
                        this.skipQuote();
                        value = this.text.subSequence(start + 1, this.index - 1);
                        this.getch();
                        buf.append("'");
                        buf.append(this.ansiEscape(value));
                        buf.append("'");
                        break;
                    }
                    Object val = this.expandVar(true);
                    if ('\uffff' == this.ch && buf.length() == 0) {
                        return val;
                    }
                    this.rawVariable = false;
                    if (null == val) continue block8;
                    buf.append(val);
                    break;
                }
                case '\\': {
                    buf.append(this.ch);
                    if (this.peek() != '\uffff') {
                        this.getch();
                        buf.append(this.ch);
                    }
                    this.getch();
                    break;
                }
                case '\"': {
                    this.skipQuote();
                    Token value = this.text.subSequence(start, this.index - 1);
                    this.getch();
                    Object expand = Expander.expand(value, this.evaluate, true);
                    if (this.eot() && buf.length() == 0) {
                        if (expand instanceof ArgList) {
                            ArrayList<String> l = new ArrayList<String>();
                            for (Object o : (ArgList)expand) {
                                l.add("\"" + String.valueOf(o) + "\"");
                            }
                            return l;
                        }
                        if (expand instanceof Collection) {
                            StringBuilder sb = new StringBuilder();
                            sb.append("\"");
                            boolean first = true;
                            for (Object e : this.asCollection(expand)) {
                                if (first) {
                                    first = false;
                                } else {
                                    sb.append(" ");
                                }
                                sb.append(String.valueOf(e));
                            }
                            return sb.append("\"").toString();
                        }
                        if (expand != null) {
                            return "\"" + expand.toString() + "\"";
                        }
                        return "";
                    }
                    if (expand instanceof Collection) {
                        boolean first = true;
                        buf.append("\"");
                        for (Object o : (Collection)expand) {
                            if (!first) {
                                buf.append(" ");
                            }
                            first = false;
                            buf.append(o);
                        }
                        buf.append("\"");
                        break;
                    }
                    if (expand == null) continue block8;
                    buf.append("\"");
                    buf.append(expand.toString());
                    buf.append("\"");
                    break;
                }
                case '\'': {
                    this.skipQuote();
                    Token value = this.text.subSequence(start - 1, this.index);
                    this.getch();
                    if (this.eot() && buf.length() == 0) {
                        return value;
                    }
                    buf.append(value);
                    break;
                }
                default: {
                    buf.append(this.ch);
                    this.getch();
                }
            }
        }
        return buf.toString();
    }

    private CharSequence ansiEscape(CharSequence arg) {
        StringBuilder buf = new StringBuilder(arg.length());
        for (int i = 0; i < arg.length(); ++i) {
            int c = arg.charAt(i);
            if (c == 92) {
                c = i < arg.length() - 1 ? (int)arg.charAt(++i) : 92;
                switch (c) {
                    case 97: {
                        buf.append('\u0007');
                        break;
                    }
                    case 110: {
                        buf.append('\n');
                        break;
                    }
                    case 116: {
                        buf.append('\t');
                        break;
                    }
                    case 114: {
                        buf.append('\r');
                        break;
                    }
                    case 92: {
                        buf.append('\\');
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        int j;
                        int ch = 0;
                        for (j = 0; j < 3; ++j) {
                            int n = c = i < arg.length() - 1 ? (int)arg.charAt(++i) : -1;
                            if (c < 0) continue;
                            ch = ch * 8 + (c - 48);
                        }
                        buf.append((char)ch);
                        break;
                    }
                    case 117: {
                        int j;
                        int ch = 0;
                        for (j = 0; j < 4; ++j) {
                            int n = c = i < arg.length() - 1 ? (int)arg.charAt(++i) : -1;
                            if (c < 0) continue;
                            if (c >= 65 && c <= 70) {
                                ch = ch * 16 + (c - 65 + 10);
                                continue;
                            }
                            if (c >= 97 && c <= 102) {
                                ch = ch * 16 + (c - 97 + 10);
                                continue;
                            }
                            if (c >= 48 && c <= 57) {
                                ch = ch * 16 + (c - 48);
                                continue;
                            }
                            --i;
                            break;
                        }
                        buf.append((char)ch);
                        break;
                    }
                    default: {
                        buf.append((char)c);
                        break;
                    }
                }
                continue;
            }
            buf.append((char)c);
        }
        return buf;
    }

    private Object expandExp() {
        assert ('%' == this.ch);
        if (this.getch() == '(') {
            Object val = this.evaluate.expr(this.group());
            this.getch();
            return val;
        }
        throw new SyntaxError(this.line, this.column, "bad expression: " + this.text);
    }

    private Token group() {
        char pop;
        char push = this.ch;
        switch (this.ch) {
            case '{': {
                pop = '}';
                break;
            }
            case '(': {
                pop = ')';
                break;
            }
            case '[': {
                pop = ']';
                break;
            }
            default: {
                assert (false);
                pop = '\u0000';
            }
        }
        short sLine = this.line;
        short sCol = this.column;
        int start = this.index;
        int depth = 1;
        block12: while (true) {
            boolean comment = false;
            switch (this.ch) {
                case '\n': 
                case '(': 
                case '[': 
                case '{': {
                    comment = true;
                }
            }
            if (this.getch() == '\uffff') {
                throw new EOFError(sLine, sCol, "unexpected EOT looking for matching '" + pop + "'", "compound", Character.toString(pop));
            }
            if (comment || this.isBlank(this.ch)) {
                this.skipSpace();
            }
            switch (this.ch) {
                case '\"': 
                case '\'': {
                    this.skipQuote();
                    continue block12;
                }
                case '\\': {
                    this.ch = this.escape();
                    continue block12;
                }
            }
            if (push == this.ch) {
                ++depth;
                continue;
            }
            if (pop == this.ch && --depth == 0) break;
        }
        return this.text.subSequence(start, this.index - 1);
    }

    private Object expandVar() throws Exception {
        return this.expandVar(false);
    }

    private Object expandVar(boolean rawVariable) throws Exception {
        assert ('$' == this.ch);
        Object val = null;
        short sLine = this.line;
        short sCol = this.column;
        if (this.getch() != '{') {
            if ('(' == this.ch) {
                int start = this.index - 1;
                this.find(')', '(');
                Token p = this.text.subSequence(start, this.index);
                val = this.evaluate.eval(new Parser(p).sequence());
                this.getch();
            } else {
                int start = this.index - 1;
                while (this.isName(this.ch)) {
                    this.getch();
                }
                if (this.index - 1 == start) {
                    val = "$";
                } else {
                    String name = this.text.subSequence(start, this.index - 1).toString();
                    val = this.evaluate.get(name);
                    this.rawVariable = rawVariable;
                }
            }
        } else {
            StringBuilder sb;
            this.getch();
            boolean flagu = false;
            boolean flago = false;
            boolean flagO = false;
            boolean flaga = false;
            boolean flagi = false;
            boolean flagn = false;
            boolean flagk = false;
            boolean flagv = false;
            boolean flagP = false;
            boolean flagC = false;
            boolean flagL = false;
            boolean flagU = false;
            boolean flagG = false;
            boolean flagExpand = false;
            boolean flagV = false;
            boolean flagSharp = false;
            int flagq = 0;
            boolean flagQ = false;
            String flags = null;
            String flagj = null;
            boolean flagPattern = false;
            boolean computeLength = false;
            if (this.ch == '(') {
                this.getch();
                boolean flagp = false;
                while (this.ch != '\uffff' && this.ch != ')') {
                    switch (this.ch) {
                        case 'u': {
                            flagu = true;
                            break;
                        }
                        case 'p': {
                            flagp = true;
                            break;
                        }
                        case 'f': {
                            flags = "\n";
                            break;
                        }
                        case 'F': {
                            flagj = "\n";
                            break;
                        }
                        case 'j': 
                        case 's': {
                            char n;
                            char opt = this.ch;
                            char c = this.getch();
                            if (c == '\uffff') {
                                throw new IllegalArgumentException("error in flags");
                            }
                            int start = this.index;
                            do {
                                if ((n = this.getch()) != '\uffff') continue;
                                throw new IllegalArgumentException("error in flags");
                            } while (n != c);
                            String s = this.text.subSequence(start, this.index - 1).toString();
                            if (flagp) {
                                s = this.ansiEscape(s).toString();
                            }
                            if (opt == 's') {
                                flags = s;
                            } else if (opt == 'j') {
                                flagj = s;
                            } else {
                                throw new IllegalArgumentException("error in flags");
                            }
                            flagp = false;
                            break;
                        }
                        case 'q': {
                            if (flagq != 0) {
                                throw new IllegalArgumentException("error in flags");
                            }
                            flagq = 1;
                            if (this.peek() == '-') {
                                flagq = -1;
                                this.getch();
                                break;
                            }
                            while (this.peek() == 'q') {
                                this.getch();
                                ++flagq;
                            }
                            if (this.peek() != '-') break;
                            throw new IllegalArgumentException("error in flags");
                        }
                        case 'Q': {
                            flagQ = true;
                            break;
                        }
                        case '#': {
                            flagSharp = true;
                            break;
                        }
                        case 'V': {
                            flagV = true;
                            break;
                        }
                        case 'o': {
                            flago = true;
                            break;
                        }
                        case 'O': {
                            flagO = true;
                            break;
                        }
                        case 'a': {
                            flaga = true;
                            break;
                        }
                        case 'i': {
                            flagi = true;
                            break;
                        }
                        case 'n': {
                            flagn = true;
                            break;
                        }
                        case 'P': {
                            flagP = true;
                            break;
                        }
                        case '@': {
                            flagExpand = true;
                            break;
                        }
                        case 'G': {
                            flagG = true;
                            break;
                        }
                        case 'k': {
                            flagk = true;
                            break;
                        }
                        case 'v': {
                            flagv = true;
                            break;
                        }
                        case 'C': {
                            flagC = true;
                            flagL = false;
                            flagU = false;
                            break;
                        }
                        case 'L': {
                            flagC = false;
                            flagL = true;
                            flagU = false;
                            break;
                        }
                        case 'U': {
                            flagC = false;
                            flagL = false;
                            flagU = true;
                            break;
                        }
                        default: {
                            throw new SyntaxError(this.line, this.column, "unsupported flag: " + this.ch);
                        }
                    }
                    this.getch();
                }
                this.getch();
            }
            final boolean _flagk = flagk;
            final boolean _flagv = flagv;
            final Function<Object, Object> toCollection = new Function<Object, Object>(){

                @Override
                public Object apply(Object v) {
                    return v instanceof Map ? Expander.this.toList(Expander.this.asMap(v), _flagk, _flagv) : (v != null && v.getClass().isArray() ? Arrays.asList((Object[])v) : v);
                }
            };
            BiFunction<Function<String, String>, Object, Object> stringApplyer = new BiFunction<Function<String, String>, Object, Object>(){

                @Override
                public Object apply(Function<String, String> func, Object v) {
                    if ((v = toCollection.apply(v)) instanceof Collection) {
                        ArrayList<String> l = new ArrayList<String>();
                        for (Object i : Expander.this.asCollection(v)) {
                            l.add(func.apply(String.valueOf(i)));
                        }
                        return l;
                    }
                    if (v != null) {
                        return func.apply(v.toString());
                    }
                    return null;
                }
            };
            if (this.ch == '+') {
                this.getch();
                val = this.getAndEvaluateName();
            } else {
                while (true) {
                    if (this.ch == '#') {
                        computeLength = true;
                        this.getch();
                        continue;
                    }
                    if (this.ch == '=') {
                        if (flags == null) {
                            flags = "\\s";
                        }
                        this.getch();
                        continue;
                    }
                    if (this.ch != '~') break;
                    flagPattern = true;
                    this.getch();
                }
                Object val1 = this.getName('}');
                if (this.ch == '}' || this.ch == '[') {
                    val = val1 instanceof Token ? this.evaluate.get(this.expand((Token)val1).toString()) : val1;
                } else {
                    int start = this.index - 1;
                    while (this.ch != '\uffff' && this.ch != '}' && ":-+=?#%/".indexOf(this.ch) >= 0) {
                        this.getch();
                    }
                    Token op = this.text.subSequence(start, this.index - 1);
                    if (Token.eq("-", op) || Token.eq(":-", op)) {
                        val1 = val1 instanceof Token ? this.evaluate.get(this.expand((Token)val1).toString()) : val1;
                        Object val2 = this.getValue();
                        val = val1 == null ? val2 : val1;
                    } else if (Token.eq("+", op) || Token.eq(":+", op)) {
                        val1 = val1 instanceof Token ? this.evaluate.get(this.expand((Token)val1).toString()) : val1;
                        Object val2 = this.getValue();
                        val = val1 != null ? val2 : null;
                    } else if (Token.eq("=", op) || Token.eq(":=", op) || Token.eq("::=", op)) {
                        if (!(val1 instanceof Token)) {
                            throw new SyntaxError(this.line, this.column, "not an identifier");
                        }
                        String name = this.expand((Token)val1).toString();
                        val1 = this.evaluate.get(name);
                        val = this.getValue();
                        if (Token.eq("::=", op) || val1 == null) {
                            this.evaluate.put(name, val);
                        }
                    } else if (Token.eq("?", op) || Token.eq(":?", op)) {
                        String name;
                        if (val1 instanceof Token) {
                            name = this.expand((Token)val1).toString();
                            val = this.evaluate.get(name);
                        } else {
                            name = "";
                            val = val1;
                        }
                        if (val == null || val.toString().length() == 0) {
                            throw new IllegalArgumentException(name + ": parameter not set");
                        }
                    } else if (Token.eq("#", op) || Token.eq("##", op) || Token.eq("%", op) || Token.eq("%%", op) || Token.eq("/", op) || Token.eq("//", op)) {
                        val1 = val1 instanceof Token ? this.evaluate.get(this.expand((Token)val1).toString()) : val1;
                        String val2 = this.getPattern(op.charAt(0) == '/' ? "/}" : "}");
                        if (val2 != null) {
                            String r;
                            String p = Expander.toRegexPattern(Expander.unquoteGlob(val2), op.length() == 1);
                            if (op.charAt(0) == '/') {
                                if (this.ch == '/') {
                                    this.getch();
                                    r = this.getValue().toString();
                                } else {
                                    r = "";
                                }
                            } else {
                                r = "";
                            }
                            String m = op.charAt(0) == '#' ? "^" + p : (op.charAt(0) == '%' ? p + "$" : p);
                            val1 = toCollection.apply(val1);
                            if (val1 instanceof Collection) {
                                ArrayList<String> l = new ArrayList<String>();
                                for (Object o : (Collection)val1) {
                                    if (flagG) {
                                        l.add(o.toString().replaceAll(m, r));
                                        continue;
                                    }
                                    l.add(o.toString().replaceFirst(m, r));
                                }
                                val = l;
                            } else if (val1 != null) {
                                val = flagG ? val1.toString().replaceAll(m, r) : val1.toString().replaceFirst(m, r);
                            }
                        } else {
                            val = val1;
                        }
                    }
                }
            }
            while (this.ch == '[') {
                String str;
                List list;
                Object right;
                Object left;
                boolean nLeft = false;
                boolean nRight = false;
                this.getch();
                if (this.ch == '*') {
                    left = this.text.subSequence(this.index - 1, this.index);
                    this.getch();
                } else if (this.ch == '@') {
                    left = this.text.subSequence(this.index - 1, this.index);
                    flagExpand = true;
                    this.getch();
                } else {
                    if (this.ch == '-') {
                        nLeft = true;
                        this.getch();
                    }
                    left = this.getName(']');
                }
                if (this.ch == ',') {
                    this.getch();
                    if (this.ch == '-') {
                        nRight = true;
                        this.getch();
                    }
                    right = this.getName(']');
                } else {
                    right = null;
                }
                if (this.ch != ']') {
                    throw new SyntaxError(this.line, this.column, "invalid subscript");
                }
                this.getch();
                if (right == null) {
                    left = left instanceof Token ? this.expand((Token)left) : left;
                    String sLeft = left.toString();
                    if (val instanceof Map) {
                        if (sLeft.equals("@") || sLeft.equals("*")) {
                            val = this.toList(this.asMap(val), flagk, flagv);
                            continue;
                        }
                        val = ((Map)val).get(sLeft);
                        continue;
                    }
                    if (val instanceof List) {
                        if (sLeft.equals("@") || sLeft.equals("*")) {
                            val = new ArgList((List)val);
                            continue;
                        }
                        int iLeft = Integer.parseInt(sLeft);
                        list = (List)val;
                        val = list.get(nLeft ? list.size() - 1 - iLeft : iLeft);
                        continue;
                    }
                    if (val == null) continue;
                    if (sLeft.equals("@") || sLeft.equals("*")) {
                        val = val.toString();
                        continue;
                    }
                    int iLeft = Integer.parseInt(sLeft);
                    str = val.toString();
                    val = Character.valueOf(str.charAt(nLeft ? str.length() - 1 - iLeft : iLeft));
                    continue;
                }
                if (val instanceof Map) {
                    val = null;
                    continue;
                }
                left = left instanceof Token ? this.expand((Token)left) : left;
                right = right instanceof Token ? this.expand((Token)right) : right;
                int iLeft = Integer.parseInt(left.toString());
                int iRight = Integer.parseInt(right.toString());
                if (val instanceof List) {
                    list = (List)val;
                    val = list.subList(nLeft ? list.size() - iLeft : iLeft, nRight ? list.size() - iRight : iRight);
                    continue;
                }
                str = val.toString();
                val = str.substring(nLeft ? str.length() - iLeft : iLeft, nRight ? str.length() - iRight : iRight);
            }
            if (this.ch != '}') {
                throw new SyntaxError(sLine, sCol, "bad substitution");
            }
            if (flagP) {
                val = val != null ? this.evaluate.get(val.toString()) : null;
            }
            boolean joined = false;
            if (this.inQuote && !computeLength && !flagExpand && (val = toCollection.apply(val)) instanceof Collection) {
                String j = flagj != null ? flagj : " ";
                sb = new StringBuilder();
                for (Object i : this.asCollection(val)) {
                    if (sb.length() > 0) {
                        sb.append(j);
                    }
                    sb.append(String.valueOf(i));
                }
                val = sb.toString();
                joined = true;
            }
            if (flagSharp) {
                val = stringApplyer.apply(new Function<String, String>(){

                    @Override
                    public String apply(String s) {
                        return Expander.this.sharp(s);
                    }
                }, val);
            }
            if (computeLength) {
                val = val instanceof Collection ? Integer.valueOf(((Collection)val).size()) : (val instanceof Map ? Integer.valueOf(((Map)val).size()) : (val != null ? Integer.valueOf(val.toString().length()) : Integer.valueOf(0)));
            }
            if ((flagj != null || flags != null && !joined) && (val = toCollection.apply(val)) instanceof Collection) {
                String j = flagj != null ? flagj : " ";
                sb = new StringBuilder();
                for (Object i : this.asCollection(val)) {
                    if (sb.length() > 0) {
                        sb.append(j);
                    }
                    sb.append(String.valueOf(i));
                }
                val = sb.toString();
            }
            if (flags != null) {
                String _flags = flags;
                if (!((val = toCollection.apply(val)) instanceof Collection)) {
                    val = Collections.singletonList(val);
                }
                ArrayList l = new ArrayList();
                for (Object i : this.asCollection(val)) {
                    Collections.addAll(l, String.valueOf(i).split(_flags));
                }
                val = l;
            }
            if (flagC) {
                val = stringApplyer.apply(new Function<String, String>(){

                    @Override
                    public String apply(String s) {
                        return Expander.this.toCamelCase(s);
                    }
                }, val);
            } else if (flagL) {
                val = stringApplyer.apply(new Function<String, String>(){

                    @Override
                    public String apply(String s) {
                        return s.toLowerCase();
                    }
                }, val);
            } else if (flagU) {
                val = stringApplyer.apply(new Function<String, String>(){

                    @Override
                    public String apply(String s) {
                        return s.toUpperCase();
                    }
                }, val);
            }
            if (flagV) {
                val = stringApplyer.apply(new Function<String, String>(){

                    @Override
                    public String apply(String s) {
                        return Expander.this.visible(s);
                    }
                }, val);
            }
            if (flagq != 0) {
                final int _flagq = flagq;
                val = stringApplyer.apply(new Function<String, String>(){

                    @Override
                    public String apply(String s) {
                        return Expander.this.quote(s, _flagq);
                    }
                }, val);
                this.inQuote = true;
            } else if (flagQ) {
                val = stringApplyer.apply(new Function<String, String>(){

                    @Override
                    public String apply(String s) {
                        return Expander.this.unquote(s);
                    }
                }, val);
            }
            if (flagu && (val = toCollection.apply(val)) instanceof Collection) {
                val = new ArrayList<Object>(new HashSet<Object>(this.asCollection(val)));
            }
            if ((flaga || flagi || flagn || flago || flagO) && (val = toCollection.apply(val)) instanceof Collection) {
                ArrayList<Object> list;
                ArrayList<String> l;
                if (flagn) {
                    final boolean _flagi = flagi;
                    l = new ArrayList<String>();
                    for (Object i : this.asCollection(val)) {
                        l.add(String.valueOf(i));
                    }
                    Collections.sort(l, new Comparator<String>(){

                        @Override
                        public int compare(String s1, String s2) {
                            return Expander.this.numericCompare(s1, s2, _flagi);
                        }
                    });
                    list = l;
                } else if (flaga) {
                    list = new ArrayList<Object>(this.asCollection(val));
                } else {
                    Comparator<Object> comparator = flagi ? String.CASE_INSENSITIVE_ORDER : new Comparator<String>(){

                        @Override
                        public int compare(String o1, String o2) {
                            return o1.compareTo(o2);
                        }
                    };
                    l = new ArrayList();
                    for (Object i : this.asCollection(val)) {
                        l.add(String.valueOf(i));
                    }
                    Collections.sort(l, comparator);
                    list = l;
                }
                if (flagO) {
                    Collections.reverse(list);
                }
                val = list;
            }
            if (this.semanticJoin && (val = toCollection.apply(val)) instanceof Collection) {
                StringBuilder sb2 = new StringBuilder();
                for (Object i : this.asCollection(val)) {
                    if (sb2.length() > 0) {
                        sb2.append(" ");
                    }
                    sb2.append(String.valueOf(i));
                }
                val = sb2.toString();
            }
            if (val instanceof Collection) {
                ArrayList<Object> l = new ArrayList<Object>();
                for (Object o : this.asCollection(val)) {
                    if (o instanceof CharSequence && ((CharSequence)o).length() <= 0) continue;
                    l.add(o);
                }
                val = l;
            }
            if (this.asPattern && !this.inQuote && !flagPattern) {
                val = toCollection.apply(val);
                ArrayList<String> patterns = new ArrayList<String>();
                for (Object o : this.toCollection(val)) {
                    patterns.add(this.quote(String.valueOf(o), 2));
                }
                ArrayList<String> arrayList = val = patterns.size() == 1 ? patterns.get(0) : patterns;
            }
            if (this.inQuote) {
                if ((val = toCollection.apply(val)) instanceof Collection) {
                    ArrayList<Object> l = new ArrayList<Object>(this.asCollection(val));
                    val = flagExpand ? new ArgList(l) : l;
                }
            } else if (flagExpand && val instanceof List) {
                val = new ArgList((List)val);
            }
            this.getch();
        }
        return val;
    }

    private String quote(String s, int flagq) {
        StringBuilder buf = new StringBuilder();
        if (flagq == 1) {
            for (int i = 0; i < s.length(); ++i) {
                char ch = s.charAt(i);
                if (ch < ' ' || ch >= '\u007f') {
                    buf.append("$'\\").append(Integer.toOctalString(ch)).append("'");
                    continue;
                }
                if (" !\"#$&'()*;<=>?[\\]{|}~%".indexOf(ch) >= 0) {
                    buf.append("\\").append(ch);
                    continue;
                }
                buf.append(ch);
            }
        } else if (flagq == 2) {
            buf.append("'");
            for (int i = 0; i < s.length(); ++i) {
                char ch = s.charAt(i);
                if (ch == '\'') {
                    buf.append("'\\''");
                    continue;
                }
                buf.append(ch);
            }
            buf.append("'");
        } else if (flagq == 3) {
            buf.append("\"");
            for (int i = 0; i < s.length(); ++i) {
                char ch = s.charAt(i);
                if ("\"\\$%".indexOf(ch) >= 0) {
                    buf.append("\\").append(ch);
                    continue;
                }
                buf.append(ch);
            }
            buf.append("\"");
        } else if (flagq == 4) {
            buf.append("$'");
            block9: for (int i = 0; i < s.length(); ++i) {
                char ch = s.charAt(i);
                if (ch < ' ' || ch >= '\u007f') {
                    buf.append("\\").append(Integer.toOctalString(ch));
                    continue;
                }
                switch (ch) {
                    case '\n': {
                        buf.append("\\n");
                        continue block9;
                    }
                    case '\t': {
                        buf.append("\\t");
                        continue block9;
                    }
                    case '\r': {
                        buf.append("\\r");
                        continue block9;
                    }
                    case '\'': {
                        buf.append("\\'");
                        continue block9;
                    }
                    default: {
                        buf.append(ch);
                    }
                }
            }
            buf.append("'");
        } else {
            boolean needQuotes = false;
            for (int i = 0; i < s.length(); ++i) {
                char ch = s.charAt(i);
                if (ch >= ' ' && ch < '\u007f' && " !\"#$&'()*;<=>?[\\]{|}~%".indexOf(ch) < 0) continue;
                needQuotes = true;
                break;
            }
            return needQuotes ? this.quote(s, 2) : s;
        }
        return buf.toString();
    }

    private String unquote(String arg) {
        boolean hasEscape = false;
        for (int i = 0; i < arg.length(); ++i) {
            char c = arg.charAt(i);
            if (c != '\\' && c != '\"' && c != '\'') continue;
            hasEscape = true;
            break;
        }
        if (!hasEscape) {
            return arg;
        }
        boolean singleQuoted = false;
        boolean doubleQuoted = false;
        boolean escaped = false;
        StringBuilder buf = new StringBuilder(arg.length());
        for (int i = 0; i < arg.length(); ++i) {
            char c = arg.charAt(i);
            if (doubleQuoted && escaped) {
                if (c != '\"' && c != '\\' && c != '$' && c != '%') {
                    buf.append('\\');
                }
                buf.append(c);
                escaped = false;
                continue;
            }
            if (escaped) {
                buf.append(c);
                escaped = false;
                continue;
            }
            if (singleQuoted) {
                if (c == '\'') {
                    singleQuoted = false;
                    continue;
                }
                buf.append(c);
                continue;
            }
            if (doubleQuoted) {
                if (c == '\\') {
                    escaped = true;
                    continue;
                }
                if (c == '\"') {
                    doubleQuoted = false;
                    continue;
                }
                buf.append(c);
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == '\'') {
                singleQuoted = true;
                continue;
            }
            if (c == '\"') {
                doubleQuoted = true;
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private int numericCompare(String s1, String s2, boolean caseInsensitive) {
        int i2;
        char c2;
        char c1;
        int i1e;
        char c22;
        char c12;
        int i2s;
        int i1s = 0;
        for (i2s = 0; i1s < s1.length() && i2s < s2.length(); ++i1s, ++i2s) {
            c12 = s1.charAt(i1s);
            char c23 = s2.charAt(i2s);
            if (caseInsensitive) {
                c12 = Character.toLowerCase(c12);
                c23 = Character.toLowerCase(c23);
            }
            if (c12 == c23) continue;
            if (c12 >= '0' && c12 <= '9' && c23 >= '0' && c23 <= '9') break;
            return c12 < c23 ? -1 : 1;
        }
        while (i1s > 0 && (c12 = s1.charAt(i1s - 1)) >= '0' && c12 <= '9') {
            --i1s;
        }
        while (i2s > 0 && (c22 = s2.charAt(i2s - 1)) >= '0' && c22 <= '9') {
            --i2s;
        }
        int i2e = i2s;
        for (i1e = i1s; i1e < s1.length() - 1 && (c1 = s1.charAt(i1e + 1)) >= '0' && c1 <= '9'; ++i1e) {
        }
        while (i2e < s2.length() - 1 && (c2 = s2.charAt(i2e + 1)) >= '0' && c2 <= '9') {
            ++i2e;
        }
        int i1 = Integer.parseInt(s1.substring(i1s, i1e + 1));
        if (i1 < (i2 = Integer.parseInt(s2.substring(i2s, i2e + 1)))) {
            return -1;
        }
        if (i1 > i2) {
            return 1;
        }
        return i1e > i2e ? -1 : 1;
    }

    private String toCamelCase(String s) {
        return s.isEmpty() ? s : s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }

    private String sharp(String s) {
        int codepoint = 0;
        try {
            codepoint = Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new String(Character.toChars(codepoint));
    }

    private String visible(String s) {
        StringBuilder sb = new StringBuilder(s.length() * 2);
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch < ' ') {
                sb.append('^');
                sb.append((char)(ch + 64));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private Collection<Object> asCollection(Object val) {
        return (Collection)val;
    }

    private Collection<Object> toCollection(Object val) {
        return val instanceof Collection ? this.asCollection(val) : Collections.singleton(val);
    }

    private Map<Object, Object> asMap(Object val) {
        return (Map)val;
    }

    private List<Object> toList(Map<Object, Object> val1, boolean flagk, boolean flagv) {
        ArrayList<Object> l = new ArrayList<Object>();
        if (flagk && flagv) {
            for (Map.Entry<Object, Object> entry : val1.entrySet()) {
                l.add(entry.getKey());
                l.add(entry.getValue());
            }
        } else if (flagk) {
            l.addAll(val1.keySet());
        } else {
            l.addAll(val1.values());
        }
        return l;
    }

    private Object getAndEvaluateName() throws Exception {
        Object r = this.getName('}');
        if (r instanceof Token) {
            return this.evaluate.get(this.expand((Token)r).toString());
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getName(char closing) throws Exception {
        if (this.ch == '\"') {
            if (this.peek() != '$') {
                throw new IllegalArgumentException("bad substitution");
            }
            boolean oldInQuote = this.inQuote;
            try {
                Object val;
                this.inQuote = true;
                this.getch();
                Object object = val = this.getName(closing);
                return object;
            }
            finally {
                this.inQuote = oldInQuote;
            }
        }
        if (this.ch == '$') {
            return this.expandVar();
        }
        int start = this.index - 1;
        while (this.ch != '\uffff' && this.ch != closing && this.isName(this.ch)) {
            this.getch();
            if (this.ch == '\\') {
                this.escape();
                continue;
            }
            if (this.ch != '{') continue;
            this.findClosing();
        }
        if (this.ch == '\uffff') {
            throw new EOFError(this.line, this.column, "unexpected EOT looking for matching '}'", "compound", Character.toString('}'));
        }
        return this.text.subSequence(start, this.index - 1);
    }

    private String getPattern(String closing) throws Exception {
        CharSequence sub = this.findUntil(this.text, this.index - 1, closing);
        this.index += sub.length() - 1;
        this.getch();
        return this.expandPattern(sub).toString();
    }

    private CharSequence findUntil(CharSequence text, int start, String closing) throws Exception {
        int braces = 0;
        boolean escaped = false;
        boolean doubleQuoted = false;
        boolean singleQuoted = false;
        for (int i = start; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (doubleQuoted && escaped) {
                escaped = false;
                continue;
            }
            if (escaped) {
                escaped = false;
                continue;
            }
            if (singleQuoted) {
                if (c != '\'') continue;
                singleQuoted = false;
                continue;
            }
            if (doubleQuoted) {
                if (c == '\\') {
                    escaped = true;
                    continue;
                }
                if (c != '\"') continue;
                doubleQuoted = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == '\'') {
                singleQuoted = true;
                continue;
            }
            if (c == '\"') {
                doubleQuoted = true;
                continue;
            }
            if (braces == 0 && closing.indexOf(c) >= 0) {
                return text.subSequence(start, i);
            }
            if (c == '{') {
                ++braces;
                continue;
            }
            if (c != '}') continue;
            --braces;
        }
        return text.subSequence(start, text.length());
    }

    private Object getValue() throws Exception {
        if (this.ch == '$') {
            return this.expandVar();
        }
        int start = this.index - 1;
        while (this.ch != '\uffff' && this.ch != '}') {
            if (this.ch == '\\') {
                this.escape();
                this.getch();
                continue;
            }
            if (this.ch == '{' || this.ch == '(' || this.ch == '[') {
                this.findClosing();
                continue;
            }
            this.getch();
        }
        if (this.ch == '\uffff') {
            throw new EOFError(this.line, this.column, "unexpected EOT looking for matching '}'", "compound", Character.toString('}'));
        }
        Token name = this.text.subSequence(start, this.index - 1);
        return this.expand(name).toString();
    }

    private void findClosing() {
        char start = this.ch;
        while (this.getch() != '\uffff') {
            if (this.ch == '(' || this.ch == '{' || this.ch == '[') {
                this.findClosing();
                continue;
            }
            if (!(start == '(' && this.ch == ')' || start == '{' && this.ch == '}') && (start != '[' || this.ch != ']')) continue;
            return;
        }
    }

    private static boolean isRegexMeta(char ch) {
        return ".^$+{[]|()".indexOf(ch) != -1;
    }

    private static boolean isGlobMeta(char ch) {
        return "\\*?[{".indexOf(ch) != -1;
    }

    private static char next(String str, int index) {
        return index < str.length() ? str.charAt(index) : (char)'\u0000';
    }

    private static String unquoteGlob(String str) {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        boolean escaped = false;
        boolean doubleQuoted = false;
        boolean singleQuoted = false;
        block5: while (index < str.length()) {
            char ch = str.charAt(index++);
            if (escaped) {
                if (Expander.isGlobMeta(ch)) {
                    sb.append('\\');
                }
                sb.append(ch);
                escaped = false;
                continue;
            }
            if (singleQuoted) {
                if (ch == '\'') {
                    singleQuoted = false;
                    continue;
                }
                if (Expander.isGlobMeta(ch)) {
                    sb.append('\\');
                }
                sb.append(ch);
                continue;
            }
            if (doubleQuoted) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                if (ch == '\"') {
                    doubleQuoted = false;
                    continue;
                }
                if (Expander.isGlobMeta(ch)) {
                    sb.append('\\');
                }
                sb.append(ch);
                continue;
            }
            switch (ch) {
                case '\\': {
                    escaped = true;
                    continue block5;
                }
                case '\'': {
                    singleQuoted = true;
                    continue block5;
                }
                case '\"': {
                    doubleQuoted = true;
                    continue block5;
                }
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private static String toRegexPattern(String str, boolean shortest) {
        boolean inGroup = false;
        StringBuilder sb = new StringBuilder();
        int index = 0;
        block9: while (index < str.length()) {
            char ch = str.charAt(index++);
            switch (ch) {
                case '*': {
                    sb.append(shortest ? ".*?" : ".*");
                    continue block9;
                }
                case ',': {
                    if (inGroup) {
                        sb.append(")|(?:");
                        continue block9;
                    }
                    sb.append(',');
                    continue block9;
                }
                case '?': {
                    sb.append(".");
                    continue block9;
                }
                case '[': {
                    sb.append("[");
                    if (Expander.next(str, index) == '^') {
                        sb.append("\\^");
                        ++index;
                    } else {
                        if (Expander.next(str, index) == '!') {
                            sb.append('^');
                            ++index;
                        }
                        if (Expander.next(str, index) == '-') {
                            sb.append('-');
                            ++index;
                        }
                    }
                    boolean inLeft = false;
                    char left = '\u0000';
                    while (index < str.length() && (ch = str.charAt(index++)) != ']') {
                        if (ch == '\\' || ch == '[' || ch == '&' && Expander.next(str, index) == '&') {
                            sb.append('\\');
                        }
                        sb.append(ch);
                        if (ch == '-') {
                            if (!inLeft) {
                                throw new PatternSyntaxException("Invalid range", str, index - 1);
                            }
                            if ((ch = Expander.next(str, index++)) == '\u0000' || ch == ']') break;
                            if (ch < left) {
                                throw new PatternSyntaxException("Invalid range", str, index - 3);
                            }
                            sb.append(ch);
                            inLeft = false;
                            continue;
                        }
                        inLeft = true;
                        left = ch;
                    }
                    if (ch != ']') {
                        throw new PatternSyntaxException("Missing ']", str, index - 1);
                    }
                    sb.append("]");
                    continue block9;
                }
                case '\\': {
                    char ch2;
                    if (index == str.length()) {
                        throw new PatternSyntaxException("No character to escape", str, index - 1);
                    }
                    if (Expander.isGlobMeta(ch2 = str.charAt(index++)) || Expander.isRegexMeta(ch2)) {
                        sb.append('\\');
                    }
                    sb.append(ch2);
                    continue block9;
                }
                case '{': {
                    if (inGroup) {
                        throw new PatternSyntaxException("Cannot nest groups", str, index - 1);
                    }
                    sb.append("(?:(?:");
                    inGroup = true;
                    continue block9;
                }
                case '}': {
                    if (inGroup) {
                        sb.append("))");
                        inGroup = false;
                        continue block9;
                    }
                    sb.append('}');
                    continue block9;
                }
            }
            if (Expander.isRegexMeta(ch)) {
                sb.append('\\');
            }
            sb.append(ch);
        }
        if (inGroup) {
            throw new PatternSyntaxException("Missing '}", str, index - 1);
        }
        return sb.toString();
    }

    private boolean isName(char ch) {
        return Character.isJavaIdentifierPart(ch) && ch != '$' || '.' == ch;
    }

    private static interface BiFunction<T, U, R> {
        public R apply(T var1, U var2);
    }

    private static interface Function<T, R> {
        public R apply(T var1);
    }
}

