/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner;

import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.command.spi.MainCommandDescription;
import de.rcenvironment.core.command.spi.SubCommandDescription;
import de.rcenvironment.core.configuration.ConfigurationException;
import de.rcenvironment.core.configuration.ConfigurationSegment;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.extras.testscriptrunner.definitions.common.RceTestLifeCycleHooks;
import de.rcenvironment.extras.testscriptrunner.definitions.impl.AssertOutputStepDefinitions;
import de.rcenvironment.extras.testscriptrunner.definitions.impl.CommonStepDefinitions;
import de.rcenvironment.extras.testscriptrunner.definitions.impl.ComponentStepDefinitions;
import de.rcenvironment.extras.testscriptrunner.definitions.impl.InstanceCommandStepDefinitions;
import de.rcenvironment.extras.testscriptrunner.definitions.impl.InstanceInstantiationStepDefinitions;
import de.rcenvironment.extras.testscriptrunner.definitions.impl.InstanceNetworkingStepDefinitions;
import de.rcenvironment.extras.testscriptrunner.definitions.impl.InstanceStateStepDefinitions;
import de.rcenvironment.extras.testscriptrunner.definitions.impl.WorkflowStepDefinitions;
import de.rcenvironment.extras.testscriptrunner.internal.CucumberTestFrameworkAdapter;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestScriptRunnerCommandPlugin
implements CommandPlugin {
    private static final String USAGE_INFO_PARAMETER_PART = "<comma-separated test ids>|--all <build id>";
    private static final String SEPARATOR_TEXT_LINE = "-----------------------------------------------------------------------------------------------";
    private ConfigurationSegment configuration;
    private File scriptLocationRoot;
    private final CucumberTestFrameworkAdapter testFrameworkAdapter;
    private final Log log = LogFactory.getLog(this.getClass());
    private final File reportsRootDir;

    public TestScriptRunnerCommandPlugin() throws IOException {
        this.testFrameworkAdapter = new CucumberTestFrameworkAdapter(AssertOutputStepDefinitions.class, CommonStepDefinitions.class, ComponentStepDefinitions.class, InstanceCommandStepDefinitions.class, InstanceInstantiationStepDefinitions.class, InstanceNetworkingStepDefinitions.class, InstanceStateStepDefinitions.class, RceTestLifeCycleHooks.class, WorkflowStepDefinitions.class);
        this.reportsRootDir = TempFileServiceAccess.getInstance().createManagedTempDir("tsr_reports");
    }

    protected void bindConfigurationService(ConfigurationService configurationService) {
        this.configuration = configurationService.getConfigurationSegment("testScriptRunner");
        String scriptLocation = this.configuration.getString("scriptLocation");
        if (!StringUtils.isNullorEmpty((String)scriptLocation)) {
            this.scriptLocationRoot = new File(scriptLocation);
        } else {
            try {
                this.scriptLocationRoot = configurationService.getUnpackedFilesLocation("testScripts");
            }
            catch (ConfigurationException e) {
                this.log.error((Object)"Failed to locate the default script file location, and no explicit path setting found - disabling TestScriptRunner", (Throwable)e);
                this.scriptLocationRoot = null;
                return;
            }
        }
        this.log.debug((Object)("Using test script folder " + this.scriptLocationRoot));
    }

    private void performRunTests(CommandContext context) throws IOException, CommandException {
        if (context.getOriginalTokens().size() != 3) {
            throw CommandException.syntaxError((String)"Wrong number of parameters\n  Usage: run-test[s] <comma-separated test ids>|--all <build id>\n  Example: run-test Test03 snapshots/trunk", (CommandContext)context);
        }
        String tagNameFilter = context.consumeNextToken();
        if ("--all".equals(tagNameFilter)) {
            tagNameFilter = null;
        }
        String buildUnderTestId = context.consumeNextToken();
        CucumberTestFrameworkAdapter.ExecutionResult result = this.testFrameworkAdapter.executeTestScripts(this.scriptLocationRoot, tagNameFilter, context.getOutputReceiver(), buildUnderTestId, this.reportsRootDir);
        List<String> reportLines = result.getReportFileLines();
        if (reportLines != null) {
            context.println((Object)"");
            context.println((Object)"Test run complete, content of report file:");
            context.println((Object)SEPARATOR_TEXT_LINE);
            for (String line : reportLines) {
                context.println((Object)line);
            }
            context.println((Object)SEPARATOR_TEXT_LINE);
        } else {
            context.println((Object)"Test run complete (no report file found)");
        }
        List<String> stdOutLines = result.getCapturedStdOutLines();
        if (!stdOutLines.isEmpty()) {
            context.println((Object)"");
            context.println((Object)"Captured Output:");
            context.println((Object)SEPARATOR_TEXT_LINE);
            for (String line : stdOutLines) {
                context.println((Object)line);
            }
            context.println((Object)SEPARATOR_TEXT_LINE);
        }
    }

    public MainCommandDescription[] getCommands() {
        MainCommandDescription[] commands = new MainCommandDescription[]{new MainCommandDescription("run-test", "run a test", "run a test", context -> {
            try {
                this.performRunTests(context);
            }
            catch (IOException e) {
                throw CommandException.executionError((String)e.getMessage(), (CommandContext)context);
            }
        }, true, new SubCommandDescription[0]), new MainCommandDescription("run-tests", "(alias of \"run-test\")", "(alias of \"run-test\")", context -> {
            try {
                this.performRunTests(context);
            }
            catch (IOException e) {
                throw CommandException.executionError((String)e.getMessage(), (CommandContext)context);
            }
        }, true, new SubCommandDescription[0])};
        return commands;
    }
}

