/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.switchcmp.gui;

import de.rcenvironment.components.switchcmp.common.SwitchComponentConstants;
import de.rcenvironment.components.switchcmp.gui.Messages;
import de.rcenvironment.core.component.model.endpoint.api.EndpointChange;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.workflow.model.spi.ComponentInstanceProperties;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.gui.resources.api.FontManager;
import de.rcenvironment.core.gui.resources.api.FontSource;
import de.rcenvironment.core.gui.resources.api.StandardFonts;
import de.rcenvironment.core.gui.workflow.editor.properties.ValidatingWorkflowNodePropertySection;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class SwitchConditionSection
extends ValidatingWorkflowNodePropertySection {
    private static final int KEY_CODE_A = 97;
    private StyledText conditionTextfield;
    private Button insertChannelButton;
    private Button insertOpButton;
    private Combo channelCombo;
    private Combo opCombo;

    protected void createCompositeContent(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        parent.setLayout((Layout)new GridLayout(1, false));
        parent.setLayoutData((Object)new GridData(1808));
        Section parentSection = aTabbedPropertySheetPage.getWidgetFactory().createSection(parent, 256);
        parentSection.setLayout((Layout)new GridLayout());
        parentSection.setLayoutData((Object)new GridData(772));
        parentSection.setText(Messages.conditionFieldString);
        super.createCompositeContent(parent, aTabbedPropertySheetPage);
        Composite mainComposite = aTabbedPropertySheetPage.getWidgetFactory().createComposite(parent);
        mainComposite.setLayout((Layout)new GridLayout(2, true));
        mainComposite.setLayoutData((Object)new GridData(1808));
        this.conditionTextfield = new StyledText(mainComposite, 2112);
        this.conditionTextfield.setLayout((Layout)new GridLayout());
        this.conditionTextfield.setFont(FontManager.getInstance().getFont((FontSource)StandardFonts.CONSOLE_TEXT_FONT));
        this.conditionTextfield.setData("property.control", (Object)"conditionKey");
        this.conditionTextfield.setLayoutData((Object)new GridData(1808));
        this.conditionTextfield.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 262144 && e.keyCode == 97) {
                    SwitchConditionSection.this.conditionTextfield.selectAll();
                }
            }
        });
        Composite comboSectionComposite = aTabbedPropertySheetPage.getWidgetFactory().createComposite(mainComposite);
        comboSectionComposite.setLayout((Layout)new GridLayout());
        comboSectionComposite.setLayoutData((Object)new GridData(1808));
        Composite propertiesComposite = aTabbedPropertySheetPage.getWidgetFactory().createComposite(comboSectionComposite);
        propertiesComposite.setLayout((Layout)new GridLayout(3, false));
        propertiesComposite.setLayoutData((Object)new GridData(1044));
        Label opLabel = new Label(propertiesComposite, 0);
        opLabel.setText(Messages.operatorsLabelString);
        opLabel.setBackground(propertiesComposite.getDisplay().getSystemColor(1));
        this.opCombo = new Combo(propertiesComposite, 8);
        this.opCombo.setLayout((Layout)new GridLayout());
        this.opCombo.setLayoutData((Object)new GridData(772));
        this.setComboOperators();
        this.opCombo.pack();
        this.insertOpButton = aTabbedPropertySheetPage.getWidgetFactory().createButton(propertiesComposite, Messages.insertButtonString, 8);
        this.insertOpButton.addListener(13, this.getButtonListener());
        Label channelLabel = new Label(propertiesComposite, 0);
        channelLabel.setText(Messages.channelLabelString);
        channelLabel.setBackground(propertiesComposite.getDisplay().getSystemColor(1));
        this.channelCombo = new Combo(propertiesComposite, 8);
        this.channelCombo.setLayout((Layout)new GridLayout());
        this.channelCombo.setLayoutData((Object)new GridData(772));
        this.channelCombo.pack();
        this.insertChannelButton = aTabbedPropertySheetPage.getWidgetFactory().createButton(propertiesComposite, Messages.insertButtonString, 8);
        this.insertChannelButton.addListener(13, this.getButtonListener());
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        ComponentInstanceProperties config = this.getConfiguration();
        config.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() instanceof EndpointChange) {
                    if (SwitchConditionSection.this.channelCombo.isDisposed()) {
                        return;
                    }
                    SwitchConditionSection.this.setInputChannels();
                }
            }
        });
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.setInputChannels();
    }

    public void setInputChannels() {
        this.channelCombo.removeAll();
        for (EndpointDescription channelName : this.getConfiguration().getInputDescriptionsManager().getDynamicEndpointDescriptions()) {
            this.channelCombo.add(channelName.getName());
        }
        for (EndpointDescription dataName : this.getConfiguration().getInputDescriptionsManager().getStaticEndpointDescriptions()) {
            DataType[] dataTypeArray = SwitchComponentConstants.CONDITION_INPUT_DATA_TYPES;
            int n = SwitchComponentConstants.CONDITION_INPUT_DATA_TYPES.length;
            int n2 = 0;
            while (n2 < n) {
                DataType datatype = dataTypeArray[n2];
                if (datatype.equals((Object)dataName.getDataType())) {
                    this.channelCombo.add(dataName.getName());
                }
                ++n2;
            }
        }
        this.channelCombo.select(0);
    }

    public void refreshSection() {
        super.refreshSection();
        this.refreshBeforeValidation();
    }

    protected void refreshBeforeValidation() {
        this.aboutToBeShown();
    }

    private void setComboOperators() {
        this.opCombo.removeAll();
        this.opCombo.setItems(SwitchComponentConstants.OPERATORS);
        this.opCombo.select(0);
    }

    private Listener getButtonListener() {
        return new Listener(){

            public void handleEvent(Event arg0) {
                if (arg0.widget.equals(SwitchConditionSection.this.insertOpButton)) {
                    String s = String.valueOf(SwitchConditionSection.this.opCombo.getText()) + " ";
                    this.apply(s);
                } else if (arg0.widget.equals(SwitchConditionSection.this.insertChannelButton)) {
                    String s = String.valueOf(SwitchConditionSection.this.channelCombo.getText()) + " ";
                    this.apply(s);
                }
            }

            private void apply(String s) {
                SwitchConditionSection.this.conditionTextfield.insert(s);
                SwitchConditionSection.this.conditionTextfield.setFocus();
                SwitchConditionSection.this.conditionTextfield.setCaretOffset(SwitchConditionSection.this.conditionTextfield.getCaretOffset() + s.length());
            }
        };
    }
}

