/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.mapping.SynchronizationCompareAdapter;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class ResourceModelPersistenceAdapter
extends SynchronizationCompareAdapter {
    private static final String RESOURCES = "resources";
    private static final String RESOURCE_PATH = "resourcePath";
    private static final String RESOURCE_TYPE = "resourceType";
    private static final String WORKING_SETS = "workingSets";
    private static final String WORKING_SET_NAME = "workingSetName";
    private static final String MODEL_PROVIDERS = "modelProviders";
    private static final String MODEL_PROVIDER_ID = "modelProviderId";

    @Override
    public void save(ResourceMapping[] mappings, IMemento memento) {
        int i = 0;
        while (i < mappings.length) {
            IMemento child;
            ResourceMapping mapping = mappings[i];
            Object object = mapping.getModelObject();
            if (object instanceof IResource) {
                IResource resource = (IResource)object;
                child = memento.createChild(RESOURCES);
                child.putInteger(RESOURCE_TYPE, resource.getType());
                child.putString(RESOURCE_PATH, resource.getFullPath().toString());
            } else if (object instanceof IWorkingSet) {
                IWorkingSet ws = (IWorkingSet)object;
                child = memento.createChild(WORKING_SETS);
                child.putString(WORKING_SET_NAME, ws.getName());
            } else if (object instanceof ModelProvider) {
                ModelProvider provider = (ModelProvider)object;
                child = memento.createChild(MODEL_PROVIDERS);
                child.putString(MODEL_PROVIDER_ID, provider.getId());
            }
            ++i;
        }
    }

    @Override
    public ResourceMapping[] restore(IMemento memento) {
        IMemento child;
        IMemento[] children = memento.getChildren(RESOURCES);
        ArrayList<ResourceMapping> result = new ArrayList<ResourceMapping>();
        int i = 0;
        while (i < children.length) {
            child = children[i];
            Integer typeInt = child.getInteger(RESOURCE_TYPE);
            if (typeInt != null) {
                int type = typeInt;
                String pathString = child.getString(RESOURCE_PATH);
                if (pathString != null) {
                    ResourceMapping mapping;
                    IWorkspaceRoot resource;
                    Path path = new Path(pathString);
                    switch (type) {
                        case 8: {
                            resource = ResourcesPlugin.getWorkspace().getRoot();
                            break;
                        }
                        case 4: {
                            resource = ResourcesPlugin.getWorkspace().getRoot().getProject(path.lastSegment());
                            break;
                        }
                        case 1: {
                            resource = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                            break;
                        }
                        case 2: {
                            resource = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)path);
                            break;
                        }
                        default: {
                            resource = null;
                        }
                    }
                    if (resource != null && (mapping = Utils.getResourceMapping(resource)) != null) {
                        result.add(mapping);
                    }
                }
            }
            ++i;
        }
        children = memento.getChildren(WORKING_SETS);
        i = 0;
        while (i < children.length) {
            ResourceMapping mapping;
            IWorkingSet set;
            child = children[i];
            String name = child.getString(WORKING_SET_NAME);
            if (name != null && (set = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(name)) != null && (mapping = Utils.getResourceMapping(set)) != null) {
                result.add(mapping);
            }
            ++i;
        }
        children = memento.getChildren(MODEL_PROVIDERS);
        i = 0;
        while (i < children.length) {
            IModelProviderDescriptor desc;
            child = children[i];
            String id = child.getString(MODEL_PROVIDER_ID);
            if (id != null && (desc = ModelProvider.getModelProviderDescriptor((String)id)) != null) {
                try {
                    ResourceMapping mapping;
                    ModelProvider provider = desc.getModelProvider();
                    if (provider != null && (mapping = Utils.getResourceMapping(provider)) != null) {
                        result.add(mapping);
                    }
                }
                catch (CoreException e) {
                    TeamUIPlugin.log(e);
                }
            }
            ++i;
        }
        return result.toArray(new ResourceMapping[result.size()]);
    }
}

