/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.toolkit.modules.introspection.internal;

import de.rcenvironment.toolkit.modules.introspection.api.StatusCollectionContributor;
import de.rcenvironment.toolkit.modules.introspection.api.StatusCollectionRegistry;
import de.rcenvironment.toolkit.modules.introspection.api.StatusCollectionService;
import de.rcenvironment.toolkit.utils.internal.StringUtils;
import de.rcenvironment.toolkit.utils.text.impl.BufferingTextLinesReceiver;
import de.rcenvironment.toolkit.utils.text.impl.MultiLineOutputWrapper;
import java.util.ArrayList;
import java.util.List;

public class StatusCollectionServiceImpl
implements StatusCollectionService,
StatusCollectionRegistry {
    private final List<StatusCollectionContributor> contributors = new ArrayList<StatusCollectionContributor>();

    @Override
    public synchronized MultiLineOutputWrapper getCollectedDefaultStateInformation() {
        BufferingTextLinesReceiver buffer = new BufferingTextLinesReceiver();
        for (StatusCollectionContributor c : this.contributors) {
            String description = c.getStandardDescription();
            if (description == null) continue;
            buffer.addLine(StringUtils.format("=== %s ===", description));
            c.printDefaultStateInformation(buffer);
        }
        return new MultiLineOutputWrapper(buffer.getCollectedLines());
    }

    @Override
    public synchronized MultiLineOutputWrapper getCollectedUnfinishedOperationsInformation() {
        BufferingTextLinesReceiver buffer = new BufferingTextLinesReceiver();
        for (StatusCollectionContributor c : this.contributors) {
            String description = c.getUnfinishedOperationsDescription();
            if (description == null) continue;
            buffer.addLine(StringUtils.format("=== %s ===", description));
            c.printUnfinishedOperationsInformation(buffer);
        }
        return new MultiLineOutputWrapper(buffer.getCollectedLines());
    }

    @Override
    public synchronized void addContributor(StatusCollectionContributor contributor) {
        this.contributors.add(contributor);
    }
}

