/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.script.execution.jython;

import de.rcenvironment.components.script.common.ScriptComponentHistoryDataItem;
import de.rcenvironment.components.script.execution.DefaultScriptExecutor;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.ComponentHistoryDataItem;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.scripting.WorkflowConsoleForwardingWriter;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.scripting.ScriptingService;
import de.rcenvironment.core.scripting.ScriptingUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.scripting.ScriptLanguage;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;

@Component
public class JythonScriptExecutor
extends DefaultScriptExecutor {
    protected static ScriptingService scriptingService;
    private static final String QUOTE = "\"";
    private static final String ESCAPESLASH = "\\\\";
    private static final String SLASH = "/";
    private static final Log LOGGER;
    protected String preHeader;
    protected String header;
    protected String inputFile;
    protected String orderedDictionary;
    protected String body;
    protected String foot;
    protected File jythonPath;
    protected String workingPath = "";

    static {
        LOGGER = LogFactory.getLog(JythonScriptExecutor.class);
    }

    public boolean prepareExecutor(ComponentContext componentContext) throws ComponentException {
        boolean successful = super.prepareExecutor(componentContext);
        try {
            this.jythonPath = ScriptingUtils.getJythonPath();
        }
        catch (IOException e) {
            throw new ComponentException("Internal error: Failed to intialize Jython", (Throwable)e);
        }
        if (this.jythonPath == null) {
            throw new ComponentException("Internal error: Failed to intialize Jython");
        }
        File scripts = new File(this.tempDir, "scripts");
        File file = new File(scripts, "script.tmp");
        this.workingPath = scripts.getParentFile().getAbsolutePath();
        this.workingPath = this.workingPath.replaceAll(ESCAPESLASH, SLASH);
        this.tempFiles.add(file);
        this.stateMap = new HashMap();
        scriptingService = (ScriptingService)componentContext.getService(ScriptingService.class);
        typedDatumFactory = ((TypedDatumService)componentContext.getService(TypedDatumService.class)).getFactory();
        return successful;
    }

    public void prepareNewRun(ScriptLanguage scriptLanguage, String userScript, ScriptComponentHistoryDataItem dataItem) throws ComponentException {
        this.historyDataItem = dataItem;
        this.scriptEngine = scriptingService.createScriptEngine(scriptLanguage);
        this.body = "";
        this.foot = "";
        this.header = ScriptingUtils.prepareHeaderScript((Map)this.stateMap, (ComponentContext)this.componentContext, (File)this.tempDir, (List)this.tempFiles);
        this.orderedDictionary = ScriptingUtils.prepareOrderedDictionaryScript();
        this.inputFile = ScriptingUtils.prepareInputFileFactoryScript((String)this.workingPath);
        this.loadScript(userScript);
        this.foot = "\nRCE_Dict_OutputChannels = RCE.get_output_internal()\nRCE_CloseOutputChannelsList = RCE.get_closed_outputs_internal()\nRCE_writtenInputFiles = RCE.get_written_input_files()\n" + StringUtils.format((String)"sys.stdout.write('%s')\nsys.stderr.write('%s')\nsys.stdout.flush()\nsys.stderr.flush()", (Object[])new Object[]{"c02abd1c-67bc-4974-902b-439cd2b14efc", "c02abd1c-67bc-4974-902b-439cd2b14efc"});
    }

    private void loadScript(String userScript) throws ComponentException {
        this.body = userScript;
        if (this.body == null || this.body.trim().isEmpty()) {
            throw new ComponentException("No Python script configured");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runScript() throws ComponentException {
        Object object = ScriptingUtils.SCRIPT_EVAL_LOCK_OBJECT;
        synchronized (object) {
            this.prepareOutputForRun();
            try {
                this.scriptEngine.eval("RCE_Bundle_Jython_Path = \"" + this.jythonPath.getAbsolutePath().replaceAll(ESCAPESLASH, SLASH) + QUOTE);
                this.scriptEngine.eval("RCE_Temp_working_path = \"" + this.workingPath + QUOTE);
                this.scriptEngine.eval(this.header);
                this.scriptEngine.eval(this.orderedDictionary);
                this.scriptEngine.eval(this.inputFile);
            }
            catch (IOError | ScriptException e) {
                throw new ComponentException("Failed to execute script that is wrapped around the actual script", e);
            }
            try {
                this.scriptEngine.eval(this.body);
            }
            catch (IOError e) {
                throw new ComponentException("Failed to execute script", (Throwable)e);
            }
            catch (ScriptException e) {
                if (e.getCause() != null) {
                    throw new ComponentException("Script execution error: " + e.getMessage() + "\n" + e.getCause().toString());
                }
                throw new ComponentException("Script execution error: " + e.getMessage());
            }
            try {
                this.scriptEngine.eval(this.foot);
                ((WorkflowConsoleForwardingWriter)this.scriptEngine.getContext().getWriter()).awaitPrintingLinesFinished();
                ((WorkflowConsoleForwardingWriter)this.scriptEngine.getContext().getErrorWriter()).awaitPrintingLinesFinished();
            }
            catch (IOError | ScriptException e) {
                throw new ComponentException("Failed to execute script that is wrapped around the actual script", e);
            }
            catch (InterruptedException interruptedException) {
                this.componentContext.getLog().componentError("Waiting for script output was interrupted. Some output might be missing");
                LOGGER.error((Object)"Waiting for stdout or stderr of Jython script execution was interrupted");
            }
        }
    }

    public boolean postRun() throws ComponentException {
        ScriptingUtils.writeAPIOutput((Map)this.stateMap, (ComponentContext)this.componentContext, (ScriptEngine)this.scriptEngine, (String)this.workingPath, (ComponentHistoryDataItem)this.historyDataItem);
        try {
            this.closeConsoleWriters();
        }
        catch (IOException e) {
            LOGGER.error((Object)"Failed to close stdout or stderr writer", (Throwable)e);
        }
        this.deleteTempFiles();
        return true;
    }

    public void setWorkingPath(String workingPath) {
        this.workingPath = workingPath;
    }

    public void cancelScript() {
    }

    public boolean isCancelable() {
        return false;
    }

    public void tearDown() {
        this.deleteTempFiles();
    }
}

