/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.cpacs.writer.gui.properties;

import de.rcenvironment.components.cpacs.writer.gui.properties.Messages;
import de.rcenvironment.core.gui.workflow.editor.properties.ValidatingWorkflowNodePropertySection;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodePropertySection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class CpacsWriterSection
extends ValidatingWorkflowNodePropertySection {
    private static final int FOLDER_TEXTFIELD_WIDTH = 300;
    private Button fileChooser;
    private Composite fileGroup;
    private Text filePath;
    private Button checkIncremental;

    protected void createCompositeContent(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        TabbedPropertySheetWidgetFactory toolkit = aTabbedPropertySheetPage.getWidgetFactory();
        WorkflowNodePropertySection.LayoutComposite content = new WorkflowNodePropertySection.LayoutComposite(parent);
        content.setLayout((Layout)new GridLayout(1, true));
        Composite fileChoosingSection = toolkit.createFlatFormComposite((Composite)content);
        this.initFileChoosingSection(toolkit, fileChoosingSection);
    }

    private void initFileChoosingSection(TabbedPropertySheetWidgetFactory toolkit, Composite container) {
        GridData layoutData = new GridData(770);
        container.setLayoutData((Object)layoutData);
        container.setLayout((Layout)new FillLayout());
        Section section = toolkit.createSection(container, 320);
        section.setText(Messages.fileChoosingSectionName);
        Composite client = toolkit.createComposite((Composite)section);
        layoutData = new GridData(768);
        client.setLayoutData((Object)layoutData);
        client.setLayout((Layout)new GridLayout(1, false));
        Label localFolderTitle = new Label(client, 85);
        localFolderTitle.setText(Messages.localFolderTitle);
        this.fileGroup = toolkit.createComposite(client);
        this.fileGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 768;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 300;
        this.filePath = toolkit.createText(this.fileGroup, "", 4);
        this.filePath.setData("property.control", (Object)"localFolder");
        this.filePath.setLayoutData((Object)gridData);
        this.fileChooser = toolkit.createButton(this.fileGroup, Messages.fileLinkButtonLabel, 8);
        this.checkIncremental = toolkit.createButton(this.fileGroup, Messages.overwrite, 0x800020);
        this.checkIncremental.setData("property.control", (Object)"saveMode");
        section.setClient((Control)client);
    }

    private void fileChoosing() {
        String path = this.getProperty("localFolder");
        DirectoryDialog dialog = new DirectoryDialog(this.fileGroup.getShell());
        dialog.setFilterPath(path);
        dialog.setMessage(Messages.loadMessage);
        dialog.setText(Messages.loadTitle);
        String newPath = dialog.open();
        if (newPath != null) {
            newPath = newPath.trim();
            while (newPath.endsWith("/") || newPath.endsWith("\\")) {
                newPath = newPath.substring(0, newPath.length() - 1).trim();
            }
            if (!newPath.trim().isEmpty()) {
                this.setProperty("localFolder", newPath);
                this.refreshSection();
            }
        }
    }

    protected void refreshBeforeValidation() {
        this.fileGroup.pack(true);
    }

    protected WorkflowNodePropertySection.Controller createController() {
        return new FileController();
    }

    private final class FileController
    extends WorkflowNodePropertySection.DefaultController {
        private FileController() {
            super((WorkflowNodePropertySection)CpacsWriterSection.this);
        }

        protected void widgetSelected(SelectionEvent event, Control source) {
            super.widgetSelected(event, source);
            if (source == CpacsWriterSection.this.fileChooser) {
                CpacsWriterSection.this.fileChoosing();
            }
        }
    }
}

