/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render.output.javafx;

import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import org.jpedal.color.PdfPaint;
import org.jpedal.examples.javafx.JavaFXFontMapper;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.render.output.FontMapper;
import org.jpedal.render.output.OutputDisplay;
import org.jpedal.render.output.TextBlock;
import org.jpedal.render.output.javafx.JavaFXHelper;
import org.jpedal.render.output.javafx.JavaFXShape;

public class JavaFXDisplay
extends OutputDisplay {
    private static final String separator = System.getProperty("file.separator");
    String packageName = "";
    private int shapeCount = 0;
    private String textName;
    private String imagePrefix = null;
    private String javaFxFileName = "";
    private String firstPageName = System.getProperty("org.jpedal.pdf2javafx.firstPageName");

    public JavaFXDisplay(int n, Point2D point2D, Rectangle rectangle, boolean bl, int n2, ObjectStore objectStore) {
        super(n, point2D, rectangle, bl, n2, objectStore);
        this.type = 5;
        Helper = new JavaFXHelper();
    }

    public static String getDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd - MMMMM - yyyy");
        Date date = new Date();
        return simpleDateFormat.format(date);
    }

    protected void completeOutput() {
        this.flushText();
        String string = this.rootDir.substring(0, this.rootDir.length() - 1);
        Boolean bl = false;
        if (this.pageData.getPageCount() == 1) {
            bl = true;
        }
        this.writeCustom(0, "/**");
        this.writeCustom(0, "* ===========================================");
        this.writeCustom(0, "* Java Pdf Extraction Decoding Access Library");
        this.writeCustom(0, "* ===========================================");
        this.writeCustom(0, "*");
        this.writeCustom(0, "* Project Info:  http://www.jpedal.org");
        this.writeCustom(0, "*");
        this.writeCustom(0, "* generated by JPedal PDF to javaFX");
        this.writeCustom(0, "*");
        this.writeCustom(0, "* --------------------------------------------");
        this.writeCustom(0, "* page" + this.pageNumberAsString + ".java");
        this.writeCustom(0, "* --------------------------------------------");
        this.writeCustom(0, "* --------------------------------------------");
        this.writeCustom(0, "* " + JavaFXDisplay.getDate());
        this.writeCustom(0, "* --------------------------------------------");
        this.writeCustom(0, "*/");
        this.writeCustom(0, "");
        this.writeCustom(0, "package " + this.packageName + ";");
        this.writeCustom(0, "");
        this.writeCustom(0, "");
        this.writeCustom(0, "import java.io.File;");
        this.writeCustom(0, "import javafx.application.Application;");
        this.writeCustom(0, "import javafx.scene.Group;");
        this.writeCustom(0, "import javafx.scene.Scene;");
        this.writeCustom(0, "import javafx.scene.Node;");
        this.writeCustom(0, "import javafx.scene.paint.Color;");
        this.writeCustom(0, "import javafx.scene.shape.*;");
        this.writeCustom(0, "import javafx.stage.Stage;");
        this.writeCustom(0, "import javafx.collections.ObservableList;");
        this.writeCustom(0, "import javafx.scene.text.*;");
        this.writeCustom(0, "import javafx.scene.layout.BorderPane;");
        this.writeCustom(0, "import javafx.scene.image.Image;");
        this.writeCustom(0, "import javafx.scene.image.ImageView;");
        if (!bl.booleanValue()) {
            this.writeCustom(0, "import javafx.scene.input.MouseEvent;");
            this.writeCustom(0, "import javafx.scene.layout.HBox;");
            this.writeCustom(0, "import javafx.scene.effect.*;");
            this.writeCustom(0, "import javafx.geometry.Pos;");
            this.writeCustom(0, "import javafx.event.EventHandler;");
            this.writeCustom(0, "import javafx.event.ActionEvent;");
            this.writeCustom(0, "import javafx.scene.control.*;");
            this.writeCustom(0, "import java.lang.reflect.Method;");
            this.writeCustom(0, "import java.net.URI;");
            this.writeCustom(0, "import java.net.URISyntaxException;");
            this.writeCustom(0, "import java.util.logging.Level;");
            this.writeCustom(0, "import java.util.logging.Logger;");
            this.writeCustom(0, "import java.io.IOException;");
        }
        this.writeCustom(0, " ");
        this.writeCustom(0, " ");
        this.writeCustom(0, "public class " + this.javaFxFileName + " extends Application {");
        this.writeCustom(0, " ");
        this.writeCustom(0, "  BorderPane root;");
        this.writeCustom(0, "  Stage primaryStage;");
        this.writeCustom(0, "  Scene scene;");
        this.writeCustom(0, " ");
        this.writeCustom(0, " ");
        this.writeCustom(0, "\tpublic static void main(String[] args) {");
        this.writeCustom(0, "\t\tApplication.launch(args);");
        this.writeCustom(0, "\t}");
        this.writeCustom(0, " ");
        this.writeCustom(0, "\tpublic void start(Stage primaryStage) { ");
        this.writeCustom(0, "\t\tthis.primaryStage = primaryStage;");
        this.writeCustom(0, "\t\troot = new BorderPane();");
        this.writeCustom(0, "\t\tscene = new Scene(root, " + this.pageData.getCropBoxWidth(this.pageNumber) + ", " + (this.pageData.getCropBoxHeight(this.pageNumber) + 75) + ");");
        this.writeCustom(0, "\t\t//draw first page");
        this.writeCustom(0, "\t\tdrawPage(primaryStage, root, scene); //actual execution of commands");
        this.writeCustom(0, "");
        this.writeCustom(0, "\t}");
        this.writeCustom(0, "\n\tpublic static void drawPage(Stage primaryStage, BorderPane root, Scene scene) {");
        this.writeCustom(0, "\t\t");
        this.writeCustom(0, "\t\tprimaryStage.setWidth(" + this.pageData.getCropBoxWidth(this.pageNumber) + ");");
        this.writeCustom(0, "\t\tprimaryStage.setHeight(" + (this.pageData.getCropBoxHeight(this.pageNumber) + 75) + ");");
        this.writeCustom(0, "\t\tprimaryStage.centerOnScreen();");
        this.writeCustom(0, "\t\troot.getChildren().clear();");
        this.writeCustom(0, "\t\t");
        this.writeCustom(0, "\t\tString imageDir = \"" + string + "\";");
        this.writeCustom(0, "\t\tFile checkExists=new File(imageDir);");
        this.writeCustom(0, "\t\tif(!checkExists.exists()){");
        this.writeCustom(0, "\t\t\tthrow new RuntimeException(\"Unable to find Image location - please alter imageDir in drawPage()\");");
        this.writeCustom(0, "\t\t}\n");
        this.writeCustom(0, "\t\tObservableList<Node> addToGroup;");
        this.writeCustom(0, "\t\t");
        this.writeCustom(0, "\t\tGroup pdfContent = new Group();");
        this.writeCustom(0, "\t\troot.setCenter(pdfContent);");
        this.writeCustom(0, "\t\taddToGroup = pdfContent.getChildren();");
        try {
            if (this.script.length() < 174080) {
                this.writeCustom(0, this.script.toString());
            } else {
                this.writeCustom(0, "\n\t\tReflection r = new Reflection();");
                this.writeCustom(0, "\t\tr.setFraction(0.7f);");
                this.writeCustom(0, "");
                this.writeCustom(0, "\t\tText textBox = new Text(\"File too large\");");
                this.writeCustom(0, "\t\taddToGroup.add(textBox);");
                this.writeCustom(0, "\t\ttextBox.setEffect(r);");
                this.writeCustom(0, "\t\ttextBox.setFont(Font.font(null, FontWeight.BOLD, 30));");
                this.writeCustom(0, "\t\ttextBox.setFill(Color.rgb(255,0,0));");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!bl.booleanValue()) {
            this.writeCustom(0, "\t\tprimaryStage.setTitle(\"" + this.packageName + " page " + this.pageNumber + "\");");
            this.writeCustom(0, "\t\taddNav(root, primaryStage, scene);");
        } else {
            this.writeCustom(0, "\t\tprimaryStage.setTitle(\"" + this.packageName + "\");");
        }
        this.writeCustom(0, "\t}\n");
        this.writeCustom(0, "\tprivate static void setTextsize(Text textBox, float requiredWidth) {");
        this.writeCustom(0, "\t\tfloat actualWidth=(int) textBox.getLayoutBounds().getWidth();");
        this.writeCustom(0, "\t\tfloat dx=requiredWidth-actualWidth;");
        this.writeCustom(0, "\t\tfloat scalingNeeded=requiredWidth/actualWidth;");
        this.writeCustom(0, "\t\ttextBox.setScaleX(scalingNeeded);");
        this.writeCustom(0, "\t\ttextBox.setScaleY(scalingNeeded);");
        this.writeCustom(0, "\t\ttextBox.setTranslateX(dx/2);");
        this.writeCustom(0, "\t}");
        if (!bl.booleanValue()) {
            String string2 = "page" + this.pageNumberAsString;
            if (this.firstPageName != null && this.firstPageName.length() > 0 && this.pageNumber == 1) {
                string2 = this.firstPageName;
            }
            this.writeCustom(0, "\n\tprivate static void addNav(BorderPane root, Stage primaryStage, Scene scene) {");
            this.writeCustom(0, "");
            this.writeCustom(0, "\t\tString imageDir = \"" + string + "\";");
            this.writeCustom(0, "");
            this.writeCustom(0, "\t\t//----- naviBar -----");
            this.writeCustom(0, "\t\tHBox naviBar = new HBox();");
            this.writeCustom(0, "\t\tnaviBar.setStyle(\"-fx-background-color: #F0F8FF; -fx-text-fill: white;\");");
            this.writeCustom(0, "\t\tButton start = makeButtons(\"smstart.gif\",\"Go to first Page\",0, root, primaryStage, scene);");
            this.writeCustom(0, "\t\tButton back = makeButtons(\"smback.gif\",\"Go back 1 page\",-1, root, primaryStage, scene);");
            this.writeCustom(0, "\t\tButton fback = makeButtons(\"smfback.gif\",\"Go back 10 pages\",-10, root, primaryStage, scene);");
            this.writeCustom(0, "\t\tString currentPageAsString= String.valueOf(" + this.pageNumber + ");");
            this.writeCustom(0, "\t\tTextField currentPage = makeTextField(false, currentPageAsString);");
            this.writeCustom(0, "\t\tLabel colon = makeLabel(\":\");");
            this.writeCustom(0, "\t\tString numberOfPagesAsString= String.valueOf(" + this.pageData.getPageCount() + ");");
            this.writeCustom(0, "\t\tTextField numberOfPages = makeTextField(false, numberOfPagesAsString);");
            this.writeCustom(0, "\t\tButton forward = makeButtons(\"smforward.gif\",\"Go forward 1 page\",1, root, primaryStage, scene);");
            this.writeCustom(0, "\t\tButton fforward = makeButtons(\"smfforward.gif\",\"Go forward 10 pages\",10, root, primaryStage, scene);");
            this.writeCustom(0, "\t\tButton end = makeButtons(\"smend.gif\",\"Go to last page\",9999, root, primaryStage, scene);");
            this.writeCustom(0, "");
            this.writeCustom(0, "\t\t//Logo with hyperlink to website");
            this.writeCustom(0, "\t\tImage logo = new Image(imageDir+\"/img/icons/logo.gif\", false);");
            this.writeCustom(0, "");
            this.writeCustom(0, "\t\tHyperlink hyperLinkLogo = new Hyperlink(\"\",new ImageView(logo));");
            this.writeCustom(0, "\t\thyperLinkLogo.tooltipProperty().set(new Tooltip(\"Visit our website\"));");
            this.writeCustom(0, "\t\thyperLinkLogo.setOnAction(new EventHandler<ActionEvent>() {");
            this.writeCustom(0, "");
            this.writeCustom(0, "\t\t\tpublic void handle(ActionEvent event) {");
            this.writeCustom(0, "\t\t\t\ttry {");
            this.writeCustom(0, "\t\t\t\t\ttry {");
            this.writeCustom(0, "\t\t\t\t\t\tjava.awt.Desktop.getDesktop().browse(new URI(\"http://www.jpedal.org/html_index.php\"));");
            this.writeCustom(0, "\t\t\t\t\t} catch (URISyntaxException ex) {");
            this.writeCustom(0, "\t\t\t\t\t\tLogger.getLogger(" + string2 + ".class.getName()).log(Level.SEVERE, null, ex);");
            this.writeCustom(0, "\t\t\t\t\t}");
            this.writeCustom(0, "\t\t\t\t} catch (IOException ex) {");
            this.writeCustom(0, "\t\t\t\t\tLogger.getLogger(" + string2 + ".class.getName()).log(Level.SEVERE, null, ex);");
            this.writeCustom(0, "\t\t\t\t}");
            this.writeCustom(0, "\t\t\t}");
            this.writeCustom(0, "");
            this.writeCustom(0, "\t\t});");
            this.writeCustom(0, "");
            this.writeCustom(0, "\t\tnaviBar.getChildren().addAll(start, fback, back, currentPage, colon, numberOfPages, forward, fforward, end, hyperLinkLogo);");
            this.writeCustom(0, "\t\tnaviBar.setSpacing(5);");
            this.writeCustom(0, "\t\tnaviBar.setPrefHeight(35);");
            this.writeCustom(0, "\t\tnaviBar.setAlignment(Pos.CENTER);");
            this.writeCustom(0, "\t\troot.setBottom(naviBar);");
            this.writeCustom(0, "\t\tprimaryStage.setScene(scene); ");
            this.writeCustom(0, "\t\tprimaryStage.show(); ");
            this.writeCustom(0, "\t} ");
            this.writeCustom(0, "\n\tprivate static Label makeLabel(String text) {");
            this.writeCustom(0, "\t\tLabel label = new Label();");
            this.writeCustom(0, "\t\tlabel.setText(text);");
            this.writeCustom(0, "\t\treturn label;");
            this.writeCustom(0, "\t}");
            this.writeCustom(0, "\n\tprivate static TextField makeTextField(Boolean check, String text) {");
            this.writeCustom(0, "\t\tTextField textfield = new TextField();");
            this.writeCustom(0, "\t\ttextfield.setEditable(check);");
            this.writeCustom(0, "\t\ttextfield.setText(text);");
            this.writeCustom(0, "\t\ttextfield.setMaxHeight(25);");
            this.writeCustom(0, "\t\ttextfield.setMaxWidth(50);");
            this.writeCustom(0, "\t\ttextfield.setPromptText(text);");
            this.writeCustom(0, "\t\treturn textfield;");
            this.writeCustom(0, "\t}");
            this.writeCustom(0, "\n\tprivate static Button makeButtons(String iconName, String toolTip, final int change, final BorderPane root, final Stage primaryStage, final Scene scene) {");
            this.writeCustom(0, "\t\tfinal int pageNumber= " + this.pageNumber + ",pageCount= " + this.pageData.getPageCount() + ";");
            this.writeCustom(0, "");
            this.writeCustom(0, "\t\tString imageDir = \"" + string + "\";");
            this.writeCustom(0, "\t\tFile checkExists=new File(imageDir);");
            this.writeCustom(0, "\t\tif(!checkExists.exists())");
            this.writeCustom(0, "\t\t\tthrow new RuntimeException(\"icon location in makeButtons() method cannot be found - please change imageDir to new location\");\n");
            this.writeCustom(0, "\t\tButton button = new Button();");
            this.writeCustom(0, "\t\tbutton.setTooltip(new Tooltip(toolTip));");
            this.writeCustom(0, "\t\t");
            this.writeCustom(0, "\t\tImage image = new Image(imageDir + \"/img/icons/\"+iconName,false);");
            this.writeCustom(0, "\t\tif (image != null) ");
            this.writeCustom(0, "\t\t\tbutton.setGraphic(new ImageView(image));");
            this.writeCustom(0, "\t\t");
            this.writeCustom(0, "\t\tcreatePressedLook(button);");
            this.writeCustom(0, "\t\t");
            this.writeCustom(0, "\t\t//event handler");
            this.writeCustom(0, "\t\t");
            this.writeCustom(0, "\t\tbutton.setOnAction(new EventHandler<ActionEvent>() {");
            this.writeCustom(0, "\t\t");
            this.writeCustom(0, "\t\t\tpublic void handle(ActionEvent event) {");
            this.writeCustom(0, "\t\t\t\tint newPage = 0;");
            this.writeCustom(0, "\t\t\t\t");
            this.writeCustom(0, "\t\t\t\tif (change == 0){ //special case 1st page");
            this.writeCustom(0, "\t\t\t\t\tnewPage = 1;");
            this.writeCustom(0, "\t\t\t\t} else if (change == 9999) {");
            this.writeCustom(0, "\t\t\t\t\tnewPage = pageCount;");
            this.writeCustom(0, "\t\t\t\t} else {");
            this.writeCustom(0, "\t\t\t\t\tnewPage = pageNumber + (change);");
            this.writeCustom(0, "\t\t\t\t}");
            this.writeCustom(0, "\t\t\t\t");
            this.writeCustom(0, "\t\t\t\t//error check for bounds");
            this.writeCustom(0, "\t\t\t\tif (newPage < 1) {");
            this.writeCustom(0, "\t\t\t\t\tnewPage = 1;");
            this.writeCustom(0, "\t\t\t\t}else if (newPage > pageCount) {");
            this.writeCustom(0, "\t\t\t\t\tnewPage = pageCount;");
            this.writeCustom(0, "\t\t\t\t}");
            this.writeCustom(0, "\t\t\t\t");
            if (this.firstPageName != null && this.firstPageName.length() > 0) {
                this.writeCustom(0, "\t\t\t\tString customClassName = \"" + this.packageName + "." + this.firstPageName + "\";");
                this.writeCustom(0, "\t\t\t\tBoolean customFirstPage = false;");
            }
            this.writeCustom(0, "\t\t\t\t");
            this.writeCustom(0, "\t\t\t\tString newPageAsString = String.valueOf(newPage);");
            if (this.firstPageName != null && this.firstPageName.length() > 0) {
                this.writeCustom(0, "\t\t\t\t");
                this.writeCustom(0, "\t\t\t\tif(newPageAsString.equals(\"1\"))");
                this.writeCustom(0, "\t\t\t\t\tcustomFirstPage=true;");
                this.writeCustom(0, "\t\t\t\t");
            }
            this.writeCustom(0, "\t\t\t\tString maxNumberOfPages = String.valueOf(pageCount);");
            this.writeCustom(0, "\t\t\t\tint padding = maxNumberOfPages.length() - newPageAsString.length();");
            this.writeCustom(0, "\t\t\t\tfor (int ii = 0; ii < padding; ii++) {");
            this.writeCustom(0, "\t\t\t\tnewPageAsString = '0' + newPageAsString;");
            this.writeCustom(0, "\t\t\t\t}");
            this.writeCustom(0, "\t\t\t\t");
            if (this.firstPageName != null && this.firstPageName.length() > 0) {
                this.writeCustom(0, "\t\t\t\t//workout new class from pageNumber");
                this.writeCustom(0, "\t\t\t\tString newClass=\"\";");
                this.writeCustom(0, "\t\t\t\t");
                this.writeCustom(0, "\t\t\t\tif(customFirstPage)");
                this.writeCustom(0, "\t\t\t\t\tnewClass=customClassName;");
                this.writeCustom(0, "\t\t\t\telse");
                this.writeCustom(0, "\t\t\t\t\tnewClass=\"" + this.packageName + ".page" + "\"+newPageAsString;");
            } else {
                this.writeCustom(0, "\t\t\t\t//workout new class from pageNumber");
                this.writeCustom(0, "\t\t\t\tString newClass=\"" + this.packageName + ".page" + "\"+newPageAsString;");
            }
            this.writeCustom(0, "\t\t\t\t");
            this.writeCustom(0, "\t\t\t\t//create an instance");
            this.writeCustom(0, "\t\t\t\ttry {");
            this.writeCustom(0, "\t\t\t\tClass c = Class.forName(newClass);");
            this.writeCustom(0, "\t\t\t\tApplication nextPage=(javafx.application.Application)c.newInstance();");
            this.writeCustom(0, "\t\t\t\t");
            this.writeCustom(0, "\t\t\t\tMethod m = c.getMethod(\"drawPage\", new Class[]{Stage.class, BorderPane.class, Scene.class});");
            this.writeCustom(0, "\t\t\t\tm.invoke(nextPage, new Object[]{primaryStage, root, scene});");
            this.writeCustom(0, "\t\t\t\t");
            this.writeCustom(0, "\t\t\t\t} catch (Exception e) {");
            this.writeCustom(0, "\t\t\t\t\te.printStackTrace();");
            this.writeCustom(0, "\t\t\t\t}");
            this.writeCustom(0, "\t\t\t}");
            this.writeCustom(0, "\t\t});");
            this.writeCustom(0, "\t\t\t\t");
            this.writeCustom(0, "\t\treturn button;");
            this.writeCustom(0, "\t}");
            this.writeCustom(0, "\n\tprivate static void createPressedLook(final Button button) {");
            this.writeCustom(0, "\t\tfinal DropShadow shadow = new DropShadow();");
            this.writeCustom(0, "\t\tshadow.setColor(Color.rgb(41, 36, 33));");
            this.writeCustom(0, "\t\t");
            this.writeCustom(0, "\t\t//Adding the shadow when the button is clicked");
            this.writeCustom(0, "\t\tbutton.addEventHandler(MouseEvent.MOUSE_PRESSED,");
            this.writeCustom(0, "\t\t\tnew EventHandler<MouseEvent>() {");
            this.writeCustom(0, "\t\t");
            this.writeCustom(0, "\t\t\t\t@Override");
            this.writeCustom(0, "\t\t\t\tpublic void handle(MouseEvent e) {");
            this.writeCustom(0, "\t\t\t\t\tbutton.setEffect(shadow);");
            this.writeCustom(0, "\t\t\t\t}");
            this.writeCustom(0, "\t\t\t});");
            this.writeCustom(0, "\t\t//Removing the shadow when the button is released");
            this.writeCustom(0, "\t\tbutton.addEventHandler(MouseEvent.MOUSE_RELEASED,");
            this.writeCustom(0, "\t\t\tnew EventHandler<MouseEvent>() {");
            this.writeCustom(0, "\t\t");
            this.writeCustom(0, "\t\t\t\t@Override");
            this.writeCustom(0, "\t\t\t\tpublic void handle(MouseEvent e) {");
            this.writeCustom(0, "\t\t\t\t\tbutton.setEffect(null);");
            this.writeCustom(0, "\t\t\t\t}");
            this.writeCustom(0, "\t\t\t});");
            this.writeCustom(0, "\t}");
        }
        this.writeCustom(0, "}");
        this.writeCustom(0, "");
        try {
            this.output.flush();
            this.output.close();
            this.output = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void writeoutJavaFXText() {
        float f;
        int n;
        if (this.currentTextBlock.isEmpty()) {
            throw new RuntimeException("writeoutTextAsDiv() called incorrectly.  Attempted to write out text with empty text block use flushText.");
        }
        this.textName = "textBox_" + this.textID;
        this.writeCustom(2, "\n\t\tText " + this.textName + " = new Text(" + (float)((int)this.currentTextBlock.getX()) * this.scaling + " , " + (float)((int)(this.currentTextBlock.getY() + (float)this.fontSize)) * this.scaling + ", \"" + JavaFXDisplay.tidyQuotes(this.currentTextBlock.getOutputString(true)) + "\");");
        this.writeCustom(2, "\taddToGroup.add(" + this.textName + ");");
        String string = this.currentTextBlock.getWeight();
        String string2 = "";
        if (string.equals("normal")) {
            string2 = "NORMAL";
        } else if (string.equals("bold")) {
            string2 = "BOLD";
        } else if (string.equals("bolder")) {
            string2 = "BLACK";
        } else if (string.equals("lighter")) {
            string2 = "EXTRA_LIGHT";
        } else if (string.equals("100")) {
            string2 = "THIN";
        } else if (string.equals("900")) {
            string2 = "BLACK";
        }
        String string3 = this.currentTextBlock.getStyle();
        if (string3.equals("normal")) {
            this.writeCustom(2, "\t" + this.textName + ".setFont(Font.font(\"" + this.currentTextBlock.getFont() + "\", FontWeight." + string2 + ", FontPosture.REGULAR," + (float)this.currentTextBlock.getFontSize() * this.scaling + "));");
        } else {
            this.writeCustom(2, "\t" + this.textName + ".setFont(Font.font(\"" + this.currentTextBlock.getFont() + "\", FontWeight." + string2 + ", FontPosture.ITALIC," + (float)this.currentTextBlock.getFontSize() * this.scaling + "));");
        }
        this.writeCustom(2, "\tsetTextsize(" + this.textName + "," + (int)(this.currentTextBlock.getWidth() * this.scaling) + ");");
        if (this.currentTextBlock.getColor() != -14475232) {
            this.writeCustom(2, "\t" + this.textName + ".setFill(Color." + JavaFXDisplay.rgbToColor(this.currentTextBlock.getColor()) + ");");
        }
        if ((n = (int)((double)((f = this.currentTextBlock.getRotationAngle()) * 180.0f) / Math.PI)) < 0) {
            n += 360;
        }
        if (f == 0.0f && !this.writeEveryGlyf) {
            this.writeCustom(2, "\t" + this.textName + ".translateYProperty().set(0);");
            this.writeCustom(2, "\t" + this.textName + ".scaleYProperty().set(1);");
        }
        switch (n) {
            case 90: {
                this.writeCustom(2, "\t" + this.textName + ".rotateProperty().set(" + n + ");");
                break;
            }
            case 270: {
                this.writeCustom(2, "\t" + this.textName + ".rotateProperty().set(" + n + ");");
            }
        }
        ++this.textID;
    }

    private static String tidyQuotes(String string) {
        string = string.replaceAll("\"", "\\\\\"");
        return string;
    }

    public void setBooleanValue(int n, boolean bl) {
        switch (n) {
            case 4: {
                this.includeJSFontResizingCode = bl;
                break;
            }
            case 5: {
                this.putTextOnCanvas = bl;
                break;
            }
            default: {
                super.setBooleanValue(n, bl);
            }
        }
    }

    public void setTag(int n, String string) {
        switch (n) {
            case 0: {
                this.tag[0] = string;
                break;
            }
            default: {
                super.setTag(n, string);
            }
        }
    }

    public void drawEmbeddedText(float[][] fArray, int n, PdfGlyph pdfGlyph, Object object, int n2, GraphicsState graphicsState, AffineTransform affineTransform, String string, PdfFont pdfFont) {
        super.drawEmbeddedText(fArray, n, pdfGlyph, object, n2, graphicsState, affineTransform, string, pdfFont);
    }

    public void drawShape(Shape shape, GraphicsState graphicsState, int n) {
        super.drawShape(shape, graphicsState, n);
    }

    public int drawImage(int n, BufferedImage bufferedImage, GraphicsState graphicsState, boolean bl, String string, int n2, int n3) {
        int n4 = super.drawImage(n, bufferedImage, graphicsState, bl, string, n2, n3);
        if (n4 == -2) {
            float f = graphicsState.getAlpha(2);
            if (f < 1.0f) {
                this.writeCustom(2, "pdf_context.globalAlpha = " + f + "; ");
            }
            switch (this.pageRotation) {
                case 90: {
                    this.writeCustom(2, "\n\t\t/**");
                    this.writeCustom(2, "\t* Image properties for " + string);
                    this.writeCustom(2, "\t*/ ");
                    this.writeCustom(2, "\tImage " + string + " = new Image(imageDir+\"" + this.imageName + "\",false);");
                    this.writeCustom(2, "\tImageView " + string + "ImageView = new ImageView(" + string + ");");
                    this.writeCustom(2, "\t" + string + "ImageView.setImage(" + string + ");");
                    this.writeCustom(2, "\t" + string + "ImageView.setFitWidth(" + this.ih + ");");
                    this.writeCustom(2, "\t" + string + "ImageView.setFitHeight(" + this.iw + ");");
                    this.writeCustom(2, "\t" + string + "ImageView.setX(" + (int)((double)this.cropBox.height - this.coords[1] - (double)this.ih) + ");");
                    this.writeCustom(2, "\t" + string + "ImageView.setY(" + (int)this.coords[0] + ");");
                    this.writeCustom(2, "\taddToGroup.add(" + string + "ImageView);");
                }
                case 270: {
                    this.writeCustom(2, "\n\t\t/**");
                    this.writeCustom(2, "\t* Image properties for " + string);
                    this.writeCustom(2, "\t*/ ");
                    this.writeCustom(2, "\tImage " + string + " = new Image(imageDir+\"" + this.imageName + "\",false);");
                    this.writeCustom(2, "\tImageView " + string + "ImageView = new ImageView(" + string + ");");
                    this.writeCustom(2, "\t" + string + "ImageView.setImage(" + string + ");");
                    this.writeCustom(2, "\t" + string + "ImageView.setFitWidth(" + this.ih + ");");
                    this.writeCustom(2, "\t" + string + "ImageView.setFitHeight(" + this.iw + ");");
                    this.writeCustom(2, "\t" + string + "ImageView.setX(" + this.setPrecision((int)this.coords[1]) + ");");
                    this.writeCustom(2, "\t" + string + "ImageView.setY(" + this.setPrecision((int)this.coords[0]) + ");");
                    this.writeCustom(2, "\taddToGroup.add(" + string + "ImageView);");
                }
            }
            this.writeCustom(2, "\n\t\t/**");
            this.writeCustom(2, "\t* Image properties for " + string);
            this.writeCustom(2, "\t*/ ");
            this.writeCustom(2, "\tImage " + string + " = new Image(imageDir+\"" + this.imageName + "\", false);");
            this.writeCustom(2, "\tImageView " + string + "ImageView = new ImageView(" + string + ");");
            this.writeCustom(2, "\t" + string + "ImageView.setImage(" + string + ");");
            this.writeCustom(2, "\t" + string + "ImageView.setFitWidth(" + this.iw + ");");
            this.writeCustom(2, "\t" + string + "ImageView.setFitHeight(" + this.ih + ");");
            this.writeCustom(2, "\t" + string + "ImageView.setX(" + (int)this.coords[0] + ");");
            this.writeCustom(2, "\t" + string + "ImageView.setY(" + (int)this.coords[1] + ");");
            this.writeCustom(2, "\taddToGroup.add(" + string + "ImageView);");
            if (f < 1.0f) {
                this.writeCustom(2, "pdf_canvas.globalAlpha = 1.0; ");
            }
        }
        return -1;
    }

    public void setOutputDir(String string, String string2, String string3) {
        super.setOutputDir(string, string2, string3);
        this.javaFxFileName = this.pageNumber == 1 && this.firstPageName != null && this.firstPageName.length() > 0 ? this.firstPageName : "page" + string3;
        this.packageName = string2;
        if (this.packageName.contains(" ")) {
            this.packageName = this.packageName.replaceAll(" ", "_");
        }
    }

    public void init(int n, int n2, int n3, Color color) {
        super.init(n, n2, n3, color);
        if (this.rootDir == null) {
            throw new RuntimeException("Please pass in output_dir (second param if running ExtractpageAsJavaFX");
        }
        try {
            this.output = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.rootDir + this.javaFxFileName + ".java"), this.encodingType[0]));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void writeCustom(int n, Object object) {
        switch (n) {
            case 0: {
                try {
                    this.output.write(object.toString());
                    this.output.write(10);
                    this.output.flush();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 1: {
                this.topSection.append('\t');
                this.topSection.append(object.toString());
                this.topSection.append('\n');
                break;
            }
            case 2: {
                this.script.append('\t');
                this.script.append(object.toString());
                this.script.append('\n');
                break;
            }
            case 3: {
                this.form.append(object.toString());
                break;
            }
            case 5: {
                this.images.append(object.toString());
                break;
            }
            case 6: {
                this.testDivs.append(object.toString());
                break;
            }
            case 4: {
                this.css.append(object.toString());
                this.css.append('\n');
                break;
            }
            case 7: {
                try {
                    this.writeEveryGlyf = (Boolean)object;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 8: {
                try {
                    this.encodingType = (String[])object;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 9: {
                if (this.jsImagesAdded) break;
                this.writeCustom(1, object);
                this.jsImagesAdded = true;
                break;
            }
            case 10: {
                Object object2;
                Object[] objectArray = (Object[])object;
                PdfFont pdfFont = (PdfFont)objectArray[0];
                String string = pdfFont.getFontName();
                String string2 = (String)objectArray[2];
                String string3 = this.rootDir + this.javaFxFileName + "/";
                File file = new File(string3);
                if (!file.exists()) {
                    file.mkdirs();
                }
                try {
                    object2 = new BufferedOutputStream(new FileOutputStream(string3 + string + "." + string2));
                    ((FilterOutputStream)object2).write((byte[])objectArray[1]);
                    ((BufferedOutputStream)object2).flush();
                    ((FilterOutputStream)object2).close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                object2 = new StringBuffer();
                ((StringBuffer)object2).append("@font-face {\n");
                ((StringBuffer)object2).append("\tfont-family: " + string + ";\n");
                ((StringBuffer)object2).append("\tsrc: url(\"" + this.javaFxFileName + "/" + string + "." + string2 + "\");\n");
                ((StringBuffer)object2).append("}\n");
                this.writeCustom(4, object2);
                break;
            }
            default: {
                super.writeCustom(n, object);
            }
        }
    }

    protected void flushText() {
        if (this.currentTextBlock == null || this.currentTextBlock.isEmpty()) {
            return;
        }
        this.writeoutJavaFXText();
        if (!this.currentTextBlock.isEmpty()) {
            this.previousTextBlock = this.currentTextBlock;
        }
        this.currentTextBlock = new TextBlock(this.putTextOnCanvas);
    }

    protected void drawPatternedShape(Shape shape, GraphicsState graphicsState) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(this.scaling, this.scaling);
        PdfPaint pdfPaint = graphicsState.getNonstrokeColor();
        Rectangle rectangle = shape.getBounds();
        rectangle.setSize((int)((float)rectangle.width * this.scaling), (int)((float)rectangle.height * this.scaling));
        if (pdfPaint.isPattern()) {
            PaintContext paintContext = pdfPaint.createContext(null, rectangle, rectangle, affineTransform, null);
            Raster raster = paintContext.getRaster(rectangle.x, rectangle.y, rectangle.width > 1 ? rectangle.width : 1, rectangle.height > 1 ? rectangle.height : 1);
            BufferedImage bufferedImage = new BufferedImage(rectangle.width > 1 ? rectangle.width : 1, rectangle.height > 1 ? rectangle.height : 1, 6);
            bufferedImage.setData(raster);
            String string = "img/shade/" + this.pageNumberAsString + "/";
            File file = new File(this.rootDir + string);
            if (!file.exists()) {
                file.mkdirs();
            }
            String string2 = "shade" + this.shadeId++;
            String string3 = string + string2 + ".png";
            int n = rectangle.width > 1 ? rectangle.width : 1;
            int n2 = rectangle.height > 1 ? rectangle.height : 1;
            float f = (float)rectangle.x * this.scaling;
            float f2 = this.h - (float)rectangle.y * this.scaling - (float)bufferedImage.getHeight();
            if (this.pageRotation == 90 || this.pageRotation == 270) {
                int n3 = n;
                n = n2;
                n2 = n3;
                float f3 = f;
                f = (float)this.cropBox.height - f2 - 240.0f;
                f2 = f3;
            }
            this.writeCustom(2, "\n\t\t/**");
            this.writeCustom(2, "\t* Shade properties for " + string2);
            this.writeCustom(2, "\t*/ ");
            this.writeCustom(2, "\tImage " + string2 + " = new Image(imageDir+\"" + "/" + string3 + "\",false);");
            this.writeCustom(2, "\tImageView " + string2 + "ImageView = new ImageView(" + string2 + ");");
            this.writeCustom(2, "\t" + string2 + "ImageView.setImage(" + string2 + ");");
            this.writeCustom(2, "\t" + string2 + "ImageView.setFitWidth(" + n + ");");
            this.writeCustom(2, "\t" + string2 + "ImageView.setFitHeight(" + n2 + ");");
            this.writeCustom(2, "\t" + string2 + "ImageView.setX(" + f + ");");
            this.writeCustom(2, "\t" + string2 + "ImageView.setY(" + f2 + ");");
            this.writeCustom(2, "\taddToGroup.add(" + string2 + "ImageView);");
            if (this.pageRotation == 90 || this.pageRotation == 270) {
                bufferedImage = this.rotateImage(bufferedImage);
            }
            try {
                ImageIO.write((RenderedImage)bufferedImage, "PNG", new File(this.rootDir + string3));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void drawNonPatternedShape(Shape shape, GraphicsState graphicsState, int n) {
        int n2 = 0;
        if (this.pageoffsets != null) {
            n2 = this.pageoffsets[this.pageNumber];
        }
        JavaFXShape javaFXShape = new JavaFXShape(n, n2, this.shapeCount, this.scaling, shape, graphicsState, new AffineTransform(), this.midPoint, this.cropBox, this.currentColor, this.dpCount, this.pageRotation, this.pageData, this.pageNumber, this.includeClip);
        javaFXShape.setShapeNumber(this.shapeCount);
        ++this.shapeCount;
        if (!javaFXShape.isEmpty()) {
            this.writeCustom(2, javaFXShape.getContent());
            this.currentColor = javaFXShape.getShapeColor();
        }
    }

    protected void drawTextArea() {
        if (this.currentTextBlock.isEmpty()) {
            return;
        }
        int n = this.putTextOnCanvas ? 0 : this.currentTextBlock.getFontSize();
        double[] dArray = new double[]{this.currentTextBlock.getX(), (int)this.currentTextBlock.getY() + n};
        this.writeCustom(2, "pdf_context.moveTo(" + this.coordsToStringParam(dArray, 2) + ");");
        dArray[0] = this.currentTextBlock.getX() + this.currentTextBlock.getWidth();
        this.writeCustom(2, "pdf_context.lineTo(" + this.coordsToStringParam(dArray, 2) + ");");
        dArray[1] = this.currentTextBlock.getY() - (float)this.currentTextBlock.getFontSize() + (float)n;
        this.writeCustom(2, "pdf_context.lineTo(" + this.coordsToStringParam(dArray, 2) + ");");
        dArray[0] = this.currentTextBlock.getX();
        this.writeCustom(2, "pdf_context.lineTo(" + this.coordsToStringParam(dArray, 2) + ");");
        this.writeCustom(2, "pdf_context.closePath();");
        this.writeCustom(2, "pdf_context.strokeStyle = '" + JavaFXDisplay.rgbToColor(200) + "';");
        this.writeCustom(2, "pdf_context.lineWidth = '1'");
        this.writeCustom(2, "pdf_context.stroke();");
    }

    protected void drawPageBorder() {
        double[] dArray = new double[]{this.cropBox.x, this.cropBox.y};
        this.writeCustom(2, "pdf_context.moveTo(" + this.coordsToStringParam(dArray, 2) + ");");
        dArray[0] = dArray[0] + (double)this.cropBox.width;
        this.writeCustom(2, "pdf_context.lineTo(" + this.coordsToStringParam(dArray, 2) + ");");
        dArray[1] = dArray[1] + (double)this.cropBox.height;
        this.writeCustom(2, "pdf_context.lineTo(" + this.coordsToStringParam(dArray, 2) + ");");
        dArray[0] = dArray[0] - (double)this.cropBox.width;
        this.writeCustom(2, "pdf_context.lineTo(" + this.coordsToStringParam(dArray, 2) + ");");
        this.writeCustom(2, "pdf_context.closePath();");
        this.writeCustom(2, "pdf_context.strokeStyle = '" + JavaFXDisplay.rgbToColor(0) + "';");
        this.writeCustom(2, "pdf_context.lineWidth = '1'");
        this.writeCustom(2, "pdf_context.stroke();");
    }

    protected FontMapper getFontMapper(PdfFont pdfFont) {
        return new JavaFXFontMapper(pdfFont.getFontName(), this.fontMode, pdfFont.isFontEmbedded);
    }
}

