/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.optimizer.execution.validator;

import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.validation.api.ComponentValidationMessage;
import de.rcenvironment.core.component.validation.spi.AbstractLoopComponentValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class OptimizerComponentValidator
extends AbstractLoopComponentValidator {
    public String getIdentifier() {
        return "de.rcenvironment.optimizer";
    }

    protected List<ComponentValidationMessage> validateLoopComponentSpecific(ComponentDescription componentDescription) {
        ArrayList<ComponentValidationMessage> messages = new ArrayList<ComponentValidationMessage>();
        ComponentValidationMessage noInputMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, null, "No Objectives", "There are no objective functions defined.");
        if (this.getInputs(componentDescription).isEmpty()) {
            messages.add(noInputMessage);
        } else {
            Set inputs = this.getInputs(componentDescription);
            boolean hasObjective = false;
            for (EndpointDescription input : inputs) {
                String dynamicEndpointIdentifier = input.getDynamicEndpointIdentifier();
                if (dynamicEndpointIdentifier == null || !dynamicEndpointIdentifier.equals("Objective")) continue;
                hasObjective = true;
                break;
            }
            if (!hasObjective) {
                messages.add(noInputMessage);
            }
        }
        ComponentValidationMessage noOutputMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, null, "No Design variables", "There are no design variables defined.");
        if (this.getOutputs(componentDescription).isEmpty()) {
            messages.add(noOutputMessage);
        } else {
            Set outputs = this.getOutputs(componentDescription);
            boolean hasDesign = false;
            for (EndpointDescription output : outputs) {
                String dynamicEndpointIdentifier = output.getDynamicEndpointIdentifier();
                if (dynamicEndpointIdentifier == null || !dynamicEndpointIdentifier.equals("Design")) continue;
                hasDesign = true;
                break;
            }
            if (!hasDesign) {
                messages.add(noOutputMessage);
            }
        }
        if (this.getProperty(componentDescription, "algorithm") == null || this.getProperty(componentDescription, "algorithm").isEmpty()) {
            ComponentValidationMessage noAlgorithmMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "algorithm", "No Algorithm", "There is no algorithm chosen.");
            messages.add(noAlgorithmMessage);
        }
        return messages;
    }

    protected List<ComponentValidationMessage> validateOnWorkflowStartComponentSpecific(ComponentDescription componentDescription) {
        return null;
    }
}

