/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner.internal;

import cucumber.api.Pending;
import cucumber.api.java.After;
import cucumber.api.java.Before;
import cucumber.api.java.ObjectFactory;
import cucumber.api.java.en.Given;
import cucumber.api.java.en.Then;
import cucumber.api.java.en.When;
import cucumber.api.java8.GlueBase;
import cucumber.runtime.Backend;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.Runtime;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.io.ClasspathResourceLoader;
import cucumber.runtime.io.FileResourceLoader;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.io.ResourceLoaderClassFinder;
import cucumber.runtime.java.JavaBackend;
import cucumber.runtime.java.picocontainer.PicoFactory;
import cucumber.runtime.model.CucumberFeature;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.extras.testscriptrunner.definitions.common.TestScenarioExecutionContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CucumberTestFrameworkAdapter {
    private static final String CLI_OPTION_PLUGIN = "-p";
    private static final String CLI_OPTION_SNIPPETS = "--snippets";
    private static final String CLI_OPTION_MONOCHROME = "-m";
    private static final String CLI_OPTION_STRICT_MODE = "-s";
    private static final String CLI_OPTION_GLUE_CODE = "-g";
    private static final String CLI_OPTION_TAG_FILTER = "-t";
    private final Backend javaBackend;
    private final Log log = LogFactory.getLog(this.getClass());

    public CucumberTestFrameworkAdapter(final Class<?> ... stepDefinitions) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        ResourceLoaderClassFinder patchedClassFinder = new ResourceLoaderClassFinder((ResourceLoader)new ClasspathResourceLoader(classLoader), classLoader){

            public <T> Collection<Class<? extends T>> getDescendants(Class<T> parentType, String packageName) {
                ArrayList<Class<T>> result = new ArrayList<Class<T>>();
                if (parentType == Object.class && packageName.endsWith(".definitions")) {
                    CucumberTestFrameworkAdapter.this.log.debug((Object)"Injecting BDD step definitions...");
                    Class[] classArray = stepDefinitions;
                    int n = stepDefinitions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Class definitionClass = classArray[n2];
                        result.add(definitionClass);
                        ++n2;
                    }
                } else if (parentType == Annotation.class && packageName.equals("cucumber.api")) {
                    CucumberTestFrameworkAdapter.this.log.debug((Object)"Injecting BDD framework annotations...");
                    result.add(Given.class);
                    result.add(When.class);
                    result.add(Then.class);
                    result.add(Pending.class);
                    result.add(Before.class);
                    result.add(After.class);
                } else if (parentType != GlueBase.class) {
                    CucumberTestFrameworkAdapter.this.log.warn((Object)("Unexpected subtype request from BDD framework: " + parentType + " / " + packageName));
                }
                return result;
            }
        };
        PicoFactory factory = new PicoFactory();
        factory.addClass(TestScenarioExecutionContext.class);
        this.javaBackend = new JavaBackend((ObjectFactory)factory, (ClassFinder)patchedClassFinder);
    }

    public ExecutionResult executeTestScripts(File scriptLocationRoot, String tagNameSelection, TextOutputReceiver outputReceiver, String buildUnderTestId, File reportDir) throws IOException {
        return this.executeTestScripts(scriptLocationRoot, tagNameSelection, outputReceiver, buildUnderTestId, reportDir, ReportOutputFormat.PRETTY);
    }

    public ExecutionResult executeTestScripts(File scriptLocationRoot, String tagNameSelection, TextOutputReceiver outputReceiver, String buildUnderTestId, File reportDir, ReportOutputFormat reportFormat) throws IOException {
        String reportDirUriString = reportDir.toURI().toASCIIString();
        String reportFileName = "plain" + reportFormat.getReportFileSuffix();
        File reportFile = new File(reportDir, reportFileName);
        if (reportFile.isFile()) {
            reportFile.delete();
        }
        if (reportFile.isFile()) {
            throw new IOException("Failed to delete pre-existing report file " + reportFile.getAbsolutePath());
        }
        ArrayList<String> cliParts = new ArrayList<String>();
        cliParts.add(CLI_OPTION_TAG_FILTER);
        cliParts.add("~@disabled");
        cliParts.add(CLI_OPTION_TAG_FILTER);
        cliParts.add("~@Disabled");
        if (!StringUtils.isNullorEmpty((String)tagNameSelection)) {
            StringBuilder buffer = new StringBuilder();
            String[] stringArray = tagNameSelection.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String trimmedPart;
                String filterPart = stringArray[n2];
                if (buffer.length() != 0) {
                    buffer.append(",");
                }
                if (!(trimmedPart = filterPart.trim()).startsWith("@")) {
                    buffer.append("@");
                }
                buffer.append(trimmedPart);
                ++n2;
            }
            if (buffer.length() != 0) {
                cliParts.add(CLI_OPTION_TAG_FILTER);
                cliParts.add(buffer.toString());
            }
        }
        cliParts.addAll(Arrays.asList(CLI_OPTION_GLUE_CODE, "de.rcenvironment.extras.testscriptrunner.definitions", CLI_OPTION_STRICT_MODE, CLI_OPTION_MONOCHROME, CLI_OPTION_SNIPPETS, "camelcase", CLI_OPTION_PLUGIN, StringUtils.format((String)"%s:%s/%s", (Object[])new Object[]{reportFormat.getFormatSpecifier(), reportDirUriString, reportFileName}), scriptLocationRoot.getAbsolutePath()));
        RuntimeOptions runtimeOptions = new RuntimeOptions(cliParts){

            public List<CucumberFeature> cucumberFeatures(ResourceLoader resourceLoader) {
                return CucumberFeature.load((ResourceLoader)new FileResourceLoader(), (List)this.getFeaturePaths(), (List)this.getFilters(), (PrintStream)System.out);
            }
        };
        ClassLoader classLoader = this.getClass().getClassLoader();
        ClasspathResourceLoader resourceLoader = new ClasspathResourceLoader(classLoader);
        ArrayList<Backend> backends = new ArrayList<Backend>();
        backends.add(this.javaBackend);
        Runtime runtime = new Runtime((ResourceLoader)resourceLoader, classLoader, backends, runtimeOptions);
        PrintStream oldStdOut = System.out;
        ByteArrayOutputStream outputBuffer = new ByteArrayOutputStream();
        PrintStream outputWriter = new PrintStream((OutputStream)outputBuffer, false, "UTF-8");
        System.setOut(outputWriter);
        TestScenarioExecutionContext.setThreadLocalParameters(outputReceiver, buildUnderTestId, scriptLocationRoot);
        try {
            runtime.run();
        }
        finally {
            TestScenarioExecutionContext.discardThreadLocalParameters();
        }
        System.setOut(oldStdOut);
        outputWriter.close();
        if (reportFile.isFile()) {
            List reportLines = FileUtils.readLines((File)reportFile, (Charset)Charsets.UTF_8);
            List capturedStdOutLines = IOUtils.readLines((InputStream)new ByteArrayInputStream(outputBuffer.toByteArray()), (Charset)Charsets.UTF_8);
            return new ExecutionResult(reportLines, capturedStdOutLines);
        }
        return null;
    }

    public static final class ExecutionResult {
        private List<String> reportFileLines;
        private List<String> capturedStdOutLines;

        public ExecutionResult(List<String> reportLines, List<String> capturedStdOutLines) {
            this.reportFileLines = reportLines;
            this.capturedStdOutLines = capturedStdOutLines;
        }

        public List<String> getReportFileLines() {
            return this.reportFileLines;
        }

        public List<String> getCapturedStdOutLines() {
            return this.capturedStdOutLines;
        }
    }

    public static enum ReportOutputFormat {
        PRETTY("pretty", ".txt"),
        JSON("json", ".json");

        private final String formatSpecifier;
        private final String reportFileSuffix;

        private ReportOutputFormat(String formatSpecifierParam, String reportFileSuffixParam) {
            this.formatSpecifier = formatSpecifierParam;
            this.reportFileSuffix = reportFileSuffixParam;
        }

        public String getFormatSpecifier() {
            return this.formatSpecifier;
        }

        public String getReportFileSuffix() {
            return this.reportFileSuffix;
        }
    }
}

