/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.scpoutputcollector.execution;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rcenvironment.core.component.update.api.PersistentComponentDescription;
import de.rcenvironment.core.component.update.spi.PersistentComponentDescriptionUpdater;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.IOException;
import org.osgi.service.component.annotations.Component;

@Component
public class ScpOutputCollectorPersistentComponentDescriptionUpdater
implements PersistentComponentDescriptionUpdater {
    private static final String V1_1 = "1.1";
    private static final String CURRENT_VERSION = "1.1";

    public String[] getComponentIdentifiersAffectedByUpdate() {
        return new String[]{"de.rcenvironment.scpoutputcollector"};
    }

    public int getFormatVersionsAffectedByUpdate(String persistentComponentDescriptionVersion, boolean silent) {
        int update = 0;
        if (!silent && persistentComponentDescriptionVersion != null && persistentComponentDescriptionVersion.compareTo("1.1") < 0) {
            update = 4;
        }
        return update;
    }

    public PersistentComponentDescription performComponentDescriptionUpdate(int formatVersion, PersistentComponentDescription description, boolean silent) throws IOException {
        switch (formatVersion) {
            case 4: {
                if (description.getComponentVersion().compareTo("1.1") >= 0) break;
                description = this.updateFromV10ToV11(description);
                break;
            }
        }
        return description;
    }

    private PersistentComponentDescription updateFromV10ToV11(PersistentComponentDescription description) throws JsonProcessingException, IOException {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        ObjectNode configurationsNode = (ObjectNode)node.get("configuration");
        if (configurationsNode != null && !configurationsNode.has("SimpleDescriptionFormat")) {
            configurationsNode.put("SimpleDescriptionFormat", "##SIMPLE_FORMAT_FLAG##");
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        description = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        description.setComponentVersion("1.1");
        return description;
    }
}

