/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.parametricstudy.gui.view;

import de.rcenvironment.components.parametricstudy.gui.view.AbstractConfiguration;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.configuration.annotation.Configurable;
import de.rcenvironment.core.utils.incubator.configuration.annotation.Configuration;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.swt.graphics.RGB;

@Configuration
public final class ChartConfiguration
extends AbstractConfiguration {
    public static final boolean DEFAULT_SHOW_TITLE = true;
    private static final int NO_SUCH_ELEMENT_INDEX = -1;
    private static final long serialVersionUID = -1320466508913829555L;
    private final List<XAxis> xAxes = new LinkedList<XAxis>();
    private final List<YAxis> yAxes = new LinkedList<YAxis>();
    private Trace[] traces = new Trace[0];
    private String title;
    private boolean showTitle = true;
    private boolean showLegend = true;

    @Configurable
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        String oldValue = this.title;
        this.title = title;
        this.firePropertyChange("title", oldValue, title);
    }

    @Configurable
    public boolean getShowTitle() {
        return this.showTitle;
    }

    public void setShowTitle(boolean showTitle) {
        boolean oldValue = this.showTitle;
        this.showTitle = showTitle;
        this.firePropertyChange("showTitle", oldValue, showTitle);
    }

    @Configurable
    public boolean isShowLegend() {
        return this.showLegend;
    }

    public void setShowLegend(boolean showLegend) {
        boolean oldValue = this.showLegend;
        this.showLegend = showLegend;
        this.firePropertyChange("showLegend", oldValue, showLegend);
    }

    public XAxis getXAxis(String axisTitle) {
        for (XAxis axis : this.xAxes) {
            if (!axisTitle.equals(axis.getTitle())) continue;
            return axis;
        }
        return null;
    }

    @Configurable
    public XAxis[] getXAxes() {
        return this.xAxes.toArray(new XAxis[this.xAxes.size()]);
    }

    public XAxis getXAxes(int index) {
        return this.xAxes.get(index);
    }

    public void addXAxis(XAxis xaxis) {
        if (this.xAxes.contains(xaxis) || this.getXAxis(xaxis.getTitle()) != null) {
            return;
        }
        this.xAxes.add(xaxis);
    }

    public YAxis getYAxis(String axisTitle) {
        for (YAxis axis : this.yAxes) {
            if (!axisTitle.equals(axis.getTitle())) continue;
            return axis;
        }
        return null;
    }

    @Configurable
    public YAxis[] getYAxes() {
        return this.yAxes.toArray(new YAxis[this.yAxes.size()]);
    }

    public YAxis getYAxes(int index) {
        return this.yAxes.get(index);
    }

    public void addYAxis(YAxis yaxis) {
        if (this.yAxes.contains(yaxis) || this.getYAxis(yaxis.getTitle()) != null) {
            return;
        }
        this.yAxes.add(yaxis);
    }

    public Trace getTrace(String traceTitle) {
        Trace[] traceArray = this.traces;
        int n = this.traces.length;
        int n2 = 0;
        while (n2 < n) {
            Trace trace = traceArray[n2];
            if (traceTitle.equals(trace.getName())) {
                return trace;
            }
            ++n2;
        }
        return null;
    }

    @Configurable
    public Trace[] getTraces() {
        return this.traces;
    }

    public Trace getTrace(int index) {
        return this.traces[index];
    }

    public void addTrace(Trace trace) {
        Trace[] oldTraces = this.traces;
        Trace[] newTraces = new Trace[oldTraces.length + 1];
        System.arraycopy(oldTraces, 0, newTraces, 0, oldTraces.length);
        newTraces[newTraces.length - 1] = trace;
        this.traces = newTraces;
        this.fireIndexedPropertyChange("traces", this.traces.length - 1, null, trace);
    }

    public void removeTrace(Trace trace) {
        int index = this.getTraceIndex(trace);
        if (index >= 0) {
            Trace[] oldTraces = this.traces;
            Trace[] newTraces = new Trace[oldTraces.length - 1];
            System.arraycopy(oldTraces, 0, newTraces, 0, index);
            System.arraycopy(oldTraces, index + 1, newTraces, index, newTraces.length - index);
            this.traces = newTraces;
            this.firePropertyChange("traces", oldTraces, this.traces);
        }
    }

    private int getTraceIndex(Trace trace) {
        int index = 0;
        while (index < this.traces.length) {
            if (this.traces[index].equals(trace)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public String validate() {
        String result = null;
        if (this.title == null || this.title.isEmpty() || this.xAxes.size() == 0 || this.yAxes.size() == 0 || this.traces.length == 0) {
            result = "chart configuration is not valid";
        }
        if (result != null) {
            LinkedList<AbstractConfiguration> elements = new LinkedList<AbstractConfiguration>();
            elements.addAll(this.xAxes);
            elements.addAll(this.yAxes);
            elements.addAll(Arrays.asList(this.traces));
            for (Object e : elements) {
                if (e instanceof AbstractConfiguration && (result = ((AbstractConfiguration)e).validate()) != null) break;
            }
        }
        return result;
    }

    @Configuration
    public static abstract class Axis
    extends AbstractConfiguration {
        private static final long serialVersionUID = -5175175964625896094L;
        private String title;
        private boolean visible = true;
        private boolean autoFormat = true;
        private boolean autoScale = true;
        private boolean logScale = false;

        @Configurable
        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            String oldValue = this.title;
            this.title = title;
            this.firePropertyChange("title", oldValue, title);
        }

        @Configurable
        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            boolean oldValue = this.visible;
            this.visible = visible;
            this.firePropertyChange("visible", oldValue, visible);
        }

        @Configurable
        public boolean isAutoFormat() {
            return this.autoFormat;
        }

        public void setAutoFormat(boolean autoFormat) {
            boolean oldValue = this.autoFormat;
            this.autoFormat = autoFormat;
            this.firePropertyChange("autoFormat", oldValue, autoFormat);
        }

        @Configurable
        public boolean isAutoScale() {
            return this.autoScale;
        }

        public void setAutoScale(boolean autoScale) {
            boolean oldValue = this.autoScale;
            this.autoScale = autoScale;
            this.firePropertyChange("autoScale", oldValue, autoScale);
        }

        @Configurable
        public boolean isLogScale() {
            return this.logScale;
        }

        public void setLogScale(boolean logScale) {
            boolean oldValue = this.logScale;
            this.logScale = logScale;
            this.firePropertyChange("logScale", oldValue, logScale);
        }

        @Override
        public String validate() {
            if (this.title == null || this.title.isEmpty()) {
                return "axis configuration is not valid";
            }
            return null;
        }

        public String toString() {
            return StringUtils.format((String)"%s", (Object[])new Object[]{this.title});
        }
    }

    @Configuration
    public static final class Trace
    extends AbstractConfiguration {
        public static final String PROPERTY_VISIBLE = "visible";
        public static final String PROPERTY_Y_AXIS = "yAxis";
        public static final String PROPERTY_X_AXIS = "xAxis";
        private static final long serialVersionUID = -6828180563766171017L;
        private final ChartConfiguration chartConfiguration;
        private Trace.TraceType type = Trace.TraceType.SOLID_LINE;
        private RGB color;
        private String name = "";
        private XAxis xAxis;
        private YAxis yAxis;
        private boolean visible = true;

        public Trace(ChartConfiguration chartConfiguration) {
            this.chartConfiguration = chartConfiguration;
        }

        public ChartConfiguration getChartConfiguration() {
            return this.chartConfiguration;
        }

        @Configurable
        public Trace.TraceType getType() {
            return this.type;
        }

        public void setType(Trace.TraceType type) {
            if (type == null) {
                throw new IllegalArgumentException();
            }
            Trace.TraceType oldValue = this.type;
            this.type = type;
            this.firePropertyChange("type", oldValue, type);
        }

        @Configurable
        public RGB getColor() {
            return this.color;
        }

        public void setColor(RGB color) {
            if (color == null) {
                throw new IllegalArgumentException();
            }
            RGB oldValue = this.color;
            this.color = color;
            this.firePropertyChange("color", oldValue, color);
        }

        @Configurable
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            String oldValue = this.name;
            this.name = name;
            this.firePropertyChange("name", oldValue, name);
        }

        @Configurable(valueProvider=XAxisSelectionProvider.class)
        public XAxis getXAxis() {
            return this.xAxis;
        }

        public void setXAxis(XAxis xAxisIn) {
            XAxis oldValue = this.xAxis;
            this.xAxis = xAxisIn;
            this.firePropertyChange(PROPERTY_X_AXIS, oldValue, xAxisIn);
        }

        @Configurable(valueProvider=YAxisSelectionProvider.class)
        public YAxis getYAxis() {
            return this.yAxis;
        }

        public void setYAxis(YAxis yAxisIn) {
            YAxis oldValue = this.yAxis;
            this.yAxis = yAxisIn;
            this.firePropertyChange(PROPERTY_Y_AXIS, oldValue, yAxisIn);
        }

        @Configurable
        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            boolean oldValue = this.visible;
            if (oldValue == visible) {
                return;
            }
            this.visible = visible;
            this.firePropertyChange(PROPERTY_VISIBLE, oldValue, visible);
            if (visible) {
                this.getXAxis().setVisible(visible);
                this.getYAxis().setVisible(visible);
            } else {
                boolean xAxisUsed = false;
                boolean yAxisUsed = false;
                Trace[] traceArray = this.getChartConfiguration().getTraces();
                int n = traceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Trace trace = traceArray[n2];
                    if (trace.isVisible()) {
                        if (trace.getXAxis() == this.getXAxis()) {
                            xAxisUsed = true;
                        }
                        if (trace.getYAxis() == this.getYAxis()) {
                            yAxisUsed = true;
                        }
                    }
                    ++n2;
                }
                if (!xAxisUsed) {
                    this.getXAxis().setVisible(visible);
                }
                if (!yAxisUsed) {
                    this.getYAxis().setVisible(visible);
                }
            }
        }

        @Override
        public String validate() {
            if (this.type == null || this.name == null || this.name.isEmpty() || this.xAxis == null || this.yAxis == null) {
                return "something is wrong";
            }
            return null;
        }

        public String toString() {
            return this.getName();
        }

        public static enum Type {
            SOLID_LINE("Solid Line"),
            DASH_LINE("Dash Line"),
            POINT("Point"),
            BAR("Bar"),
            AREA("Area"),
            STEP_VERTICALLY("Step Vertically"),
            STEP_HORIZONTALLY("Step Horizontally");

            private final String title;

            private Type(String title) {
                this.title = title;
            }

            public String toString() {
                return this.title;
            }
        }

        public static final class XAxisSelectionProvider
        implements Configurable.ValueProvider {
            private Trace trace;

            public void setObject(Object object) {
                this.trace = (Trace)object;
            }

            public Object[] getValues() {
                return this.trace.getChartConfiguration().getXAxes();
            }
        }

        public static final class YAxisSelectionProvider
        implements Configurable.ValueProvider {
            private Trace trace;

            public void setObject(Object object) {
                this.trace = (Trace)object;
            }

            public Object[] getValues() {
                return this.trace.getChartConfiguration().getYAxes();
            }
        }
    }

    public static final class XAxis
    extends Axis {
        private static final long serialVersionUID = -8467430361175681746L;
    }

    public static final class YAxis
    extends Axis {
        private static final long serialVersionUID = 6839843465063469066L;
    }
}

