/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.inputprovider.gui;

import de.rcenvironment.components.inputprovider.gui.InputProviderAddDynamicEndpointCommand;
import de.rcenvironment.components.inputprovider.gui.InputProviderEditDynamicEndpointCommand;
import de.rcenvironment.components.inputprovider.gui.InputProviderEndpointEditDialog;
import de.rcenvironment.components.inputprovider.gui.InputProviderRemoveDynamicEndpointCommand;
import de.rcenvironment.components.inputprovider.gui.Messages;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.workflow.model.spi.ComponentInstanceProperties;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointActionType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.workflow.editor.properties.EndpointSelectionPane;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class InputProviderEndpointSelectionPane
extends EndpointSelectionPane {
    private Composite noteComposite;

    public InputProviderEndpointSelectionPane(String title, EndpointType direction, String dynEndpointIdToManage, WorkflowNodeCommand.Executor executor) {
        super(title, direction, dynEndpointIdToManage, new String[0], new String[0], executor);
    }

    public Control createControl(Composite parent, String title, FormToolkit toolkit) {
        Control control = super.createControl(parent, title, toolkit);
        new Label(this.client, 8);
        this.noteComposite = toolkit.createComposite(this.client);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.noteComposite.setLayoutData((Object)gridData);
        this.noteComposite.setLayout((Layout)new GridLayout(2, false));
        CLabel noteLabel = new CLabel(this.noteComposite, 0);
        noteLabel.setImage(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.WARNING_16));
        noteLabel.setText(Messages.note);
        this.section.setClient((Control)this.client);
        toolkit.paintBordersFor(this.client);
        this.section.setExpanded(true);
        return control;
    }

    public void setConfiguration(ComponentInstanceProperties configuration) {
        if (configuration != null) {
            super.setConfiguration(configuration);
            this.setNoteVisible(this.areFilesOrDirectoriesDefined());
        }
    }

    private void setNoteVisible(boolean visible) {
        if (!this.noteComposite.isDisposed()) {
            this.noteComposite.setVisible(visible);
        }
    }

    protected void onAddClicked() {
        Map<String, String> metaData = new HashMap<String, String>();
        InputProviderEndpointEditDialog dialog = new InputProviderEndpointEditDialog(Display.getDefault().getActiveShell(), EndpointActionType.ADD, this.configuration, this.endpointType, this.dynEndpointIdToManage, false, this.icon, this.endpointManager.getDynamicEndpointDefinition(this.dynEndpointIdToManage).getMetaDataDefinition(), metaData);
        if (dialog.open() == 0) {
            String name = dialog.getChosenName();
            DataType type = dialog.getChosenDataType();
            metaData = dialog.getMetadataValues();
            if (metaData.containsKey("fileSourceType") && metaData.get("fileSourceType").equals("atWorkflowStart")) {
                metaData.put("startValue", "${" + name + "}");
            }
            this.executeAddCommand(name, type, metaData);
            this.setNoteVisible(this.areFilesOrDirectoriesDefined());
        }
    }

    private boolean areFilesOrDirectoriesDefined() {
        for (EndpointDescription desc : this.configuration.getOutputDescriptionsManager().getDynamicEndpointDescriptions()) {
            if (desc.getDataType() != DataType.FileReference && desc.getDataType() != DataType.DirectoryReference) continue;
            return true;
        }
        return false;
    }

    protected void onEditClicked() {
        String name = (String)this.table.getSelection()[0].getData();
        EndpointDescription endpoint = this.endpointManager.getEndpointDescription(name);
        Map newMetaData = this.cloneMetaData(endpoint.getMetaData());
        InputProviderEndpointEditDialog dialog = new InputProviderEndpointEditDialog(Display.getDefault().getActiveShell(), EndpointActionType.EDIT, this.configuration, this.endpointType, this.dynEndpointIdToManage, false, this.icon, endpoint.getEndpointDefinition().getMetaDataDefinition(), newMetaData);
        this.onEditClicked(name, dialog, newMetaData);
        this.setNoteVisible(this.areFilesOrDirectoriesDefined());
    }

    protected void executeAddCommand(String name, DataType type, Map<String, String> metaData) {
        if (metaData.containsKey("fileSourceType") && metaData.get("fileSourceType").equals("atWorkflowStart")) {
            InputProviderAddDynamicEndpointCommand command = new InputProviderAddDynamicEndpointCommand(this.endpointType, this.dynEndpointIdToManage, name, type, metaData, new Refreshable[]{this});
            this.execute((WorkflowNodeCommand)command);
        } else {
            super.executeAddCommand(name, type, metaData);
        }
    }

    protected void executeEditCommand(EndpointDescription oldDescription, EndpointDescription newDescription) {
        if (oldDescription.getMetaData().containsKey("fileSourceType") && ((String)oldDescription.getMetaData().get("fileSourceType")).equals("atWorkflowStart") || newDescription.getMetaData().containsKey("fileSourceType") && ((String)newDescription.getMetaData().get("fileSourceType")).equals("atWorkflowStart")) {
            InputProviderEditDynamicEndpointCommand command = new InputProviderEditDynamicEndpointCommand(this.endpointType, oldDescription, newDescription, new Refreshable[]{this});
            this.execute((WorkflowNodeCommand)command);
        } else {
            super.executeEditCommand(oldDescription, newDescription);
        }
    }

    protected void executeRemoveCommand(List<String> names) {
        InputProviderRemoveDynamicEndpointCommand command = new InputProviderRemoveDynamicEndpointCommand(this.endpointType, this.dynEndpointIdToManage, names, null, new Refreshable[]{this});
        this.execute((WorkflowNodeCommand)command);
        this.setNoteVisible(this.areFilesOrDirectoriesDefined());
    }
}

