/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.cluster.execution;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rcenvironment.components.cluster.common.ClusterComponentConstants;
import de.rcenvironment.core.component.update.api.PersistentComponentDescription;
import de.rcenvironment.core.component.update.api.PersistentComponentDescriptionUpdaterUtils;
import de.rcenvironment.core.component.update.spi.PersistentComponentDescriptionUpdater;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.IOException;

public class ClusterPersistentComponentDescriptionUpdater
implements PersistentComponentDescriptionUpdater {
    private static final String CONFIGURATION = "configuration";
    private static final String V3_0 = "3.0";
    private static final String CURRENT_VERSION = "3.1";

    public String[] getComponentIdentifiersAffectedByUpdate() {
        return ClusterComponentConstants.COMPONENT_IDS;
    }

    public int getFormatVersionsAffectedByUpdate(String persistentComponentDescriptionVersion, boolean silent) {
        int versions = 0;
        if (!(silent || persistentComponentDescriptionVersion != null && persistentComponentDescriptionVersion.compareTo(V3_0) >= 0)) {
            versions |= 2;
        }
        if (!silent && persistentComponentDescriptionVersion != null && persistentComponentDescriptionVersion.compareTo(CURRENT_VERSION) < 0) {
            versions |= 4;
        }
        return versions;
    }

    public PersistentComponentDescription performComponentDescriptionUpdate(int formatVersion, PersistentComponentDescription description, boolean silent) throws IOException {
        if (!silent) {
            PersistentComponentDescription updatedDescription = null;
            if (formatVersion == 2) {
                updatedDescription = this.firstUpdate(description);
                updatedDescription.setComponentVersion(V3_0);
            } else if (formatVersion == 4) {
                updatedDescription = this.uodateFrom30To31(description);
                updatedDescription.setComponentVersion(CURRENT_VERSION);
            }
            return updatedDescription;
        }
        return description;
    }

    private PersistentComponentDescription uodateFrom30To31(PersistentComponentDescription description) throws JsonParseException, IOException {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        ObjectNode objectNode = (ObjectNode)node.get(CONFIGURATION);
        objectNode.put("pathToQueuingSystemCommands", "");
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        return new PersistentComponentDescription(writer.writeValueAsString((Object)node));
    }

    private PersistentComponentDescription firstUpdate(PersistentComponentDescription description) throws JsonParseException, IOException {
        description = PersistentComponentDescriptionUpdaterUtils.updateAllDynamicEndpointsToIdentifier((String)"dynamicOutputs", (String)"default", (PersistentComponentDescription)description);
        description = PersistentComponentDescriptionUpdaterUtils.updateAllDynamicEndpointsToIdentifier((String)"dynamicInputs", (String)"default", (PersistentComponentDescription)description);
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        ObjectNode oldConfig = (ObjectNode)node.get(CONFIGURATION);
        ((ObjectNode)node).remove(CONFIGURATION);
        ObjectNode newConfig = JsonNodeFactory.instance.objectNode();
        this.checkConfig("host", oldConfig, newConfig);
        this.checkConfig("port", oldConfig, newConfig);
        this.checkConfig("queuingSystem", oldConfig, newConfig);
        this.checkConfig("authUser", oldConfig, newConfig);
        this.checkConfig("authPhrase", oldConfig, newConfig);
        this.checkConfig("sandboxRoot", oldConfig, newConfig);
        this.checkConfig("deleteSandbox", oldConfig, newConfig);
        this.checkConfig("uploadFiles", oldConfig, newConfig);
        this.checkConfig("uploadInputFiles", oldConfig, newConfig);
        this.checkConfig("filesToUpload", oldConfig, newConfig);
        this.checkConfig("inputsToUpload", oldConfig, newConfig);
        this.checkConfig("usageOfScript", oldConfig, newConfig);
        this.checkConfig("localScript", oldConfig, newConfig);
        this.checkConfig("localScriptName", oldConfig, newConfig);
        this.checkConfig("remotePathOfScript", oldConfig, newConfig);
        this.checkConfig("remoteUploadPathOfNewScript", oldConfig, newConfig);
        this.checkConfig("downloadFiles", oldConfig, newConfig);
        this.checkConfig("downloadOutputFiles", oldConfig, newConfig);
        this.checkConfig("filesToDownload", oldConfig, newConfig);
        this.checkConfig("outputsToDownload", oldConfig, newConfig);
        this.checkConfig("script", oldConfig, newConfig);
        ((ObjectNode)node).set(CONFIGURATION, (JsonNode)newConfig);
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        return new PersistentComponentDescription(writer.writeValueAsString((Object)node));
    }

    private void checkConfig(String configKey, ObjectNode oldConfig, ObjectNode newConfig) {
        if (!oldConfig.get(configKey).textValue().isEmpty()) {
            newConfig.put(configKey, oldConfig.get(configKey));
        }
    }
}

