/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.net;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import org.eclipse.core.internal.net.AbstractProxyProvider;
import org.eclipse.core.internal.net.Activator;
import org.eclipse.core.internal.net.Policy;
import org.eclipse.core.internal.net.ProxyData;
import org.eclipse.core.internal.net.StringUtil;
import org.eclipse.core.net.proxy.IProxyData;

public class ProxyProvider
extends AbstractProxyProvider {
    private static LibGio fLibGio;
    private static Pointer proxySettings;
    private static Pointer httpProxySettings;
    private static Pointer httpsProxySettings;
    private static Pointer socksProxySettings;
    private static Pointer ftpProxySettings;
    private static final String ENABLE_GNOME = "org.eclipse.core.net.enableGnome";
    private static final String LIBRARY_NAME = "gio-2.0";
    private static boolean isGnomeLibLoaded;

    static {
        proxySettings = Pointer.NULL;
        httpProxySettings = Pointer.NULL;
        httpsProxySettings = Pointer.NULL;
        socksProxySettings = Pointer.NULL;
        ftpProxySettings = Pointer.NULL;
        isGnomeLibLoaded = false;
        String value = System.getProperty(ENABLE_GNOME);
        if ("".equals(value) || "true".equals(value)) {
            ProxyProvider.initializeSettings();
        }
    }

    public IProxyData[] select(URI uri) {
        int n;
        int n2;
        String[] stringArray;
        String[] nonProxyHosts = this.getNonProxiedHosts();
        if (nonProxyHosts != null) {
            String host = uri.getHost();
            stringArray = nonProxyHosts;
            n2 = nonProxyHosts.length;
            n = 0;
            while (n < n2) {
                String nonProxyHost = stringArray[n];
                if (StringUtil.hostMatchesFilter((String)host, (String)nonProxyHost)) {
                    return new IProxyData[0];
                }
                ++n;
            }
        }
        IProxyData[] proxies = new IProxyData[]{};
        if (uri.getScheme() != null) {
            IProxyData[] iProxyDataArray;
            ProxyData pd = this.getSystemProxyInfo(uri.getScheme());
            if (pd != null) {
                IProxyData[] iProxyDataArray2 = new IProxyData[1];
                iProxyDataArray = iProxyDataArray2;
                iProxyDataArray2[0] = pd;
            } else {
                iProxyDataArray = new IProxyData[]{};
            }
            proxies = iProxyDataArray;
        } else {
            proxies = this.getProxyData();
        }
        if (Policy.DEBUG) {
            Policy.debug((String)("LinuxProxyProvider#select result for [" + uri + "]"));
            stringArray = proxies;
            n2 = proxies.length;
            n = 0;
            while (n < n2) {
                String proxy = stringArray[n];
                System.out.println("\t" + proxy);
                ++n;
            }
        }
        return proxies;
    }

    public IProxyData[] getProxyData() {
        String[] commonTypes = new String[]{"HTTP", "SOCKS", "HTTPS"};
        return this.getProxyForTypes(commonTypes);
    }

    private IProxyData[] getProxyForTypes(String[] types) {
        ArrayList<ProxyData> allData = new ArrayList<ProxyData>();
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            ProxyData pd = this.getSystemProxyInfo(type);
            if (pd != null && pd.getHost() != null) {
                allData.add(pd);
            }
            ++n2;
        }
        return allData.toArray(new IProxyData[0]);
    }

    public String[] getNonProxiedHosts() {
        String npEnv;
        if (Policy.DEBUG_SYSTEM_PROVIDERS) {
            Policy.debug((String)"Getting no_proxy");
        }
        if ((npEnv = ProxyProvider.getEnv("no_proxy")) != null) {
            String[] npHosts = StringUtil.split((String)npEnv, (String[])new String[]{","});
            int i = 0;
            while (i < npHosts.length) {
                npHosts[i] = npHosts[i].trim();
                ++i;
            }
            if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                Policy.debug((String)("Got Env no_proxy: " + npEnv));
                this.debugPrint(npHosts);
            }
            return npHosts;
        }
        if (isGnomeLibLoaded) {
            try {
                String[] npHosts = ProxyProvider.getGSettingsNonProxyHosts();
                if (npHosts != null && npHosts.length > 0) {
                    if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                        Policy.debug((String)"Got Gnome no_proxy");
                        this.debugPrint(npHosts);
                    }
                    return npHosts;
                }
            }
            catch (UnsatisfiedLinkError e) {
                Activator.logError((String)"Problem during accessing Gnome library", (Throwable)e);
            }
        }
        return new String[0];
    }

    protected ProxyData getSystemProxyInfo(String protocol) {
        ProxyData pd = null;
        String envName = null;
        if (Policy.DEBUG_SYSTEM_PROVIDERS) {
            Policy.debug((String)("Getting proxies for: " + protocol));
        }
        try {
            protocol = protocol.toLowerCase(Locale.ENGLISH);
            envName = String.valueOf(protocol) + "_proxy";
            String proxyEnv = ProxyProvider.getEnv(envName);
            if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                Policy.debug((String)("Got proxyEnv: " + proxyEnv));
            }
            if (proxyEnv != null) {
                int colonInd = proxyEnv.indexOf(":");
                if (colonInd != -1 && proxyEnv.length() > colonInd + 2 && !"//".equals(proxyEnv.substring(colonInd + 1, colonInd + 3))) {
                    proxyEnv = "http://" + proxyEnv;
                }
                URI uri = new URI(proxyEnv);
                pd = new ProxyData(protocol);
                pd.setHost(Objects.requireNonNull(uri.getHost(), "no host in " + proxyEnv));
                int port = uri.getPort();
                if (port == -1) {
                    throw new IllegalStateException("no port in " + proxyEnv);
                }
                pd.setPort(port);
                String userInfo = uri.getUserInfo();
                if (userInfo != null) {
                    String user = null;
                    String password = null;
                    int pwInd = userInfo.indexOf(58);
                    if (pwInd >= 0) {
                        user = userInfo.substring(0, pwInd);
                        password = userInfo.substring(pwInd + 1);
                    } else {
                        user = userInfo;
                    }
                    pd.setUserid(user);
                    pd.setPassword(password);
                }
                pd.setSource("LINUX_ENV");
                if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                    Policy.debug((String)("Got Env proxy: " + pd));
                }
                return pd;
            }
        }
        catch (Exception e) {
            Activator.logError((String)("Problem during accessing system variable: " + envName), (Throwable)e);
        }
        if (isGnomeLibLoaded) {
            try {
                pd = ProxyProvider.getGSettingsProxyInfo(protocol);
                if (pd != null) {
                    if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                        Policy.debug((String)("Got Gnome proxy: " + pd));
                    }
                    pd.setSource("LINUX_GNOME");
                    return pd;
                }
            }
            catch (UnsatisfiedLinkError e) {
                Activator.logError((String)"Problem during accessing Gnome library", (Throwable)e);
            }
        }
        return null;
    }

    private static String getEnv(String env) {
        try {
            return System.getenv(env);
        }
        catch (Throwable throwable) {
            Properties props;
            block12: {
                String[] cmd = new String[]{"/bin/sh", "-c", "env | grep -i proxy"};
                props = new Properties();
                Process proc = null;
                try {
                    proc = Runtime.getRuntime().exec(cmd);
                    props.load(proc.getInputStream());
                }
                catch (IOException e) {
                    Activator.logError((String)("Problem during accessing system variable: " + env), (Throwable)e);
                    if (proc != null) {
                        proc.destroy();
                    }
                    break block12;
                }
                catch (IllegalArgumentException e) {
                    try {
                        Activator.logError((String)("Problem during accessing system variable: " + env), (Throwable)e);
                        break block12;
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                    finally {
                        if (proc != null) {
                            proc.destroy();
                        }
                    }
                }
                if (proc != null) {
                    proc.destroy();
                }
            }
            return props.getProperty(env);
        }
    }

    private void debugPrint(String[] strs) {
        int i = 0;
        while (i < strs.length) {
            System.out.println(String.valueOf(i) + ": " + strs[i]);
            ++i;
        }
    }

    private static void initializeSettings() {
        block3: {
            try {
                fLibGio = (LibGio)Native.load((String)LIBRARY_NAME, LibGio.class);
                proxySettings = fLibGio.g_settings_new("org.gnome.system.proxy");
                httpProxySettings = fLibGio.g_settings_new("org.gnome.system.proxy.http");
                httpsProxySettings = fLibGio.g_settings_new("org.gnome.system.proxy.https");
                socksProxySettings = fLibGio.g_settings_new("org.gnome.system.proxy.socks");
                ftpProxySettings = fLibGio.g_settings_new("org.gnome.system.proxy.ftp");
                isGnomeLibLoaded = true;
                if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                    Policy.debug((String)("Loaded " + System.mapLibraryName(LIBRARY_NAME) + " library"));
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                isGnomeLibLoaded = false;
                if (!Policy.DEBUG_SYSTEM_PROVIDERS) break block3;
                Policy.debug((String)("Could not load library: " + System.mapLibraryName(LIBRARY_NAME)));
            }
        }
    }

    protected static ProxyData getGSettingsProxyInfo(String protocol) {
        boolean reqAuth;
        int port;
        Pointer host;
        Pointer mode;
        if (protocol == null) {
            return null;
        }
        if (proxySettings == Pointer.NULL) {
            ProxyProvider.initializeSettings();
        }
        if (!(mode = fLibGio.g_settings_get_string(proxySettings, "mode")).getString(0L).equalsIgnoreCase("manual")) {
            fLibGio.g_free(mode);
            return null;
        }
        fLibGio.g_free(mode);
        switch (protocol.toLowerCase()) {
            case "http": {
                host = fLibGio.g_settings_get_string(httpProxySettings, "host");
                port = fLibGio.g_settings_get_int(httpProxySettings, "port");
                break;
            }
            case "https": {
                host = fLibGio.g_settings_get_string(httpsProxySettings, "host");
                port = fLibGio.g_settings_get_int(httpsProxySettings, "port");
                break;
            }
            case "ftp": {
                host = fLibGio.g_settings_get_string(ftpProxySettings, "host");
                port = fLibGio.g_settings_get_int(ftpProxySettings, "port");
                break;
            }
            case "socks": {
                host = fLibGio.g_settings_get_string(socksProxySettings, "host");
                port = fLibGio.g_settings_get_int(socksProxySettings, "port");
                break;
            }
            default: {
                return null;
            }
        }
        ProxyData proxyData = new ProxyData(protocol);
        proxyData.setHost(host.getString(0L));
        fLibGio.g_free(host);
        proxyData.setPort(port);
        if (proxyData.getHost() == null || proxyData.getPort() == 0) {
            return null;
        }
        if (protocol.equalsIgnoreCase("http") && (reqAuth = fLibGio.g_settings_get_boolean(httpProxySettings, "use-authentication"))) {
            Pointer user = fLibGio.g_settings_get_string(httpProxySettings, "authentication-user");
            proxyData.setUserid(user.getString(0L));
            fLibGio.g_free(user);
            Pointer password = fLibGio.g_settings_get_string(httpProxySettings, "authentication-password");
            proxyData.setPassword(password.getString(0L));
            fLibGio.g_free(password);
        }
        return proxyData;
    }

    protected static String[] getGSettingsNonProxyHosts() {
        Pointer mode;
        if (proxySettings == Pointer.NULL) {
            ProxyProvider.initializeSettings();
        }
        if (!(mode = fLibGio.g_settings_get_string(proxySettings, "mode")).getString(0L).equalsIgnoreCase("manual")) {
            fLibGio.g_free(mode);
            return null;
        }
        fLibGio.g_free(mode);
        PointerByReference npHostsArray = fLibGio.g_settings_get_strv(proxySettings, "ignore-hosts");
        String[] npHosts = npHostsArray.getPointer().getStringArray(0L);
        fLibGio.g_strfreev(npHostsArray);
        return npHosts;
    }

    private static interface LibGio
    extends Library {
        public Pointer g_settings_new(String var1);

        public boolean g_settings_get_boolean(Pointer var1, String var2);

        public Pointer g_settings_get_string(Pointer var1, String var2);

        public int g_settings_get_int(Pointer var1, String var2);

        public PointerByReference g_settings_get_strv(Pointer var1, String var2);

        public void g_strfreev(PointerByReference var1);

        public void g_free(Pointer var1);
    }
}

