/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.handlers;

import de.rcenvironment.core.component.workflow.model.api.Connection;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowLabel;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.workflow.ConnectionUtils;
import de.rcenvironment.core.gui.workflow.editor.commands.ConnectionDeleteCommand;
import de.rcenvironment.core.gui.workflow.editor.commands.WorkflowLabelDeleteCommand;
import de.rcenvironment.core.gui.workflow.editor.commands.WorkflowNodeDeleteCommand;
import de.rcenvironment.core.gui.workflow.editor.handlers.AbstractWorkflowNodeEditHandler;
import de.rcenvironment.core.gui.workflow.parts.ConnectionPart;
import de.rcenvironment.core.gui.workflow.parts.ConnectionWrapper;
import de.rcenvironment.core.gui.workflow.parts.WorkflowLabelPart;
import de.rcenvironment.core.gui.workflow.parts.WorkflowNodePart;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;

public class WorkflowNodeDeleteHandler
extends AbstractWorkflowNodeEditHandler {
    @Override
    void edit() {
        List selections = this.viewer.getSelectedEditParts();
        ArrayList<WorkflowNode> wfNodes = new ArrayList<WorkflowNode>();
        ArrayList<WorkflowLabel> wfLabels = new ArrayList<WorkflowLabel>();
        ArrayList<Connection> wfConnections = new ArrayList<Connection>();
        for (Object element : selections) {
            PropertyChangeListener part;
            if (element instanceof WorkflowNodePart) {
                part = (WorkflowNodePart)element;
                wfNodes.add((WorkflowNode)part.getModel());
            }
            if (element instanceof WorkflowLabelPart) {
                part = (WorkflowLabelPart)element;
                wfLabels.add((WorkflowLabel)part.getModel());
            }
            if (!(element instanceof ConnectionPart)) continue;
            part = (ConnectionPart)element;
            ConnectionWrapper wrapper = (ConnectionWrapper)part.getModel();
            wfConnections.addAll(ConnectionUtils.getConnectionsFromSourceToTarget(wrapper.getSource(), wrapper.getTarget(), (WorkflowDescription)this.viewer.getContents().getModel()));
        }
        if (!wfNodes.isEmpty()) {
            this.commandStack.execute((Command)new WorkflowNodeDeleteCommand((WorkflowDescription)this.viewer.getContents().getModel(), wfNodes));
        }
        if (!wfLabels.isEmpty()) {
            this.commandStack.execute((Command)new WorkflowLabelDeleteCommand((WorkflowDescription)this.viewer.getContents().getModel(), wfLabels));
        }
        if (!wfConnections.isEmpty()) {
            this.commandStack.execute((Command)new ConnectionDeleteCommand((WorkflowDescription)this.viewer.getContents().getModel(), wfConnections));
        }
    }
}

