/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.commands.endpoint;

import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.workflow.model.spi.ComponentInstanceProperties;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RemoveDynamicEndpointCommand
extends WorkflowNodeCommand {
    protected final EndpointType direction;
    protected final String id;
    protected Refreshable[] refreshable;
    protected final List<String> names;
    protected Map<String, EndpointDescription> oldDescriptions;
    private boolean executable = true;
    private boolean undoable = false;

    public RemoveDynamicEndpointCommand(EndpointType type, String dynamicEndpointId, List<String> names, Refreshable ... refreshable) {
        this.direction = type;
        this.id = dynamicEndpointId;
        this.names = names;
        this.refreshable = refreshable;
        this.oldDescriptions = new HashMap<String, EndpointDescription>();
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean canExecute() {
        return this.executable;
    }

    @Override
    public void execute() {
        if (this.executable) {
            for (String name : this.names) {
                ComponentInstanceProperties componentInstanceConfiguration = this.getProperties();
                if (this.direction == EndpointType.INPUT) {
                    this.oldDescriptions.put(name, this.getProperties().getInputDescriptionsManager().getEndpointDescription(name));
                    componentInstanceConfiguration.getInputDescriptionsManager().removeDynamicEndpointDescription(name);
                    continue;
                }
                this.oldDescriptions.put(name, this.getProperties().getOutputDescriptionsManager().getEndpointDescription(name));
                componentInstanceConfiguration.getOutputDescriptionsManager().removeDynamicEndpointDescription(name);
            }
            this.executable = false;
            this.undoable = true;
        }
        if (this.refreshable != null) {
            Refreshable[] refreshableArray = this.refreshable;
            int n = this.refreshable.length;
            int n2 = 0;
            while (n2 < n) {
                Refreshable r = refreshableArray[n2];
                r.refresh();
                ++n2;
            }
        }
    }

    @Override
    public boolean canUndo() {
        return this.undoable;
    }

    @Override
    public void undo() {
        if (this.undoable) {
            for (String name : this.names) {
                EndpointDescription oldDescription = this.oldDescriptions.get(name);
                ComponentInstanceProperties componentInstanceConfiguration = this.getProperties();
                if (this.direction == EndpointType.INPUT) {
                    componentInstanceConfiguration.getInputDescriptionsManager().addDynamicEndpointDescription(this.id, name, oldDescription.getDataType(), oldDescription.getMetaData(), oldDescription.getIdentifier(), oldDescription.getParentGroupName(), true);
                    continue;
                }
                componentInstanceConfiguration.getOutputDescriptionsManager().addDynamicEndpointDescription(this.id, name, oldDescription.getDataType(), oldDescription.getMetaData());
            }
            this.executable = true;
            this.undoable = false;
        }
        if (this.refreshable != null) {
            Refreshable[] refreshableArray = this.refreshable;
            int n = this.refreshable.length;
            int n2 = 0;
            while (n2 < n) {
                Refreshable r = refreshableArray[n2];
                r.refresh();
                ++n2;
            }
        }
    }
}

