/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.utils.incubator;

import de.rcenvironment.core.gui.utils.common.ClipboardHelper;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class PasteListeningText
extends Text
implements ModifyListener {
    private List<PasteListener> li = new ArrayList<PasteListener>();
    private boolean listenerActive = true;

    public PasteListeningText(Composite parent, int style) {
        super(parent, style);
        this.addModifyListener(this);
    }

    public void addPasteListener(PasteListener listener) {
        this.li.add(listener);
    }

    private void notifyPasteListener(String text) {
        for (PasteListener l : this.li) {
            l.paste(text);
        }
    }

    public void setText(String text) {
        this.listenerActive = false;
        super.setText(text);
        this.listenerActive = true;
    }

    protected void checkSubclass() {
    }

    public void modifyText(ModifyEvent arg0) {
        if (this.listenerActive && this.isTextPasted()) {
            this.notifyPasteListener(this.getText().trim());
        }
    }

    private boolean isTextPasted() {
        String clipboardText = "";
        clipboardText = ClipboardHelper.getContentAsStringOrNull();
        if (clipboardText != null) {
            String text = this.getText().trim();
            return !(clipboardText = clipboardText.trim()).isEmpty() && clipboardText.equals(text);
        }
        return false;
    }

    public static interface PasteListener {
        public void paste(String var1);
    }
}

