/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.integration.common.editor;

import de.rcenvironment.core.gui.integration.common.editor.IntegrationEditor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;

public class IntegrationEditorButtonBar
extends Composite
implements SelectionListener {
    protected static final String KEY = "id";
    protected static final String ID_CANCEL = "Cancel";
    protected static final String ID_SAVE = "Save";
    protected static final String ID_NEXT = "Next";
    protected static final String ID_BACK = "Back";
    private static final String ID_HELP = "Help";
    private IntegrationEditor editorPart;
    private Button backButton;
    private Button nextButton;
    private Button saveButton;

    public IntegrationEditorButtonBar(Composite parent, IntegrationEditor editorPart) {
        super(parent, 0);
        this.editorPart = editorPart;
        this.createEditorButtons();
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    private void createEditorButtons() {
        this.setLayout((Layout)new GridLayout(2, false));
        this.setLayoutData(new GridData(768));
        ToolBar toolbar = new ToolBar((Composite)this, 0);
        ToolItem helpButton = new ToolItem(toolbar, 0x800008);
        helpButton.setImage(JFaceResources.getImage((String)"dialog_help_image"));
        helpButton.setData(KEY, (Object)ID_HELP);
        helpButton.addSelectionListener((SelectionListener)this);
        GridData compositeGridData = new GridData();
        compositeGridData.horizontalAlignment = 3;
        compositeGridData.verticalAlignment = 3;
        compositeGridData.grabExcessHorizontalSpace = true;
        compositeGridData.grabExcessVerticalSpace = false;
        Composite buttonComposite = new Composite((Composite)this, 0);
        buttonComposite.setLayout((Layout)new GridLayout(4, true));
        buttonComposite.setLayoutData((Object)compositeGridData);
        buttonComposite.setBackground(this.getDisplay().getSystemColor(1));
        this.backButton = this.createButton(buttonComposite, IDialogConstants.BACK_LABEL, ID_BACK);
        this.nextButton = this.createButton(buttonComposite, IDialogConstants.NEXT_LABEL, ID_NEXT);
        this.saveButton = this.createButton(buttonComposite, this.editorPart.getButtonTextIntegrate(), ID_SAVE);
        this.saveButton.setEnabled(false);
        this.createButton(buttonComposite, IDialogConstants.CANCEL_LABEL, ID_CANCEL);
    }

    private Button createButton(Composite buttonComposite, String label, String id) {
        Button button = new Button(buttonComposite, 8);
        button.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        button.setText(label);
        button.setData(KEY, (Object)id);
        button.addSelectionListener((SelectionListener)this);
        return button;
    }

    public void widgetSelected(SelectionEvent evt) {
        String buttonId;
        switch (buttonId = (String)evt.widget.getData(KEY)) {
            case "Back": {
                this.editorPart.setPreviousPage();
                break;
            }
            case "Next": {
                this.editorPart.setNextPage();
                break;
            }
            case "Save": {
                this.editorPart.integrate();
                break;
            }
            case "Cancel": {
                this.editorPart.cancelPressed();
                break;
            }
            case "Help": {
                this.helpPressed();
            }
        }
    }

    private void helpPressed() {
        PlatformUI.getWorkbench().getHelpSystem().displayDynamicHelp();
    }

    public void setBackButtonEnabled(boolean enable) {
        this.backButton.setEnabled(enable);
    }

    public void setNextButtonEnabled(boolean enable) {
        this.nextButton.setEnabled(enable);
    }

    public void setSaveButtonEnabled(boolean enable) {
        this.saveButton.setEnabled(enable);
    }
}

